#define DATUM "11 February 2009"
#define VERSION "3"
#define BUILD "49"

#define _CRT_SECURE_NO_DEPRECATE /* To stop complaints by Visual C++ ver. 8*/
/*
    11 February 2009:
    Corrected error in flt$. All powers of ten where analysed to 1, 
    for example flt$(100,2) -> 1,00*10E0
*/
/* 13 November 2008 
stop string also works when writing.
fil$("file.txt",w)
fil$(,STR," \n\r\t")
fil$(,,,"Workers go to strike/for higher wages
and for more kindergartens.")
fil$("file.txt",r)
fil$(outfile,w)
fil$("infile.txt",STR)
fil$(outfile,STR," \n\r\t")
fil$(,,,"Workers go to strike for higher wages")

Stop string can also be specified when reading or writing
fil$(,,"/","Workers go to strike/for higher wages")
fil$("infile.txt",,".!?,;")

An empty stop string means: write all of the string.
(Or read to end of file, if file mode is reading).
*/
/* 10 September 2008
x^(y*(a+b))+-1*x^(a*y+b*y) -> 0 Before, the exponents were regarded as
different. If, during comparison, a subtree of lhs has pattern ?*(?+?) and 
the corresponding subtree of the rhs ?+?, the lhs subtree is expanded to
a sum (defactorised) and the comparison is done on the transformed lhs and
the rhs. Notice that the most expensive exponent survives:
x^(y*(a+b))+x^(a*y+b*y): 2*x^(y*(a+b))

0^-1 succeeded and gave 0, now it fails. (0/7^-1 already failed)

Strings starting with a zero and followed by another figure are not numbers 
00/7, 098

Input ()k went in endless loop, because the k was interpreted as an operator.
Now it says "malformed input".
*/
/* 11 February 2008
whl' now returns built_in_function_ok instead of function_fail. Although the 
loop exits when the rhs fails and there therefore is nothing meaningful to
"return", it led to ugly code when a whl' loop always had to be negated

    ... & ~(whl'(...)) & ...

or put into the lhs of an OR

    & ( whl'(...) |  ) &

til' is commented out. It has no future.
*/
/* 28 January 2008
evalmacro did not unset the ready-bit on an inserted expression consisting of
a variable with exclamation mark. It does now.
*/
/* 27 January 2008
Introduction of flag [ for acquiring or requiring the current position during
a (string)match. Examples:
    a b c:? ([-1:[?endpos)
will assign the length of the subject, 3, to variable endpos.
    a b c d e:? [!endpos ?extramaterial
will assign d e to extramaterial.
Works in match and stringmatch alike, with some exceptions:
@(:[0) succeeds, but (:[0) fails. Reason: in the first case, the subject
is the nil element, but in the second case, the lhs is just an atom,
although a funny one. In a certain context, this atom plays the role
of nil element, but not in other contexts.

Found out that stringmatch had a measurable side effect on the subject

subject=abcdef
@(!subject:? (d & !subject:abcd) ?

This would succeed, because the string had been temporarily cut off after
the 'd'.
Now match and string match are much more alike and the problem is solved.

Introduction of two built-in functions: whl and til. whl repeatedly evaluates
its argument until it fails. whl always returns failure. til repeatedly
evaluates its argument until it succeeds and returns the result of the last
evaluation.
There are no plans to make if...else and switch equivalents in Bracmat.
It may be that whl and/or til are retracted later. They seem a bit superfluous.
*/
/* 13 January 2008
`~a:?b will now assign `~a to b
@(`~a:?b) will assign a to b. !a will succeed
As before, this will assign something failing to a variable:
dummy ~a:dummy ?m
!m fails
~!m gives ~a
*/
/* 3 January 2008
Better implementation of the evaluation of !(=a).
It is now possible to construct and run a loop as a datastructure with
a closed loop of pointers. Performance-wise nothing is gained, however.
  (loop= !i+1:<10000000:?i&!(=))
& '$loop:(=?(loop.)) {Make closed datastructure}
& ~!loop {loop 10.000.000 times}
& :?(loop.) {Open the datastructure.(Otherwise you'll have a memory leak when
             'loop' goes out of scope.)}

Several functions have been factorised. evalueer() has been restructured.
*/
/* 2 January 2008
I've decided that a:(~@(a:a)) means about the same as a:(~@:(a:a)), i.e. it
fails because a is not not an atom. For the same reason a:(~@(a:b)) fails.
~@(a:a) in an evaluation context such as x&~@(a:a) succeeds. It merely means
a:a

Use #define STRINGMATCH_CAN_BE_NEGATED 1 to allow ~@(<subject>:<pattern>)
as a stringmatch that has its result negated after evaluation.

Use #define STRINGMATCH_CAN_BE_NEGATED 0 to interpret ~@(<subject>:<pattern>)
as the opposite of stringmatch, i.e. a normal match, the same as
(<subject>:<pattern>) with the additional condition that <subject> is not an
atom. Notice, however, that ~@#(abc:? b ?) succeeds, as the ~ negates #, not @
(priority /#<>@)

Succeeding tests:
a b:(~@(? b:a %))
~@(a b:a ?)
~@(a:a)
12/34:@(?x:#?a (~#%@:?y) #?b)&!y:"/"

Failing tests:
a:(~@(a:a))
~@(a:b)
12/34:@(#?a (~#%@:?y) #?b:?x)&!y:"/"
    (This fails because the pattern
        #?a (~#%@:?y) #?b
    is in the match context 12/34:<rhs>, not in a stringmatch context.
    Remember, the first @ says that subject is an atom, which it is in the
    match context, but not in a stringmatch context.)
@(12/34:@(#?a (~#%@:?y) #?b:?x)&!y:"/")
    (This fails because 12/34 is not an atom in a stringmatch context.)
*/
/* 29 December 2008
Compilation with Norcroft RISC OS ARM C vsn 3.00 [Jul 12 1989]
This resulted in some formal corrections (signed vs unsigned int,
int vs long, too many arguments for format in printf,
#if BRACMATEMBEDDED changed to #if defined BRACMATEMBEDDED)

The changes of 20071217 were undone, because the solution did not work for
    ~(&~@(a:a))
New solution:
In lex(), undo setting of
    success == FALSE
on : node if ~@ flags are attached to this operator.
This is a special case. In ~@(a:b) the ~ operator must
not negate the @ but the result of the string match.

I am not convinced that this is the right decision. Perhaps we simply
should not allow other flags than @ on : if we want it to be interpreted
as a string match operation.
*/
/* 17 December 2007
~@(a:a) didn't fail and ~@(a:b) didn't succeed. Now they do.
*/
/* 9 October 2007
Removed test print from getObjectDef. */
/* 18 September 2007
    a b "" ""
evaluates to
    a b ()
instead of
    a b
Changed function handleLUCHT to correct this.
*/
/* 7 July 2007
Differentiation: Originally, to indicate that a variable x depends on another
variable p, one wrote x=p, or x=s and s=p. If one wrote (x=), then y\Dx
resulted in stack overflow. The appropriate way to indicate dependeny is
dep=(x.p) (....)

The range function has been abolished. Originally the idea was that Bracmat
not only should handle numbers and symbols, but also ranges. Thus, 2^>3 would
give >16 and -5*>2 would give <-10. This had to be given up as ranges become
more and more complicated to express. (>4*~>3 = ?)

Code implementing a string table (COMPILE==1) has been removed
COMPILE works not faster, but slower (about 10%) and uses more nodes.

The unfinished attempt at implementing objects that can be saved and re-read
(serialization) has been given up (OBJECTS==1) Flag: [

VAX-specific code removed.
*/
/* 5 July 2007:
There were problems with stringmatches:
@(aaab:((|a) aa) b)
This failed because the match
    aa:aa
prematurely ended the match with failure.
The cause was that this match ONCED the whole match
    aa:(|a) aa

This partly undoes a change made in 200704

new$hash:?h
(h..ISO)$
(h..insert)$(a.b)

This made a division by zero, because (h..ISO) had rehashed the table
to a table with zero size. (hashes are born with non-zero size)
The computation of the loadfactor went wrong.
*/
/*  4 April 2007:
Tail recursion optimisation in complexiteit.

Solved bug in handling of strings with characters > 0x80 in expressions like
    a 

Solved bug in handling of e^(i*pi)

Solved bug in handling of i:-i

Solved bug in handling of -1*i^1/3

lst$ now lists ALL names. Previously, names starting with character above 0x7f
were hidden. Som hidden functions that were called from f0, f4 or f5 are
now declared inside these functions and therefore hidden.

get$ and fil$ first try to open a file interpreting the file name as a path
relative to the current working directory. If that fails, and if the program
is started with a fully qualified path+file name, this path is prepended to the
name of the file to be opened. If opening the file also fails with the new
path, get$ and fil$ fail. This functionality requires that
1) the file mode is "reading"
2) the file name does not contain an absolute path
3) the program knows its path
If the program does not know its path, it may help to start the program with
a fully qualified path on the command line. This instruction can be put in
a shell script or batch file.
This improvement is especially helpful for opening the "help"-file.

In string matching the expression
    @(abcd:?u (?:%@ %@) (?z & ~))
now makes sure that the pattern (?:%@ %@) never is presented with more than two
characters. Before, the @ flag did not really work with string matching and the
: operator extinguished the cut condition that arises in its rhs.
This works now within a reasonable time:
(do=
  get$(help,STR):?S
& @( !S
   :   ?
       ( ?:(%@:~" ":~",") %@ %@ %@ %@ %@ %@ %@ %@ %@ %@ %@ %@ %@ %@ %@ %@ %@ %@ %@ %@ %@ %@:?x
       & '(? ()$x ?):(=?x)
       )
       !x
   )
& !x);
!do


In a string, characters that also have a meaning as an operator can be escaped:
nsc\'ere
is the same as
"nsc'ere"

The names of cat$'s local variables are now taken from the list of names of
predefined functions. Consequently, cat$ does not list its own local variables.
(Previously, listing of these names was circumvented by the rule that names
starting with high-bit-set characters are kept hidden.)

Defunct ego$ and goe$ are abolished.
*/
/*
    22 February 2007:
    Major change in match() that speeds up matching. Found also an error in the
    handling of an alternating pattern with an alternating pattern in the lhs
    and a FENCE flag in the leftmost node.
    Similar changes in stringmatch() must yet be made.
*/
/*
    20 February 2007:
    Changed int and unsigned long to size_t in two places to stop warnings.
*/
/*
    18 January 2007:
    Added _CONSOLE to test for Windows API
    @(:? ?) failed. Cause: Unmotivied test for subjectstring not being empty.
*/
/*  20060704 caseinsensitivehash fixed*/
/*  23 June 2006
caseinsensitivehash uses lowerEquivalent without converting array index to
unsigned int!
*/
/*
    12 October 2005:
    Corrected error in flt$. During rounding, the variable m could become
    > 10. Consequently, the exponent must be increased by one and m must
    be divided by 10 in those cases.
*/
/*
    5 September 2005:
    Changed C++-style comments to old fashioned C-style comments.
    Removed enum {NoIndication,AnInteger,NotAFraction,NotANumber,AFraction,ANumber};
*/
/*
    5 april 2005:
    flg$<flags><atom> now returns ((=<flags>).<atom>)
    This protects the flags from evaluation.
*/
/* 17 november 2004:
    clk$ returns 0 if clock() returns -1
    bez$ returns (<nodes>.<max nodes>.<max ref>)
    epoc version: delete key emits ascii 8 (back space). Now, ascii(8) moves
    the input pointer one position back, deleting the previous entered
    character. (see mygetc)
*/
/* 25 sep 2004: strrev rewritten for Epoc */
/*
6 June 2004:
1) Started to make late binding in string matching
2) Corrected errors in assignment to and listing of objects with late bound values
*/
/*
20040830
This fails:
(obj=x=)&dbg'@("abc":?(obj.x) "c") & out$!(obj.x);

This works:
dbg'@("abc":?x "c") & out$!x;
*/
/*
    Bracmat. Programming language with pattern matching on tree structures.
    Copyright (C) 2002  Bart Jongejan

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*
NOTES
=====

2002.12.15
----------
This is the open source version of Bracmat.

Originally, Bracmat was written in Basic for the Amstrad computer. Its sole
purpose was to derive a simple expression for the curvature of a model
space-time, starting from the components of the metric. The only operations
the program was capable to perform were multiplications, exponentiations,
logarithms, and partial derivatives. The expressions were a mix of numbers
and symbolic variables, like "a+2*b". Thus, "a+a" was simplified to "2*a".

The second version of Bracmat, about 1988, was developed in Ansi C and run
on an Acorn Archimedes. Great care was taken to make the program portable to
other hardware, such as Atari, VAX and even the PC. The PC architecture, with
its limited memory, its 16 bit architecture and its limitation on the size of
the program stack, posed some severe limitations on the program. Therefore
great care was taken to limit the use of the stack to a minimum. This has
lead to some rather large functions (to save stack-consuming function calls).

The C version became a true programnming language, with program variables,
logical operators and function calls. The syntax, however, was not changed.
For example, instead of using "if...then...else...", I decided to write
something like "...&...|...", using lazy evaluation of the infix binary
logical operators "&" (AND) and "|" (OR) for program control.

The logical operators, of course, should test for operands being "true" or
"false". The main provider of interesting truth values became the pattern
matching operator ":", which tests whether the pattern (the rhs-operand)
matches the subject (the lhs-operand). The single outstanding feature of
Bracmat is, in fact, its pattern recognition, which works on tree structures,
not on strings of characters.

Bracmat was also extended with a few operators that makes this programming
language interesting in the field of computational linguistics, namely the
blank " ", the comma "," and the full stop ".". (The interpunction symbols
"?", "!" and ";" were already 'taken' to serve other purposes.)

You may find the source code difficult to read at some places. You are best
off if you understand English and Dutch (and perhaps Danish). Only if the
program arises enough interest I will invest the effort to streamline the
source text and make it more understandable for the general programmer.

COMPILATION
-----------
To compile an executable you only need this source file, bracmat.c.
It is assumed that the hardware is litte-endian, (which has become the most
common these days).

With GNU C, this should be enough to compile and link an executable:

gcc bracmat.c

With HP cc:

cc -Ae bracmat.c

If you can compile successfully but cannot run the program succesfully,
try putting -DBIGENDIAN on the command line of the compiler, like this:

cc -DBIGENDIAN  bracmat.c

This works of course only if the machine's hardware is big-endian.
*/

/*
TODO list:
20010103: Make > and < work on non-atomic stuff
20010904: Issue warning if 'arg' is declared as a local variable
*/
/* 20001213, There is a need to improve documentation of fil$ */
/* 20001213, rename a file ren$(oldname.newname) */
/* >Bracmat 16-11-91 */
/* 20010309 evalueer on LUCHT and KOMMA strings is now iterative on the
   right descending (deep) branch, not recursive.
   (It is now possible to read long lists, e.g. dictionairies, without causing
   stack overflow when evaluating the list.)
   20010821 a () () was evaluated to a (). Removed last ().
   20010903 (a.) () was evaluated to a
*/
#define DEBUGBRACMAT 0 /* implement dbg'(expression) */
#define DOSUMCHECK 0
#define PVNAME 0 /* allocate strings of variable names separately from variable structure. */
#define STRINGMATCH_CAN_BE_NEGATED 0 /* ~@(a:a) */

/**/
#ifndef NDEBUG
#define NDEBUG
#endif
/**/

#include <assert.h>

/* 12.10.1999 */
/* Hier moet nog wat gedaan worden.
Tweede argument van zoeknaam (voorvar) moet verwijderd worden en deallocatie
van eenmaal gealloceerde vars moet niet plaatsvinden.
Wanneer een eindknoop wordt gekopieerd moet een vars->Refcount opgehoogd worden
als de knoop een pointer naar een vars is. Omgekeerd moet vars->Refcount
verlaagd worden als zo'n knoop verwijderd wordt.
RESOLVE is te ruw: de string wordt eenvoudig overschreven met een pointer, wat
tot verlies van geheugen kan leiden.
*/

/*19980208
Bug in match!!
Removed 19971207
*/
/*
sub must also accept . as separator between args
*/
/* wis: 18 Maart 1997, tail recursion optimization; delete deep structures*/
/* bezig met modernisering getallen */
/* 16 mei 1993: constante "-i" ingevoerd om evenwicht te brengen in gedrag
   van complexe getallen en hun complex geconjugeerde. */
/* Nog nodig: -n*i^iets -> n*-i^iets
              n*i*a+m*-i*a  -> (n-m)*i*a
   Goed doortesten !
*/


/* 24 april 1992: UNOPS uitgebreid met MINUS */
/* 26 april 1992: fct aangepast voor (a+b)^-n */
/* 24 maart 1993: function syntax veranderd:
   met FUNC defined oude stijl: foo = fun$(loc'(x,y,z),!arg);
   zonder FUNC define:          foo = x,y,z.!arg */

/* 30 juli 1993: structure:
   het is nu mogelijk om aan een expressie als naam=Bart een andere waarde
   toe te kennen. In feite wordt de rechter operand van de = operator
   stomweg vervangen door de nieuwe waarde, waardoor circulaire data-
   structuren mogelijk worden! BJO 4 Jan 1996

   voorbeeld:

   {?} x==(name=Bart).(age=40)
   {?} !x
   {!} =(name=Bart).(age=40)
   {?} !!x
   {!} Bart.40
   {?} !x:(=?naam.?leeftijd)
   {?} Bart Jongejan:?!naam
   {?} !!x
   {!} Bart Jongejan.40
   {?} x..age=veertig                          BJO 4 Jan 1996
   {?} !!x
   {!} Bart Jongejan.veertig

   x..name.first=Bart vervangt Jan door Bart in

   x==(name=(first=Jan).(family=Abbens)).(age=33)

   Merk op dat de = operator z'n speciale betekenis in patterns kwijt is
   ~=(% %) moet dus voortaan geschreven worden als ((% %) & `~|?)
*/

#if 0 && defined __GNUC__ && !defined sparc && !defined __hpux && !defined __hpux__
/* TODO test must be changed to a positive list. Bart 20030704 */
#define ARM /*1*/ /* assume it's an Acorn */
#define os_swix os_swi /* different naming */
typedef struct {
 int r[10];
}os_regset;
#else
/*#define ARM 0*/ /* assume it isn't an Acorn */
#endif


#if (defined __TURBOC__ && !defined __WIN32__) || (defined ARM && !defined __SYMBIAN32__)
#define O_S 1 /* 1 = with operating system interface swi$ (RISC_OS or TURBO-C), 0 = without  */
#else
#define O_S 0
#endif

/* aanwijzingen voor het compileren
   (met een ANSI-C compiler of iets wat daar dichtbij in de buurt komt)

Archimedes ANSI-C release 3:
*up
*del. :0.$.c.clog
*spool :0.$.c.clog
*cc bracmat
*spool

Met RISC_OS functies:

cc bracmat

file cc (in directory c):

| >cc
up
delete $.c.clog
spool $.c.clog
cc -c %0 -IRAM:$.RISC_OSLib
if Sys$ReturnCode = 0 then run c.li %0 else spool

file li (in directory c):

| >li
link -o %0 o.%0 RAM:$.RISC_OSLib.o.RISC_OSLib RAM:$.Clib.o.Stubs
||G
spool
if Sys$ReturnCode = 0 then squeeze %0 else echo |G

Microsoft QUICKC (MS-DOS) (compact en large model kunnen allebei)
qcl /Ox /AC /F D000 bracmat.c
Microsoft optimizing compiler V5.1
cl /Ox /AC /F D000 bracmat.c

Borland TURBOC (MS-DOS) V2.0
tcc -w -f- -r- -mc -K- bracmat

Atari : definieer -DATARI i.v.m. BIGENDIAN en extern int _stksize = -1;
               en -DW32   doch alleen als (int)==(long)
*/

/* optionele #defines voor debuggen en aanpassing aan machine */

#define TELMAX 1 /* maximaal aantal gealloceerde nodes laten zien */
#define TELLING 0   /* idem,uitgebreid met huidige allocatie, per groep van
                       4,8,12 en >12 bytes */
#if TELLING
#ifndef TELMAX
#define TELMAX 1
#endif
#endif

/*#define reslt hreslt  om in resultaat ALLE haakjes te laten zien*/
#define INTSCMP 0   /* linke manier om strings te vergelijken */
#define ICPY 0      /* woord voor woord copieren, i.p.v. byte voor byte */

/* hieronder zijn geen optionele #defines meer */
#if defined __BYTE_ORDER && defined __LITTLE_ENDIAN /* gcc on linux defines these */
#if __BYTE_ORDER == __LITTLE_ENDIAN
#define BIGENDIAN 0
#else
#define BIGENDIAN 1
#endif
#endif

#ifndef BIGENDIAN

#if defined mc68000 || defined MC68000 || defined mc68010 || defined mc68020 || defined mc68030 || defined ATARI || defined sparc || defined __hpux || defined __hpux__
#define BIGENDIAN 1
#endif

#endif

/* this would exclude gcc on Linux
#ifndef BIGENDIAN
#if defined ARM || defined _Windows || defined __MSDOS__ || defined _M_IX86 || defined __WIN32__ || defined _WIN32 || defined _M_I86
#define BIGENDIAN     0
#else
#define BIGENDIAN     1
#endif
#endif
*/

#ifndef BIGENDIAN
#define BIGENDIAN     0
#endif

#if (defined _Windows || defined _MT /*multithreaded, VC6.0*/)&& (!defined _CONSOLE /*18 January 2007*/ && !defined __CONSOLE__ || defined NOTCONSOLE || defined BRACMATEMBEDDED)
/* _CONSOLE defined by Visual C++ and __CONSOLE__ seems always to be defined in C++Builder */
#define MICROSOFT_WINDOWS_API 1
#else
#define MICROSOFT_WINDOWS_API 0
#endif

#if MICROSOFT_WINDOWS_API && defined POLL /*Bart 20030410: Often no need for polling in multithreaded apps.*/
#define JMP 1 /* 1: listen to WM_QUIT message. 0: Do not listen to WM_QUIT message. */
#else
#define JMP 0
#endif

#ifdef BRACMATEMBEDDED /*MICROSOFT_WINDOWS_API*/ /* def ARM */
#include "bracmat.h"
#else
typedef struct startStruct
    {
    int (*WinIn)(void);
    void (*WinOut)(int c);
    void (*WinFlush)(void);
    } startStruct;
#endif


#if defined sun && !defined __GNUC__
#define SIGNED_CHAR 1
#include <unistd.h> /* SEEK_SET, SEEK_CUR */
#define ALERT 7
#define strtoul(a,b,c) strtol(a,b,c)
#else
#include <stddef.h>
#endif

#include <stdlib.h>

#ifndef ALERT
#define ALERT '\a'
#endif

#include <limits.h>

#if defined __TURBOC__ || defined __MSDOS__ || defined _WIN32 || defined __GNUC__
#define DELAY_DUE_TO_INPUT
#endif

#include <time.h>
#ifndef CLOCKS_PER_SEC
#ifdef CLK_TCK  /* pre-ANSI-C */
#define CLOCKS_PER_SEC CLK_TCK
#else
#if defined sun
#define CLOCKS_PER_SEC 1000000 /* ??? */
#endif
#endif
#endif

#ifndef SIGNED_CHAR
#define SIGNED_CHAR 0
#endif





#define LOGWORDLENGTH 2
/* vlaggen in knoop */
#define NOT              1      /* ~ */
     /* zo houden ivm vermenging logische en bit operatoren && || | ^ & */
/*#define OBJECT      (1<< 1), This bit is free 20070708*/
#define POSITION        (1<< 1) /* [ */
#define SUCCESS         (1<< 2)
#define READY           (1<< 3)
#define INDIRECT        (1<< 4) /* ! */
#define DOUBLY_INDIRECT (1<< 5) /* !! */
#define FENCE           (1<< 6) /* `   binnen 1 byte met ATOM en NOT */
#define ATOM            (1<< 7) /* @ */
#define NONIDENT        (1<< 8) /* % */
#define GREATER_THAN    (1<< 9) /* > */
#define SMALLER_THAN    (1<<10) /* < */
#define NUMBER          (1<<11) /* # */
#define BREUK           (1<<12) /* / */
#define UNIFY           (1<<13) /* ? */
#define IDENT           (1<<14)
#define IMPLIEDFENCE    (1<<15) /* 20070222 */
#define VISIBLE_FLAGS_NON_COMP   (INDIRECT|DOUBLY_INDIRECT|ATOM|NONIDENT|\
                        NUMBER|BREUK|UNIFY) /* allows < > ~< and ~> as flags on numbers */
#define VISIBLE_FLAGS_WEAK   (INDIRECT|DOUBLY_INDIRECT|FENCE|UNIFY) /* allows < > ~< and ~> as flags on numbers */
#define VISIBLE_FLAGS_COMP   (VISIBLE_FLAGS_NON_COMP|NOT|GREATER_THAN|SMALLER_THAN)
#define VISIBLE_FLAGS   (VISIBLE_FLAGS_COMP|FENCE|POSITION)

#define RATIONAAL(psk)      (((psk)->ops & (QGETAL|IS_OPERATOR|VISIBLE_FLAGS)) == QGETAL)
#define RATIONAAL_COMP(psk) (((psk)->ops & (QGETAL|IS_OPERATOR|VISIBLE_FLAGS_NON_COMP)) == QGETAL)
#define RATIONAAL_WEAK(psk) (((psk)->ops & (QGETAL|IS_OPERATOR|VISIBLE_FLAGS_WEAK)) == QGETAL)
#define       LESS(psk) (((psk)->v.fl & (VISIBLE_FLAGS_COMP)) == SMALLER_THAN)
#define LESS_EQUAL(psk) (((psk)->v.fl & (VISIBLE_FLAGS_COMP)) == (NOT|GREATER_THAN))
#define MORE_EQUAL(psk) (((psk)->v.fl & (VISIBLE_FLAGS_COMP)) == (NOT|SMALLER_THAN))
#define       MORE(psk) (((psk)->v.fl & (VISIBLE_FLAGS_COMP)) == GREATER_THAN)
#define UNEQUAL(psk) (((psk)->v.fl & (VISIBLE_FLAGS_COMP)) == NOT)

#define INTEGER(kn) (((kn)->ops & (QGETAL|QBREUK|IS_OPERATOR|VISIBLE_FLAGS)) == QGETAL)
#define INTEGER_COMP(kn) (((kn)->ops & (QGETAL|QBREUK|IS_OPERATOR|VISIBLE_FLAGS_NON_COMP)) == QGETAL)

#define INTEGER_NIET_NEG(kn) (((kn)->ops & (QGETAL|MINUS|QBREUK|IS_OPERATOR|VISIBLE_FLAGS))\
                                == QGETAL)
#define INTEGER_NIET_NEG_COMP(kn) (((kn)->ops & (QGETAL|MINUS|QBREUK|IS_OPERATOR|VISIBLE_FLAGS_NON_COMP))\
                                == QGETAL)

#define INTEGER_POS(kn) (((kn)->ops & (QGETAL|MINUS|QNUL|QBREUK|IS_OPERATOR|VISIBLE_FLAGS))\
                                == QGETAL)
#define INTEGER_POS_COMP(kn) (((kn)->ops & (QGETAL|MINUS|QNUL|QBREUK|IS_OPERATOR|VISIBLE_FLAGS_NON_COMP))\
                                == QGETAL)

/*
#define INTEGER_NIET_NUL(kn) (((kn)->ops & (QGETAL|QNUL|QBREUK|IS_OPERATOR|VISIBLE_FLAGS))\
                                == QGETAL)*/
#define INTEGER_NIET_NUL_COMP(kn) (((kn)->ops & (QGETAL|QNUL|QBREUK|IS_OPERATOR|VISIBLE_FLAGS_NON_COMP))\
                                == QGETAL)
#define HAS_MINUS_SIGN(kn) (((kn)->ops & (MINUS|IS_OPERATOR)) == MINUS)

#define RAT_NUL(kn) (((kn)->v.fl & (QNUL|IS_OPERATOR|VISIBLE_FLAGS)) == QNUL)
#define RAT_NUL_COMP(kn) (((kn)->v.fl & (QNUL|IS_OPERATOR|VISIBLE_FLAGS_NON_COMP)) == QNUL)
#define RAT_NEG(kn) (((kn)->ops & (QGETAL|MINUS|IS_OPERATOR|VISIBLE_FLAGS)) \
                                == (QGETAL|MINUS))
#define RAT_NEG_COMP(kn) (((kn)->ops & (QGETAL|MINUS|IS_OPERATOR|VISIBLE_FLAGS_NON_COMP)) \
                                == (QGETAL|MINUS))

#define RAT_RAT(kn) (((kn)->ops & (QGETAL|QBREUK|IS_OPERATOR|VISIBLE_FLAGS))\
                                == (QGETAL|QBREUK))

#define RAT_RAT_COMP(kn) (((kn)->ops & (QGETAL|QBREUK|IS_OPERATOR|VISIBLE_FLAGS_NON_COMP))\
                                == (QGETAL|QBREUK))
#define IS_EEN(kn) ((kn)->u.iobj == EEN && !((kn)->ops & (MINUS | VISIBLE_FLAGS)))


#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>

#if INTSCMP
#define STRCMP(a,b) intscmp((long*)(a),(long*)(b))
#else
#define STRCMP(a,b) strcmp((char *)(a),(char *)(b))
#endif
#if ICPY
#define MEMCPY(a,b,n) icpy((long*)(a),(long*)(b),n)
#else
#define MEMCPY(a,b,n) memcpy((char *)(a),(char *)(b),n)
#endif

#ifdef ATARI
extern int _stksize = -1;
#endif

#if defined ARM
#if O_S /*20010827, was #ifdef O_S */
#if defined __GNUC__ && !defined sparc
#include "sys/os.h"
#else
#include "os.h"
#endif
#endif
#endif

#define SHL 16

#define ops v.fl
#define flgs v.fl

#ifdef __TURBOC__
#if O_S
typedef struct
    {
    int r[10];
    } os_regset;
#endif
#endif

#define RIGHT u.p.rechts
#define LEFT  u.p.links
#define TRUE 1
#define FALSE 0
#define PRISTINE (1<<2)
#define ONCE (1<<3)
#define POSITION_ONCE (1<<4)
#define POSITION_MAX_REACHED (1<<5)
/*#define DONOTSHORTEN (1<<5) */ /* 32 */
    /*  wordt gezet door match(sub,pat,snijaf).
        Aan : doe geen pogingen om pat met een andere sub te matchen
    */
#define OBJ(p) &((p).u.obj)
#define LOBJ(p) ((p).u.lobj)
#define POBJ(p) &((p)->u.obj)
#define PIOBJ(p) ((p)->u.iobj) /* Added. Bart 20031110 */
#define PLOBJ(p) ((p)->u.lobj)

#define QOBJ(p) &(p)
#define QPOBJ(p) p

#if BIGENDIAN
#define iobj lobj
#define O(a,b,c) (a*0x1000000L+b*0x10000L+c*0x100)
#else
#define O(a,b,c) (a+b*0x100+c*0x10000L)
#endif

#if TELMAX
#define BEZ O('b','e','z')
#endif

#if O_S
#define SWI O('s','w','i')
#endif

#define ALC O('a','l','c')
#define APP O('A','P','P')
#define ASC O('a','s','c')
#define CHR O('C','H','R')
#define CLK O('c','l','k')
#define CON O('C','O','N')
#define CUR O('C','U','R')
#define DBG O('d','b','g')
#define DEC O('D','E','C')
#define DEN O('d','e','n')
#define DIV O('d','i','v')
#define DOS O('D','O','S')
#define ECH O('E','C','H')
#define EEN O('1', 0 , 0 )
#define END O('E','N','D')/*SEEK_END hoeft niet te werken voor binary file !!*/
/* err$foo redirects error messages to foo */
/*#define ERR O('e','r','r')*/
#define EXT O('E','X','T')
#define FIL O('f','i','l')
#define FLG O('f','l','g')
#define GLF O('g','l','f') /* 20050405 The opposite of flg */
#define FRE O('f','r','e')
#define FNC O('f','n','c')
#define GET O('g','e','t')
/*#define HUM O('H','U','M')*/
#define IM  O('i', 0 , 0 )
#define KAR O('c','h','r')
#define LIN O('L','I','N')
#define LOW O('l','o','w')
#define REV O('r','e','v') /* 20040830 strrev */
#define LST O('l','s','t')
#define MEM O('M','E','M')
#define MINEEN O('-','1',0)
#define MMF O('m','e','m')
#define MOD O('m','o','d')
#define NEW O('N','E','W')
#define New O('n','e','w')
#define NULLE O('0',0 , 0 )
#define PEE O('p','e','e')
#define PI  O('p','i', 0 )
#define POK O('p','o','k')
#define PUT O('p','u','t')
#define PRV O('?', 0 , 0 )
#define REN O('r','e','n') /* 20001213, rename a file */
#define SET O('S','E','T')
#define STR O('s','t','r')
#define STRt O('S','T','R')
#define SYS O('s','y','s')
#define SIM O('s','i','m')
#define STG O('S','T','R')
#define TBL O('t','b','l')
#define TEL O('T','E','L')
//#define TIL O('t','i','l')
#define TWEE O('2', 0 , 0 )
#define TXT O('E','X','P')
#define UPP O('u','p','p')
#define VAP O('V','A','P')
#define WHL O('w','h','l')
#define XX  O('e', 0 , 0 )


#define SHIFT_STR 0
#define SHIFT_VAP 1
#define SHIFT_MEM 2
#define SHIFT_ECH 3
#define OPT_STR 1
#define OPT_VAP 2
#define OPT_MEM 4
#define OPT_ECH 8


#define REF_COUNT_BITS 6 /* 6 - 15 , 8 - 11 is heel mooi */

#define FILTERS (BREUK | NUMBER | SMALLER_THAN | GREATER_THAN | NONIDENT | ATOM)
#define ATOMFILTERS (BREUK | NUMBER | SMALLER_THAN | GREATER_THAN | ATOM | FENCE | IDENT)
#define SATOMFILTERS (/*ATOM | */FENCE | IDENT)

#define FLGS (FILTERS | FENCE | DOUBLY_INDIRECT | INDIRECT)

#define ONTKENNING(Flgs,flag)  ((Flgs & NOT ) && \
                                (Flgs & FILTERS) >= (flag) && \
                                (Flgs & FILTERS) < ((flag) << 1))
#define ASSERTIVE(Flgs,flag) ((Flgs & flag) && !ONTKENNING(Flgs,flag))
#define FAAL (pat->v.fl & NOT)
#define NIKS(p) (((p)->v.fl & NOT) && !((p)->v.fl & FILTERS))
#define NIKSF(Flgs) ((Flgs & NOT) && !(Flgs & FILTERS))

#define ERFENIS (GREATER_THAN|SMALLER_THAN|FENCE/*|OBJECT*/|POSITION)
#define UNOPS (UNIFY | FLGS | NOT | MINUS)
#define HAS_UNOPS(a) ((a)->v.fl & UNOPS)
#define HAS__UNOPS(a) (is_op(a) && (a)->v.fl & (UNIFY | FLGS | NOT))
#define IS_VARIABLE(a) (/*is_op(a) && 19970831*/ (a)->v.fl & (UNIFY | INDIRECT | DOUBLY_INDIRECT))
#define IS_BANG_VARIABLE(a) ((a)->v.fl & (INDIRECT | DOUBLY_INDIRECT))

#define SUBJECTNOTNIL(sub,pat) (is_op(sub) || HAS_UNOPS(sub) || (PIOBJ(sub) != PIOBJ(nil(pat))))



typedef int Boolean;
typedef struct Vars vars;

typedef union
        {
#ifndef NDEBUG
        struct
            {
            unsigned int not             :1;      /* ~ */
            unsigned int position        :1; /* [ */
            unsigned int success         :1;
            unsigned int ready           :1;

            unsigned int indirect        :1; /* ! */
            unsigned int doubly_indirect :1; /* !! */
            unsigned int fence           :1; /* `   binnen 1 byte met ATOM en NOT */
            unsigned int atom            :1; /* @ */

            unsigned int nonident        :1; /* % */
            unsigned int greater_than    :1; /* > */
            unsigned int smaller_than    :1; /* < */
            unsigned int number          :1; /* # */

            unsigned int breuk           :1; /* / */
            unsigned int unify           :1; /* ? */
            unsigned int ident           :1;
            unsigned int impliedfence    :1;

            unsigned int IS_OPERATOR        :1;
            unsigned int binop              :4;
            /* WORDT DOT KOMMA OF EN MATCH LUCHT PLUS MAAL EXP LOG DIF FUU FUN STREEP */
            unsigned int latebind           :1;
            unsigned int refcount           :10;
            } node;
        struct
            {
            unsigned int not             :1;      /* ~ */
            unsigned int position        :1; /* [ */
            unsigned int success         :1;
            unsigned int ready           :1;

            unsigned int indirect        :1; /* ! */
            unsigned int doubly_indirect :1; /* !! */
            unsigned int fence           :1; /* `   binnen 1 byte met ATOM en NOT */
            unsigned int atom            :1; /* @ */

            unsigned int nonident        :1; /* % */
            unsigned int greater_than    :1; /* > */
            unsigned int smaller_than    :1; /* < */
            unsigned int number          :1; /* # */

            unsigned int breuk           :1; /* / */
            unsigned int unify           :1; /* ? */
            unsigned int ident           :1;
            unsigned int impliedfence    :1;

            unsigned int is_operator        :1;
            unsigned int qgetal             :1;
            unsigned int minus              :1;
            unsigned int qnul               :1;
            unsigned int qbreuk             :1;

            unsigned int latebind           :1;
            unsigned int refcount           :10;
            } leaf;
#endif
        unsigned int fl;
        } tFlags;


typedef struct sk
    {
    tFlags v;

    union
        {
        struct
            {
            struct sk *links,*rechts;
            } p;
        long lobj;
#if !BIGENDIAN
        int  iobj; /* This part of the structure can be used for comparisons
                      with short strings that fit into 2 bytes in one machine
                      operation, like "\0\0" or "1\0" */
#endif
        unsigned char obj;
        } u;
    } sk;

static sk nilk,nulk,eenk,argk,selfkn,Selfkn,mintweek,mineenk,tweek,minvierk,vierk;/*diek,*/
static char * targetPath = NULL; /* 20070402. Path that can be prepended to filenames. */

typedef sk *psk;

static psk adr[7],m0 = NULL,m1 = NULL,
f0 = NULL,f1 = NULL,f4 = NULL,f5 = NULL
/*,f7 = NULL*/
;

typedef psk *ppsk;
typedef struct ngetal
    {
    int sign;
    ptrdiff_t length;
    void *alloc;
    char *number;
    } ngetal;

#define Qgetal psk

typedef struct varia
    {
    struct varia *prev; /* verdi[-1] */
    psk verdi[1];       /* verdi[0], arraysize wordt door psh aangepast */
    } varia;

struct Vars /* sizeof(vars) = n * 4 bytes */
    {
#if PVNAME
    unsigned char *vname;
#define VARNAME(x) x->vname
#endif
    vars *next;
    int n;
    int selector;
    varia *pvaria; /* kan ook entry[0] bevatten (als n == 0) */
#if PVNAME
/*    unsigned char *vname;*/
#else
    union
        {
        long Lobj;
        unsigned char Obj;
        } u;
#define VARNAME(x) &x->u.Obj
#endif
    };

/*typedef struct Vars vars;*/

static vars * variabelen[256];

typedef struct kknoop
    {
    tFlags v;
    psk links,rechts;
    } kknoop;

typedef struct objectknoop /* createdWithNew == 0 */
    {
    tFlags v;
    psk links,rechts;
    unsigned int refcount : 30;
    unsigned int built_in:1;
    unsigned int createdWithNew:1;
    } objectknoop;

typedef struct stringrefknoop /* 20040606 */
    {
    tFlags v;
    psk kn;
    unsigned char * str;
    /*unsigned long length;*/
    size_t length; /*Bart 20070220 unsigned long -> size_t*/
    } stringrefknoop;

/*typedef typedObjectknoop;*/
typedef enum    {function_fail
                ,built_in_function_ok
                ,user_function_ok
                ,user_object_method_ok
                ,builtin_object_builtin_method_ok
                ,builtin_object_user_method_ok
                } function_return_type;
struct typedObjectknoop;
typedef function_return_type (*method_pnt)(struct typedObjectknoop * This,ppsk pkn);

typedef struct method
    {
    char * name;
    method_pnt func;
    } method;

/*
typedef union method_or_data
    {
    method m;
    objectdata d;
    } method_or_data;
*/
typedef struct /**/ typedObjectknoop /**/ /* createdWithNew == 1 */
    {
    tFlags v;
    psk links,rechts; /* links == nil, rechts == data (if vtab == NULL)
            or name of object type, e.g. [set], [hash], [file], [float] (if vtab != NULL)*/
    unsigned int refcount : 30; /* Always 0L */
    unsigned int built_in:1;
    unsigned int createdWithNew:1;
    void * voiddata;
    #define HASH(x) (Hash*)x->voiddata
    #define VOID(x) x->voiddata
    #define PHASH(x) (Hash**)&x->voiddata
    method * vtab; /* The last element n of the array must have vtab[n].name == NULL */
    } typedObjectknoop;

#define INCREFCOUNT(a) (a)->refcount++
#define DECREFCOUNT(a) (a)->refcount--
#define REFCOUNTNONZERO(a) ((a)->refcount)
#define ISBUILTIN(a) ((a)->built_in)
#define SETBUILTIN(a) (a)->built_in = 1
#define UNSETBUILTIN(a) (a)->built_in = 0
#define ISCREATEDWITHNEW(a) ((a)->createdWithNew)
#define SETCREATEDWITHNEW(a) (a)->createdWithNew = 1
#define UNSETCREATEDWITHNEW(a) (a)->createdWithNew = 0

#ifndef BRACMATEMBEDDED
static char * errorFileName = NULL;
static FILE * errorStream = NULL;
#endif

typedef struct filehendel
    {
    char *naam;
    FILE *fp;
    long filepos; /* Normally -1. If >= 0, then the file is closed.
                When reopening, filepos is used to find the position
                before the file was closed. */
    long mode;
    long type;
    long size;
    long getal;
    long tijd;
    int written;
    struct filehendel *next;
    char * stop; /* contains characters to stop reading at, default NULL */
    } filehendel;

static filehendel *fh0 = NULL;

typedef long refCountType;

typedef struct indexType
    {
    long offset;
    refCountType refCnt;
    size_t size;
    } indexType;

typedef struct handleType
    {
    long number;
    char *fileName;
    } handleType;

typedef struct objectType
    {
    handleType handle;
    refCountType refCnt;
    long offset;
    psk obj;
    long size;
    } objectType;

#define NOT_STORED -1L

typedef struct freeStoreType
    {
    long nextFree;
    long size;
    } freeStoreType;

/*       operator                 eindknoop           optab       note
Flgs 0                   NOT
     1                  free (previously: OBJECT) POSITION
     2                  SUCCESS
     3                  READY
     4                 INDIRECT
     5              DOUBLY_INDIRECT
     6                  FENCE
     7                  ATOM
     8                 NONIDENT
     9                GREATER_THAN
    10                SMALLER_THAN
    11                  NUMBER
    12                  BREUK
    13                  UNIFY
    14                  IDENT
    15               IMPLIEDFENCE
ops 16  0             IS_OPERATOR
    17  1   (operatoren 0-14)     QGETAL
    18  2       "                 MINUS
    19  3       "                 QNUL
    20  4       "                 QBREUK
    21  5             LATEBIND                        NOOP
    22  6          (reference count)
    23  7                 "
    24  8                 "
    25  9                 "
    26 10                 "
    27 11                 "
    28 12                 "
    29 13                 "
    30 14                 "
    31 15                 "

Reference count starts with 0, not 1
*/

#define OPSH (SHL+1)
#define IS_OPERATOR (1 << SHL)
#define WORDT   ((0<<OPSH) + IS_OPERATOR)
#define DOT     ((1<<OPSH) + IS_OPERATOR)
#define KOMMA   ((2<<OPSH) + IS_OPERATOR)
#define OF      ((3<<OPSH) + IS_OPERATOR)
#define EN      ((4<<OPSH) + IS_OPERATOR)
#define MATCH   ((5<<OPSH) + IS_OPERATOR)
#define LUCHT   ((6<<OPSH) + IS_OPERATOR)
#define PLUS    ((7<<OPSH) + IS_OPERATOR)
#define MAAL    ((8<<OPSH) + IS_OPERATOR)
#define EXP     ((9<<OPSH) + IS_OPERATOR)
#define LOG     ((10<<OPSH) + IS_OPERATOR)
#define DIF     ((11<<OPSH) + IS_OPERATOR)
#define FUU     ((12<<OPSH) + IS_OPERATOR)
#define FUN     ((13<<OPSH) + IS_OPERATOR)
#define STREEP  ((14<<OPSH) + IS_OPERATOR) /* dummy */

static const psk knil[16] =
{NULL,NULL,NULL,NULL,NULL,NULL,&nilk,&nulk,
&eenk,NULL,NULL,NULL,NULL,NULL,NULL,NULL};

static const char opchar[16] =
{'=','.',',','|','&',':',' ','+','*','^','\016','\017','\'','$','_','?'};

#define OPERATOR ((0xF<<OPSH) + IS_OPERATOR)

#define kop(kn) ((kn)->ops & OPERATOR)
#define kopo(kn) ((kn).ops & OPERATOR)
#define is_op(kn) ((kn)->ops & IS_OPERATOR)
#define is_object(kn) (((kn)->ops & (IS_OPERATOR|OPERATOR)) == (IS_OPERATOR|WORDT))
#define klopcode(kn) (kop(kn) >> OPSH)

#define nil(p) knil[klopcode(p)]


#define NOOP    (OPERATOR+1)
#define QGETAL  (1 << (SHL+1))
#define MINUS   (1 << (SHL+2))
#define QNUL    (1 << (SHL+3))
#define QBREUK  (1 << (SHL+4))
#define LATEBIND (1 << (SHL+5))
#define ONE     (1 << (SHL+REF_COUNT_BITS))
#define DEFINITELYNONUMBER (1 << (SHL+6))
#define LAGEROP (1<<OPSH)

#define ALL_REFCOUNT_BITS_SET \
       ((((unsigned int)(~0)) >> (SHL+REF_COUNT_BITS)) << (SHL+REF_COUNT_BITS))

#ifdef __SYMBIAN32__
#define KILOKNOPEN    11
#else
#if defined ARM
#define KILOKNOPEN    10 /* 10 -> 100 21 Aug 1996 (Windows 95)*/
#else
#define KILOKNOPEN    10000 /* 10 -> 100 21 Aug 1996 (Windows 95)*/
#endif
#endif

#ifdef __CONSOLE__
#define PROMILLAGE4   20
#define PROMILLAGE8  290
#define PROMILLAGE12 400
#define PROMILLAGE16 250
#define PROMILLAGE20  20
#define PROMILLAGE24  20
#else
#define PROMILLAGE4   40  /* 12 *  40 *  4 =  1920 */
#define PROMILLAGE8  320  /* 12 * 320 *  8 = 30720 */
#define B24
#ifdef B24
#define PROMILLAGE12 300
#define PROMILLAGE16 300
                                       /*              + 207360 */
#define PROMILLAGE20  10
#define PROMILLAGE24  30
#else
#define PROMILLAGE12 320  /* 12 * 320 * 12 = 46080  (  < 65536 ) */
#define PROMILLAGE16 320  /* 12 * 320 * 16 = 61440  (  < 65536 ) */
                                       /*              + 207360 */
#define PROMILLAGE20   0
#define PROMILLAGE24   0
#endif
#endif

#define shared(kn) ((kn)->ops & ALL_REFCOUNT_BITS_SET)
#define sharedo(kn) ((kn).ops & ALL_REFCOUNT_BITS_SET)

#if 0
#define all_refcount_bits_set(kn) (shared(kn) == ALL_REFCOUNT_BITS_SET)
#define inc_refcount(kn) ((kn)->ops += ONE)
#define dec_refcount(kn) ((kn)->ops -= ONE)
#else

static int all_refcount_bits_set(psk kn)
    {
    return (shared(kn) == ALL_REFCOUNT_BITS_SET) && !is_object(kn);
    }

static void inc_refcount(psk kn)
    {
    if(shared(kn) == ALL_REFCOUNT_BITS_SET) /* ensure that this can only be the case
                                            for objectknoop nodes, i.e. test
                                            with all_refcount_bits_set before calling
                                            inc_refcount.
                                            (all_refcount_bits_set must return FALSE)
                                            */
        INCREFCOUNT((objectknoop*)kn);
    else
        (kn)->ops += ONE;
    }

static void dec_refcount(psk kn)
    {
    if(  is_object(kn)
      && REFCOUNTNONZERO((objectknoop*)kn)
      )
        {
        DECREFCOUNT((objectknoop*)kn);
        }
    else
        (kn)->ops -= ONE;
    }
#endif

/*
#define new_operator_like(kn) (psk)bmalloc(kop(kn) == WORDT ? sizeof(objectknoop) : sizeof(kknoop))
*/

#define STRING    1
#define VAPORIZED 2
#define MEMORY    4
#define ECHO      8

#include <stdarg.h>
static va_list ap;
static unsigned char *startPos;

static const char
hekje1[] = "\1",
hekje5[] = "\5",
hekje6[] = "\6",
onbal[] =
"unbalanced",

fct[] = "(fct=((m,w,b,Z,f,T,v,X,B,N,n,k)."
 "(k=(p.!arg:%?p+?arg&!s*!p+k$!arg|!arg))&"
 "(f=((l,r,S).!arg:(?arg,?S)&Z$(v$(m$!arg:?arg:%+%))|"
  "!arg:%?l*%?r&f$(!l,!S)*f$(!r,!S)|!arg:%?l^%?r&f$(!l,!S)^f$(!r,!S)|!arg))&"
 "(b=(U.!arg:%?U %?arg&!U+b$!arg|!arg))&"
 "(v=(U.!arg:%?U+%?arg&!U v$!arg|!arg))&"
 "(m=((l,r).!arg:%+%:?+?*(?^(#<0*?):?l)*?+?&"
  "!l*m$(1+!l^(-1*+-1)*(1+!l^*!arg+-1)+-1)|w$!arg))&"
 "(w=((l,r).!arg:#%?l*?+%&!l*w$(1+!l^-1*!arg+-1)|!arg))&"
 "(Z=((C,E,G,H,O,P,p,s,q,r,x,t,u,X,Q,R)."
  "!arg:((|1):?E) %?G ?H %?`O (?P&b$!G:?p*(?x^?t|~#%?`x&1:?t)*(?q&"
  "!O:?s*(!x^?u|`!x&1:?u)*(?r&(!E (!P:?Q (?*(!x^?|!x)*?:?X) ?R&"
  "!T !X !R !H !Q|!P !H !T):?C:(% %&`~|?)|Z$!C:?C|!S:0&b$!C:?C))))&!C))&"
 "(T=!x^!u*f$(!p*!x^(!t+-1*!u)*!q+!s*!r,!S+1))&"
 "f$(!arg,0)))";

typedef struct deelres
    {
    ngetal quot;
    ngetal rest;
    } deelres;







typedef struct byte4
    {
    union
        {
        struct byte4 *p;
        unsigned long f;
        } u;
    } byte4;

static byte4 *p4,*p4start,*p4end;

typedef struct byte8
    {
    union
        {
        struct byte8 *p;
        unsigned long f;
        } u;
    long rest;
    } byte8;

static byte8 *p8,*p8start,*p8end;

typedef struct byte12
    {
    union
        {
        struct byte12 *p;
        unsigned long f;
        } u;
    long rest1;
    long rest2;
    } byte12;

static byte12 *p12,*p12start,*p12end;

typedef struct byte16
    {
    union
        {
        struct byte16 *p;
        unsigned long f;
        } u;
    long rest1;
    long rest2;
    long rest3;
    } byte16;

static byte16 *p16,*p16start,*p16end;

#ifdef _4_5
typedef struct byte20
    {
    union
        {
        struct byte20 *p;
        unsigned long f;
        } u;
    long rest1;
    long rest2;
    long rest3;
    long rest4;
    } byte20;

static byte20 *p20,*p20start,*p20end;

typedef struct byte24
    {
    union
        {
        struct byte24 *p;
        unsigned long f;
        } u;
    long rest1;
    long rest2;
    long rest3;
    long rest4;
    long rest5;
    } byte24;

static byte24 *p24,*p24start,*p24end;
#endif

static size_t telling = 0;

/*ptrdiff_t xlengte,ylengte;*/

#ifdef TELMAX
static size_t
    globalloc = 0,
    maxgloballoc = 0;
#endif

#if TELLING
static size_t cnts[256],alloc_cnt = 0,totcnt = 0;
#endif

static size_t
    al4 = PROMILLAGE4*KILOKNOPEN,
    al8 = PROMILLAGE8*KILOKNOPEN,
    al12 = PROMILLAGE12*KILOKNOPEN,
    al16 = PROMILLAGE16*KILOKNOPEN
#ifdef _4_5
        ,
    al20 = PROMILLAGE20*KILOKNOPEN,
    al24 = PROMILLAGE24*KILOKNOPEN
#endif
    ;

static int
carry,
hum = 1,
mooi = TRUE,
optab[256],
dummy_op = LUCHT,
dummy_flgs = 0, /* Bart 20021215 */
debug = 0;

#ifdef TELMAX
static unsigned int maxbez=0;
#endif

static FILE
*fpi,
*fpo;

static const char quote[256] = {
/*
   1 : quote if first character;
   3 : quote always
   4 : quote if \t and \n must be expanded
*/
0,0,0,0,0,0,0,0,0,4,4,0,0,0,3,3, /* \L \D */
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,1,0,1,3,1,3,3,3,3,3,3,3,1,3,1, /* SP ! # $ % & ' ( ) * + , - . / */
0,0,0,0,0,0,0,0,0,0,3,3,1,3,1,1, /* : < = > ? */
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* @ */
0,0,0,0,0,0,0,0,0,0,0,1,3,1,3,3, /* [ \ ] ^ _ */
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* ` */
0,0,0,0,0,0,0,0,0,0,0,3,3,3,1,0};/* { | } ~ */

#define LATIN_1
#ifdef LATIN_1 /* ISO8859 */ /* NOT DOS compatible! */
static const unsigned char lowerEquivalent[256] =
{
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
     16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
    ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/',
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?',
    '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',
    'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_',
    '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',
    'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', 127,
    128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
    144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
    160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
    176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
    224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
    240, 241, 242, 243, 244, 245, 246, 215, 248, 249, 250, 251, 252, 253, 254, 223 /*ringel s*/,
    224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
    240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255
};

static const unsigned char upperEquivalent[256] =
{
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
     16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
    ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/',
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?',
    '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
    'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_',
    '`', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
    'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', 127,
    128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
    144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
    160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
    176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
    192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
    208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
    192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
    208, 209, 210, 211, 212, 213, 214, 247, 216, 217, 218, 219, 220, 221, 222, 255 /* ij */
};
#endif


static unsigned char ISO8859toCodePage850(unsigned char kar)

{
    static unsigned char translationTable[] =
    {
    0xBA,0xCD,0xC9,0xBB,0xC8,0xBC,0xCC,0xB9,0xCB,0xCA,0xCE,0xDF,0xDC,0xDB,0xFE,0xF2,
    0xB3,0xC4,0xDA,0xBF,0xC0,0xD9,0xC3,0xB4,0xC2,0xC1,0xC5,0xB0,0xB1,0xB2,0xD5,0x9F,
    0xFF,0xAD,0xBD,0x9C,0xCF,0xBE,0xDD,0xF5,0xF9,0xB8,0xA6,0xAE,0xAA,0xF0,0xA9,0xEE,
    0xF8,0xF1,0xFD,0xFC,0xEF,0xE6,0xF4,0xFA,0xF7,0xFB,0xA7,0xAF,0xAC,0xAB,0xF3,0xA8,
    0xB7,0xB5,0xB6,0xC7,0x8E,0x8F,0x92,0x80,0xD4,0x90,0xD2,0xD3,0xDE,0xD6,0xD7,0xD8,
    0xD1,0xA5,0xE3,0xE0,0xE2,0xE5,0x99,0x9E,0x9D,0xEB,0xE9,0xEA,0x9A,0xED,0xE8,0xE1,
    0x85,0xA0,0x83,0xC6,0x84,0x86,0x91,0x87,0x8A,0x82,0x88,0x89,0x8D,0xA1,0x8C,0x8B,
    0xD0,0xA4,0x95,0xA2,0x93,0xE4,0x94,0xF6,0x9B,0x97,0xA3,0x96,0x81,0xEC,0xE7,0x98
    };

    if(kar & 0x80)
        return translationTable[kar & 0x7F];
    else
        return kar;
/*    return kar & 0x80 ? (unsigned char)translationTable[kar & 0x7F] : kar;*/
}

static unsigned char CodePage850toISO8859(unsigned char kar)
{
    static unsigned char translationTable[] =
    {
    0xC7,0xFC,0xE9,0xE2,0xE4,0xE0,0xE5,0xE7,0xEA,0xEB,0xE8,0xEF,0xEE,0xEC,0xC4,0xC5,
    0xC9,0xE6,0xC6,0xF4,0xF6,0xF2,0xFB,0xF9,0xFF,0xD6,0xDC,0xF8,0xA3,0xD8,0xD7,0x9F,
    0xE1,0xED,0xF3,0xFA,0xF1,0xD1,0xAA,0xBA,0xBF,0xAE,0xAC,0xBD,0xBC,0xA1,0xAB,0xBB,
    0x9B,0x9C,0x9D,0x90,0x97,0xC1,0xC2,0xC0,0xA9,0x87,0x80,0x83,0x85,0xA2,0xA5,0x93,
    0x94,0x99,0x98,0x96,0x91,0x9A,0xE3,0xC3,0x84,0x82,0x89,0x88,0x86,0x81,0x8A,0xA4,
    0xF0,0xD0,0xCA,0xCB,0xC8,0x9E,0xCD,0xCE,0xCF,0x95,0x92,0x8D,0x8C,0xA6,0xCC,0x8B,
    0xD3,0xDF,0xD4,0xD2,0xF5,0xD5,0xB5,0xFE,0xDE,0xDA,0xDB,0xD9,0xFD,0xDD,0xAF,0xB4,
    0xAD,0xB1,0x8F,0xBE,0xB6,0xA7,0xF7,0xB8,0xB0,0xA8,0xB7,0xB9,0xB3,0xB2,0x8E,0xA0,
    };

    /* 0x7F = 127, 0xFF = 255 */
    /* delete bit-7 before search in tabel (0-6 is unchanged) */
    /* delete bit 15-8 */

    if(kar & 0x80)
        return translationTable[kar & 0x7F];
    else
        return kar;
/*    return kar & 0x80 ? (unsigned char)translationTable[kar & 0x7F] : kar;*/
}

typedef struct tConc
    {
    unsigned char * mconc;
    int cutoff:1;
    int allocated:1;
    } tConc;

static tConc * Pstart;
static unsigned char *start,**pstart,*bron;

static psk anker;


#ifdef DELAY_DUE_TO_INPUT
static clock_t delayDueToInput = 0;
#endif

#ifdef __SYMBIAN32__
/* #define LIJSTLEN 0x100*/ /* If too high you get __chkstk error. Stack = 8K only! */
/* #define LIJSTLEN 0x7F00*/
#define LIJSTLEN 0x2000
#else
#ifdef _MSC_VER
#define LIJSTLEN 0x7F00 /* Microsoft C staat 32k automatic data toe */

#else
#ifdef __BORLANDC__
#if __BORLANDC__ >= 0x500
#define LIJSTLEN 0x7000
#else
#define LIJSTLEN 0x7FFC
#endif
#else
#define LIJSTLEN 0x7FFC
#endif
#endif
#endif

#ifndef UNREFERENCED_PARAMETER /* 20080102 */
#if defined _MSC_VER
#define UNREFERENCED_PARAMETER(P) (P)
#else
#define UNREFERENCED_PARAMETER(P)
#endif
#endif



static unsigned char * wijzer;
static unsigned char * maxwijzer; /* wijzer <= maxwijzer,
                            if wijzer == maxwijzer, don't assign to *wijzer */
static tConc * Conc;


/* FUNCTIONS */

static void hreslt(psk wortel,int nivo,int ind,int space);
#if DEBUGBRACMAT
static void hreslts(psk wortel,int nivo,int ind,int space,psk snijaf);
#endif
static int evalueer(ppsk pkn);
static psk subboomcopie(psk src);

#ifdef BRACMATEMBEDDED /*MICROSOFT_WINDOWS_API*/

static int (*WinIn)(void) = NULL;
static void (*WinOut)(int c) = NULL;
static void (*WinFlush)(void) = NULL;

static int mygetc(FILE * fpi)
    {
    if(WinIn && fpi == stdin)
        {
        return WinIn();
        }
    else
        return fgetc(fpi);
    }


static void myputc(int c)
    {
    if(WinOut && (fpo == stdout || fpo == stderr))
        {
        WinOut(c);
        }
    else
        fputc(c,fpo);
    }
#else
static void myputc(int c)
    {
    fputc(c,fpo);
    }

static int mygetc(FILE * fpi)
    {
#ifdef __SYMBIAN32__
    if(fpi == stdin)
        {
        static unsigned char inputbuffer[256] = {0};
        static unsigned char * out = inputbuffer;
        if(!*out)
            {
            static unsigned char * in = inputbuffer;
            static int kar;
            while(  in < inputbuffer + sizeof(inputbuffer) - 2
                 && (kar = fgetc(fpi)) != '\n'
                 )
                {
                switch(kar)
                    {
                    case '\r':
                        break;
                    case 8:
                        if(in > inputbuffer)
                            {
                            --in;
                            putchar(' ');
                            putchar(8);
                            }
                        break;
                    default:
                        *in++ = kar;
                    }
                }
            *in = kar;
            *++in = '\0';
            out = in = inputbuffer;
            }
        return *out++;
        }
#endif
    return fgetc(fpi);
    }
#endif

static void (*verwerk)(int c) = myputc;

static void myprintf(char *string,...)
{
char *i,*j;
va_list ap;
va_start(ap,string);
i = string;
while(i)
    {
    for(j = i;*j;j++)
        (*verwerk)(*j);
    i = va_arg(ap,char *);
    }
va_end(ap);
}


#if defined BRACMATEMBEDDED /*MICROSOFT_WINDOWS_API*/ && !defined _MT
static int printf(const char *fmt, ...)
    {
    char buffer[1000];
    int ret;
    va_list ap;
    va_start(ap,fmt);
    ret = vsprintf(buffer,fmt,ap);
    myprintf(buffer,NULL);
    va_end(ap);
    return ret;
    }
#endif

static int errorprintf(const char *fmt, ...)
    {
    char buffer[1000];
    int ret;
    FILE * save = fpo;
    va_list ap;
    va_start(ap,fmt);
    ret = vsprintf(buffer,fmt,ap);
#ifdef BRACMATEMBEDDED
    fpo = stderr;
#else
    fpo = errorStream;
#endif
    if(fpo)
    myprintf(buffer,NULL);
    else
    ret = 0;
    fpo = save;
    va_end(ap);
    return ret;
    }

#if DOSUMCHECK

static int LineNo;
static int N;

static int getchecksum(void)
    {
    byte4 *P4 = p4;
    byte8 *P8 = p8;
    byte12 *P12 = p12;
    byte16 *P16 = p16;
#ifdef _4_5
    byte20 *P20 = p20;
    byte24 *P24 = p24;
#endif
    int sum = 0;
    while(P4)
        {
        sum += (int)P4;
        P4 = P4->u.p;
        }
    while(P8)
        {
        sum += (int)P8;
        P8 = P8->u.p;
        }
    while(P12)
        {
        sum += (int)P12;
        P12 = P12->u.p;
        }
    while(P16)
        {
        sum += (int)P16;
        P16 = P16->u.p;
        }
#ifdef _4_5
    while(P20)
        {
        sum += (int)P20;
        P20 = P20->u.p;
        }
    while(P24)
        {
        sum += (int)P24;
        P24 = P24->u.p;
        }
#endif
    return sum;
    }

static int Checksum = 0;

static void setChecksum(int lineno,int n)
    {
    if(lineno)
        {
        LineNo = lineno;
        N = n;
        }
    Checksum = getchecksum();
    }

static void checksum(int line)
    {
    static int nChecksum = 0;
    nChecksum = getchecksum();
    if(Checksum && Checksum != nChecksum)
        {
        printf("Line %d: Illegal write after bmalloc(%d) on line %d",line,N,LineNo);
        getchar();
        exit(1);
        }
    }
#else
#define setChecksum(a,b)
#define bmalloc(LINENO,N) bmalloc(N)
#define checksum(a)
#endif

static void bfree(void *p)
{
#ifdef TELMAX
globalloc--;
#endif
#ifdef _4_5
if(p >= (void*)p24start &&
   p <  (void*)p24end)
    {
    al24++;
    ((byte24*)p)->u.p = p24;
    p24 = (byte24*)p;
    }
else
if(p >= (void*)p20start &&
   p <  (void*)p20end)
    {
    al20++;
    ((byte20*)p)->u.p = p20;
    p20 = (byte20*)p;
    }
else
#endif
if(p >= (void*)p16start &&
   p <  (void*)p16end)
    {
    al16++;
    ((byte16*)p)->u.p = p16;
    p16 = (byte16*)p;
    }
else
if(p >= (void*)p12start &&
   p <  (void*)p12end)
    {
    al12++;
    ((byte12*)p)->u.p = p12;
    p12 = (byte12*)p;
    }
else
if(p >= (void*)p8start &&
   p <  (void*)p8end)
    {
    al8++;
    ((byte8*)p)->u.p = p8;
    p8 = (byte8*)p;
    }
else
if(p >= (void*)p4start &&
   p <  (void*)p4end)
    {
    al4++;
    ((byte4*)p)->u.p = p4;
    p4 = (byte4*)p;
    }
else
    {
    free(p);
    return;
    }
setChecksum(0,0);
}

static void pskfree(psk p)
    {
    bfree(p);
    }

#if TELLING
static void bezetting(void)
{
printf("bezet (promilles) 1 woord : %lu, 2 woorden : %lu, 3 woorden : %lu, 4 woorden : %lu, 5 woorden : %lu, 6 woorden : %lu\n",
1000UL-(1000UL * al4)/(PROMILLAGE4 *KILOKNOPEN),
1000UL-(1000UL * al8)/(PROMILLAGE8 *KILOKNOPEN),
1000UL-(1000UL * al12)/(PROMILLAGE12*KILOKNOPEN),
1000UL-(1000UL * al16)/(PROMILLAGE16*KILOKNOPEN),
1000UL-(1000UL * al20)/(PROMILLAGE20*KILOKNOPEN),
1000UL-(1000UL * al24)/(PROMILLAGE24*KILOKNOPEN));
printf("bezet (absoluut) 1 woord : %lu, 2 woorden : %lu, 3 woorden : %lu, 4 woorden : %lu, 5 woorden : %lu, 6 woorden : %lu\n",
(PROMILLAGE4  * KILOKNOPEN - al4),
(PROMILLAGE8  * KILOKNOPEN - al8),
(PROMILLAGE12 * KILOKNOPEN - al12),
(PROMILLAGE16 * KILOKNOPEN - al16),
(PROMILLAGE20 * KILOKNOPEN - al20),
(PROMILLAGE24 * KILOKNOPEN - al24));
printf("meer dan 6 woorden : %lu\n",
globalloc+al4+al8+al12+al16+al20+al24-1000UL*KILOKNOPEN);
}
#endif



static void *bmalloc(int lineno,size_t n)
    {
    void *ret;
#if DOSUMCHECK
    size_t nn = n;
#endif
#if TELLING
    int tel;
    alloc_cnt++;
    if(n < 256)
        cnts[n]++;
    totcnt += n;
#endif
#ifdef TELMAX
    globalloc++;
    if(maxgloballoc < globalloc)
        maxgloballoc = globalloc;
#endif
    checksum(__LINE__);
    n = (n - 1) >> 2;
    switch(n)
        {
        case 0 :
            if(p4)
                {
                al4--;
                ret = p4;
                p4 = p4->u.p;
                *(long*)ret = 0;
                setChecksum(lineno,nn);
                return ret;
                }
        case 1 :
            if(p8)
                {
                al8--;
                p8->rest = 0;
                ret = p8;
                p8 = p8->u.p;
                *((long*)ret + n) = 0; /* 20040302 */
                setChecksum(lineno,nn);
                return ret;
                }
        case 2 :
            if(p12)
                {
                al12--;
                ret = p12;
                p12 = p12->u.p;
                *((long*)ret + n) = 0; /* 20040302 */
                setChecksum(lineno,nn);
                return ret;
                }
        case 3 :
            if(p16)
                {
                al16--;
                ret = p16;
                p16 = p16->u.p;
                *((long*)ret + n) = 0; /* 20040302 */
                setChecksum(lineno,nn);
                return ret;
                }
#ifdef _4_5
        case 4 :
            if(p20)
                {
                al20--;
                ret = p20;
                p20 = p20->u.p;
                *((long*)ret + n) = 0;
                setChecksum(lineno,nn);
                return ret;
                }
        case 5 :
            if(p24)
                {
                al24--;
                ret = p24;
                p24 = p24->u.p;
                *((long*)ret + n) = 0; /* 20040302 */
                setChecksum(lineno,nn);
                return ret;
                }
#endif
        }
    ret = malloc((n<<2)+4);
    if(!ret)
        {
#if TELLING
        errorprintf(
        "MEMORY FULL AFTER %lu ALLOCATIONS WITH MEAN LENGTH %lu\n",
            globalloc,totcnt/alloc_cnt);
        for(tel = 0;tel<16;tel++)
            {
            int tel1;
            for(tel1 = 0;tel1<256;tel1 += 16)
                errorprintf("%lu ",(cnts[tel+tel1]*1000UL+500UL)/alloc_cnt);
            errorprintf("\n");
            }
        bezetting();
#endif
        errorprintf(
            "memory full (requested block of %d bytes could not be allocated)",
            (n<<2)+4);

        exit(1);
        }

    *((long*)ret+n) = 0;
    *(long*)ret = 0;
    setChecksum(lineno,n);
    return ret;
    }

static psk new_operator_like(psk kn)
    {
    if(kop(kn) == WORDT)
        {
        if(ISBUILTIN((objectknoop*)kn))
            {
            typedObjectknoop * goal = (typedObjectknoop *)bmalloc(__LINE__,sizeof(typedObjectknoop));
            goal->refcount = 0;
            UNSETCREATEDWITHNEW(goal);
            SETBUILTIN(goal);
            goal->vtab = ((typedObjectknoop*)kn)->vtab;
            goal->voiddata = NULL;
            return (psk)goal;
            }
        else
            {
            objectknoop * goal = (objectknoop *)bmalloc(__LINE__,sizeof(objectknoop));
            goal->refcount = 0;
            UNSETCREATEDWITHNEW(goal);
            UNSETBUILTIN(goal);
            return (psk)goal;
            }
        }
    else
        return (psk)bmalloc(__LINE__,sizeof(kknoop));
    }

static unsigned char *shift_nw(void)
/* Used from startboom_w and opb */
    {
    if(startPos)
        {
        startPos = va_arg(ap,unsigned char *);
        if(startPos)
                start = startPos;
        }
    return start;
    }

static void combineConc(void)
    {
    tConc * next = Pstart + 1;
    tConc * next2;
    unsigned char * nconc;
    size_t len;
    while(next->cutoff)
        ++next;

    len = (next - Pstart) * (LIJSTLEN - 1) + 1;

    if(next->mconc)
        {
        len += strlen((const char *)next->mconc);
        }

    nconc = (unsigned char *)bmalloc(__LINE__,len);

    next = Pstart;

    while(next->cutoff)
        {
        strncpy((char *)nconc + (next - Pstart)*(LIJSTLEN - 1),(char *)next->mconc,LIJSTLEN - 1);
        bfree(next->mconc);
        ++next;
        }

    if(next->mconc)
        {
        strcpy((char *)nconc + (next - Pstart)*(LIJSTLEN - 1),(char *)next->mconc);
        if(next->allocated)
            {
            bfree(next->mconc);
            }
        ++next;
        }
    else
        nconc[(next - Pstart)*(LIJSTLEN - 1)] = '\0';

    Pstart->mconc = nconc;
    Pstart->cutoff = FALSE;
    Pstart->allocated = TRUE;

    for(next2 = Pstart + 1;next->mconc;++next2,++next)
        {
        next2->mconc = next->mconc;
        next2->cutoff = next->cutoff;
        next2->allocated = next->allocated;
        }

    next2->mconc = NULL;
    next2->cutoff = FALSE;
    next2->allocated = FALSE;
    }

static unsigned char * vshift_w(void)
/* used from bouwboom_w, which receives a list of bmalloc-allocated string
   pointers. The last string pointer must not be deallocated here */
    {
    if(Pstart->mconc && (++Pstart)->mconc)
        {
        if(Pstart->cutoff)
            {
                combineConc();
            }
        bfree(Pstart[-1].mconc);
        Pstart[-1].allocated = FALSE;
        start = Pstart->mconc;
        }
    return start;
    }

static unsigned char *vshift_nw(void)
/* Used from vopb */
    {
    if(*pstart && *++pstart)
        start = *pstart;
    return start;
    }

static unsigned char *(*shift)(void) = shift_nw;

static void tel(int c)
    {
    UNREFERENCED_PARAMETER(c);
    telling++;
    }

static void tstr(int c)
    {
    static int esc = FALSE,str = FALSE;
    if(esc)
        {
        esc = FALSE;
        telling++;
        }
    else if(c == '\\')
        esc = TRUE;
    else if(str)
        {
        if(c == '"')
            str = FALSE;
        else
            telling++;
        }
    else if(c == '"')
        str = TRUE;
    else if(c != ' ')
        telling++;
    }

static void pstr(int c)
    {
    static int esc = FALSE,str = FALSE;
    if(esc)
        {
        esc = FALSE;
        switch(c)
            {
            case 'n' :
                c = '\n';
                break;
            case 'f' :
                c = '\f';
                break;
            case 'r' :
                c = '\r';
                break;
            case 'b' :
                c = '\b';
                break;
            case 'a' :
                c = ALERT;
                break;
            case 'v' :
                c = '\v';
                break;
            case 't' :
                c = '\t';
                break;
            case 'L' :
                c = 016;
                break;
            case 'D' :
                c = 017;
                break;
            }
        *bron++ = (char)c;
        }
    else if(c == '\\')
        esc = TRUE;
    else if(str)
        {
        if(c == '"')
            str = FALSE;
        else
            *bron++ = (char)c;
        }
    else if(c == '"')
        str = TRUE;
    else if(c != ' ')
        *bron++ = (char)c;
    }

static void plak(int c)
    {
    *bron++ = (char)c;
    }

#define COMPLEX_MAX 80
#define LINELENGTH 80

static /*int 20031126*/size_t complexiteit(psk wortel,/*int 20031126*/size_t max)
    {
    /*int left,right;*/
    static int ouder,kind;
    while(is_op(wortel))
        {
        switch(kop(wortel))
            {
            case OF :
            case EN :
                max += COMPLEX_MAX/5;
                break;
            case WORDT :
            case MATCH :
                max += COMPLEX_MAX/10;
                break;
            case DOT :
            case KOMMA :
            case LUCHT :
                switch(kop(wortel->LEFT))
                    {
                    case DOT:
                    case KOMMA:
                    case LUCHT :
                        max += COMPLEX_MAX/10;
                        break;
                    default:
                        max += COMPLEX_MAX/LINELENGTH;
                    }
                break;
                /*
                case PLUS:
                max += COMPLEX_MAX/25;
                break;
                case MAAL:
                max += COMPLEX_MAX/40;
                break;
                */
            default:
                max += COMPLEX_MAX/LINELENGTH;
            }
        ouder = kop(wortel);
        kind = kop(wortel->LEFT);
        if(HAS__UNOPS(wortel->LEFT) || ouder >= kind)
            max += (2 * COMPLEX_MAX)/LINELENGTH; /* 2 parentheses */

        kind = kop(wortel->RIGHT);
        if(HAS__UNOPS(wortel->RIGHT) || ouder > kind || (ouder == kind && ouder > MAAL))
            max += (2 * COMPLEX_MAX)/LINELENGTH; /* 2 parentheses */

        if(max > COMPLEX_MAX)
            return max;
            /*
            left = complexiteit(wortel->LEFT,max);
            right = complexiteit(wortel->RIGHT,max);

             if(left > right)
             max = left;
             else
             max = right;
        */
        max = complexiteit(wortel->LEFT,max);
        wortel = wortel->RIGHT;
        }
    if(!is_op(wortel))
        max += (COMPLEX_MAX*strlen((char *)POBJ(wortel))) / LINELENGTH;
    return max;
    }

static int indtel = 0,extraspatie = 0,number_of_flags_on_node=0;

static int indent(psk wortel,int nivo,int ind)
    {
    if(hum)
        {
        if(ind > 0 || (ind == 0 && complexiteit(wortel,2*nivo) > COMPLEX_MAX))
            {  /*    blanks that start a line    */
            int p;
            (*verwerk)('\n');
            for(p = 2*nivo+number_of_flags_on_node;p;p--)
                (*verwerk)(' ');
            ind = TRUE;
            }
        else
            {  /* blanks after an operator or parenthesis */
            for(indtel = extraspatie + 2*indtel;indtel;indtel--)
                (*verwerk)(' ');
            ind = FALSE;
            }
        extraspatie = 0;
        }
    return ind;
    }

static int moetIndent(psk wortel,int ind,int nivo)
    {
    return hum && !ind && complexiteit(wortel,2*nivo) > COMPLEX_MAX;
    }

static void bewerk(int c)
    {
    if(c == 016 || c == 017)
        {
        (*verwerk)('\\');
        (*verwerk)(c == 016 ? 'L' : 'D');
        }
    else
        (*verwerk)(c);
    }

static int lineToLong(unsigned char *string)
    {
    if(  hum
      && strlen((const char *)string) > 10 /*LINELENGTH*/
      /* very short strings are allowed to keep \n and \t */
      )
        return TRUE;
    return FALSE;
    }

static int haalaan(unsigned char *string)
    {
    unsigned char *pstring;
    if(quote[*string] & 1)
        return TRUE;
    for(pstring = string;*pstring;pstring++)
        if(quote[*pstring] & 2)
            return TRUE;
        else if(  quote[*pstring] & 4
            && lineToLong(string)
            )
            return TRUE;
    return FALSE;
    }

static int printflags(psk wortel)
    {
    int count = 0;
    int Flgs = wortel->v.fl;
    if(Flgs & POSITION)
        {
        (*verwerk)('[');
        ++count;
        }
    if(Flgs & NOT)
        {
        (*verwerk)('~');
        ++count;
        }
    if(Flgs & BREUK)
        {
        (*verwerk)('/');
        ++count;
        }
    if(Flgs & NUMBER)
        {
        (*verwerk)('#');
        ++count;
        }
    if(Flgs & SMALLER_THAN)
        {
        (*verwerk)('<');
        ++count;
        }
    if(Flgs & GREATER_THAN)
        {
        (*verwerk)('>');
        ++count;
        }
    if(Flgs & NONIDENT)
        {
        (*verwerk)('%');
        ++count;
        }
    if(Flgs & ATOM)
        {
        (*verwerk)('@');
        ++count;
        }
    if(Flgs & UNIFY)
        {
        (*verwerk)('?');
        ++count;
        }
    if(Flgs & FENCE)
        {
        if(!(Flgs & POSITION))
            {
            (*verwerk)('`');
            ++count;
            }
        }
    if(Flgs & INDIRECT)
        {
        (*verwerk)('!');
        ++count;
        }
    if(Flgs & DOUBLY_INDIRECT)
        {
        (*verwerk)('!');
        ++count;
        }
    return count;
    }

#define LHS 1
#define RHS 2

static void eindknoop(psk wortel,int space)
    {
    unsigned char *pstring;
    int q,ikar;
    if(!wortel->u.obj
        && !HAS_UNOPS(wortel)
        && space)
        {
        (*verwerk)('(');
        (*verwerk)(')');
        return;
        }
    printflags(wortel);
    if(wortel->ops & MINUS)
        (*verwerk)('-');
    if(mooi)
        {
        for(pstring = POBJ(wortel);*pstring;pstring++)
            bewerk(*pstring);
        }
    else
        {
        Boolean longline = FALSE;
        if((q = haalaan(POBJ(wortel))) == TRUE)
            (*verwerk)('"');
            /*
            if(hum) / * 20001129 * /
            for(pstring = POBJ(wortel);*pstring;pstring++)
            bewerk(*pstring);
            else
            20010103 File saved this way can not be re-read if string contains doublequote \"
        */
        for(pstring = POBJ(wortel);(ikar = *pstring) != 0;pstring++)
            {
            switch(ikar)
                {
                case '\n' :
                    if(longline || lineToLong(POBJ(wortel)))
                    /* We need to call this, even though haalaan returned TRUE,
                    because haalaan may have returned before reaching this character.
                    */
                        {
                        longline = TRUE;
                        (*verwerk)('\n');
                        continue;
                        }
                    ikar = 'n';
                    break;
                case '\f' :
                    ikar = 'f';
                    break;
                case '\r' :
                    ikar = 'r';
                    break;
                case '\b' :
                    ikar = 'b';
                    break;
                case ALERT :
                    ikar = 'a';
                    break;
                case '\v' :
                    ikar = 'v';
                    break;
                case '\t' :
                    if(longline || lineToLong(POBJ(wortel)))
                    /* We need to call this, even though haalaan returned TRUE,
                    because haalaan may have returned before reaching this character.
                    */
                        {
                        longline = TRUE;
                        (*verwerk)('\t');
                        continue;
                        }
                    ikar = 't';
                    break;
                case '"' :
                case '\\' :
                    break;
                case 016 :
                    ikar = 'L';
                    break;
                case 017 :
                    ikar = 'D';
                    break;
                default :
                    (*verwerk)(ikar);
                    continue;
                }
            (*verwerk)('\\');
            (*verwerk)(ikar);
            }
        if(q)
            (*verwerk)('"');
        }
    }

static psk zelfde_als_w(psk kn)
    {
#ifdef TELMAX
    if(maxbez < kn->ops)
        maxbez = kn->ops;
#endif
    if(shared(kn) != ALL_REFCOUNT_BITS_SET)
        {
        (kn)->ops += ONE;
        return kn;
        }
    else if(is_object(kn))
        {
        INCREFCOUNT((objectknoop*)kn);
        return kn;
        }
    else
        return subboomcopie(kn);
    }

#if ICPY
static void icpy(long *d,long *b,int words)
    {
    while(words--)
        *d++ = *b++;
    }
#endif

static psk icopievan(psk kn)
    {
    /* EISEN : Na de afsluitende 0 van string moeten eventuele resterende bytes
    van het betreffende computerwoord ook 0 zijn.
    Beide argumenten moeten op een woordgrens beginnen. */
    psk ret;
    size_t len;
    len = sizeof(unsigned long)+strlen((char *)POBJ(kn));
    ret = (psk)bmalloc(__LINE__,len+1);
#if ICPY
    MEMCPY(ret,kn,(len >> LOGWORDLENGTH) + 1);
#else
    MEMCPY(ret,kn,((len >> 2) + 1) << 2);
#endif
    ret->ops &= ~ALL_REFCOUNT_BITS_SET;
    return ret;
    }

static void wis(psk top);

static void copyToSnijaf(psk * ppknoop,psk pknoop,psk snijaf)
    {
    for(;;)
        {
        if(is_op(pknoop))
            {
            if(pknoop->RIGHT == snijaf)
                {
                *ppknoop = zelfde_als_w(pknoop->LEFT);
                break;
                }
            else
                {
                psk p = new_operator_like(pknoop);
                p->ops = pknoop->ops & ~ALL_REFCOUNT_BITS_SET;
                p->LEFT = zelfde_als_w(pknoop->LEFT);
                *ppknoop = p;
                ppknoop = &(p->RIGHT);
                pknoop = pknoop->RIGHT;
                }
            }
        else
            {
            *ppknoop = icopievan(pknoop);
            break;
            }
        }
    }

static ppsk Head(ppsk ppknoop)
{
psk root;
assert(ppknoop != NULL);
if(((root = *ppknoop)->ops & LATEBIND))
    {
    assert(!shared(root));
    if(is_op(root))
        {
        copyToSnijaf(ppknoop,root->LEFT,root->RIGHT);
        wis(root);
        }
    else
        {
        stringrefknoop * ps = (stringrefknoop *)*ppknoop;
        root = (psk)bmalloc(__LINE__,sizeof(unsigned long) + 1 + ps->length);
        root->ops = (ps->ops & ~ALL_REFCOUNT_BITS_SET & ~LATEBIND);
        strncpy((char *)POBJ(root),(char *)ps->str,ps->length); /* Bart 20040827 strcpy -> strncpy */
        wis(ps->kn);
        bfree(ps);
        *ppknoop = root;
        }
    }
return ppknoop;
}

#define RSP (ouder == LUCHT ? RHS : 0)
#define LSP (ouder == LUCHT ? LHS : 0)

#ifndef reslt
static void reslt(psk wortel,int nivo,int ind,int space)
{
static int ouder,kind,/* 18 Maart 1997:*/newind;
while(is_op(wortel))/* 18 Maart 1997: */
    {
    if(kop(wortel) == WORDT)
        wortel->RIGHT = *Head(&wortel->RIGHT);
    ouder = kop(wortel);
    kind = kop(wortel->LEFT);
    if(moetIndent(wortel,ind,nivo))
        indtel++;
    if(HAS__UNOPS(wortel->LEFT) || ouder >= kind)
        hreslt(wortel->LEFT,nivo+1,FALSE,(space & LHS) | RSP);
    else
        reslt(wortel->LEFT,nivo+1,FALSE,(space & LHS) | RSP);
    newind = indent(wortel,nivo,ind);
    if(newind)
        extraspatie = 1;
    bewerk(opchar[klopcode(wortel)]);
    ouder = kop(wortel);
    kind = kop(wortel->RIGHT);
    if(HAS__UNOPS(wortel->RIGHT) || ouder > kind || (ouder == kind && ouder > MAAL))
        {
        hreslt(wortel->RIGHT,nivo+1,FALSE,LSP | (space & RHS));
        return;
        }
    else if(ouder < kind)
        {
        reslt(wortel->RIGHT,nivo+1,FALSE,LSP | (space & RHS));
        return;
        }
    else if(newind != ind || ((LSP | (space & RHS)) != space))
        {
        reslt(wortel->RIGHT,nivo,newind,LSP | (space & RHS));
        return;
        }
    wortel = wortel->RIGHT;
    }
indent(wortel,nivo,-1);
eindknoop(wortel,space);
/*
while(1)/ * 18 Maart 1997: * /
    {
    if(is_op(wortel))
        {
        ouder = kop(wortel);
        kind = kop(wortel->LEFT);
        if(moetIndent(wortel,ind,nivo))
            indtel++;
        if(HAS__UNOPS(wortel->LEFT) || ouder >= kind)
            hreslt(wortel->LEFT,nivo+1,FALSE,(space & LHS) | RSP);
        else
            reslt(wortel->LEFT,nivo+1,FALSE,(space & LHS) | RSP);
        newind = indent(wortel,nivo,ind);
        if(newind)
            extraspatie = 1;
        bewerk(opchar[klopcode(wortel)]);
        ouder = kop(wortel);
        kind = kop(wortel->RIGHT);
        if(HAS__UNOPS(wortel->RIGHT) || ouder > kind || (ouder == kind && ouder > MAAL))
            hreslt(wortel->RIGHT,nivo+1,FALSE,LSP | (space & RHS));
        else
            {
            if(ouder < kind)
                reslt(wortel->RIGHT,nivo+1,FALSE,LSP | (space & RHS));
            else if(newind == ind && ((LSP | (space & RHS)) == space))
                {
                wortel = wortel->RIGHT;
                continue;
                }
            else
                reslt(wortel->RIGHT,nivo,newind,LSP | (space & RHS));
            }
        }
    else
        {
        indent(wortel,nivo,-1);
        eindknoop(wortel,space);
        }
    break;
    }
*/
}

#if DEBUGBRACMAT

static void reslts(psk wortel,int nivo,int ind,int space,psk snijaf)
    {
    static int ouder,kind,/* 18 Maart 1997:*/newind;
    if(is_op(wortel))/* 11 May 2004: */
        {
        if(kop(wortel) == WORDT)
            wortel->RIGHT = *Head(&wortel->RIGHT);

        do
            {
            if(snijaf && wortel->RIGHT == snijaf)
                {
                reslt(wortel->LEFT,nivo,ind,space);
                return;
                }
            ouder = kop(wortel);
            kind = kop(wortel->LEFT);
            if(moetIndent(wortel,ind,nivo))
                indtel++;
            if(HAS__UNOPS(wortel->LEFT) || ouder >= kind)
                hreslt(wortel->LEFT,nivo+1,FALSE,(space & LHS) | RSP);
            else
                reslt(wortel->LEFT,nivo+1,FALSE,(space & LHS) | RSP);
            newind = indent(wortel,nivo,ind);
            if(newind)
                extraspatie = 1;
            bewerk(opchar[klopcode(wortel)]);
            ouder = kop(wortel);
            kind = kop(wortel->RIGHT);
            if(HAS__UNOPS(wortel->RIGHT) || ouder > kind || (ouder == kind && ouder > MAAL))
                hreslts(wortel->RIGHT,nivo+1,FALSE,LSP | (space & RHS),snijaf);
            else if(ouder < kind)
                {
                reslts(wortel->RIGHT,nivo+1,FALSE,LSP | (space & RHS),snijaf);
                return;
                }
            else if(newind != ind || ((LSP | (space & RHS)) != space))
                {
                reslts(wortel->RIGHT,nivo,newind,LSP | (space & RHS),snijaf);
                return;
                }
            wortel = wortel->RIGHT;
            }
        while(is_op(wortel));/* 18 Maart 1997: */
        }
    else
        {
        indent(wortel,nivo,-1);
        eindknoop(wortel,space);
        }
    }
#endif /* DEBUGBRACMAT */
#endif

static void hreslt(psk wortel,int nivo,int ind,int space)
{
static int ouder,kind;
if(is_op(wortel))
    {
    int number_of_flags;
    if(kop(wortel) == WORDT)
        wortel->RIGHT = *Head(&wortel->RIGHT);
    indent(wortel,nivo,-1);
    number_of_flags = printflags(wortel);
    number_of_flags_on_node += number_of_flags;
    (*verwerk)('(');
    indtel = 0;
    if(moetIndent(wortel,ind,nivo))
        extraspatie = 1;
    ouder = kop(wortel);
    kind = kop(wortel->LEFT);
    if(HAS__UNOPS(wortel->LEFT) || ouder >= kind)
        hreslt(wortel->LEFT,nivo+1,FALSE,RSP);
    else
        reslt(wortel->LEFT,nivo+1,FALSE,RSP);
    ind = indent(wortel,nivo,ind);
    if(ind)
        extraspatie = 1;
    bewerk(opchar[klopcode(wortel)]);
    ouder = kop(wortel);
    kind = kop(wortel->RIGHT);
    if(HAS__UNOPS(wortel->RIGHT) || ouder > kind || (ouder == kind && ouder > MAAL))
        hreslt(wortel->RIGHT,nivo+1,FALSE,LSP);
    else if(ouder < kind)
        reslt(wortel->RIGHT,nivo+1,FALSE,LSP);
    else
        reslt(wortel->RIGHT,nivo,ind,LSP);
    indent(wortel,nivo,FALSE);
    (*verwerk)(')');
    number_of_flags_on_node -= number_of_flags;
    }
else
    {
    indent(wortel,nivo,-1);
    eindknoop(wortel,space);
    }
}

static void result(psk wortel)
{
if(HAS__UNOPS(wortel))
    {
    hreslt(wortel,0,FALSE,0);
    }
else
    reslt(wortel,0,FALSE,0);
}

#if DEBUGBRACMAT
static void hreslts(psk wortel,int nivo,int ind,int space,psk snijaf)
{
static int ouder,kind;
if(is_op(wortel))
    {
    int number_of_flags;
    if(kop(wortel) == WORDT)
        wortel->RIGHT = *Head(&wortel->RIGHT);
    if(snijaf && wortel->RIGHT == snijaf)
        {
        hreslt(wortel->LEFT,nivo,ind,space);
        return;
        }
    indent(wortel,nivo,-1);
    number_of_flags = printflags(wortel);
    number_of_flags_on_node += number_of_flags;
    (*verwerk)('(');
    indtel = 0;
    if(moetIndent(wortel,ind,nivo))
        extraspatie = 1;
    ouder = kop(wortel);
    kind = kop(wortel->LEFT);
    if(HAS__UNOPS(wortel->LEFT) || ouder >= kind)
        hreslt(wortel->LEFT,nivo+1,FALSE,RSP);
    else
        reslt(wortel->LEFT,nivo+1,FALSE,RSP);
    ind = indent(wortel,nivo,ind);
    if(ind)
        extraspatie = 1;
    bewerk(opchar[klopcode(wortel)]);
    ouder = kop(wortel);
    kind = kop(wortel->RIGHT);
    if(HAS__UNOPS(wortel->RIGHT) || ouder > kind || (ouder == kind && ouder > MAAL))
        hreslts(wortel->RIGHT,nivo+1,FALSE,LSP,snijaf);
    else if(ouder < kind)
        reslts(wortel->RIGHT,nivo+1,FALSE,LSP,snijaf);
    else
        reslts(wortel->RIGHT,nivo,ind,LSP,snijaf);
    indent(wortel,nivo,FALSE);
    (*verwerk)(')');
    number_of_flags_on_node -= number_of_flags;
    }
else
    {
    indent(wortel,nivo,-1);
    eindknoop(wortel,space);
    }
}

static void results(psk wortel,psk snijaf)
{
if(HAS__UNOPS(wortel))
    {
    hreslts(wortel,0,FALSE,0,snijaf);
    }
else
    reslts(wortel,0,FALSE,0,snijaf);
}
#endif

static long toLong(psk kn)
{
long res;
res = strtoul((char *)POBJ(kn),(char **)NULL,10);
if(kn->ops & MINUS)
    res = -res;
return res;
}

#if DEBUGBRACMAT
static void setend(unsigned char ** punmatched,unsigned char * p,const char * wh)
    {
    if(punmatched)
        {
        *punmatched = p;
        if(debug)
            {
            printf("                   *punmatched=\"%s\" ;; %s\n",p,wh);
            }
        }
    }
#else
#define setend(punmatched,p,wh) {if(punmatched)*punmatched=p;}
#endif

static int numbercheck(unsigned char *begin,unsigned char ** punmatched)
/* If 'punmatched' != NULL and if numbercheck fails, then '*punmatched' points at the
first character that cannot be accepted. '*punmatched' must be set to NULL
if the string 'begin' seems to be too short.
*/
    {
    int op_of_0,check;
    int needNonZeroDigit = FALSE; /* 20040308 */
    if(!*begin)
        return 0;
    check = QGETAL;
    op_of_0 = *begin;

    if(op_of_0 >= '0' && op_of_0 <= '9')
        {
        if(op_of_0 == '0')
            check |= QNUL;
        while(optab[op_of_0 = *++begin] != -1)/*20010126*/
            {
            if(op_of_0 == '/')
                {
                /*20080911 check &= ~QNUL;*/
                if(check & QBREUK)
                    {
                    if(punmatched)
                        {
                        if(needNonZeroDigit)
                            {
                            setend(punmatched,begin - 1,"A The first '/' was not acceptable");
                            }
                        else
                            {
                            setend(punmatched,begin,"B The second '/' is not acceptable");
                            }
                        }
                    /*check = 0;*/
                    check = DEFINITELYNONUMBER;
                    break;
                    }
                else
                    {
                    needNonZeroDigit = TRUE;
                    check |= QBREUK;
                    }
                }
            else if(op_of_0 < '0' || op_of_0 > '9')
                {
                if(punmatched)
                    {
                    if(needNonZeroDigit)
                        {
                        setend(punmatched,begin - 1,"C The '/' was not acceptable");
                        }
                    else
                        {
                        setend(punmatched,begin,"D This character is not acceptable");
                        }
                    }
                /*check = 0;*/
                check = DEFINITELYNONUMBER;
                break;
                }
            else
                {
                /*20080910 initial zero followed by 
                                 0 <= k <= 9 makes no number */
                if((check & (QNUL|QBREUK)) == QNUL) 
                    {
                    setend(punmatched,begin,"H The second figure is not acceptable");
                    check = DEFINITELYNONUMBER;
                    break;
                    }
                else if(op_of_0 != '0')
                    {
                    needNonZeroDigit = FALSE;
                    /*check &= ~QNUL;*/ /*Bart 20080908*/
                    }
                else if(needNonZeroDigit) /* '/' followed by '0' */
                    {
                    if(punmatched)
                        {
                        setend(punmatched,begin - 1,"E The '/' was not acceptable");
                        }
                    /*check = 0;*/
                    check = DEFINITELYNONUMBER;
                    break;
                    }
                }
            }
        }
    else
        {
        if(punmatched)
            {
            if(*begin)
                {
                setend(punmatched,begin,"F NAN");
                }
            else
                *punmatched = NULL;
            }
        check = DEFINITELYNONUMBER;
        }
    if(check && needNonZeroDigit)
        {
        if(punmatched)
            {
            if(*begin)
                {
                setend(punmatched,begin,"G needNonZeroDigit");
                }
            else
                *punmatched = NULL;
            }
        check = 0;
        }
    return check;
    }

static int fullnumbercheck(unsigned char *begin,unsigned char ** punmatched)
/* sets *punmatched to NULL if there are no digits or if there is a digit after a division slash, */
    {
    if(*begin == '-')
        {
        int ret = numbercheck(begin+1,punmatched);
        if(ret & ~DEFINITELYNONUMBER)
            return ret | MINUS;
        else
            return ret;
        }
    else
        return numbercheck(begin,punmatched);
    }

static int sfullnumbercheck(unsigned char *begin,unsigned char * snijaf,unsigned char ** punmatched)
    {
    unsigned char sav = *snijaf;
    int ret;
    *snijaf = '\0';
    ret = fullnumbercheck(begin,punmatched);
    *snijaf = sav;
    return ret;
    }

static int flags(
                void /* 20 Dec 1995 */
                )
{
int Flgs = 0;

for(;;start++)
    {
    switch(*start)
        {
        case '!' :
            if(Flgs & INDIRECT)
                Flgs |= DOUBLY_INDIRECT;
            else
                Flgs |= INDIRECT;
            continue;
        case '[' :
            Flgs |= POSITION|FENCE;
            continue;
        case '?' :
            Flgs |= UNIFY;
            continue;
        case '#' :
            Flgs |= NUMBER;
            continue;
        case '/' :
            Flgs |= BREUK;
            continue;
        case '@' :
            Flgs |= ATOM;
            continue;
        case '`' :
            Flgs |= FENCE;
            continue;
        case '%' :
            Flgs |= NONIDENT;
            continue;
        case '~' :
            Flgs ^= NOT;
            continue;
        case '<' :
            Flgs |= SMALLER_THAN;
            continue;
        case '>' :
            Flgs |= GREATER_THAN;
            continue;
        case '-' :
            Flgs ^= MINUS;
            continue;
        }
    break;
    }

if((Flgs & NOT) && (Flgs < ATOM))
    Flgs ^= SUCCESS;
return Flgs;
}

#define flags(OPSFLGS) flags()


#define atoom(PKN,FLGS,OPSFLGS) atoom(PKN,FLGS)

static void atoom(ppsk pkn,int Flgs,int opsflgs)
    {
    unsigned char *begin,*eind;
    size_t af = 0;
    begin = start;

    while(optab[*start] == NOOP)
        if(*start++ == 0x7F)
            af++;

    eind = start;
    *pkn = (psk)bmalloc(__LINE__,sizeof(unsigned long) + 1 + (size_t)(eind - begin) - af);
start = begin;
begin = POBJ(*pkn);
while(start < eind)
    {
    if(*start == 0x7F)
        {
        ++start;
        *begin++ = (unsigned char)(*start++ | 0x80);
        }
    else
        {
        *begin++ = (unsigned char)(*start++ & 0x7F);
        }
    }
if(Flgs & INDIRECT)
    {
    (*pkn)->v.fl = Flgs ^ SUCCESS;
    }
else
    {
    if(ONTKENNING(Flgs,NUMBER))
        (*pkn)->v.fl = (Flgs ^ (READY|SUCCESS));
    else
        (*pkn)->v.fl = (Flgs ^ (READY|SUCCESS)) | (numbercheck(POBJ(*pkn),NULL) & ~DEFINITELYNONUMBER);
    /* Bart 20010322 : */
    if(  !(Flgs & UNIFY)
      && (Flgs & (ATOM|NONIDENT))
      && (*pkn)->u.obj
      )
        (*pkn)->v.fl &= ~(ATOM|NONIDENT); /* Remove superfluous flags @ and % from non-empty atom*/
    }

#undef opsflgs
}

#define lex(PKN,GRENS,FLGS,OPSFLGS) lex(PKN,GRENS,FLGS)

static int lex(ppsk pkn,int grens,int Flgs,int opsflgs)
/* tbw zoekt een expressie of subexpressie */
/* returnwaarde is het teken volgend op de expressie */
    {
    int op_of_0;
    if(*start > 0 && *start <= '\6')
        *pkn = zelfde_als_w(adr[*start++]);
    else
        {
        int Flgs;
        Flgs = flags(&locopsflgs);
        if(*start == '(')
            {
            if(*++start == 0)
                (*shift)();
            lex(pkn,0,Flgs,locopsflgs);
            }
        else
            atoom(pkn,Flgs,locopsflgs);
        }

    if(*start == 0)
        {
        if(!*(*shift)())
            return 0;
        }

    op_of_0 = *start;

    if(*++start == 0)
        (*shift)();

    if(optab[op_of_0] == NOOP) /* 20080910 Otherwise problem with the k in ()k */
        printf("malformed input\n");
    else
    do
        {
        /* op_of_0 == een operator */
        psk operatorNode;
        int child_op_of_0;
        if(optab[op_of_0] < grens) /* 'op_of_0' heeft te lage prioriteit */
            {
#if STRINGMATCH_CAN_BE_NEGATED
            if(  (Flgs & (NOT|FILTERS)) == (NOT|ATOM)
              && kop(*pkn) == MATCH
              ) /* 20071229 Undo setting of
                    success == FALSE
                   if ~@ flags are attached to : operator
                   Notice that op_of_0 is ')'
                   This is a special case. In ~@(a:b) the ~ operator must
                   not negate the @ but the result of the string match.
                */
                {
                Flgs ^= SUCCESS;
                }
#endif
            (*pkn)->v.fl ^= Flgs; /*19970821*/
            return op_of_0;
            }
        if(optab[op_of_0] == WORDT)
            {
            operatorNode = (psk)bmalloc(__LINE__,sizeof(objectknoop));
    /*        ((objectknoop*)psk)->refcount = 0; done by bmalloc */
            }
        else
            operatorNode = (psk)bmalloc(__LINE__,sizeof(kknoop));
        assert(optab[op_of_0] != NOOP);
        operatorNode->v.fl = optab[op_of_0] | SUCCESS;
        /*operatorNode->v.fl ^= Flgs;*/
        operatorNode->LEFT = *pkn;
        *pkn = operatorNode;/* 'op_of_0' heeft voldoende prioriteit */
        if(optab[op_of_0] == grens) /* 'op_of_0' heeft zelfde prioriteit */
            {
            /*
            if(kop(*pkn) == MATCH)
                {
                if(Flgs & ATOM)
                    {
                    if(Flgs & NOT)
                        Flgs ^= SUCCESS;
                    }
                }
                */
            (*pkn)->v.fl ^= Flgs; /*19970821*/
            operatorNode->RIGHT = NULL;
            return op_of_0;
            }
        while((child_op_of_0 = lex(&(operatorNode->RIGHT),optab[op_of_0],0,0)) == op_of_0)
            {
            /* zoek rechter-operand bij op_of_0 */
            operatorNode = operatorNode->RIGHT;
            }
        op_of_0 = child_op_of_0;
        }
    while(op_of_0 != 0);
    /*
    if(kop(*pkn) == MATCH)
        {
        if(Flgs & ATOM)
            {
            if(Flgs & NOT)
                Flgs ^= SUCCESS;
            }
        }
        */
    (*pkn)->v.fl ^= Flgs; /*19970821*/
    return 0;
    }

static void bouwboom_w(ppsk pkn)
    {
    if(*pkn)
        wis(*pkn);
    *pkn = NULL;
    start = (unsigned char *)Conc[0].mconc;
    Pstart = Conc;
    if(Pstart->cutoff)
        {
        combineConc();
        start = Conc->mconc;
        }
    shift = vshift_w;
    lex(pkn,0,0,0);
    shift = shift_nw;
    if((--Pstart)->allocated)
        {
        bfree(Pstart->mconc);
        }
    bfree(Conc);
    }

static void lput(int c)
    {
    if(wijzer >= maxwijzer)
        {
        tConc * nConc;
        unsigned char * lijst;
        int len;

        for(len = 0;Conc[++len].mconc;)
            ;
        /* len = index of last element in Conc array */

        lijst = Conc[len - 1].mconc;

        /* The last string (probably on the stack, not on the heap) */

        while(wijzer > lijst && optab[*--wijzer] == NOOP)
            ;

        /* wijzer points at last operator (where string can be split) or at
           the start of the string. */

        nConc = (tConc *)bmalloc(__LINE__,(2 + len) * sizeof(tConc));
        /* allocate new array one element bigger than the previous. */

        nConc[len + 1].mconc = NULL;
        nConc[len + 1].cutoff = FALSE;
        nConc[len + 1].allocated = FALSE;
        nConc[len].mconc = lijst;
        /*printf("lijst %p\n",lijst);*/
        nConc[len].cutoff = FALSE;
        nConc[len].allocated = FALSE;

        if(wijzer == lijst)
            {
            /* copy the full content of lijst to the second last element */
            nConc[--len].mconc = (unsigned char *)bmalloc(__LINE__,LIJSTLEN);
            strncpy((char *)nConc[len].mconc,(char *)lijst,LIJSTLEN - 1);
            /* Make a notice that the element's string is cut-off */
            nConc[len].cutoff = TRUE;
            nConc[len].allocated = TRUE;
            }
        else
            {
            ++wijzer; /* wijzer points at first character after the operator */
            /* maxwijzer - wijzer >= 0 */
            nConc[--len].mconc = (unsigned char *)bmalloc(__LINE__,(size_t)(wijzer - lijst + 1));
            strncpy((char *)nConc[len].mconc,(char *)lijst,(size_t)(wijzer - lijst));
            nConc[len].mconc[(unsigned int)(wijzer - lijst)] = 0;
            nConc[len].cutoff = FALSE;
            nConc[len].allocated = TRUE;

            /* Now remove the substring up to wijzer from lijst */
            strncpy((char *)lijst,(char *)wijzer,(size_t)(maxwijzer - wijzer));
            wijzer = lijst + (size_t)(maxwijzer - wijzer);
            }

        /* Copy previous element's fields */
        while(len)
            {
            --len;
            nConc[len].mconc = Conc[len].mconc;
            nConc[len].cutoff = Conc[len].cutoff;
            nConc[len].allocated = Conc[len].allocated;
            }
        bfree(Conc);
        Conc = nConc;
        }
    *wijzer++ = (unsigned char)c;
    }

void writeError(psk pkn)
    {
    FILE *redfpo;
    int redMooi;
    redMooi = mooi;
    mooi = FALSE;
    redfpo = fpo;
#ifdef BRACMATEMBEDDED
    fpo = stderr;
#else
    fpo = errorStream;
#endif
    errorprintf(" in:\n");
    result(pkn);
    myputc('\n');
    fpo = redfpo;
    mooi = redMooi;
    }

#ifndef BRACMATEMBEDDED
static int redirectError(char * name)
    {
    if(errorFileName)
        {
        free(errorFileName);
        errorFileName = NULL;
        }

    if(errorStream && errorStream != stdout && errorStream != stderr)
        fclose(errorStream);

    if(!strcmp(name,"stdout"))
        {
        errorStream = stdout;
        return TRUE;
        }
    else if(!strcmp(name,"stderr"))
        {
        errorStream = stderr;
        return TRUE;
        }
    else
        {
        errorStream = fopen(name,"w");
        if(errorStream)
            {
/*            errorFileName = strdup(name);*/
            errorFileName = (char *)malloc(strlen(name)+1);
            strcpy(errorFileName,name);
            return TRUE;
            }
        errorStream = stderr;
        }
    return FALSE;
    }
#endif

static Boolean input(FILE * fpi,ppsk pkn,int echmemvapstr,Boolean * err)
    {
    int accolades,ikar,hasop,lucht,escape,noEscape,string,haken,error;
#ifdef __SYMBIAN32__
    unsigned char * lijst;
    lijst = bmalloc(__LINE__,LIJSTLEN);
    /*if(fpi == stdin)
        {
        int kar;
        unsigned char * p;
        bron = lijst;
        p = bron;
        while(  ((kar = mygetc(fpi)) != '\n')
             && (p - bron < LIJSTLEN - 1)
             )
            {
            if((kar == 8) && (p > bron))
                {
                --p;
                putchar(' ');
                putchar(8);
                }
            else if(kar != '\r')
                *p++ = kar;
            }
        *p = '\0';
        return input(NULL,pkn,echmemvapstr,err);
        }*/
#else
    unsigned char lijst[LIJSTLEN];
#endif
    maxwijzer = lijst + (LIJSTLEN - 1);/* er moet ruimte zijn voor afsluitende 0 */
    /*
    conc = (unsigned char **)bmalloc(__LINE__,2*sizeof(char *));
    conc[0] = lijst;
    conc[1] = NULL;
    */
    Conc = (tConc *)bmalloc(__LINE__,2*sizeof(tConc));
    Conc[0].mconc = lijst;
    Conc[0].cutoff = FALSE;
    Conc[0].allocated = FALSE;
    Conc[1].mconc = NULL;
    Conc[1].cutoff = FALSE;
    Conc[1].allocated = FALSE;
    error = FALSE;
    accolades = 0;
    haken = 0;
    hasop = TRUE;
    lucht = FALSE;
    escape = FALSE;
    noEscape = FALSE; /* @"C:\dir1\bracmat" */
    string = FALSE;

    if(echmemvapstr & (OPT_VAP|OPT_STR))
        {
        for(wijzer = lijst;;)
            {
            if(fpi)
                {
                ikar = mygetc(fpi);
                if(fpi == stdin)
                   {
                   if(ikar == '\n')
                       break;
                   }
                else if(ikar == EOF)
                   break;
                }
            else
                if((ikar = *bron++) == 0)
                    break;
            if(ikar & 0x80)
                 lput(0x7F);
            lput(ikar | 0x80);
            if(echmemvapstr & OPT_VAP)
                {
                if(echmemvapstr & OPT_STR)
                    lput(' ' | 0x80);
                else
                    lput(' ');
                }
            }
        *wijzer = 0;
        bouwboom_w(pkn/*,conc*/);
        if(err) *err = error;
#ifdef __SYMBIAN32__
        bfree(lijst);
#endif
        return FALSE;
        }
    for( wijzer = lijst
       ;    (ikar = fpi ? mygetc(fpi) : *bron++) != EOF
         && haken >= 0
       ;
       )
        {
        if(echmemvapstr & OPT_ECH)
            {
            if(fpi != stdin && ikar)
                printf("%c",ikar);
            if(ikar == '\n')
                {
                if(accolades)
                    printf("{com} ");
                else if(string)
                    printf("{str} ");
                else if(haken > 0 || fpi != stdin)
                    {
                    int tel;
                    printf("{%d} ",haken);
                    if(fpi == stdin)
                        for(tel = haken;tel;tel--)
                                printf("  ");
                    }
                }
            }
        if(!accolades)
            {
            if(ikar & 0x80)
                {
                if(lucht && !hasop)
                    lput(' ');
                lucht = FALSE;
                lput(0x7F);
                }
            if(escape)
                {
                escape = FALSE;
#if SIGNED_CHAR
                if(ikar >= 0 && ikar < ' ')
#else
                if(ikar < ' ')
#endif
                    break;
                switch(ikar)
                    {
                    case 'n' :
                        ikar = '\n' | 0x80;
                        break;
                    case 'f' :
                        ikar = '\f' | 0x80;
                        break;
                    case 'r' :
                        ikar = '\r' | 0x80;
                        break;
                    case 'b' :
                        ikar = '\b' | 0x80;
                        break;
                    case 'a' :
                        ikar = ALERT | 0x80;
                        break;
                    case 'v' :
                        ikar = '\v' | 0x80;
                        break;
                    case 't' :
                        ikar = '\t' | 0x80;
                        break;
                    case '"' :
                        ikar = '"' | 0x80;
                        break;
                    case 'L' :
                        ikar = 016;
                        break;
                    case 'D' :
                        ikar = 017;
                        break;
                    default:
                        ikar = ikar | 0x80; /* 20070403 */
                    }
                }
            else if(ikar == '\\' && !noEscape)
                {
                escape = TRUE;
                continue;
                }
            }
        if(string)
            {
            if(ikar == '"')
                {
                string = FALSE;
                noEscape = FALSE;
                }
            else
                lput(ikar | 0x80);
            }
        else
            {
            switch(ikar)
                {
                case '{' :
                    accolades++;
                    break;
                case '}' :
                    accolades--;
                    if(accolades < 0)
                        {
                        *wijzer = 0;
                        errorprintf(
                        "\n%s brace }",
                            onbal);
                        error = TRUE;
                        accolades = 0;
                        /*exit(1);*/
                        }
                    break;
                default :
                    {
                    if(!accolades)
                        {
                        if(optab[ikar] == LUCHT
                        && !(ikar == '\n' && fpi == stdin && !haken))
                            {
                            lucht = TRUE;
                            noEscape = FALSE; /* Bart 20030331 */
                            }
                        else
                            {
                            switch(ikar)
                                {
                                case '"':
                                    string = TRUE;
                                    break;
                                case '@':
                                case '%': /* These flags are removed if the string
                                             is non-empty, so using them to
                                             indicate "do not use escape sequences"
                                             does no harm.
                                             Bart 20010322
                                         */
                                    noEscape = TRUE;
                                    break;
                                case '(':
                                    haken++;
                                    break;
                                case ')':
                                    noEscape = FALSE;
                                    haken--;
                                    break;
                                case 0 :
                                case ';' :
                                    if(haken)
                                        {
                                        *wijzer = 0;
                                        errorprintf("\n%d %s \"(\"",haken,onbal);
                                        error = TRUE;
                                        /*exit(1);*/
                                        }
                                    if(echmemvapstr & OPT_ECH)
                                        printf("\n");
                                    /* doorvallen */
                                case '\n':
                                    /* alleen met fpi==stdin kom je hier direkt */
                                    *wijzer = 0;
                                    bouwboom_w(pkn/*,conc*/);
                                    if(error)
                                        writeError(*pkn);
                                    if(err) *err = error;
#ifdef __SYMBIAN32__
                                    bfree(lijst);
#endif
                                    return ikar == ';' && !error;
                                }
                            if(lucht
                            && !hasop
                            && optab[ikar] == NOOP)
                                lput(' ');
                            lucht = FALSE;
                            hasop = ( (ikar == '(')
                                 || ((optab[ikar] < NOOP) && ikar != ')'));

                            if(!string)
                                {
                                lput(ikar);
                                if(hasop)
                                    noEscape = FALSE;
                                }
                            }
                        }
                    }
                }
            }
        if(!(ikar & 0x7F))
            break;
        }
    *wijzer = 0;
    if(string)
        {
        errorprintf("\n%s \"",onbal);
        error = TRUE;
        /*exit(1);*/
        }
    if(accolades)
        {
        errorprintf("\n%d %s \"{\"",accolades,onbal);
        error = TRUE;
        /*exit(1);*/
        }
    if(haken > 0)
        {
        errorprintf("\n%d %s \"(\"",haken,onbal);
        error = TRUE;
        /*exit(1);*/
        }
    if(haken < 0)
        {
        if(ikar == 'j' || ikar == 'J' || ikar == 'y' || ikar == 'Y')
            {
            exit(0);
            }
        else if(!fpi || fpi == stdin)
            {
            printf(
            "\nend session? (y/n)"
            );
            while((ikar = mygetc(stdin)) != 'n')
                {
                if(ikar == 'j' || ikar == 'J' || ikar == 'y' || ikar == 'Y')
                    {
                    exit(0);
                    }
                }
            while(ikar != '\n')
                {
                ikar = mygetc(stdin);
                }
            }
        else
            {
            errorprintf("\n%d %s \")\"",-haken,onbal);
            error = TRUE;
            /*exit(1);*/
            }
        }
    if(echmemvapstr & OPT_ECH)
        printf("\n");
/*  if(*conc[0])*/
    if(*Conc[0].mconc)
        {
        bouwboom_w(pkn/*,conc*/);
        if(error)
            {
#ifndef BRACMATEMBEDDED
            if(errorFileName)
                {
                printf("Error! (See file \"%s\")\n",errorFileName);
                }
            else
                {
    /*            printf("\n(Use err$<filename> to direct error output to file.)\n");
    */
                printf("\nType name of file to write erroneous code to and then press <return>: ");
                wijzer = lijst;
                while((ikar = mygetc(stdin)) != '\n')
                    {
                    *wijzer++ = (unsigned char)ikar;
                    }
                *wijzer = '\0';
                if(lijst[0])
                    redirectError((char *)lijst);
                }
#endif
            writeError(*pkn);
#ifndef BRACMATEMBEDDED
            if(errorStream && errorStream != stdout && errorStream != stderr)
                fclose(errorStream);
#endif
            }
        }
    else
        {
        bfree(Conc);
        }
    if(err)
        *err = error;
    #ifdef __SYMBIAN32__
    bfree(lijst);
    #endif
    return FALSE;
    }

#if JMP
#include <setjmp.h>
static jmp_buf jumper;
#endif

int stringEval(const char *s,char **out,int * err)
    {
    Boolean ret;
#ifdef BRACMATEMBEDDED /*MICROSOFT_WINDOWS_API*/
    char * buf = malloc(strlen(s) + 11);
    sprintf(buf,"put$(%s,MEM)",s);
#else
    char * buf = malloc(strlen(s) + 7);
    sprintf(buf,"str$(%s)",s);
#endif
    bron = (unsigned char *)buf;
    input(NULL,&anker,4,err);
    if(err && *err) return FALSE;
#if JMP
    if(setjmp(jumper) != 0)
        {
        free(buf);
        return -1;
        }
#endif
    ret = evalueer(&anker);
    if(out != NULL)
        *out = is_op(anker) ? "" : (char *)POBJ(anker);
    free(buf);
    return ret;
    }

static psk copievan(psk kn)
    {
    psk res;
    res = icopievan(kn);
    res->v.fl &= ~IDENT;
    return res;
    }

static psk replace(ppsk goal,psk source)
    {
    wis(*goal);
    return *goal = copievan(source);
    }

static psk _copyop(psk pkn)
    {
    psk hulp;
    hulp = new_operator_like(pkn);
    hulp->ops = pkn->ops & ~ALL_REFCOUNT_BITS_SET;
    hulp->LEFT = zelfde_als_w(pkn->LEFT);
    hulp->RIGHT = zelfde_als_w(pkn->RIGHT);
    return hulp;
    }

static int copyop(ppsk pkn)
    {
    if(shared(*pkn))
        {
        dec_refcount(*pkn);
        *pkn = _copyop(*pkn);
        return TRUE;
        }
    return FALSE;
    }

static psk subboomcopie(psk src)
    {
    if(is_op(src))
        return _copyop(src);
    else
        return icopievan(src);
    }

static int getal_graad(psk kn)
    {
    if(RATIONAAL_COMP(kn))
        return 4;
    switch(PLOBJ(kn))
        {
        case IM: return 3;
        case PI: return 2;
        case XX: return 1;
        default: return 0;
        }
    }

static int is_constant(psk kn)
    {
    while(is_op(kn))
        {
        /* return is_constant(kn->LEFT) && is_constant(kn->RIGHT);
        18 Maart 1997 */
        if(!is_constant(kn->LEFT))
            return FALSE;
        kn = kn->RIGHT;
        }
    return getal_graad(kn);
    }

static void init_opcode(void)
    {
    int tel;
    for(tel = 0;tel<256;tel++)
        {
#if TELLING
        cnts[tel] = 0;
#endif
        switch (tel)
            {
            case 0   :
            case ')' : optab[tel] = -1   ;break;
            case '=' : optab[tel] = WORDT;break;
            case '.' : optab[tel] = DOT  ;break;
            case ',' : optab[tel] = KOMMA;break;
            case '|' : optab[tel] = OF   ;break;
            case '&' : optab[tel] = EN   ;break;
            case ':' : optab[tel] = MATCH;break;
            case '+' : optab[tel] = PLUS ;break;
            case '*' : optab[tel] = MAAL ;break;
            case '^' : optab[tel] = EXP  ;break;
            case 016 : optab[tel] = LOG  ;break;
            case 017 : optab[tel] = DIF  ;break;
            case '$' : optab[tel] = FUN  ;break;
            case '\'': optab[tel] = FUU  ;break;
            case '_' : optab[tel] = STREEP;break;
            default  : optab[tel] = (tel <= ' ') ? LUCHT : NOOP;
            }
        }
    }

static psk prive(psk pkn)
    {
    if(shared(pkn))
        {
        dec_refcount(pkn);
        return subboomcopie(pkn);
        }
    return pkn;
    }

static void setflgs(ppsk pokn,int Flgs)
    {
    if((Flgs & ERFENIS) || !(Flgs & SUCCESS))
        {
        *pokn = prive(*pokn);
        (*pokn)->v.fl ^= ((Flgs & SUCCESS) ^ SUCCESS);
        (*pokn)->v.fl |= (Flgs & ERFENIS);
        if(ONTKENNING(Flgs,GREATER_THAN) || ONTKENNING(Flgs,SMALLER_THAN))
            (*pokn)->v.fl |= NOT;
        }
    }

static void startboom_w(ppsk pkn,...)
    {
    if(*pkn)
        wis(*pkn);
    *pkn = NULL;
    va_start(ap,pkn);
    start = startPos = va_arg(ap,unsigned char *);
    lex(pkn,0,0,0);
    va_end(ap);
    }

static psk vopb(psk pkn,const char *conc[])
    {
    psk okn;
    pstart = (unsigned char **)conc;
    start = (unsigned char *)conc[0];
    shift = vshift_nw;
    lex(&okn,0,0,0);
    shift = shift_nw;
    setflgs(&okn,pkn->v.fl);
    wis(pkn);
    return okn;
    }

static psk opb(psk pkn,...)
    {
    psk okn;
    va_start(ap,pkn);
    start = startPos = va_arg(ap,unsigned char *);
    lex(&okn,0,0,0);
    va_end(ap);
    if(pkn)
        {
        setflgs(&okn,pkn->v.fl);
        wis(pkn);
        }
    return okn;
    }

static void dopb(ppsk pkn,psk src)
    {
    psk okn;
    okn = zelfde_als_w(src);
    setflgs(&okn,(*pkn)->v.fl);
    wis(*pkn);
    *pkn = okn;
    }



static int fireBuiltInFunc(objectknoop * object,char * name)
    {
    /*printf("find member %s\n",name);*/
    if(ISBUILTIN((objectknoop*)object))
        {
        method_pnt theMethod = NULL;
        method * methods = ((typedObjectknoop*)object)->vtab;
        /*
        printf("object==(");result((psk)object);printf(")\n");
        printf("is <%s> built-in?\n",name);
        printf("object %p\n",object);
        result((psk)object);
        printf("methods %p\n",methods);
        getchar();
        */
        if(methods)
            {
            for(;methods->name && strcmp(methods->name,name);++methods)
                ;
            theMethod = methods->func;
            }
        if(theMethod)
            {
            /*printf("theMethod found %p\n",theMethod);*/
            theMethod((struct typedObjectknoop *)object,NULL);
            return TRUE;
            }
        }
    return FALSE;
    }

static void wis(psk top)
    {
    while(!shared(top)) /* 18 Maart 1997, tail recursion optimisation; delete deep structures*/
        {
        psk kn = NULL; /* 18 Maart 1997 */
        if(is_object(top) && ISCREATEDWITHNEW((objectknoop*)top))
            {
    /*        psk kn = NULL;*/
            adr[1] = top->RIGHT;
            kn = opb(kn,"(((=\1).die)')",NULL);
            evalueer(&kn);
            wis(kn);
            if(ISBUILTIN((objectknoop*)top))
                fireBuiltInFunc((objectknoop*)top,"Die");
            }
        if(is_op(top))
            {
            wis(top->LEFT);
            kn = top; /* 18 Maart 1997 */
            top = top->RIGHT; /* 18 Maart 1997 */
            pskfree(kn);
            }
        else
            {
            if(top->ops & LATEBIND)
                {
                wis(((stringrefknoop*)top)->kn);
                }
            pskfree(top);
            return;
            }
        }
    dec_refcount(top);
    }

static int macht2(int n)
/* retourneert MSB van n */
    {
    int m;
    for(m=1;n;n>>=1,m<<=1);
    return m>>1;
    }

static ppsk entry(int n,int index,varia **pv)
    {
    int m;
    varia *hv;
    if(n == 0)
        return (ppsk)pv;  /* er zijn geen varia records nodig voor 1 entry */
    for(m = n,hv = *pv; /* begin bij langste varia record */
    m > 1 && index < macht2(m);
    m >>= 1,hv = hv->prev);
    index -= macht2(m);   /* als index == 0, dan wordt index -1 */
    return &hv->verdi[index];  /* verdi[-1] == (psk)*prev */
    }

#if INTSCMP
static int intscmp(long *s1,long *s2) /* deze routine geeft verschillende resultaten
                                  afhankelijk van BIGENDIAN */
{
while(*((char *)s1 + 3))
    {
    if(*s1 != *s2)
        {
        if(*s1 < *s2)
            return -1;
        else
            return 1;
        }
    s1++;
    s2++;
    }
if(*s1 != *s2)
    {
    if(*s1 < *s2)
        return -1;
    else
        return 1;
    }
else
    return 0;
}
#endif


static int zoeknaam(psk name,
                    vars **pvoorvar,
                    vars **pnavar)
    {
    unsigned char *string;
    vars *navar
        ,*voorvar
        ;
    string = POBJ(name);
    for( voorvar = NULL,navar = variabelen[*string]
       ;  navar && (STRCMP(VARNAME(navar),string) < 0)
       ; voorvar = navar,navar = navar->next
       )
       ;
    /* voorvar < string <= navar */
    *pvoorvar = voorvar;
    *pnavar = navar;
    return navar && !STRCMP(VARNAME(navar),string);
    }

static Qgetal _qmaalmineen(Qgetal _qx)
    {
    Qgetal res;
    int len;
    len = sizeof(long) + 1 + strlen((char *)POBJ(_qx));
    res = (Qgetal)bmalloc(__LINE__,len);
    memcpy(res,_qx,len);
    res->ops ^= MINUS;
    res->ops &= ~ALL_REFCOUNT_BITS_SET;
    return res;
    }

static psk numberNode(ngetal g)
    {
    psk res;
    int len;
    len = sizeof(long) + 1 + g.length;
    res = (psk)bmalloc(__LINE__,len);
    if(g.sign & QNUL)
        res->u.obj = '0';
    else
        {
        memcpy((void*)POBJ(res),g.number,g.length);
    /*(char *)POBJ(res) + g.length = '\0'; hoeft niet, gebeurt in bmalloc */
        }
    res->v.fl = READY | SUCCESS | QGETAL;
    res->ops |= g.sign;
    return res;
    }

static psk fnumberNode(ngetal g)
    {
    psk res;
    res = numberNode(g);
    bfree(g.alloc);
    return res;
    }

static Qgetal not_a_number(void)
    {
    Qgetal res;
    res = copievan(&nulk);
    res->v.fl ^= SUCCESS;
    return res;
    }

static char *splits(Qgetal _qget,ngetal *ptel,ngetal *pnoem)
    {
    register char *on;
    ptel->sign = _qget->ops & (MINUS|QNUL);
    pnoem->sign = 0;
    pnoem->alloc = ptel->alloc = NULL;
    for( ptel->number = on = (char *)POBJ(_qget)
       ; *on && *on != '/'
       ; on++
       )
       ;

    ptel->length = on - ptel->number;

    if(*on)
        {
        pnoem->number = on + 1;
        pnoem->length = strlen(on + 1);
        return on;
        }
    else
        {
        pnoem->number = "1";
        pnoem->length = 1;
        return NULL;
        }
    }

static void skipnullen(ngetal *nget,int teken)
    {
    for(
       ; nget->length > 0 && *(nget->number) == '0'
       ; nget->number++,nget->length--
       )
       ;
    nget->sign = nget->length ? (teken & MINUS) : QNUL;
    }

static ngetal nmaal(ngetal x,ngetal y)
    {
    ngetal res;
    char *i1,*i2;
    char *wyzer,*tussen;
    res.length = x.length + y.length;
    res.alloc = res.number = (char *)bmalloc(__LINE__,(size_t)res.length);
    for(wyzer = res.number;wyzer - res.number < res.length;*wyzer++ = '0')
        ;
    for(i1 = x.number + x.length - 1;i1 >= x.number;i1--)
        {
        tussen = --wyzer;
        for(i2 = y.number + y.length - 1;i2 >= y.number;i2--)
            {
            register int prod;
            register int karry;
            register char *tussen2;
            prod = (*i1-'0')*(*i2-'0');
            *tussen += (prod%10);
            karry = prod/10;
            tussen2 = tussen--;
            do
                {
                if(*tussen2 > '9')
                    {
                    karry++;
                    *tussen2 -= 10;
                    }
                --tussen2;
                *tussen2 = *tussen2 + karry;
                /*            *--tussen2 += karry;*/
                karry = 0;
                }
            while(*tussen2 > '9');
            }
        }
    skipnullen(&res,x.sign ^ y.sign);
    return res;
    }

static void opaf(char **pres,char *bx,char *ex,char *by,char *ey,int act)
    {
    register char *i1,*i2,*wyzer;
    register int lcarry;
    lcarry = 0;
    i1 = *pres;
    i2 = ex;
    wyzer = ey;
    do
        {
        *i1 = (char)(*i2 + lcarry + act * (*wyzer-'0'));
        if(*i1 > '9')
            {
            lcarry = 1;
            *i1 -= (char)10;
            }
        else
            if(*i1 < '0')
                {
                lcarry = -1;
                *i1 += (char)10;
                }
            else
                lcarry = 0;
            i1--;
            i2--;
            wyzer--;
        }
    while(wyzer >= by);
    for(;i2 >= bx;)
        {
        *i1 = (char)(*i2 + lcarry);
        if(*i1 > '9')
            {
            lcarry = 1;
            *i1 -= (char)10;
            }
        else
            if(*i1 < '0')
                {
                lcarry = -1;
                *i1 += (char)10;
                }
            else
                lcarry = 0;
            i1--;
            i2--;
        }
    *pres = i1+1;
    carry = lcarry;
    }

static int nndeel(ngetal x,ngetal y,deelres *pres)
    {
    char *i1,*i2,*i3;
    ngetal hquot,hrest;
    if(y.sign & QNUL)
        return FALSE;
    hrest.length = x.sign & QNUL ? 1 : x.length;
    hrest.alloc = hrest.number = (char *)bmalloc(__LINE__,(size_t)(hrest.length));
    *(hrest.number) = '0';
    memcpy(hrest.number,x.number,x.length);
    if(x.length >= y.length)
        hquot.length = 1 + x.length - y.length;
    else
        hquot.length = 1;
    hquot.alloc = hquot.number = (char *)bmalloc(__LINE__,(size_t)(hquot.length));
    *(hquot.number) = '0';
    i3 = hquot.number;
    for( i1 = hrest.number + (size_t)y.length - 1
       ; i1 - hrest.number < x.length
       ; i1++,i3++
       )
        {
        *i3 = '0'-1;
        do
            {
            i2 = i1;
            opaf(&i2,hrest.number,i1,y.number,y.number + y.length - 1,-1);
            (*i3)++;
            }
        while(!carry);
        i2 = i1;
        opaf(&i2,hrest.number,i1,y.number,y.number + y.length - 1,1);
        }
    skipnullen(&hrest,x.sign);
    skipnullen(&hquot,x.sign ^ y.sign);
    pres->rest = hrest;
    pres->quot = hquot;
    return TRUE;
    }

static int numberIs1(ngetal x)
    {
    return x.number[0] == '1' && x.length == 1;
    }

static Qgetal _qndeel(ngetal x,ngetal y)
    {
    Qgetal res;
    deelres resx,resy;
    ngetal ggd,hrest;

    if(x.sign & QNUL)
        return copievan(&nulk);
    else
        {
        if(y.sign & QNUL)
            return not_a_number();
        }
    ggd = x;
    ggd.alloc = NULL;
    hrest = y;
    hrest.alloc = NULL;
    do
        {
        nndeel(ggd,hrest,&resx);
        if(ggd.alloc)
            bfree(ggd.alloc);
        ggd = hrest;
        hrest = resx.rest;
        bfree(resx.quot.alloc);
        }
    while(!(hrest.sign & QNUL));
    if(hrest.alloc)
        bfree(hrest.alloc);

    nndeel(x,ggd,&resx);
    bfree(resx.rest.alloc);

    nndeel(y,ggd,&resy);
    bfree(resy.rest.alloc);
    if(ggd.alloc)
        bfree(ggd.alloc);
    resx.quot.sign ^= (resy.quot.sign & MINUS);

    if(numberIs1(resy.quot))
        {
        res = numberNode(resx.quot);
        }
    else
        {
        res = (psk)bmalloc(__LINE__,sizeof(long) + 2 + resx.quot.length + resy.quot.length);
        sprintf((char *)POBJ(res),"%.*s/%.*s",
            (int /*size_t*/)resx.quot.length,resx.quot.number,
            (int /*size_t*/)resy.quot.length,resy.quot.number);
        res->v.fl = READY | SUCCESS | QGETAL | QBREUK;
        res->ops |= resx.quot.sign;
        }
    bfree(resx.quot.alloc);
    bfree(resy.quot.alloc);
    return res;
    }

static ngetal nplus(ngetal x,ngetal y)
    {
    ngetal res,hget;
    char *hres;
    /*int 20031126*/ptrdiff_t xgrotery;
    res.length = 1+(x.length > y.length ? x.length : y.length);
    res.alloc = res.number = (char *)bmalloc(__LINE__,(size_t)res.length);
    *res.number = '0';
    hres = res.number+(size_t)res.length - 1;
    if(x.length == y.length)
        xgrotery = strncmp(x.number,y.number,(size_t)res.length);
    else
        xgrotery = x.length - y.length;
    if(xgrotery < 0)
        {
        hget = x;
        x = y;
        y = hget;
        }
    if(x.sign == y.sign)
        {
        opaf(&hres,x.number,x.number + x.length - 1,
            y.number,y.number + y.length - 1,1);
        if(carry)
            *--hres = '1';
        }
    else
        opaf(&hres,x.number,x.number + x.length - 1,
                   y.number,y.number + y.length - 1,-1);
    skipnullen(&res,x.sign);
    return res;
    }

static Qgetal _qplus(Qgetal _qx,Qgetal _qy)
    {
    ngetal xt,xn,yt,yn;
    char *xb,*yb;
    xb = splits(_qx,&xt,&xn);
    yb = splits(_qy,&yt,&yn);
    if(!xb && !yb)
        {
        Qgetal ret;
        ret = fnumberNode(nplus(xt,yt));
        return ret;
        }
    else
        {
        ngetal pa,pb,som;
        Qgetal res;
        pa = nmaal(xt,yn);
        pb = nmaal(yt,xn);
        som = nplus(pa,pb);
        bfree(pa.alloc);
        bfree(pb.alloc);
        pa = nmaal(xn,yn);
        res = _qndeel(som,pa);
        bfree(som.alloc);
        bfree(pa.alloc);
        return res;
        }
    }

static Qgetal _qdema(ngetal x1,ngetal x2,ngetal y1,ngetal y2)
    {
    ngetal pa,pb;
    Qgetal res;
    pa = nmaal(x1,y1);
    pb = nmaal(x2,y2);
    res = _qndeel(pa,pb);
    bfree(pa.alloc);
    bfree(pb.alloc);
    return(res);
    }

static Qgetal _qmaal(Qgetal _qx,Qgetal _qy)
    {
    ngetal xt,xn,yt,yn;
    char *xb,*yb;
    xb = splits(_qx,&xt,&xn);
    yb = splits(_qy,&yt,&yn);
    if(!xb && !yb)
        {
        return fnumberNode(nmaal(xt,yt));
        }
    else
        {
        Qgetal res;
        res = _qdema(xt,xn,yt,yn);
        return res;
        }
    }

static Qgetal _q_qdeel(Qgetal _qx,Qgetal _qy)
    {
    ngetal xt,xn,yt,yn;
    char *xb,*yb;
    xb = splits(_qx,&xt,&xn);
    yb = splits(_qy,&yt,&yn);
    if(!xb && !yb)
        return _qndeel(xt,yt);
    else
        {
        Qgetal res;
        res = _qdema(xt,xn,yn,yt);
        return res;
        }
    }


static Qgetal _qheeldeel(Qgetal _qx,Qgetal _qy)
    {
    int ok;
    deelres deling;
    Qgetal res,hulp;
    ngetal xt,xn,yt,yn,p1,p2;
    splits(_qx,&xt,&xn);
    splits(_qy,&yt,&yn);
    p1 = nmaal(xt,yn);
    p2 = nmaal(xn,yt);
    ok = nndeel(p1,p2,&deling);
    bfree(p1.alloc);
    bfree(p2.alloc);
    if(ok)
        {
        res = _qplus((deling.rest.sign & QNUL) || !(_qx->ops & MINUS) ?
            &nulk : (_qy->ops & MINUS) ? &eenk : &mineenk,
            (hulp = numberNode(deling.quot)));
        pskfree(hulp);
        bfree(deling.quot.alloc);
        bfree(deling.rest.alloc);
        }
    else
        res = not_a_number();
    return res;
    }

static Qgetal _qmodulo(Qgetal _qx,Qgetal _qy)
    {
    Qgetal res,_q1,_q2,_q3;
    _q1 = _qmaalmineen(_qy);
    _q2 = _qheeldeel(_qx,_qy);
    _q3 = _qmaal(_q1,_q2);
    pskfree(_q1);
    pskfree(_q2);
    res = _qplus(_qx,_q3);
    pskfree(_q3);
    return res;
    }

static Qgetal _qdenominator(Qgetal _qx)
    {
    ngetal xt,xn;
    splits(_qx,&xt,&xn);
    return numberNode(xn);
    }
/* 20070707
static int range(psk kn)
    {
    if(      LESS(kn)) return -2;
    if(LESS_EQUAL(kn)) return -1;
    if(MORE_EQUAL(kn)) return  1;
    if(      MORE(kn)) return  2;
    return 0;
    }*/

static int _qvergelijk(Qgetal _qx,Qgetal _qy)
    {
    Qgetal min_qy,som;
    int res;
    min_qy = _qmaalmineen(_qy);
    som = _qplus(_qx,min_qy);
    pskfree(min_qy);
    res = som->ops & (MINUS|QNUL);
    pskfree(som);
    return res;
    }

static int vgl(psk kn1,psk kn2);

static int vglsub(psk kn1,psk kn2)
    {
    psk kn = NULL;
    int ret;
    adr[1] = kn1;
    kn = opb(kn,"1+\1+-1)",NULL);
    evalueer(&kn);
    ret = vgl(kn,kn2);
    wis(kn);
    return ret;
    }

static int vgl(psk kn1,psk kn2)
    {
    while(kn1 != kn2)
        {
        register int r;
        if(is_op(kn1))
            {
            if(is_op(kn2))
                {
                r = (int)kop(kn2) - (int)kop(kn1);
                if(r)
                    {
                    /* 20080911 x^(y*(a+b))+-1*x^(a*y+b*y) -> 0 */
                    if(  kop(kn1) == MAAL 
                      && kop(kn2) == PLUS
                      && is_op(kn1->RIGHT)
                      && kop(kn1->RIGHT) == PLUS
                      )
                        {
                        /*printf("vgl ");result(kn1);printf(" =?= ");result(kn2);
                        printf("\n");*/
                        return vglsub(kn1,kn2);
                        }
                    return r;
                    }
                r = vgl(kn1->LEFT,kn2->LEFT);
                if(r)
                    return r;
                    /* return vgl(kn1->RIGHT,kn2->RIGHT);
                18 Maart 1997 */
                kn1 = kn1->RIGHT;
                kn2 = kn2->RIGHT;
                /*19970825  continue;*/
                }
            else
                return 1;
            }
        else if(is_op(kn2))
            return -1;
        else if(RATIONAAL_COMP(kn1) && RATIONAAL_COMP(kn2))
            {
            switch(_qvergelijk(kn1,kn2))
                {
                case MINUS: return -1;
                case QNUL:
                    {
                    /*int diff;
                    if(RATIONAAL(kn1) || RATIONAAL(kn2))
                        return 0;
                    diff = range(kn1) - range(kn2);
                    if(diff < 0)
                        return -1;
                    if(diff > 0)
                        return 1; 20070707*/
                    return 0;
                    }
                default: return 1;
                }
            }
        else
            return (r = HAS_MINUS_SIGN(kn1) - HAS_MINUS_SIGN(kn2)) == 0
            ? strcmp((char *)POBJ(kn1),(char *)POBJ(kn2))
            : r;
        /*19970825 break;*/
        }
    return 0;
    }

/*
name must be atom or <atom>.<atom>.<atom>...
*/
static int setmember(psk name,psk tree,psk nieuw)
    {
    while(is_op(tree))
        {
        if(kop(tree) == WORDT)
            {
            psk nname;
            if(kop(name) == DOT)
                nname = name->LEFT;
            else
                nname = name;
            if(vgl(tree->LEFT,nname))
                {
                return FALSE;
                }
            else if(nname == name)
                {
                wis(tree->RIGHT);
                tree->RIGHT = zelfde_als_w(nieuw);
                return TRUE;
                }
            else /* Found partial match for member name,
                    recurse in both name and member */
                {
                name = name->RIGHT;
                }
            }
        else if(setmember(name,tree->LEFT,nieuw))
            {
            return TRUE;
            }
        tree = tree->RIGHT;
        }
    return FALSE;
    }

static int update(psk name,psk pknoop) /* name = tree with DOT in root */
/*
    x:?(k.b)
    x:?((=(a=) (b=)).b)
*/
    {
    vars * navar;
    vars * voorvar;
    if(is_op(name->LEFT))
        {
        if(kop(name->LEFT) == WORDT)
            /*
            ((=(a=) (b=)).b)
              ^
            */
            return setmember(name->RIGHT,name->LEFT->RIGHT,pknoop);
        else
            {
            /*
            b:?((x.y).z)
            */
            return FALSE;
            }
        }
    if(zoeknaam(name->LEFT,
        &voorvar,
        &navar))
        {
        psk pkn;
        assert(navar->pvaria);
        pkn = *entry(navar->n,navar->selector,&navar->pvaria);
        return setmember(name->RIGHT,pkn,pknoop);
        }
    else
        {
        return FALSE;
        }
    }


static int insert(psk name,psk pknoop)
    {
    vars *navar,*voorvar,*nieuwvar;

    if(is_op(name))
        {
        if(kop(name) == WORDT)
            {
            wis(name->RIGHT);
            name->RIGHT = zelfde_als_w(pknoop);
            return TRUE;
            }
        else
            { /* This allows, in fact, other operators than DOT, e.g. b:?(x y) */
            return update(name,pknoop);
    /*        return FALSE;*/
            }
        }
    if(zoeknaam(name,
                &voorvar,
                &navar))
        {
        ppsk ppkn;
        wis(*(ppkn = entry(navar->n,navar->selector,&navar->pvaria)));
        *ppkn = zelfde_als_w(pknoop);
        }
    else
        {
        size_t len;
        unsigned char *string;
        string = POBJ(name);
        len = strlen((char *)string);
#if PVNAME
        nieuwvar = (vars*)bmalloc(__LINE__,sizeof(vars));
        if(*string)
            {
#if ICPY
            MEMCPY(nieuwvar->vname = (unsigned char *)
                 bmalloc(__LINE__,len+1),string,(len >> LOGWORDLENGTH)+1);
#else
            MEMCPY(nieuwvar->vname = (unsigned char *)
                 bmalloc(__LINE__,len+1),string,((len >> 2)+1) << 2);
#endif
            }
#else
        if(len < 4)
            nieuwvar = (vars*)bmalloc(__LINE__,sizeof(vars));
        else
            nieuwvar = (vars*)bmalloc(__LINE__,sizeof(vars) - 3 + len);
        if(*string)
            {
#if ICPY
            MEMCPY(&nieuwvar->u.Obj,string,(len >> LOGWORDLENGTH)+1);
#else
            MEMCPY(&nieuwvar->u.Obj,string,((len >> 2)+1) << 2);
#endif
            }
#endif
        else
            {
#if PVNAME
            nieuwvar->vname = OBJ(nilk);
#else
            nieuwvar->u.Lobj = LOBJ(nilk);
#endif
            }
        nieuwvar->next = navar;
        if(voorvar == NULL)
            variabelen[*string] = nieuwvar;
        else
            voorvar->next = nieuwvar;
        nieuwvar->n = 0;
        nieuwvar->selector = 0;
        nieuwvar->pvaria = (varia*)zelfde_als_w(pknoop);
        }
    return TRUE;
    }

static int copy_insert(psk name,psk pknoop,psk snijaf)
    {
    psk kn;
    int ret;
    if(pknoop->v.fl & IDENT)
        {
        kn = copievan(pknoop);
        }
    else if(snijaf == NULL)
        {
        return insert(name,pknoop);
        }
    else if(pknoop->RIGHT == snijaf)
        {
        kn = zelfde_als_w(pknoop->LEFT);
        }
    else if(!all_refcount_bits_set(pknoop) && !all_refcount_bits_set(snijaf))
        {
        kn = new_operator_like(pknoop);
        /*kn = (psk)bmalloc(/ *__LINE__,* /sizeof(kknoop));*/
        kn->ops = (pknoop->ops & ~ALL_REFCOUNT_BITS_SET) | LATEBIND;
        inc_refcount(pknoop);
        inc_refcount(snijaf);
        kn->LEFT = pknoop;
        kn->RIGHT = snijaf;
        }
    else
        {
        copyToSnijaf(&kn,pknoop,snijaf);
        }
    ret = insert(name,kn);
    wis(kn);
    return ret;
    }

static int scopy_insert(psk name,unsigned char * str)
    {
    int ret;
    int nr = fullnumbercheck(str,NULL) & ~DEFINITELYNONUMBER;
    psk kn;
    if(nr & MINUS)
        {
        kn = (psk)bmalloc(__LINE__,sizeof(unsigned long) + strlen((const char *)str));
        strcpy((char *)POBJ(kn),(char *)str + 1);
        }
    else
        {
        kn = (psk)bmalloc(__LINE__,sizeof(unsigned long) + 1 + strlen((const char *)str));
        strcpy((char *)POBJ(kn),(char *)str);
        }
    kn->v.fl = READY | SUCCESS | nr;
    ret = insert(name,kn);
    wis(kn);
    return ret;
    }

static int icopy_insert(psk name,int number)
    {
    unsigned char buf[12];
    sprintf((char*)buf,"%d",number);
    return scopy_insert(name,buf);
    }

static int string_copy_insert(psk name,psk pknoop,unsigned char * str,unsigned char * snijaf)
    {
    unsigned char sav = *snijaf;
    int ret;
    *snijaf = '\0';
    if((pknoop->v.fl & IDENT) || all_refcount_bits_set(pknoop))
        {
        ret = scopy_insert(name,str);
        }
    else
        {
        stringrefknoop * kn;
        int nr;
        nr = fullnumbercheck(str,NULL) & ~DEFINITELYNONUMBER;
        if((nr & MINUS) && !(name->v.fl & NUMBER))
            nr = 0; /* "-1" is only converted to -1 if the # flag is present on the pattern */
        kn = bmalloc(__LINE__,sizeof(stringrefknoop));
        kn->ops = /*(pknoop->ops & ~(ALL_REFCOUNT_BITS_SET|VISIBLE_FLAGS)) 20080911 substring doesn't inherit flags like */
            READY | SUCCESS | LATEBIND | nr;
        /*kn->ops |= SUCCESS;*/ /*20080113 @(~`ab:?%x ?%y)  ->  x == a */
        kn->kn = zelfde_als_w(pknoop);
        if(nr & MINUS)
            {
            kn->str = str+1;
            kn->length = snijaf - str - 1;
            }
        else
            {
            kn->str = str;
            kn->length = snijaf - str;
            }
        /*
            ++str;
        kn->str = str;
        kn->length = strlen((char *)str);
        */
#if DEBUGBRACMAT
        if(debug)
            {
            int redMooi;
            int redhum;
            redMooi = mooi;
            redhum = hum;
            mooi = FALSE;
            hum = FALSE;
            printf("str [%s] length %d\n",kn->str,kn->length);
            mooi = redMooi;
            hum = redhum;
            }
#endif
        ret = insert(name,(psk)kn);
        if(ret)
            dec_refcount((psk)kn);
        else
            {
            wis(pknoop);
            bfree(kn);
            }
        }
    *snijaf = sav;
    return ret;
    }

static int assign(ppsk pkn)
    {
    register psk lknoop;
    if(is_op(lknoop = (*pkn)->LEFT))
        {
        return update(lknoop,(*pkn)->RIGHT);
        }
    else
        {
        insert(lknoop,(*pkn)->RIGHT);
        }
    return TRUE;
    }

static int strcasecompu(unsigned char *s, unsigned char *p,unsigned char ** punmatched)
    {
    while(*s && *p)
        {
        int diff = (int)lowerEquivalent[*s] - (int)lowerEquivalent[*p];
        if(diff)
            {
            if(punmatched)
                            setend(punmatched,s,"H strcasecompu diff");
                /* *punmatched = s; */
            return diff;
            }
        ++s;
        ++p;
        }
    if(punmatched)
        {
        if(*p && !*s)
            {
            *punmatched = NULL; /* subject too short*/
            }
        else
            {
                            setend(punmatched,s,"I strcasecompu subject not too short");
               /* *punmatched = s; */
            }
        }
    return (int)*s - (int)*p;
    }


static int strcasecomp(const char *s, const char *p)
    {
    while(*s && *p)
        {
        int diff = (int)lowerEquivalent[(const unsigned char)*s] - (int)lowerEquivalent[(const unsigned char)*p];
        if(diff)
            {
            return diff;
            }
        ++s;
        ++p;
        }
    return (int)(const unsigned char)*s - (int)(const unsigned char)*p;
    }

static int strcasecmpDOS(const char *s, const char *p)
    {
    while(*s && *p)
        {
        int diff = (int)ISO8859toCodePage850(lowerEquivalent[CodePage850toISO8859((unsigned char)*s)]) - (int)ISO8859toCodePage850(lowerEquivalent[CodePage850toISO8859((unsigned char)*p)]);
        if(diff)
            return diff;
        ++s;
        ++p;
        }
    return (int)*s - (int)*p;
    }

#define NIET ((p->v.fl & NOT) && (p->v.fl & FLGS) < NUMBER)
#define PGRT (p->v.fl & GREATER_THAN)
#define PKLN (p->v.fl & SMALLER_THAN)
#define PONG  (PGRT && PKLN)
#define EPGRT (PGRT && !PKLN)
#define EPKLN (PKLN && !PGRT)

static int compare(psk s,psk p)
    {
    int teken;
    /*if(RATIONAAL_COMP(s) && RATIONAAL_COMP(p))*/
    if(RATIONAAL_COMP(s) && RATIONAAL_WEAK(p))
        teken = _qvergelijk /*bereken_verschil*/(s,p);
    else
        {
        if(is_op(s))
            return NIKS(p);
        if(PLOBJ(s) == IM && PLOBJ(p) == IM)
            {
            int TMP = ((s->v.fl & MINUS) ^ (p->v.fl & MINUS));
            int Niet = (p->v.fl & FLGS) < NUMBER && ((p->v.fl & NOT) && 1);
            int ul = (p->v.fl & (GREATER_THAN|SMALLER_THAN)) == (GREATER_THAN|SMALLER_THAN);
            int e1 = ((p->v.fl & GREATER_THAN) && 1);
            int e2 = ((p->v.fl & SMALLER_THAN) && 1);
            int ee = (e1 ^ e2) && 1;
            int R = !ee && (Niet ^ ul ^ !TMP);
            return R;
            }
        if((p->v.fl & (NOT|BREUK|NUMBER|GREATER_THAN|SMALLER_THAN)) == (NOT|GREATER_THAN|SMALLER_THAN))
            { /* 20040223 Case insensitive match: ~<> means "not different" */
            teken = strcasecomp((char *)POBJ(s),(char *)POBJ(p));
            }
        else
            {
            teken = strcmp((char *)POBJ(s),(char *)POBJ(p));
            }
        if(teken > 0)
            teken = 0;
        else if(teken < 0)
            teken = MINUS;
        else
            teken = QNUL;
        }
    switch(teken)
        {
        case 0 :
            {
            if(s->v.fl & SMALLER_THAN)
                return FALSE;
            return NIET ^ (PGRT && 1);
            }
        case QNUL :
            {
            switch(s->v.fl & (GREATER_THAN|SMALLER_THAN))
                {
                case GREATER_THAN|SMALLER_THAN :
                    return NIET ^ PONG;
                case GREATER_THAN :
                    return NIET ^ PONG ^ EPGRT;
                case SMALLER_THAN :
                    return NIET ^ PONG ^ EPKLN;
                default :
                    return !NIET ^ (PGRT || PKLN);
                }
            }
        default :
            {
            if(s->v.fl & GREATER_THAN)
                return FALSE;
            return NIET ^ (PKLN && 1);
            }
        }
    }

/*#if !DEBUGBRACMAT*/
#define scompare(wh,s,c,p,punmatched) scompare(s,c,p,punmatched)
/*#endif*/

static int scompare(char * wh,unsigned char * s,unsigned char * snijaf,psk p,unsigned char ** punmatched)
    {
/*    char buf[80];*/
    int teken;
    int return_value = 0xDADA;
    unsigned char * P;
    unsigned char * S = s;
    unsigned char sav;
    int smallerIfMoreDigitsAdded/*= FALSE*/;
    int Flgs = p->v.fl;
    /*enum {NoIndication,AnInteger,NotAFraction,NotANumber,AFraction,ANumber};
    int status = NoIndication;*/
    if((Flgs & (NOT|BREUK)) == (NOT|BREUK))
        {
        Flgs &= ~(NOT|BREUK);

        /*if(Flgs & NUMBER)
            status = AnInteger;
        else
            status = NotAFraction;
          */
        }
    else if((Flgs & (NOT|NUMBER)) == (NOT|NUMBER))
        {
        Flgs &= ~(NOT|NUMBER);
        /*status = NotANumber;*/
        }
        /*
    else if(Flgs & BREUK)
        status = AFraction;
    else if(Flgs & NUMBER)
        status = ANumber;
        */
    if(/*status != NoIndication || */RATIONAAL_WEAK(p))
        {
        int check = sfullnumbercheck(s,snijaf,punmatched);
        /*if(status != NoIndication)
            {
            switch(status)
                {
                case AnInteger:
                    if(check & QBREUK)
                        return ONCE;
                    else if(!(check & QGETAL))
                        return *s == '-' ? FALSE : ONCE;
                    break;
                case NotAFraction:
                    if(check & QBREUK)
                        return ONCE;
                    break;
                case NotANumber:
                    if(check & QGETAL)
                        return ONCE;
                    else if(*s == '-')
                        return FALSE;
                    break;
                case AFraction:
                    if(check & QGETAL)
                        {
                        if(!(check & QBREUK))
                            return FALSE;
                        }
                    else if(*s == '-')
                        return FALSE;
                    break;
                case ANumber:
                    if(!(check & QGETAL))
                        {
                        if(*s == '-')
                            return FALSE;
                        else
                            return ONCE;
                        }
                    break;
                }

            }
        if(RATIONAAL_WEAK(p))*/
            {
            if(check & QGETAL)
                {
                psk n = NULL;
                sav = *snijaf;
                *snijaf = '\0';
                n = opb(n,s,NULL);
                *snijaf = sav;
                smallerIfMoreDigitsAdded = (RAT_NEG_COMP(n) && 1) ^ (RAT_RAT(n) && 1);
                teken = _qvergelijk(n,p);
                wis(n);
                switch(Flgs & (NOT|GREATER_THAN|SMALLER_THAN))
                    {
                    case NOT|GREATER_THAN|SMALLER_THAN:    /* n:~<>p */
                    case 0:                                /* n:p */
                        {
        /*
                        n:p        n == p
                        n:~<>p  same as n:p
                            [n == p]
                                TRUE | ONCE
                            [n > p]
                                if n < 0 && p < 0
                                    FALSE
                                else
                                    ONCE
                            [n < p]
                                if n < 0
                                    ONCE
                                else
                                    FALSE
        */
                        switch(teken)
                            {
                            case QNUL:    /* n == p */
                                return TRUE|ONCE;
                            case 0:        /* n > p */
                                if(RAT_NEG_COMP(p) || smallerIfMoreDigitsAdded)
                                    return FALSE;
                                else
                                    return ONCE;
                            default:    /* n < p */
                                if(smallerIfMoreDigitsAdded)
                                    return ONCE;
                                else
                                    return FALSE;
                            }
                        }
                    case SMALLER_THAN:    /* n:<p */
                        {
        /*
                        n:<p    n < p
                            [n == p]
                                if n < 0
                                    FALSE
                                else
                                    ONCE
                            [n > p]
                                if n < 0
                                    FALSE
                                else
                                    ONCE
                            [n < p]
                                TRUE
        */
                        switch(teken)
                            {
                            case QNUL:    /* n == p */
                            case 0:        /* n > p */
                                if(smallerIfMoreDigitsAdded)
                                    return FALSE;
                                else
                                    return ONCE;
                            default:    /* n < p */
                                return TRUE;
                            }
                        }
                    case GREATER_THAN:    /* n:>p */
                        {
        /*
                        n:>p    n > p
                            [n == p]
                                if n < 0
                                    ONCE
                                else
                                    FALSE
                            [n > p]
                                TRUE
                            [n < p]
                                if n < 0
                                    ONCE
                                else
                                    FALSE
        */
                        switch(teken)
                            {
                            case 0:        /* n > p */
                                return TRUE;
                            default:    /* n == p , n < p */
                                if(smallerIfMoreDigitsAdded)
                                    return ONCE;
                                else
                                    return FALSE;
                            }
                        }
                    case GREATER_THAN|SMALLER_THAN:    /* n:<>p */
                    case NOT:                        /* n:~p */
                        {
        /*
                        n:<>p   n != p
                        n:~p    same as n:<>p
                            [n == p]
                                FALSE
                            [n > p]
                                TRUE
                            [n < p]
                                TRUE

        */
                        switch(teken)
                            {
                            case QNUL:    /* n == p */
                                return FALSE;
                            default:    /* n < p, n > p */
                                return TRUE;
                            }
                        }
                    case NOT|SMALLER_THAN:    /* n:~<p */
                        {
        /*
                        n:~<p   n >= p
                            [n == p]
                                if n < 0
                                    TRUE | ONCE
                                else
                                    TRUE
                            [n > p]
                                TRUE
                            [n < p]
                                if n < 0
                                    ONCE
                                else
                                    FALSE
        */
                        switch(teken)
                            {
                            case QNUL:    /* n == p */
                                if(smallerIfMoreDigitsAdded)
                                    return TRUE|ONCE;
                                else
                                    return TRUE;
                            case 0:        /* n > p */
                                return TRUE;
                            default:    /* n < p */
                                if(smallerIfMoreDigitsAdded)
                                    return ONCE;
                                else
                                    return FALSE;
                            }
                        }
                    case NOT|GREATER_THAN:    /* n:~>p */
                        {
        /*
                        n:~>p   n <= p
                            [n == p]
                                if n < 0
                                    TRUE
                                else
                                    TRUE | ONCE
                            [n > p]
                                if n < 0
                                    FALSE
                                else
                                    ONCE
                            [n < p]
                                TRUE
        */
                        switch(teken)
                            {
                            case QNUL:    /* n == p */
                                if(smallerIfMoreDigitsAdded)
                                    return TRUE;
                                else
                                    return TRUE|ONCE;
                            case 0:        /* n > p */
                                if(smallerIfMoreDigitsAdded)
                                    return FALSE;
                                else
                                    return ONCE;
                            default:    /* n < p */
                                return TRUE;
                            }
                        }
                    default:
                        return FALSE;
                    }
                }
            else if((s < snijaf) && (*s == '-') && (snijaf < s + 2)/*!s[1]*/)
                return FALSE;
            }
        if(return_value != 0xDADA)
            {
            return return_value;
            }
        }

    /*teken = strcmp((char *)s,(char *)POBJ(p));*/
    P = (unsigned char *)POBJ(p);
/*    sprintf(buf,"%s[%.20s:%.20s] ",wh,s,P);*/

    sav = *snijaf;
    *snijaf = '\0';
    if((Flgs & (NOT|BREUK|NUMBER|GREATER_THAN|SMALLER_THAN)) == (NOT|GREATER_THAN|SMALLER_THAN))
        { /* 20040223 Case insensitive match: ~<> means "not different" */
        teken = strcasecompu(s,P,punmatched);
/*
        while(*s && *p)
            {
            int teken = (int)lowerEquivalent[*s] - (int)lowerEquivalent[*p];
            if(teken)
                {
                if(punmatched)
                    setend(punmatched,s,"H strcasecompu diff");
                return teken;
                }
            ++s;
            ++p;
            }
        if(punmatched)
            {
            if(*p && !*s)
                {
                *punmatched = NULL;
                }
            else
                {
                setend(punmatched,s,"I strcasecompu subject not too short");
                }
            }
        return (int)*s - (int)*p;
*/
        }
    else
        {
        teken = *s - *P;
        while(!teken && *s && *P)
            {
            ++s;
            ++P;
            teken = *s - *P;
            }
/*        if(!teken && (*s || *P))
            teken = *s - *P;*/
        if(punmatched)
            {
            if(*P && !*s)
                {
                *punmatched = NULL; /* subject too short (well, this depends on the unary operator on the pattern)*/
                }
            else
                {
                setend(punmatched,s,"J scompare subject not too short");
                }
            }
        }
    *snijaf = sav;

    if(teken > 0)
        {
        teken = 0;
        return_value = ONCE;
        }
    else if(teken < 0)
        {
        teken = MINUS;
        if((s < snijaf) /* *s */ || (punmatched && (s == S)))
            {
            return_value = ONCE;
            }
        else
            return_value = FALSE; /*subject too short*/
        }
    else
        {
        teken = QNUL;
        return_value = ONCE;
        }
    switch(Flgs & (NOT|GREATER_THAN|SMALLER_THAN))
        {
        case NOT|GREATER_THAN|SMALLER_THAN:    /* n:~<>p */
        case 0:                                /* n:p */
            {
/*
            n:p        n == p
            n:~<>p  same as n:p
                [n == p]
                    TRUE | ONCE
                [n > p]
                    ONCE
                [n < p]
                    FALSE
*/
            switch(teken)
                {
                case QNUL:    /* n == p */
                    return TRUE|ONCE;
                case 0:        /* n > p */
                    if(punmatched && !*P && (s < snijaf) /* *s */)
                        return TRUE|ONCE;
                    return ONCE;
                default:    /* n < p */
                    /*
                    if(return_value == FALSE)
                        {
                        printf(buf);
                        return ONCE;
                        }
*/
                    return return_value;
                }
            }
        case SMALLER_THAN:    /* n:<p */
            {
/*
            n:<p    n < p
                [n == p]
                    ONCE
                [n > p]
                    ONCE
                [n < p]
                    TRUE
*/
            switch(teken)
                {
                case QNUL:    /* n == p */
                case 0:        /* n > p */
                    /*strcat(buf,"B(s P)\n");
                    printf(buf);*/
                    if((s < snijaf) /* *s */ && *P && punmatched)
                        {
                        setend(punmatched,s,"Z n < p");
                        return TRUE|ONCE; /* if we discard the last (s < snijaf), the comparison becomes right */
                        }
                    return ONCE;
                default:    /* n < p */
                    /*strcat(buf,"C(s)\n");
                    printf(buf);*/
                    if(punmatched && !*punmatched)
                        {
                        setend(punmatched,snijaf/* s+strlen((const char *)s)*/,"K n < p");
                        }
                    return TRUE;
                }
            }
        case GREATER_THAN:    /* n:>p */
            {
/*
            n:>p    n > p
                [n == p]
                    FALSE
                [n > p]
                    TRUE
                [n < p]
                    FALSE
*/
            switch(teken)
                {
                case 0:        /* n > p */
                    return TRUE;
                case QNUL:        /* n == p */
                    return FALSE;
                default:    /* n < p */
                    return return_value;
                }
            }
        case GREATER_THAN|SMALLER_THAN:    /* n:<>p */
        case NOT:                        /* n:~p */
            {
/*
            n:<>p   n != p
            n:~p    same as n:<>p
                [n == p]
                    FALSE
                [n > p]
                    TRUE
                [n < p]
                    TRUE

*/
            switch(teken)
                {
                case QNUL:    /* n == p */
                    return FALSE;
                default:    /* n < p, n > p */
                    /*strcat(buf,"D(s)\n");
                    printf(buf);*/
                    if(punmatched && !*punmatched)
                        {
                        setend(punmatched,snijaf/*s+strlen((const char *)s)*/,"L <>");
                        }
                    return TRUE;
                }
            }
        case NOT|SMALLER_THAN:    /* n:~<p */
            {
/*
            n:~<p   n >= p
                [n == p]
                    TRUE
                [n > p]
                    TRUE
                [n < p]
                    FALSE
*/
            switch(teken)
                {
                case QNUL:    /* n == p */
                case 0:        /* n > p */
                    return TRUE;
                default:    /* n < p */
                    return return_value;
                }
            }
        case NOT|GREATER_THAN:    /* n:~>p */
            {
/*
            n:~>p   n <= p
                [n == p]
                    TRUE | ONCE
                [n > p]
                    ONCE
                [n < p]
                    TRUE
*/
            switch(teken)
                {
                case QNUL:    /* n == p */
                    return TRUE|ONCE;
                case 0:        /* n > p */
                    /*strcat(buf,"E(s P)\n");
                    printf(buf);*/
                    if((s < snijaf) /* *s */ && *P && punmatched && !*punmatched)
                        {
                        setend(punmatched,s,"Y n < p");
                        return TRUE|ONCE; /* if we discard the last (s < snijaf), the comparison becomes right */
                        }
                    return ONCE;
                default:    /* n < p */
                    /*strcat(buf,"F(s)\n");
                    printf(buf);*/
                    if(punmatched && !*punmatched)
                        {
                        setend(punmatched,snijaf/*s+strlen((const char *)s)*/,"M ~>");
                        }
                    return TRUE;
                }
            }
        default:
            return ONCE;
        }
    }



static int psh(psk name,psk pknoop,psk dim)
    {
    /* string dient aan de eisen van icpy te voldoen */
    vars *navar
      ,*voorvar
      ;
    varia *nvaria;
    psk cknoop;
    int oldn,n,m2,m22;
    while(is_op(name))
        {
        /* return psh(name->LEFT,pknoop,dim) && psh(name->RIGHT,pknoop,dim);
        18 Maart 1997 */
        if(!psh(name->LEFT,pknoop,dim))
            return FALSE;
        name = name->RIGHT;
        }
    if(dim && !INTEGER(dim))
        return FALSE;
    if(!zoeknaam(name,
                 &voorvar,
                 &navar))
        {
        insert(name,pknoop);
        if(dim)
            {
            zoeknaam(name,
                     &voorvar,
                     &navar);
            }
        else
            return TRUE;
        }
    n = oldn = navar->n;
    if(dim)
        {
        int newn;
        newn = (int)strtoul((char *)POBJ(dim),(char **)NULL,10);
        if(RAT_NEG(dim))
            newn = oldn - newn + 1;
        if(newn < 0)
            return FALSE;
        navar->n = newn;
        if(oldn >= navar->n)
            {
            assert(navar->pvaria);
            for(;oldn >= navar->n;)
                wis(*entry(n,oldn--,&navar->pvaria));
            }
        navar->n--;
        if(navar->selector > navar->n)
            navar->selector = navar->n;
        }
    else
        {
        navar->n++;
        navar->selector = navar->n;
        }
    m2 = macht2(n);
    if(m2 == 0)
        m22 = 1;
    else
        m22 = m2 << 1;
    if(navar->n >= m22)
        /* alloceren */
        {
        for(;navar->n >= m22;m22 <<= 1)
            {
            nvaria = (varia*)bmalloc(__LINE__,sizeof(varia) + (m22-1)*sizeof(psk));
            nvaria->prev = navar->pvaria;
            navar->pvaria = nvaria;
            }
        }
    else if(navar->n < m2)
        /* dealloceren */
        {
        for(;m2 && navar->n < m2;m2 >>= 1)
            {
            nvaria = navar->pvaria;
            navar->pvaria = nvaria->prev;
            bfree(nvaria);
            }
        if(navar->n < 0)
            {
            if(voorvar)
                voorvar->next = navar->next;
            else
                variabelen[*POBJ(name)] = navar->next;
#if PVNAME
            if(navar->vname != OBJ(nilk))
                bfree(navar->vname);
#endif
            bfree(navar);
            return TRUE; /* 20001222 */
            }
        }
    /*else
       geen allocatie
        {
        }*/
    assert(navar->pvaria);
    for(cknoop = pknoop;
        ++oldn <= navar->n;
        cknoop = *entry(navar->n,oldn,&navar->pvaria) = zelfde_als_w(cknoop));
    return TRUE;
    }

typedef struct classdef
    {
    char * name;
    method * vtab;
    } classdef;

typedef struct pskRecord
    {
    psk entry;
    struct pskRecord * next;
    } pskRecord;

typedef int (*cmpfuncTp)(const char *s, const char *p);
typedef long (*hashfuncTp)(const char *s);

typedef struct Hash
    {
    pskRecord **hash_table;
    unsigned long hash_size;
    unsigned long elements;     /* elements >= record_count */
    unsigned long record_count; /* record_count >= size - unoccupied */
    unsigned long unoccupied;
    cmpfuncTp cmpfunc;
    hashfuncTp hashfunc;
    /*
    unsigned int Dos:1;
    unsigned int casesensitive:1;
    */
    } Hash;

static long casesensitivehash(const char * cp)
    {
    long hash_temp = 0;
    while (*cp != '\0')
        {
        if(hash_temp < 0)
            hash_temp = (hash_temp << 1) +1;
        else
            hash_temp = hash_temp << 1;
        hash_temp ^= *cp;
        ++cp;
        }
    return hash_temp;
    }

static long caseinsensitivehash(const char * cp)
    {
    long hash_temp = 0;
    while (*cp != '\0')
        {
        if(hash_temp < 0)
            hash_temp = (hash_temp << 1) +1;
        else
            hash_temp = hash_temp << 1;
        /* 20060704 (int) --> (const unsigned char) */
        hash_temp ^= lowerEquivalent[(const unsigned char)*cp];
        ++cp;
        }
    return hash_temp;
    }

static long caseinsensitivehashDOS(const char * cp)
    {
    long hash_temp = 0;
    while (*cp != '\0')
        {
        if(hash_temp < 0)
            hash_temp = (hash_temp << 1) +1;
        else
            hash_temp = hash_temp << 1;
        hash_temp ^= ISO8859toCodePage850(lowerEquivalent[CodePage850toISO8859(*cp)]);
        ++cp;
        }
    return hash_temp;
    }

static psk removeFromHash(Hash * temp,psk Arg)
    {
    const char * key = (const char *)POBJ(Arg);
    long i;
    long hash_temp;
    pskRecord ** pr;
    hash_temp = (*temp->hashfunc)(key);
    /*i = temp->hash_size ? ((unsigned int)hash_temp) % temp->hash_size : 0;*/
    assert(temp->hash_size);
    i = ((unsigned int)hash_temp) % temp->hash_size;
    pr = temp->hash_table + i;
    if(*pr)
        {
        while(*pr)
            {
            if(kop((*pr)->entry) == LUCHT)
                {
                if(!(*temp->cmpfunc)(key,(const char *)POBJ((*pr)->entry->LEFT->LEFT)))
                    break;
                }
            else if(!(*temp->cmpfunc)(key,(const char *)POBJ((*pr)->entry->LEFT)))
               break;
            pr = &(*pr)->next;
            }
        if(*pr)
            {
            pskRecord * next = (*pr)->next;
            psk ret = (*pr)->entry;
            bfree(*pr);
            *pr = next;
            --temp->record_count; /* Bart 20040903 */
            return ret;
            }
        }
    return NULL;
    }

static psk inserthash(Hash * temp,psk Arg)
    {
    const char * key = (const char *)POBJ(Arg->LEFT);
    long i;
    long hash_temp;
    pskRecord * r;
    hash_temp = (*temp->hashfunc)(key);
    /*i = temp->hash_size ? ((unsigned int)hash_temp) % temp->hash_size : 0;*/
    assert(temp->hash_size);
    i = ((unsigned int)hash_temp) % temp->hash_size;
    r = temp->hash_table[i];
    if(!r)
        --temp->unoccupied;
    else
        while(r)
            {
            if(kop(r->entry) == LUCHT)
                {
                if(!(*temp->cmpfunc)(key,(const char *)POBJ(r->entry->LEFT->LEFT)))
                    break;
                }
            else if(!(*temp->cmpfunc)(key,(const char *)POBJ(r->entry->LEFT)))
               break;
            r = r->next;
            }
    if(r)
        {
        psk goal = (psk)bmalloc(__LINE__,sizeof(kknoop));
        goal->v.fl = LUCHT | SUCCESS;
        goal->ops &= ~ALL_REFCOUNT_BITS_SET;
        goal->LEFT = zelfde_als_w(Arg);
        goal->RIGHT = r->entry;
        r->entry = goal;
        }
    else
        {
        r = (pskRecord *)bmalloc(__LINE__,sizeof(pskRecord));
        r->entry = zelfde_als_w(Arg);
        r->next = temp->hash_table[i];
        temp->hash_table[i] = r;
        ++temp->record_count;
        }
    ++temp->elements;
    return r->entry;
    }

static psk findhash(Hash * temp,psk Arg)
    {
    const char * key = (const char *)POBJ(Arg);
    long i;
    long hash_temp;
    pskRecord * r;
    hash_temp = (*temp->hashfunc)(key);
    /*i = temp->hash_size ? ((unsigned int)hash_temp) % temp->hash_size : 0;*/
    assert(temp->hash_size);
    i = ((unsigned int)hash_temp) % temp->hash_size;
    r = temp->hash_table[i];
    if(r)
        {
        while(r)
            {
            if(kop(r->entry) == LUCHT)
                {
                if(!(*temp->cmpfunc)(key,(const char *)POBJ(r->entry->LEFT->LEFT)))
                    break;
                }
            else if(!(*temp->cmpfunc)(key,(const char *)POBJ(r->entry->LEFT)))
               break;
            r = r->next;
            }
        if(r)
            return r->entry;
        }
    return NULL;
    }

static void freehash(Hash * temp)
    {
    if(temp)
        {
        if(temp->hash_table)
            {
            unsigned long i;
            for(i = temp->hash_size;i > 0;)
                {
                pskRecord * r = temp->hash_table[--i];
                pskRecord * next;
                while(r)
                    {
                    wis(r->entry);
                    next = r->next;
                    bfree(r);
                    r = next;
                    }
                }
            bfree(temp->hash_table);
            }
        bfree(temp);
        }
    }

static Hash * newhash(unsigned long size)
    {
    unsigned long i;
    Hash * temp = bmalloc(__LINE__,sizeof(Hash));
    assert(size > 0);
    temp->hash_size = size;
    temp->record_count = (unsigned int)0;
    temp->hash_table = (pskRecord **)bmalloc(__LINE__,sizeof(pskRecord *) * temp->hash_size);
    temp->cmpfunc = strcmp;
    temp->hashfunc = casesensitivehash;
    /*
    temp->Dos = FALSE;
    temp->casesensitive = TRUE;
    */
    temp->elements = 0L;     /* elements >= record_count */
    temp->record_count = 0L; /* record_count >= size - unoccupied */
    temp->unoccupied = size;
    for(i = temp->hash_size;i > 0;)
        temp->hash_table[--i] = NULL;
    return temp;
    }

static unsigned long nextprime(unsigned long g)
    {
    int i;
    unsigned long kleindeler;
    static int bijt[12]=
      {1,  2,  2,  4,    2,    4,    2,    4,    6,    2,  6};
    /*2-3,3-5,5-7,7-11,11-13,13-17,17-19,19-23,23-29,29-1,1-7*/
    unsigned long grootdeler;
    if(g & 1)
        ++g; /* even -> uneven */
    kleindeler = 2;
    i = 0;
    while((grootdeler = g / kleindeler) >= kleindeler)
        {
        if(grootdeler * kleindeler == g)
            {
            ++g;
            kleindeler = 2;
            i = 0;
            }
        else
            {
            kleindeler += bijt[i];
            if(++i > 10)
                i = 3;
            }
        }
    return g;
    }

static void rehash(Hash ** ptemp,int loadFactor/*1-100*/)
    {
    Hash * temp = *ptemp;
    if(temp)
        {
        unsigned long newsize;
        Hash * newtable;
/*
        printf("Old: size %ld unoccupied %ld records %ld elements %ld\n",
            temp->hash_size,temp->unoccupied,temp->record_count,temp->elements);
        printf("rehash\n");
*/
        newsize = nextprime((100 * temp->record_count)/loadFactor);
        if(!newsize)
            newsize = 1;
        newtable = newhash(newsize);
        newtable->cmpfunc = temp->cmpfunc;
        newtable->hashfunc = temp->hashfunc;
        if(temp->hash_table)
            {
            unsigned long i;
            for(i = temp->hash_size;i > 0;)
                {
                pskRecord * r = temp->hash_table[--i];
                while(r)
                    {
                    psk pkn = r->entry;
                    while(is_op(pkn) && kop(pkn) == LUCHT)
                        {
                        inserthash(newtable,pkn->LEFT);
                        pkn = pkn->RIGHT;
                        }
                    inserthash(newtable,pkn);
                    r = r->next;
                    }
                }
            }
/*
        printf("New: size %ld unoccupied %ld records %ld elements %ld\n",
            newtable->hash_size,newtable->unoccupied,newtable->record_count,newtable->elements);
*/
        freehash(temp);
        *ptemp = newtable;
        }
    }

static int loadfactor(Hash * temp)
    {
    /*if(!temp->hash_size)
        return 100;
    else */
    assert(temp->hash_size);
    if(temp->record_count < 10000000L)
        return (int)((100 * temp->record_count) / temp->hash_size);
    else
        return (int)(temp->record_count / (temp->hash_size/100));
    }

static function_return_type hashinsert(struct typedObjectknoop * This,ppsk arg)
    {
    psk Arg = (*arg)->RIGHT;
    if(is_op(Arg) && !is_op(Arg->LEFT))
        {
        psk ret;
        int lf = loadfactor(HASH(This));
        if(lf > 100)
            rehash(PHASH(This),60);
        ret = inserthash(HASH(This),Arg);
        wis(*arg);
        *arg = zelfde_als_w(ret);
        return builtin_object_builtin_method_ok;
        }
    return function_fail;
    }

static function_return_type hashfind(struct typedObjectknoop * This,ppsk arg)
    {
    psk Arg = (*arg)->RIGHT;
    if(!is_op(Arg))
        {
        psk ret = findhash(HASH(This),Arg);
        if(ret)
            {
            wis(*arg);
            *arg = zelfde_als_w(ret);
            return builtin_object_builtin_method_ok;
            }
        }
    return function_fail;
    }

static function_return_type hashremove(struct typedObjectknoop * This,ppsk arg)
    {
    psk Arg = (*arg)->RIGHT;
    if(!is_op(Arg))
        {
        Hash * temp = HASH(This);
        psk ret = removeFromHash(temp,Arg);
        if(ret)
            {
            if(loadfactor(temp) < 50 && temp->hash_size > 97)
                rehash(PHASH(This),90);
            wis(*arg);
            *arg = ret;
            return builtin_object_builtin_method_ok;
            }
        }
    return function_fail;
    }

static function_return_type hashnew(struct typedObjectknoop * This,ppsk arg)
    {
    UNREFERENCED_PARAMETER(arg);
    VOID(This) = (void *)newhash(97);
    return builtin_object_builtin_method_ok;
    }

static function_return_type hashdie(struct typedObjectknoop * This,ppsk arg)
    {
    UNREFERENCED_PARAMETER(arg);
    freehash(HASH(This));
    return builtin_object_builtin_method_ok;
    }

static function_return_type hashDOS(struct typedObjectknoop * This,ppsk arg)
    {
    UNREFERENCED_PARAMETER(arg);
    (HASH(This))->hashfunc = caseinsensitivehashDOS;
    (HASH(This))->cmpfunc = strcasecmpDOS;
    rehash(PHASH(This),100);
    return builtin_object_builtin_method_ok;
    }

static function_return_type hashISO(struct typedObjectknoop * This,ppsk arg)
    {
    UNREFERENCED_PARAMETER(arg);
    (HASH(This))->hashfunc = caseinsensitivehash;
    (HASH(This))->cmpfunc = strcasecomp;
    rehash(PHASH(This),100);
    return builtin_object_builtin_method_ok;
    }

static function_return_type hashcasesensitive(struct typedObjectknoop * This,ppsk arg)
    {
    UNREFERENCED_PARAMETER(arg);
    (HASH(This))->hashfunc = casesensitivehash;
    (HASH(This))->cmpfunc = strcmp;
    rehash(PHASH(This),100);
    return builtin_object_builtin_method_ok;
    }


static function_return_type hashforall(struct typedObjectknoop * This,ppsk arg)
    {
    unsigned long i;
    int ret = TRUE;
    This = (typedObjectknoop *)zelfde_als_w((psk)This);
    for( i = 0
        ;    ret && HASH(This)
          && i < (HASH(This))->hash_size
        ;
       )
        {
        pskRecord * r = (HASH(This))->hash_table[i];
        int j = 0;
        while(r)
            {
            int m;
            psk pkn = NULL;
            adr[2] = (*arg)->RIGHT; /* each time! adr[n] may be overwritten by evalueer (below)*/
            adr[3] = r->entry;
            pkn = opb(pkn,"(\2'\3)",NULL);
            ret = evalueer(&pkn);
            wis(pkn);
            if(  !ret
              || !HASH(This)
              || i >= (HASH(This))->hash_size
              || !(HASH(This))->hash_table[i]
              )
                break;
            ++j;
            for(m = 0,r = (HASH(This))->hash_table[i]
               ;r && m < j
               ;++m
               )
                 r = r->next;
            }
        ++i;
        }
    wis((psk)This);
    return builtin_object_builtin_method_ok;
    }


method hash[] = {
    {"find",hashfind},
    {"insert",hashinsert},
    {"remove",hashremove},
    {"New",hashnew},
    {"Die",hashdie},
    {"DOS",hashDOS},
    {"ISO",hashISO},
    {"casesensitive",hashcasesensitive},
    {"forall",hashforall},
    {NULL,NULL}};
/*
Standard methods are 'New' and 'Die'.
A user defined 'die' can be added after creation of the object and will be invoked just before 'Die'.

Example:

new$hash:?h;

     (=(Insert=.out$Insert & lst$its & lst$Its & (Its..insert)$!arg)
      (die = .out$"Oh my God")
    ):(=?(h.));

    (h..Insert)$(X.x);

    :?h;



    (=(Insert=.out$Insert & lst$its & lst$Its & (Its..insert)$!arg)
      (die = .out$"The end.")
    ):(=?(new$hash:?k));

    (k..Insert)$(Y.y);

    :?k;

A little problem is that in the last example, the '?' ends up as a flag on the '=' node.

Bart 20010222

*/

classdef classes[] = {{"hash",hash},{NULL,NULL}};


static method_pnt findBuiltInMethod(typedObjectknoop * object,psk methodName)
    {
    if(!is_op(methodName))
        {
        method * methods = object->vtab;
        if(methods)
            {
            for(;methods->name && strcmp(methods->name,(const char *)POBJ(methodName));++methods)
                ;
            return methods->func;
            }
        }
    return NULL;
    }

static int getmember(psk name,psk tree,ppsk doel,ppsk self,ppsk object,method_pnt * theMethod)
    {
    while(is_op(tree))
        {
        if(kop(tree) == WORDT)
            {
            psk nname;
            if(  theMethod
              && object
              && ISBUILTIN((objectknoop*)tree)
              && kop(name) == DOT
              )
                {
                *object = tree;  /* object == (=) */
                *theMethod = findBuiltInMethod((typedObjectknoop *)tree,name->RIGHT);
                /* findBuiltInMethod((=),(insert)) */
                if(*theMethod)
                    {
                    *doel = NULL;
                    return TRUE;
                    }
                }

            if(kop(name) == DOT)
                nname = name->LEFT;
            else
                nname = name;
            if(vgl(tree->LEFT,nname))
                return FALSE;
            else if(nname == name)
                {
                *doel = *Head(&tree->RIGHT);
                return TRUE;
                }
            else
                {
                if(self)
                    *self = tree->RIGHT;
                name = name->RIGHT;
                }
            }
        else
            {
            psk tmp;
            if(getmember(name,tree->LEFT,&tmp,self,object,theMethod))
                {
                *doel = tmp;
                return TRUE;
                }
            }
        tree = tree->RIGHT;
        }
    return FALSE;
    }


static int find(psk naamknoop,ppsk doel,int *newval,ppsk self,ppsk object,method_pnt * theMethod)
/*
'naamknoop' is the expression that has to lead to a binding.
Conceptually, expression (or its complement) and binding are separated by a '=' operator.
E.g.

  say            =         (.out$!arg)
  ---            -         -----------
  expression   '='-operator     binding

    say$HELLO
    and
    (= (.out$!arg))$HELLO

      must be equivalent. Therefore, both of 'say' and its complement '(= .out$!arg)' have the binding '(.out$!arg)'.

        If the binding is found 'find' returns TRUE, otherwise it returns FALSE.
        The binding is either returned in 'doel' or in 'theMethod', not both.
        The parameter 'newval' is set to TRUE if 'doel' has increased a reference counter. (must be ignored if find returns FALSE.)
        The parameter 'self' is the rhs of the root '=' of an object. It is used for non-built-ins
        The parameter 'object' is the root of an object, possibly having built-in methods.


Built in methods:
if
    new$hash:?x
then
    ((=).insert)$   (=) being the hash node with invisible built in method 'insert'
and
    (!x.insert)$
and
    (x..insert)$
must be equivalent
*/
    {
    vars *navar;
    /* 29 juli 1993 */
    if(!doel)
        {
        return FALSE;
        }
    if(is_op(naamknoop))
        {
        switch(kop(naamknoop))
            {
            case WORDT: /* Lambda function: (=.out$!arg)$HELLO -> naamknoop == (=.out$!arg) */
                {
                *newval = TRUE;
                naamknoop->RIGHT = *Head(&naamknoop->RIGHT);
                *doel = zelfde_als_w(naamknoop->RIGHT);
                /*evalobject(doel);*/ /* This makes that (==.out$!arg)$HELLO also works, but not (===.out$!arg)$HELLO
                                     so what is the meaning of this?
                                    */
                return TRUE;
                }
            case DOT: /*
                      e.g.

                      (1)
                            x  =  (a=2) (b=3)

                            !(x.a)
                      and
                            !((=  (a=2) (b=3)).a)

                      must give same result.

                      (2)

                      new$hash:?y

                      ((=).insert)$
                      (y..insert)$
                      (!y.insert)$
                      */
                {
                psk tmp;
                psk tmp2 = NULL;
                int nieuw = FALSE;
                if(is_op(naamknoop->LEFT))
                    {
                    if(kop(naamknoop->LEFT) == WORDT) /* naamknoop->LEFT == (=  (a=2) (b=3))   */
                        {
                        if(  theMethod
                          && object
                          && ISBUILTIN((objectknoop*)(naamknoop->LEFT))
                          /*&& !is_op(naamknoop->RIGHT)*/
                          )
                            {
                            *theMethod = findBuiltInMethod((typedObjectknoop *)(naamknoop->LEFT),naamknoop->RIGHT);
                                                /* findBuiltInMethod((=),(insert)) */
                            *object = naamknoop->LEFT;  /* object == (=) */
                            if(*theMethod)
                                {
                                *doel = NULL;
                                return TRUE;
                                }
                            }
                        tmp = naamknoop->LEFT->RIGHT; /* tmp == ((a=2) (b=3))   */
                        }
                    else
                        return FALSE;
                    }
                else                                   /* x */
                    {
                    if(!find(naamknoop->LEFT,&tmp,&nieuw,NULL,NULL/*object*/,NULL/*theMethod*/))
                        return FALSE;
                    /*
                    tmp == ((a=2) (b=3))
                    tmp == (=)
                    */
                    }
                if(self)
                    *self = tmp; /* self == ((a=2) (b=3))   */
                /* The number of '=' to reach the method name in 'tmp' must be one greater
                   than the number of '.' that precedes the method name in 'naamknoop->RIGHT'

                   e.g (= (say=.out$!arg)) and (.say) match

                   For built-in methods (definitions of which are not visible) an invisible '=' has to be assumed.

                   The function getmember resolves this.
                */
                getmember(naamknoop->RIGHT,tmp,&tmp2,self,object,theMethod);

                if(tmp2)
                    {
                    *newval = TRUE;
                    *doel = zelfde_als_w(tmp2);
#ifdef SELF
                    if(*doel && self && *self)
                        {
                        psh(&selfkn,*self,NULL);
                        }
#endif
                    }
                else
                    *doel = NULL;
                if(nieuw)
                    wis(tmp);
                return *doel != NULL || (theMethod && *theMethod != NULL);
                }
            default:
                {
                *newval = FALSE;
                return FALSE;
                }
            }
        }
    else
        {
        for(navar = variabelen[naamknoop->u.obj];
            navar && (STRCMP(VARNAME(navar),POBJ(naamknoop)) < 0);
            navar = navar->next)
            ;
        if(navar && !STRCMP(VARNAME(navar),POBJ(naamknoop))
           && navar->selector <= navar->n
          )
            {
            assert(navar->pvaria);
            *doel = *Head(entry(navar->n,navar->selector,&navar->pvaria));
            *newval = FALSE;
            return TRUE;
            }
        else
            {
            return FALSE;
            }
        }
    }

#ifdef SELF
static int naamwoord(psk variabele,ppsk pbinding,unsigned int *pflags,int *newval,ppsk self);

static int sufficiently_resolved(ppsk pbinding,unsigned int *pflags,int *newval,ppsk self)
#else
static int naamwoord(psk variabele,ppsk pbinding,unsigned int *pflags,int *newval);

static int sufficiently_resolved(ppsk pbinding,unsigned int *pflags,int *newval)
#endif
    {
    psk name;
    name = *pbinding; /* e.g. !x or !!x */
    if(!(name->v.fl & INDIRECT))
        return TRUE;
    else
        {
        int res;
        int newv;
        res = naamwoord(name,pbinding,pflags,&newv
#ifdef SELF
            ,self
#endif
            );

        if(*newval)
            wis(name);

        *newval = newv;

        return res;
        }
    }

static int deleteNode(psk name)
{
vars *navar
,*voorvar
;
varia *hv;
if(zoeknaam(name,
            &voorvar,
            &navar))
    {
    assert(navar->pvaria);
    wis(*entry(navar->n,navar->n,&navar->pvaria));
    if(navar->n)
        {
        if((navar->n)-1 < macht2(navar->n))
            {
            hv = navar->pvaria;
            navar->pvaria = hv->prev;
            bfree(hv);
            }
        navar->n--;
        if(navar->n < navar->selector)
            navar->selector = navar->n;
        }
    else
        {
        if(voorvar)
            voorvar->next = navar->next;
        else
            variabelen[*POBJ(name)] = navar->next;
#if PVNAME
        if(navar->vname != OBJ(nilk))
            bfree(navar->vname);
#endif
        bfree(navar); /* nieuw */
        }
    return TRUE;
    }
else
    return FALSE;
}

#ifdef SELF
static int naamwoord(psk variabele,ppsk pbinding,unsigned int *pflags,int *newval,ppsk self)
#else
static int naamwoord(psk variabele,ppsk pbinding,unsigned int *pflags,int *newval)
#endif
/* *pbinding kan een andere waarde krijgen, ook als de boel faalt */
    {
    register int Flgs;
#ifdef SELF
    psk self2 = NULL;
#endif
    int ret = TRUE;
    Flgs = variabele->v.fl;
    *pflags |= (Flgs & ERFENIS);
    if(ONTKENNING(Flgs,GREATER_THAN) || ONTKENNING(Flgs,SMALLER_THAN))
        *pflags |= NOT;
    *pflags ^= ((Flgs & SUCCESS) ^ SUCCESS);
#ifdef SELF
    if(find(variabele,pbinding,newval,self,NULL,NULL))
#else
    if(find(variabele,pbinding,newval,NULL,NULL,NULL))
#endif
        {
        if(sufficiently_resolved(pbinding,pflags,newval
#ifdef SELF
          ,&self2
#endif
          ))
            {
            /*
            a=b=(c=d)
            e:?!(a.b)
            dan krijg ik c en ken daar e aan toe, maar dat is niet de
            bedoeling! Ik moet testen of ik in een object zit (self).
            Als dat zo is, moet ik e toekennen aan its.c (e:?(its.c)),
            zodat ik krijg a=b=c=e
            */
            if(variabele->v.fl & DOUBLY_INDIRECT)
                {
#ifdef SELF
                psk self3 = NULL;
#endif
                if(is_op(*pbinding))
                    {
                    psk peval;
                    if(is_object(*pbinding))
                        {
                        peval = zelfde_als_w(*pbinding);
                        }
                    else
                        {
                        peval = subboomcopie(*pbinding);
                        /*
                        a=b=(c.d)
                        c=(d=e)
                        f:?!!(a.b)
                        dan sta ik hier met (c.d)
                        bedoeling is dat ik e vind, zodat
                        ik f kan toekennen aan e.
                        */
                        if(  !(evalueer(&peval) == TRUE)
                          || (  is_op(peval)
                             && kop(peval) != WORDT
                             && kop(peval) != DOT
                             )
                          )
                            {
                            wis(peval);
                            ret = FALSE;
                            }
                        }
                    if(ret)
                        {
                        if(*newval)
                            {
                            *newval = FALSE;
                            wis(*pbinding);
                            }
                        if(naamwoord(peval,pbinding,pflags,newval
#ifdef SELF
                                    ,&self3
#endif
                          ))
                            {
                            wis(peval);
                            /*ret = TRUE;*/
                            }
                        else
                            {
                            wis(peval);
                            ret = FALSE;
                            }
                        }
                    else if(*newval)
                        {
                        *newval = FALSE;
                        wis(*pbinding);
                        }
                    }
                else
                    {
                    int newv = *newval;
                    psk binding;
                    *newval = FALSE;
                    ret = naamwoord(*pbinding,&binding,pflags,newval
#ifdef SELF
                            ,&self3
#endif
                            );
                    if(newv)
                        {
                        wis(*pbinding);
                        }
                    *pbinding = binding;
                    }
#ifdef SELF
                if(self3)
                    {
                    deleteNode(&selfkn);
                    }
#endif
                }
            /*else
                ret = TRUE;*/
            }
        else
            {
            ret = FALSE;
/*            printf("naamwoord NOT sufficiently_resolved\n");*/
            }
        }
    else
        {
        ret = FALSE;
        }
#ifdef SELF
    if(self2)
       {
       deleteNode(&selfkn);
       }
#endif
    return ret;
    }


static int naamwoord_w(psk variabele,ppsk pbinding)
    {
    unsigned int flags,flags2;
    int newval;
    int ret;
#ifdef SELF
    psk self = NULL;
#endif
    flags = SUCCESS;
    *pbinding = NULL;
    newval = FALSE;

    if(naamwoord(variabele,pbinding,&flags,&newval
#ifdef SELF
        ,&self
#endif
        ))
        {
        assert(*pbinding != NULL);
        flags2 = (*pbinding)->v.fl;
        flags2 |= (flags & (ERFENIS|NOT));
        flags2 ^= ((flags & SUCCESS) ^ SUCCESS);

        if((*pbinding)->v.fl == flags2)
            {
            if(!newval)
                {
                *pbinding = zelfde_als_w(*pbinding);
                }
            }
        else
            {
            if(newval)
                {
                *pbinding = prive(*pbinding);
                }
            else
                {
                *pbinding = subboomcopie(*pbinding);
                }
            (*pbinding)->v.fl = flags2 & ~ALL_REFCOUNT_BITS_SET;
            }
        ret = TRUE;
        }
    else
        ret = FALSE;
#ifdef SELF
    if(self)
        {
        deleteNode(&selfkn);
        }
#endif
    return ret;
    }

/*
{?} dbg'(a b b:? ?%x !x)
match(a b b:? %?x !x)
 match(:?)
 match(a b b:%?x !x)
  match(:%?x)
  match(a b b:%?x)  snijaf:b b
   match(a:%?x)
  match(b b:!x)
   match(b b:a)
  match(a b b:%?x)  snijaf:b
  match(b:!x)
   match(b:a b)
    match(:a)
    match(b:a)

  match(a b b:%?x)
  match(:!x)
   match(:a b b)
    match(:a)
 match(a b b:?)  snijaf:b b
  match(a:?)
 match(b b:%?x !x)
  match(:%?x)
  match(b b:%?x)  snijaf:b
   match(b:%?x)
  match(b:!x)
   match(b:b)
{!} a b b
    S   0,00 sec
*/

#if !DEBUGBRACMAT
#define match(IND,SUB,PAT,SNIJAF,POS,LENGTH) match(SUB,PAT,SNIJAF,POS,LENGTH)
#define stringmatch(IND,WH,SUB,SNIJAF,PAT,PKN,POS,LENGTH) stringmatch(SUB,SNIJAF,PAT,PKN,POS,LENGTH)
#endif

static size_t patlen(psk pat)
    {
    if(is_op(pat))
        {
        if(kop(pat) == MATCH)
            {
            size_t len = patlen(pat->LEFT);
            if(!len)
                return patlen(pat->RIGHT);
            else
                return len;
            }
        else
            return 0;
        }
    else
        {
        if(
           pat->u.obj
           )
            {
            int Flgs = pat->v.fl;
            if(Flgs & (UNIFY|INDIRECT|DOUBLY_INDIRECT|SMALLER_THAN|GREATER_THAN))
                return 0;
            else
                {
                if(Flgs & NOT)
                    {
                    if(Flgs & (BREUK | NUMBER | ATOM | NONIDENT))
                        Flgs &= ~(NOT|BREUK | NUMBER | ATOM | NONIDENT);
                    }
                if(Flgs & NOT)
                    return 0;
                return strlen((char *)POBJ(pat)) + ((pat->v.fl & MINUS) ? 1 : 0);
                }
            }
        else
            return 0;
        }
    }

/* dbg'@(abc:? (a ? c) ?) */
/* dbg'@(abcd:? (ab ? d) ?) */

static void cleanOncePattern(psk pat) /* 20070222 */
    {
    pat->v.fl &= ~IMPLIEDFENCE;
    if(is_op(pat))
        {
        cleanOncePattern(pat->LEFT);
        cleanOncePattern(pat->RIGHT);
        }
    }


static int stringOncePattern(psk pat) /* 20070222 */
    {
    /*
    This function has a side effect: it sets a flag in all pattern nodes that
    can be matched by at most one non-trivial list element (a nonzero term in
    a sum, a factor in a product that is not 1, or a nonempty word in a
    sentence. Because the function depends on ATOMFILTERS, the algorithm
    should be slightly different for normal matches and for string matches.
    Ideally, two flags should be reserved.
    */
    if(pat->v.fl & IMPLIEDFENCE)
        {
        return TRUE;
        }
    if(pat->v.fl & SATOMFILTERS)
        {
        pat->v.fl |= IMPLIEDFENCE;
        return TRUE;
        }
    else if(pat->v.fl & ATOMFILTERS)
        {
        return FALSE;
        }
    else if(IS_VARIABLE(pat) || NIKS(pat))
        {
        return FALSE;
        }
    else if(!is_op(pat))
        {
        if(!pat->u.obj)
            {
            pat->v.fl |= IMPLIEDFENCE;
            return TRUE;
            }
        else
            {
            return FALSE;
            }
        }
    else
        {
        switch(kop(pat))
            {
            case DOT:
            case KOMMA:
            case WORDT:
            case EXP:
            case LOG:
            case DIF:
                pat->v.fl |= IMPLIEDFENCE;
                return TRUE;
            case OF:
                if(stringOncePattern(pat->LEFT) && stringOncePattern(pat->RIGHT))
                    {
                    pat->v.fl |= IMPLIEDFENCE;
                    return TRUE;
                    }
                break;
            case MATCH:
                if(stringOncePattern(pat->LEFT) || stringOncePattern(pat->RIGHT))
                    {
                    pat->v.fl |= IMPLIEDFENCE;
                    return TRUE;
                    }
                break;
            case EN:
                if(stringOncePattern(pat->LEFT))
                    {
                    pat->v.fl |= IMPLIEDFENCE;
                    return TRUE;
                    }
                break;
            default:
                break;
            }
        }
    return FALSE;
    }


static int oncePattern(psk pat) /* 20070222 */
    {
    /*
    This function has a side effect: it sets a flag in all pattern nodes that
    can be matched by at most one non-trivial list element (a nonzero term in
    a sum, a factor in a product that is not 1, or a nonempty word in a
    sentence. Because the function depends on ATOMFILTERS, the algorithm
    should be slightly different for normal matches and for string matches.
    Ideally, two flags should be reserved.
    */
    if(pat->v.fl & IMPLIEDFENCE)
        return TRUE;
    if(pat->v.fl & ATOMFILTERS)
        {
        pat->v.fl |= IMPLIEDFENCE;
        return TRUE;
        }
    else if(IS_VARIABLE(pat) || NIKS(pat))
        return FALSE;
    else if(!is_op(pat))
        {
        pat->v.fl |= IMPLIEDFENCE;
        return TRUE;
        }
    else
        switch(kop(pat))
        {
            case DOT:
            case KOMMA:
            case WORDT:
            case EXP:
            case LOG:
            case DIF:
                pat->v.fl |= IMPLIEDFENCE;
                return TRUE;
            case OF:
                if(oncePattern(pat->LEFT) && oncePattern(pat->RIGHT))
                    {
                    pat->v.fl |= IMPLIEDFENCE;
                    return TRUE;
                    }
                break;
            case MATCH:
                if(oncePattern(pat->LEFT) || oncePattern(pat->RIGHT))
                    {
                    pat->v.fl |= IMPLIEDFENCE;
                    return TRUE;
                    }
                break;
            case EN:
                if(oncePattern(pat->LEFT))
                    {
                    pat->v.fl |= IMPLIEDFENCE;
                    return TRUE;
                    }
                break;
            default:
                break;
        }
    return FALSE;
    }

#define SHIFT_SAV 0
#define SHIFT_LMR 8
#define SHIFT_RMR 16
#define SHIFT_ONCE 24

typedef union matchstate
    {
#ifndef NDEBUG
    struct
        {
        unsigned int bsave               :8;

        unsigned int blmr_true                  :1;
        unsigned int blmr_unused_9              :1;
        unsigned int blmr_pristine              :1;
        unsigned int blmr_once                  :1;
        unsigned int blmr_position_once         :1;
        unsigned int blmr_position_max_reached  :1;
        unsigned int blmr_fence                 :1;
        unsigned int blmr_unused_15             :1;

        unsigned int brmr_true                  :1;
        unsigned int brmr_unused_17             :1;
        unsigned int brmr_pristine              :1;
        unsigned int brmr_once                  :1;
        unsigned int brmr_position_once         :1;
        unsigned int brmr_position_max_reached  :1;
        unsigned int brmr_fence                 :1;
        unsigned int brmr_unused_23             :1;

        unsigned int unused_24_26               :3;
        unsigned int bonce                      :1;
        unsigned int unused_28_31               :4;
        } b;
#endif
    struct
        {
        char sav;
        char lmr;
        char rmr;
        unsigned char once;
        } c;
    unsigned int i;
    } matchstate;

#ifndef NDEBUG
static void printMatchState(const char * msg,matchstate s,int pos,int len)
    {
/*    return;*/
    printf("\n%s pos %d len %d once %d",msg,pos,len,s.b.bonce);
    printf("\n     t o p m f i");
    printf("\n lmr %d %d %d %d %d %d",
        s.b.blmr_true,s.b.blmr_once,s.b.blmr_position_once,s.b.blmr_position_max_reached,s.b.blmr_fence,s.b.blmr_pristine);
    printf("\n rmr %d %d %d %d %d %d\n",
        s.b.brmr_true,s.b.brmr_once,s.b.brmr_position_once,s.b.brmr_position_max_reached,s.b.brmr_fence,s.b.brmr_pristine);
    }
#endif

static char doPosition(matchstate s,psk pat,int pposition,int stringLength)
    {
    unsigned int Flgs;
    psk name = subboomcopie(pat);
    name->v.fl |= SUCCESS;
    s.c.rmr = (char)evalueer(&name);
/*    s.c.rmr ^= (char)NIKS(pat);*/
    if (!(s.c.rmr))
        {
        wis(name);
        return FALSE;
        }
    pat = name;
    Flgs = pat->v.fl;
    if(Flgs & UNIFY)
        {
        if (  is_op(pat)
           || pat->u.obj
           )
            {
            if (Flgs & INDIRECT)        /* ?! of ?!! */
                {
                psk loc;
                if (naamwoord_w(pat, &loc))
                    {
                    if (is_object(loc))
                        s.c.rmr = (char)icopy_insert(loc,pposition);
                    else
                        {
                        s.c.rmr = (char)evalueer(&loc);
                        if(!icopy_insert(loc,pposition))
                            s.c.rmr = FALSE;
                        }
                    wis(loc);
                    }
                }
            else
                {
                s.c.rmr = (char)icopy_insert(pat,pposition);
                }
            }
        else
            s.c.rmr = TRUE;
        if(name)
            wis(name);
        s.c.rmr |= (char)(pat->v.fl & FENCE);
        return ONCE | POSITION_ONCE | s.c.rmr;
        }

    if( ((pat->v.fl & SUCCESS)/* && 1*/)
     /*   ^ (UNEQUAL(pat) && 1)*//*&& INTEGER_COMP(pat)*/
        )
        {
        int pos = toLong(pat);
#if DEBUGBRACMAT
        if(debug)
            {
            printf("pat:");result(pat);printf("\n");
            }
#endif
        if(pos < 0)
            pos += stringLength + 1;
        if(LESS(pat))
            {
            if(pposition < pos)
                {
                s.c.rmr = TRUE;
                }
            else
                {
                s.c.rmr = FALSE|POSITION_MAX_REACHED;
                }
            }
        else if(LESS_EQUAL(pat))
            {
            if(pposition < pos)
                {
                s.c.rmr = TRUE;
                }
            else if(pposition == pos)
                {
                s.c.rmr = TRUE|POSITION_MAX_REACHED;
                }
            else
                {
                s.c.rmr = FALSE|POSITION_MAX_REACHED;
                }
            }
        else if(MORE_EQUAL(pat))
            {
            if(pposition >= pos)
                {
                s.c.rmr = TRUE;
                }
            else
                {
                s.c.rmr = FALSE;
                }
            }
        else if(MORE(pat))
            {
            if(pposition > pos)
                {
                s.c.rmr = TRUE;
                }
            else
                {
                s.c.rmr = FALSE;
                }
            }
        else if(UNEQUAL(pat))
            {
            if(pposition != pos)
                {
                s.c.rmr = TRUE;
                }
            else
                {
                s.c.rmr = FALSE;
                }
            }
        else
            {
            if(pposition == pos)
                {
                s.c.rmr = TRUE|POSITION_MAX_REACHED;
                }
            else if(pposition > pos)
                {
                s.c.rmr = FALSE|POSITION_MAX_REACHED;
                }
            else
                s.c.rmr = FALSE;
            }
        }
    else
        {
        s.c.rmr = FALSE;
        }
    wis(pat);
    s.c.rmr |= ONCE | POSITION_ONCE;
    /*printf("POSITION pos %d len %d once %d\n",pposition,stringLength,s.b.bonce);
    printMatchState("POSITION",s,pposition,stringLength);*/
    return s.c.rmr;
    /*return ONCE | POSITION_ONCE | s.c.rmr;*/
    }


static char stringmatch(int ind,char * wh,unsigned char * sub,unsigned char * snijaf, psk pat, psk subkn, int pposition,int stringLength)
    {
/*
s.c.lmr of s.c.rmr hebben 3 onafhankelijke vlaggen : TRUE/FALSE, ONCE en FENCE.
TRUE/FALSE Het slagen van de match.
ONCE       Onbereidheid van het patroon om andere subjecten te matchen.
           Van belang voor patroon met spatie, + of * operator.
           Wordt in patronen aangezet door de `@#/ vlaggen en de operatoren
           anders dan spatie + * _ & : | = $ '.
           Wordt uitgezet in patroon met spatie + * of | operator.
FENCE      Onbereidheid van het subject om door alternatieve patronen gematcht
           te worden. Van belang voor de | en : operatoren in een patroon.
           Wordt aangezet door ` vlag (al dan niet in een patroon).
           Wordt uitgezet in patroon met spatie + * | of : operator.
           (Bij | en : operatoren geldt dit alleen voor de linkeroperand,
           bij de andere voor alle behalve de laatste operand in een lijst.)
*/
    psk loc;
    unsigned char * sloc;
    register unsigned int Flgs;
    matchstate s;
    int ci;
    psk name = NULL;
    assert(sizeof(s) == 4);
    if(!snijaf)
        snijaf = sub+stringLength;
    /*printf("size c %d\n",sizeof(c));getchar();*/
#if DEBUGBRACMAT
    if(debug)
        {
        int redMooi;
        int redhum;
        redMooi = mooi;
        redhum = hum;
        mooi = FALSE;
        hum = FALSE;
        printf("%d%*sstringmatch(%.*s",ind,ind,"",snijaf-sub,sub);printf(":");result(pat);printf(")");printf("\n");
/*        printf("%s %d%*sstringmatch(%s",wh,ind,ind,"",sub);printf(":");result(pat);printf(")");printf("\n");*/
        mooi = redMooi;
        hum = redhum;
        }
#endif
    s.i = (PRISTINE << SHIFT_LMR) + (PRISTINE << SHIFT_RMR);
    /*s.c.rmr = FALSE;*/

    Flgs = pat->v.fl;
    if(Flgs & POSITION)
        {
        if(snijaf > sub)
            return FALSE | ONCE | POSITION_ONCE;
        else
            return doPosition(s,pat,pposition,stringLength);
        }
    if(!(  (  (Flgs & NONIDENT)
           && ( ONTKENNING(Flgs, NONIDENT)
              ? ( (s.c.once = ONCE) /* 20070402 */
                , snijaf > sub
                )
              : snijaf == sub
              )
           )
        || (  (Flgs & ATOM)
           && ( ONTKENNING(Flgs, ATOM)
              ?    (snijaf < sub + 2) /*!(sub[0] && sub[1])*/
              :    snijaf > sub/*sub[0]*/
                && ( (s.c.once = ONCE) /* 20070402 */
                   , snijaf > sub + 1 /*sub[1]*/
                   )
              )
           )
        || (  (Flgs & (BREUK|NUMBER))
           && ( (ci = sfullnumbercheck(sub,snijaf,NULL))
/*#if DEBUGBRACMAT
              , (debug && printf("fullnumbercheck %d QGETAL %d MINUS %d QNUL %d QBREUK %d DEFINITELYNONUMBER %d\n",ci,ci & QGETAL,ci & MINUS,ci & QNUL,ci & QBREUK, ci & DEFINITELYNONUMBER))
#endif*/
              , (  (  (Flgs & BREUK)
                   && ((ci != (QBREUK | QGETAL)) ^ ONTKENNING(Flgs, BREUK))
                   )
                || (  (Flgs & NUMBER)
                   && (((ci & QGETAL) == 0)      ^ ONTKENNING(Flgs, NUMBER))
                   )
                )
              )
           && (  (  (   (ci == DEFINITELYNONUMBER)
                    && (s.c.rmr = ONCE) /* =, not == !*/
                    )
                 || (s.c.rmr = FALSE)   /* =, not == !*/
                 )
/*#if DEBUGBRACMAT
              , (debug && printf("s.c.rmr %d \n",s.c.rmr))
#endif*/
              ,  (s.c.lmr = PRISTINE)
              )
           )
        )
       )
        {
        /*s.c.lmr = SCHAR_MAX;
        s.c.rmr = FALSE;*/
        if(IS_VARIABLE(pat))
            {
            int ok = TRUE;
            if(is_op(pat))
                {
                unsigned int saveflgs = Flgs & VISIBLE_FLAGS;
                name = subboomcopie(pat);
                name->v.fl &= ~VISIBLE_FLAGS;
                name->v.fl |= SUCCESS;
                if ((s.c.rmr = (char)evalueer(&name)) != TRUE)
                    ok = FALSE;
                name->v.fl |= saveflgs;
                pat = name;
                }
            if(ok)
                {
                if (Flgs & UNIFY)        /* ?  */
                    {
                    if (!NIKS(pat) || snijaf > sub)
                        {
                        if (  is_op(pat)
                           || pat->u.obj
                           )
                            {
                            if (Flgs & INDIRECT)        /* ?! of ?!! */
                                {
                                if (naamwoord_w(pat, &loc))
                                    {
                                    if (is_object(loc))
                                        /*s.c.rmr = (char)scopy_insert(loc, sub);*/
                                        s.c.rmr = (char)string_copy_insert(loc,subkn,sub,snijaf);
                                    else
                                        {
                                        s.c.rmr = (char)evalueer(&loc);
                                        /*if(!scopy_insert(loc, sub))*/
                                        if(!string_copy_insert(loc,subkn,sub,snijaf))
                                            s.c.rmr = FALSE;
                                        }
                                    wis(loc);
                                    }
                                }
                            else
                                /*s.c.rmr = (char)scopy_insert(pat, sub);*/
                                {
                                s.c.rmr = (char)string_copy_insert(pat,subkn,sub,snijaf);
                                }
                            }
                        else
                            s.c.rmr = TRUE;
                        }
                    }
                else if (Flgs & INDIRECT)        /* ! of !! */
                    {
                    if (naamwoord_w(pat, &loc))
                        {
                        cleanOncePattern(loc);
                        s.c.rmr = (char)(stringmatch(ind+1,"A",sub,snijaf,loc,subkn,pposition,stringLength) ^ NIKS(pat));
                        wis(loc);
                        }
                    else
                        s.c.rmr = (char)NIKS(pat);
                    }
                }
            }
        else
            switch (kop(pat))
                {
                case PLUS:
                case MAAL:
                    break;
                case LUCHT:
                    {
#if 1
                    int locpos = pposition;
                    /* This code mirrors that of match(). (see below)*/
                    /* A    divisionPoint=S */
                    sloc = sub;
                    /*s.c.sav = *sloc;
                    *sloc = '\0';*/
                    /* B    leftResult=0(P):car(P) */
                    s.c.lmr = stringmatch(ind+1,"I",sub, sloc, pat->LEFT, subkn,pposition,stringLength);
                    s.c.lmr &= ~ONCE;
                    /**sloc = s.c.sav;*/
                    /* C    while divisionPoint */
                    while(sloc < snijaf)
                        {
                    /* D        if leftResult.succes */
                        if(s.c.lmr & TRUE)
                    /* E            rightResult=SR:cdr(P) */
                            {
                            s.c.rmr = stringmatch(ind+1,"J",sloc,snijaf, pat->RIGHT, subkn,locpos,stringLength);
                            if(!(s.c.lmr & ONCE))
                                s.c.rmr &= ~ONCE;
                            }
                    /* F        if(done) */
                        /* done =  (1) full succes */
                        if(  (s.c.rmr & TRUE)
                        /*      or (2) may not be shifted.
                           ad (2): In the first pass, a position
                           flag on car(P) counts as criterion for being done. */
                          || (s.c.lmr & (POSITION_ONCE
                        /* In all but the first pass, the left and right
                           results can indicate that the loop is done. */
                                        | ONCE
                                        )
                             )
                          || (s.c.rmr & (ONCE
                        /* In all passes a position_max_reached on the
                           rightResult indicates that the loop is done. */
                                        |POSITION_MAX_REACHED
                                        )
                             )
                          )
                    /* G            return */
                            {
                        /* Return true if full success.

                           Also return whether sub has reached max position.*/
                            /*if(!(s.c.rmr & POSITION_MAX_REACHED))
                                s.c.rmr &= ~POSITION_ONCE;*/
                            if(sloc > sub)
                                s.c.rmr &= ~POSITION_MAX_REACHED; /* This flag is
                            reason to stop increasing the position of the
                            division any further, but it must not be signalled
                            back to the caller if the lhs is not nil ... */
                            s.c.rmr |= s.c.lmr & POSITION_MAX_REACHED;
                            /* ... unless it is the lhs that signals it. */
                        /* Also return whether the pattern as a whole doesn't
                           want longer subjects, which can be found out by
                           looking at the pattern */
                            if(stringOncePattern(pat))
                                {
                                s.c.rmr |= ONCE;
                                s.c.rmr |= (char)(pat->v.fl & FENCE);
                                }
                        /* or by looking at whether both lhs and rhs results
                           indicated this, in which case both sides must be
                           non-zero size subjects. */
                            else if(!(s.c.lmr & ONCE))
                                s.c.rmr &= ~ONCE;
                        /* POSITION_ONCE, on the other hand, requires zero size
                           subjects. */
                           /* if(!(s.c.lmr & POSITION_ONCE))
                                s.c.rmr &= ~POSITION_ONCE;*/
                        /* Also return the fence flag, if present in rmr.
                           (This flag in lmr has no influence.)
                        */
                            /*s.c.rmr |= (s.c.lmr & FENCE);*/
                            return s.c.rmr ^ (char)NIKS(pat);
                            }
                    /* H        SL,SR=shift_right divisionPoint */
                        ++sloc;
                        /* SL = lhs divisionPoint S, SR = rhs divisionPoint S
                        */
                        ++locpos;
                    /* I        leftResult=SL:car(P) */
                        /*s.c.sav = *sloc;
                        *sloc = '\0';*/
                        s.c.lmr = stringmatch(ind+1,"I",sub,sloc, pat->LEFT, subkn,
                            /* 0 ? */pposition,/* strlen(sub) ? */ stringLength);
                        /**sloc = s.c.sav;*/
                        }
                    /* J    if leftResult.succes */
                    if(s.c.lmr & TRUE)
                    /* K        rightResult=0(P):cdr(pat) */
                        {
                        s.c.rmr = stringmatch(ind+1,"J",sloc,snijaf,pat->RIGHT, subkn,locpos,stringLength);
                        s.c.rmr &= ~ONCE;
                        }
                    /* L    return */
                        /* Return true if full success.

                           Also return whether lhs experienced max position
                           being reached. */
                        /* Also return whether the pattern as a whole doesn't
                           want longer subjects, which can be found out by
                           looking at the pattern */
                    if(!(s.c.rmr & POSITION_MAX_REACHED))
                        s.c.rmr &= ~POSITION_ONCE;
                    if(/*(snijaf > sub) &&*/ stringOncePattern(pat))
                        /* The test snijaf > sub merely avoids that
                        stringOncePattern is called when it is useless. */
                        {/* Test:
                         @(abcde:`(a ?x) (?z:d) ? )
                          z=b
                         */
                        s.c.rmr |= ONCE;
                        s.c.rmr |= (char)(pat->v.fl & FENCE);
                        }
                        /* POSITION_ONCE requires zero size subjects. */
                    /*if(!(s.c.lmr & POSITION_ONCE))
                        s.c.rmr &= ~POSITION_ONCE;*/
                        /* Also return the fence flag, which can be found on
                           the pattern or in the result of the lhs or the rhs.
                           (Not necessary that both have this flag.)
                        */
/*                    s.c.rmr |= (s.c.lmr & FENCE);*/
                    return s.c.rmr ^ (char)NIKS(pat);
                    /* end */
#else
                    sloc = sub;
                    while(*sloc)
                        {
                        s.c.sav = *sloc;
                        *sloc = '\0';
#if DEBUGBRACMAT
                        if(debug)
                            {
                            printf("%d%*ssub:",ind,ind,"");
                            printf("%.*s",snijaf-sub,sub);
                            printf(" / ");
                            *sloc = s.c.sav;
                            printf("%s",sloc);
                            *sloc = '\0';
                            printf("  pat:");
                            result(pat->LEFT);
                            printf(" / ");
                            result(pat->RIGHT);
                            printf("\n");
                            }
#endif
                        s.c.lmr = stringmatch(ind+1,"I",sub, pat->LEFT, subkn,pposition,stringLength);
                        if(  !(s.c.lmr & POSITION_ONCE)
                          && sloc == sub
                          )
                            {
                            s.c.lmr &= TRUE; /* turn off ONCE if sub is empty string */
                            }
                        *sloc = s.c.sav;
                        if(s.c.lmr & TRUE)
                            {
                            if(s.c.lmr & ONCE)
                                s.c.rmr = (char)(stringmatch(ind+1,"J",sloc, pat->RIGHT, subkn,pposition,stringLength));
                            else
                                s.c.rmr = (char)(~(ONCE|POSITION_ONCE) & /*20070705 */ stringmatch(ind+1,"J",sloc, pat->RIGHT, subkn,pposition,stringLength));
                            }
                        else
                            {
                            s.c.rmr = (char)0;
                            }
                        s.c.rmr |= (s.c.lmr & POSITION_MAX_REACHED);
                        /* Only if the pattern as a whole is ONCE you can
                        return ONCE. It is not sufficient that the rhs is ONCE.
                        E.g.:
                          @( aaab
                           :   ( (|a)
                                 (|a)
                                 (|a|aa)
                               )
                               b
                           ));
                       This would fail if the match of the first two a's
                            aa:(|a|aa)
                       was allowed to ONCE the result of
                            aa:(|a) (|a) (|a|aa)
                        */
                        if (s.c.rmr & TRUE)
                            {
                            s.c.rmr |= (char)(pat->v.fl & FENCE);
                            if(!(s.c.rmr & ONCE) && stringOncePattern(pat))
                                s.c.rmr |= ONCE;
#if DEBUGBRACMAT
                            if(debug)
                                {
                                printf("%d%*s",ind,ind,"");
                                printf("OK ");
                                printf("s.c.rmr %d s.c.lmr %d\n",s.c.rmr,s.c.lmr);
                                }
#endif
                            return s.c.once
                                | (s.c.lmr & POSITION_MAX_REACHED)
                                | ((char)(s.c.rmr ^ (char)NIKS(pat)));
                            }
                        else
                            {
                            if(  sloc > sub
                              && (s.c.lmr & ONCE)
                              )
                                {
                                s.c.rmr |= (char)(pat->v.fl & FENCE);
                                if(!(s.c.lmr & TRUE))
                                    s.c.rmr |= ONCE;
#if DEBUGBRACMAT
                                if(debug)
                                    {
                                    printf("%d%*s",ind,ind,"");
                                    printf("CUT ");
                                    printf("s.c.rmr %d s.c.lmr %d\n",s.c.rmr,s.c.lmr);
                                    printf("%d%*s stringmatch(%s",ind,ind,"",sub);
                                    printf(":");result(pat);
                                    printf(") returns %d\n",s.c.once | ((char)(s.c.rmr ^ (char)NIKS(pat))));
                                    }
#endif
                                return s.c.once
                                    | (s.c.lmr & POSITION_MAX_REACHED)
                                    | ( ~(ONCE|POSITION_ONCE)
                                      & ((char)(s.c.rmr
                                        ^ (char)NIKS(pat))
                                        )
                                      );
                                /*20070705 added ~ONCE & matches with stretchable patterns should
                                in general not be ONCEed.
                                E.g. @("pand ":?a ( (p|q) and|z) ?b)
                                */
                                }
                            }
                        if(  s.c.lmr & POSITION_ONCE
                          || s.c.rmr & POSITION_MAX_REACHED
                          )
                            {
                            break;
                            }

                        ++sloc;
                        ++pposition;
                        }

                    s.c.rmr = 0;
                    if(  !(s.c.lmr & POSITION_ONCE)
                      && ( (s.c.lmr = (char)
                               ( ~(ONCE|POSITION_ONCE|FENCE)
                               & stringmatch(ind+1,"K",sub, pat->LEFT, subkn,pposition,stringLength)
                               )
                           )
                         & TRUE
                         )
                      )
                        {
                        s.c.rmr |= (char)
                            ( ~(ONCE|POSITION_ONCE)
                            & stringmatch(ind+1,"L",(unsigned char *)"", pat->RIGHT, subkn,pposition,stringLength)
                            ); /* do not extinguish FENCE flag on rightmost subpattern */
                        }
                    s.c.rmr |= (char)(pat->v.fl & FENCE);
                    if(stringOncePattern(pat))
                        {
                        s.c.rmr |= ONCE;
#if DEBUGBRACMAT
                        if(debug)
                            {
                            int redMooi;
                            int redhum;
                            redMooi = mooi;
                            redhum = hum;
                            mooi = FALSE;
                            hum = FALSE;
                            printf("%d%*sstringmatch(%s",ind,ind,"",sub);printf(":");result(pat);
                            /*printf("%s %d%*sstringmatch(%s",wh,ind,ind,"",sub);printf(":");result(pat);*/
                            mooi = redMooi;
                            hum = redhum;
                            printf(") s.c.rmr %d (A)",s.c.rmr);
                            if(pat->v.fl & POSITION)
                                printf("POSITION ");
                            if(pat->v.fl & BREUK)
                                printf("BREUK ");
                            if(pat->v.fl & NUMBER)
                                printf("NUMBER ");
                            if(pat->v.fl & SMALLER_THAN)
                                printf("SMALLER_THAN ");
                            if(pat->v.fl & GREATER_THAN)
                                printf("GREATER_THAN ");
                            if(pat->v.fl & ATOM)
                                printf("ATOM ");
                            if(pat->v.fl & FENCE)
                                printf("FENCE ");
                            if(pat->v.fl & IDENT)
                                printf("IDENT");
                            printf("\n");
                            }
#endif
                        }
                    s.c.rmr ^= (char)NIKS(pat);
                    return s.c.once
                        | (s.c.lmr & POSITION_MAX_REACHED)
                        | s.c.rmr;
#endif
                    }
                case STREEP:
                    /*if(sub[0] && sub[1])*/
                    if(snijaf > sub + 1)
                        {
                        /*s.c.sav = sub[1];*/
                        s.c.lmr = stringmatch(ind+1,"M",sub,sub+1,pat->LEFT,subkn,pposition,stringLength);
                        /*sub[1] = s.c.sav;*/
                        if(  (s.c.lmr & TRUE)
                          && ((s.c.rmr = stringmatch(ind+1,"N",sub+1,snijaf,pat->RIGHT, subkn,pposition,stringLength)) & TRUE)
                          )
                            {
                            dummy_op = LUCHT;
                            }
                            /*
                            s.c.lmr != SCHAR_MAX)
                                */
                        s.c.rmr |= (char)(s.c.lmr & (FENCE | ONCE));
                        }
                    break;
                case EN:
                    if ((s.c.lmr = stringmatch(ind+1,"O",sub,snijaf, pat->LEFT, subkn,pposition,stringLength)) & TRUE)
                        {
                        loc = zelfde_als_w(pat->RIGHT);
                        /* 13 november 1991 */
                        evalueer(&loc);
                        if (loc->v.fl & SUCCESS)
                            {
                            s.c.rmr = TRUE;
                            if (loc->v.fl & FENCE)
                                s.c.rmr |= ONCE;
                            }
                        else
                            {
                            s.c.rmr = FALSE;
                            if (loc->v.fl & FENCE)
                                s.c.rmr |= (FENCE | ONCE);        /* 13 november 1991 */
                            }
                        wis(loc);
                        }
                            /*
                            if (s.c.lmr != SCHAR_MAX)
                                */
                    s.c.rmr |= (char)(s.c.lmr & (FENCE | ONCE));
                    break;
                case MATCH:
                    if ((s.c.lmr = stringmatch(ind+1,"P",sub,snijaf, pat->LEFT, subkn,pposition,stringLength)) & TRUE)
                        s.c.rmr = (char)(stringmatch(ind+1,"Q",sub,snijaf,pat->RIGHT,subkn,pposition,stringLength) /*& TRUE 20070402 */);
                    else
                        s.c.rmr = FALSE;
                    s.c.rmr |= (char)(s.c.lmr & (FENCE | ONCE | POSITION_MAX_REACHED));
                    break;
                case OF:
                    if ( (s.c.lmr = (char)( stringmatch(ind+1,"R",sub,snijaf,pat->LEFT,subkn,pposition,stringLength)))
                       & (TRUE | FENCE)
                       )
                        {
                        if((s.c.lmr & ONCE) && !stringOncePattern(pat->RIGHT))
                            {
                            s.c.rmr = (char)(s.c.lmr & TRUE);
                            }
                        else
                            {
                            s.c.rmr = (char)(s.c.lmr & (TRUE|ONCE));
                            }
                        }
                    else
                        {
                        s.c.rmr = stringmatch(ind+1,"S",sub,snijaf,pat->RIGHT, subkn,pposition,stringLength);
                        if(  (s.c.rmr & ONCE)
                          && !(s.c.lmr & ONCE)
                          )
                            {
                            s.c.rmr &= ~(ONCE|POSITION_ONCE);
                            }
                        if(  (s.c.rmr & POSITION_MAX_REACHED)
                          && !(s.c.lmr & POSITION_MAX_REACHED)
                          )
                            {
                            s.c.rmr &= ~(POSITION_MAX_REACHED|POSITION_ONCE);
                            }
                        }
                    break;
#if 0
                    /* & ~ONCE; removed 13 november 1991 */
/*                    s.c.rmr &= ~(FENCE | ONCE);*/ /* 20040907 s.c.lmr -> s.c.rmr This error made @(abc:(ab|x) c) to fail! */
                    if(!(s.c.rmr & FENCE))
                        s.c.rmr &= ~(ONCE|POSITION_ONCE); /* 20040908 */
#if DEBUGBRACMAT
                    if(debug)
                        {
                        printf("%d%*s",ind,ind,"");
                        printf("OF s.c.lmr %d s.c.rmr %d\n",s.c.lmr,s.c.rmr);
                        }
#endif
                    s.c.rmr |= (char)(s.c.lmr & ONCE);
                    break;
#endif
/*
20070222 This is now much quicker than previously, because the whole expression
(|bc|x) is ONCE if the start of the subject does not match the start of any of
the alternations:
dbg'@(hhhhhhhhhbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbhhhabcd:?X (|bc|x) d)
*/
                case FUN:
                case FUU:
                    loc = zelfde_als_w(pat);
                    evalueer(&loc);
                    if (vgl(pat, loc))
                        {
                        s.c.rmr = /*~DONOTSHORTEN & */(char)(stringmatch(ind+1,"T",sub,snijaf,loc,subkn,pposition,stringLength) ^ NIKS(loc));
                        wis(loc);
                            /*
                            if (s.c.lmr != SCHAR_MAX)
                        s.c.rmr |= (char)(s.c.lmr & (FENCE | ONCE));
                                */
                        break;
                        }
                    wis(loc);
                    break;
                default:
                    if(!is_op(pat))
                        {
                        if (  !pat->u.obj
                           && (Flgs & (BREUK | NUMBER | NONIDENT | ATOM | IDENT))
                           /*&& !(((Flgs & NOT) && 1) ^ ((Flgs & (GREATER_THAN|SMALLER_THAN)) && 1))*/
                           )
                            {         /* e.g.    a b c : % */
                            s.c.rmr = TRUE;
                            }
                        else
                            {
                            s.c.rmr = (char)(/** / ONCE | / **/ scompare("b",(unsigned char *)sub,snijaf, pat,NULL));

#if DEBUGBRACMAT
                            if(debug)
                                {
                                printf("%s %d%*sscompare(%.*s,",wh,ind,ind,"",snijaf-sub,sub);result(pat);printf(") ");
                                if(s.c.rmr & ONCE)
                                    printf("ONCE|");
                                if(s.c.rmr & TRUE)
                                    printf("TRUE");
                                else
                                    printf("FALSE");
                                printf("\n");
                                }
#endif

                            }
                        }
                    /*
                    if (s.c.lmr != SCHAR_MAX)
                    s.c.rmr |= (char)(s.c.lmr & (FENCE | ONCE));
                    */
                }
        }
#if DEBUGBRACMAT
    if(debug && (s.c.rmr & (FENCE | ONCE)))
        {
        printf("%s %d%*s+",wh,ind,ind,"");if(s.c.rmr & FENCE)printf(" FENCE ");if(s.c.rmr & ONCE)printf(" ONCE ");printf("\n");
        }
#endif
    s.c.rmr |= (char)(pat->v.fl & FENCE);
    if(stringOncePattern(pat) || /* Bart 20070820 @("abXk":(|? b|`) X ?id) must fail*/ (s.c.rmr & (TRUE|FENCE|ONCE)) == FENCE)
        {
        s.c.rmr |= ONCE;
#if DEBUGBRACMAT
        if(debug)
            {
            int redMooi;
            int redhum;
            redMooi = mooi;
            redhum = hum;
            mooi = FALSE;
            hum = FALSE;
            printf("%d%*sstringmatch(%.*s",ind,ind,"",snijaf-sub,sub);printf(":");result(pat);
            /*printf("%s %d%*sstringmatch(%s",wh,ind,ind,"",sub);printf(":");result(pat);*/
            mooi = redMooi;
            hum = redhum;
            printf(") s.c.rmr %d (B)",s.c.rmr);
            if(pat->v.fl & POSITION)
                printf("POSITION ");
            if(pat->v.fl & BREUK)
                printf("BREUK ");
            if(pat->v.fl & NUMBER)
                printf("NUMBER ");
            if(pat->v.fl & SMALLER_THAN)
                printf("SMALLER_THAN ");
            if(pat->v.fl & GREATER_THAN)
                printf("GREATER_THAN ");
            if(pat->v.fl & ATOM)
                printf("ATOM ");
            if(pat->v.fl & FENCE)
                printf("FENCE ");
            if(pat->v.fl & IDENT)
                printf("IDENT");
            printf("\n");
            }
#endif
        }
    if(is_op(pat))
        s.c.rmr ^= (char)NIKS(pat);
/*
#if DEBUGBRACMAT
    if(debug)
        {
        printf("%s %d%*s----------->",wh,ind,ind,"");
        if(s.c.rmr & TRUE)
            printf(" TRUE");
        if(s.c.rmr & FENCE)
            printf(" FENCE");
        if(s.c.rmr & ONCE)
            printf(" ONCE");
        printf("\n");
        }
#endif
*/
    if(name)
        wis(name);
    return s.c.once | s.c.rmr;
    }


static int expressionLength(psk pkn)
    {
    int len = 1;
    if(is_op(pkn))
        {
        unsigned int op = kop(pkn);
        psk cur = pkn->RIGHT;
/*        result(pkn);*/
        ++len;
        while(kop(cur) == op)
            {
            ++len;
            cur = cur->RIGHT;
            }
        }
    //printf(" %d <-\n",len);
    return len;
    }


static char match(int ind,psk sub, psk pat, psk snijaf,int pposition,int stringLength)
    {
/*
s.c.lmr or s.c.rmr have three independent flags: TRUE/FALSE, ONCE and FENCE.

TRUE/FALSE The success or failure of the match.

ONCE       Unwillingness of the pattern to match longer substrings from the
           subject. Example:

{?} a b c d:?x @?y d
{!} a b c d
{?} !y
{!} c
{?} !x
{!} a b
           In fact, the pattern @?y first matches the empty string and then,
           after backtracking from the failing match of the last subpattern d,
           a single element from the string. Thereafter, when again
           backtracking, the subpattern @?y denies to even try to match a
           substring that is one element longer (two elements, in this example)
           and the subpattern preceding @?y is offered an enlarged substring
           from the subject, while @?y itself starts with the empty element.

           This flag is of importance for patterns with the space, + or
           * operator.
           The flag is turned on in patterns by the `@#/ flags and by operators
           other than space + * _ & : | = $ '
           The flag is turned off "after consumption", i.e. it does not
           percolate upwards through patterns with space + or * operators.

(once=
  (p=?`Y)
&   a b c d
  : ?X !p (d|?&(p=`?Z&foo:?Y)&~)
& out$(X !X Y !Y Z !Z));


(once=a b c d:?X (?|?) d & out$(X !X))
(once=a b c d:?X (@|@) d & out$(X !X))
(once=a b c d:?X (?|@) d & out$(X !X))
(once=a b c d:?X (@|?) d & out$(X !X))
(once=a b c d:?X (@|`) d & out$(X !X))
(once=a b c d:?X (`|?) d & out$(X !X))
(once=a b c d:?X (`c|?) d & out$(X !X))

FENCE      Onbereidheid van het subject om door alternatieve patronen gematcht
           te worden. Van belang voor de | en : operatoren in een patroon.
           Wordt aangezet door ` vlag (al dan niet in een patroon).
           Wordt uitgezet in patroon met spatie + * | of : operator.
           (Bij | en : operatoren geldt dit alleen voor de linkeroperand,
           bij de andere voor alle behalve de laatste operand in een lijst.)
*/
    matchstate s;
    psk loc;
    register unsigned int Flgs;
    psk name = NULL;
#if DEBUGBRACMAT
    if(debug){printf("%d%*smatch(",ind,ind,"");results(sub,snijaf);printf(":");result(pat);printf(")");printf("\n");}
#endif
    if (is_op(sub))
        {
        if(kop(sub) == WORDT)
            sub->RIGHT = *Head(&sub->RIGHT);

        if (sub->RIGHT == snijaf)
            return match(ind+1,sub->LEFT, pat, NULL,pposition,stringLength);
        }
    s.i = (PRISTINE << SHIFT_LMR) + (PRISTINE << SHIFT_RMR);
    Flgs = pat->v.fl;
    if(Flgs & POSITION)
        {
        if(snijaf || !(sub->v.fl & IDENT))
            return FALSE | ONCE | POSITION_ONCE;
        else
            return doPosition(s,pat,pposition,stringLength);
        }
    if ( !(  ((Flgs & NONIDENT) && (((sub->v.fl & IDENT) && 1) ^ ONTKENNING(Flgs, NONIDENT)))
          || ((Flgs & ATOM    ) && ((is_op(sub)          && 1) ^ ONTKENNING(Flgs, ATOM   )))
          || ((Flgs & BREUK   ) && ( !RAT_RAT(sub)             ^ ONTKENNING(Flgs, BREUK   )))
          || ((Flgs & NUMBER  ) && ( !RATIONAAL_COMP(sub)      ^ ONTKENNING(Flgs, NUMBER  )))
          )
       )
        {
        if(IS_VARIABLE(pat))
            {
            int ok = TRUE;
            if(is_op(pat))
                {
                unsigned int saveflgs = Flgs & VISIBLE_FLAGS;
                name = subboomcopie(pat);
                name->v.fl &= ~VISIBLE_FLAGS;
                name->v.fl |= SUCCESS;
                if ((s.c.rmr = (char)evalueer(&name)) != TRUE)
                    ok = FALSE;
                name->v.fl |= saveflgs;
                pat = name;
                }
            if(ok)
                {
                if (Flgs & UNIFY)        /* ?  */
                    {
                    if (!NIKS(pat) || is_op(sub) || (sub->u.obj))
                        {
                        if (  is_op(pat)
                           || pat->u.obj
                           )
                            if (Flgs & INDIRECT)        /* ?! of ?!! */
                                {
                                if (naamwoord_w(pat, &loc))
                                    {
                                    if (is_object(loc))
                                        s.c.rmr = /*~DONOTSHORTEN & */(char)copy_insert(loc, sub, snijaf);
                                    else
                                        {
                                        s.c.rmr = /*~DONOTSHORTEN & */(char) evalueer(&loc);
                                        if(!copy_insert(loc, sub, snijaf))
                                            s.c.rmr = FALSE;
                                            /* 19971207. Previously, s.c.rmr was not influenced by failure of copy_insert */

                                        }
                                    wis(loc);
                                    }
                                }
                            else
                                {
                                s.c.rmr = (char)copy_insert(pat, sub, snijaf);
                                /* 19971207. Previously, s.c.rmr was unconditionally set to TRUE */
                                }

                        else
                            s.c.rmr = TRUE;
                        }
                    /*
                     * else NIKS(pat) && !is_op(sub) && !sub->u.obj
                     * dwz   ~?[`][!][!]
                     */
                    }
                else if (Flgs & INDIRECT)        /* ! of !! */
                    {
                    if (naamwoord_w(pat, &loc))
                        {
                        cleanOncePattern(loc);
                        s.c.rmr = /*~DONOTSHORTEN & */(char)(match(ind+1,sub, loc, snijaf,pposition,stringLength) ^ NIKS(pat));
                        wis(loc);
                        }
                    else
                        s.c.rmr = /*~DONOTSHORTEN & */(char)NIKS(pat);
                    }
                }
            }
        else
            switch (kop(pat))
                {
                case LUCHT:
                case PLUS:
                case MAAL:
                    {
                    int locpos = pposition;
                    /* Optimal sructure for this code:
                                A0 (B A)* B0
                    S:P ::=
                    A       divisionPoint=S
                    B       leftResult=0(P):car(P)
                    C       while divisionPoint
                    D           if leftResult.succes
                    E               rightResult=SR:cdr(P)
                    F           if(done)
                    G               return
                    H           SL,SR=shift_right divisionPoint
                    I           leftResult=SL:car(P)
                    J       if leftResult.succes
                    K           rightResult=0(P):cdr(pat)
                    L       return

                    0(P)=nil(pat): nil(LUCHT)="", nil(+)=0,nil(*)=1
                    In stringmatch, there is no need for L0; the empty string ""
                    is part of the string.
                    */
                    /* A    divisionPoint=S */
                    /* B    leftResult=0(P):car(P) */
                    /* C    while divisionPoint */
                    /* D        if leftResult.succes */
                    /* E            rightResult=SR:cdr(P) */
                    /* F        if(done) */
                        /* done =  (1) full succes */
                        /*      or (2) may not be shifted.
                           ad (2): In the first pass, a position
                           flag on car(P) counts as criterion for being done. */
                        /* In all but the first pass, the left and right
                           results can indicate that the loop is done. */
                        /* In all passes a position_max_reached on the
                           rightResult indicates that the loop is done. */
                    /* G            return */
                        /* Return true if full success.

                           Also return whether lhs experienced max position
                           being reached. */
                        /* Also return whether the pattern as a whole doesn't
                           want longer subjects, which can be found out by
                           looking at the pattern */
                        /* or by looking at whether both lhs and rhs results
                           indicated this, in which case both sides must be
                           non-zero size subjects. */
                        /* POSITION_ONCE, on the other hand, requires zero size
                           subjects. */
                        /* Also return the fence flag, if present in rmr.
                           (This flag in lmr has no influence.)
                        */
                    /* H        SL,SR=shift_right divisionPoint */
                        /* SL = lhs divisionPoint S, SR = rhs divisionPoint S
                        */
                    /* I        leftResult=SL:car(P) */
                    /* J    if leftResult.succes */
                    /* K        rightResult=0(P):cdr(pat) */
                    /* L    return */
                        /* Return true if full success.

                           Also return whether lhs experienced max position
                           being reached. */
                        /* Also return whether the pattern as a whole doesn't
                           want longer subjects, which can be found out by
                           looking at the pattern or by looking at whether */
                        /* both lhs and rhs results indicated this.
                           These come in two sorts: POSITION_ONCE requires */
                        /* zero size subjects, ONCE requires non-zero size
                           subjects. */
                        /* Also return the fence flag, which can be found on
                           the pattern or in the result of the lhs or the rhs.
                           (Not necessary that both have this flag.)
                        */
                    /* end */
#if 1
                    /* A    divisionPoint=S */
                    if(SUBJECTNOTNIL(sub,pat))
                        loc = sub;
                    else
                        loc = NULL;
                    /* B    leftResult=0(P):car(P) */
                    s.c.lmr = (char)match(ind+1,nil(pat), pat->LEFT, NULL,pposition,stringLength);
                    /*Problem: a*b+c*d:?+[1+?*[1*%@?q*?+? must give q=d, but what about
                      a b c d:? [1 (? [1 %@?q ?) ? versus   (q = c)
                      a b c d:? [1  ? [1 %@?q ?  ?          (q = b)
                    */
                    s.c.lmr &= ~ONCE;
                    /* C    while divisionPoint */
                    while(loc)
                        {
                    /* D        if leftResult.succes */
                        if(s.c.lmr & TRUE)
                    /* E            rightResult=SR:cdr(P) */
                            {
                            s.c.rmr = match(ind+1,loc,pat->RIGHT,snijaf,locpos,stringLength);
                            if(!(s.c.lmr & ONCE))
                                s.c.rmr &= ~ONCE;
                            }
                    /* F        if(done) */
                        /* done =  (1) full succes */
                        if(  (s.c.rmr & TRUE)
                        /*      or (2) may not be shifted.
                           ad (2): In the first pass, a position
                           flag on car(P) counts as criterion for being done. */
                          || (s.c.lmr & (POSITION_ONCE
                        /* In all but the first pass, the left and right
                           results can indicate that the loop is done. */
                                        | ONCE
                                        )
                             )
                          || (s.c.rmr & (ONCE
                        /* In all passes a position_max_reached on the
                           rightResult indicates that the loop is done. */
                                        |POSITION_MAX_REACHED
                                        )
                             )
                          )
                    /* G            return */
                            {
                        /* Return true if full success.

                           Also return whether sub has reached max position.*/
                            /*if(!(s.c.rmr & POSITION_MAX_REACHED))
                                s.c.rmr &= ~POSITION_ONCE;*/
                            if(loc != sub)
                                s.c.rmr &= ~POSITION_MAX_REACHED; /* This flag is
                            reason to stop increasing the position of the
                            division any further, but it must not be signalled
                            back to the caller if the lhs is not nil ... */
                            s.c.rmr |= s.c.lmr & POSITION_MAX_REACHED;
                            /* ... unless it is the lhs that signals it. */
                        /* Also return whether the pattern as a whole doesn't
                           want longer subjects, which can be found out by
                           looking at the pattern */
                            if(oncePattern(pat))
                                {
                                /*
                                For example,
                                    a b c d:`(?x ?y) (?z:c) ?
                                must fail and set x==nil, y==a and z==b
                                */
                                s.c.rmr |= ONCE;
                                s.c.rmr |= (char)(pat->v.fl & FENCE);
                                }
                        /* or by looking at whether both lhs and rhs results
                           indicated this, in which case both sides must be
                           non-zero size subjects. */
                            else if(!(s.c.lmr & ONCE))
                                s.c.rmr &= ~ONCE;
                        /* POSITION_ONCE, on the other hand, requires zero size
                           subjects. */
                        /*    if(!(s.c.lmr & POSITION_ONCE))
                                s.c.rmr &= ~POSITION_ONCE;
                                s.c.lmr & POSITION_ONCE has nothing to do with the return value*/
                        /* Also return the fence flag, if present in rmr.
                           (This flag in lmr has no influence.)
                        */
#if DEBUGBRACMAT
                            if(debug)
                                {
                                printf("%d%*smatch(",ind,ind,"");results(sub,snijaf);printf(":");result(pat);
#ifndef NDEBUG
                                printMatchState("EXIT-MID",s,pposition,stringLength);
#endif
                                if(pat->v.fl & BREUK)
                                    printf("BREUK ");
                                if(pat->v.fl & NUMBER)
                                    printf("NUMBER ");
                                if(pat->v.fl & SMALLER_THAN)
                                    printf("SMALLER_THAN ");
                                if(pat->v.fl & GREATER_THAN)
                                    printf("GREATER_THAN ");
                                if(pat->v.fl & ATOM)
                                    printf("ATOM ");
                                if(pat->v.fl & FENCE)
                                    printf("FENCE ");
                                if(pat->v.fl & IDENT)
                                    printf("IDENT");
                                printf("\n");
                                }
#endif
                            return s.c.rmr ^ (char)NIKS(pat);
                            }
                    /* H        SL,SR=shift_right divisionPoint */
                        if(  kop(loc) == kop(pat)
                          && loc->RIGHT != snijaf
                          )
                            loc = loc->RIGHT;
                        else
                            loc = NULL;
                        /* SL = lhs divisionPoint S, SR = rhs divisionPoint S
                        */
                        ++locpos;
                    /* I        leftResult=SL:car(P) */
                        s.c.lmr = match(ind+1,sub, pat->LEFT, loc,pposition,expressionLength(sub)/*stringLength*/);
                        }
                    /* J    if leftResult.succes */
                    if(s.c.lmr & TRUE)
                    /* K        rightResult=0(P):cdr(pat) */
                        {
                        s.c.rmr = match(ind+1,nil(pat),pat->RIGHT, NULL,locpos,stringLength);
                        s.c.rmr &= ~ONCE;
                        }
                    /* L    return */
                        /* Return true if full success.

                           Also return whether lhs experienced max position
                           being reached. */
                    if(!(s.c.rmr & POSITION_MAX_REACHED))
                        s.c.rmr &= ~POSITION_ONCE;
         /*           if(!SUBJECTNOTNIL(sub,pat))
                        s.c.rmr &= ~POSITION_MAX_REACHED; */
                        /* Also return whether the pattern as a whole doesn't
                           want longer subjects, which can be found out by
                           looking at the pattern. */
                    if(/*snijaf &&*/ oncePattern(pat))
                        /* The test snijaf != NULL merely avoids that
                        oncePattern is called when it is useless. */
                        { /* Test:
                          a b c d e:`(a ?x) (?z:d) ?
                          x=
                          z=b
                          */
                        s.c.rmr |= ONCE;
                        s.c.rmr |= (char)(pat->v.fl & FENCE);
                        }
                        /* POSITION_ONCE requires zero size subjects. */
                    /*
                    if(!(s.c.lmr & POSITION_ONCE))
                        s.c.rmr &= ~POSITION_ONCE;
                        */

                        /* Also return the fence flag, which can be found on
                           the pattern or in the result of the lhs or the rhs.
                           (Not necessary that both have this flag.)
                        */
                    /* s.c.rmr |= (s.c.lmr & FENCE);*/
                    s.c.rmr ^= (char)NIKS(pat);
                    return s.c.rmr;
                    /* end */
#else
                    s.c.lmr = (char)match(ind+1,nil(pat), pat->LEFT, NULL,pposition,stringLength);
                    printMatchState("NIL LEFT",s,pposition,stringLength);
                    if(s.c.lmr & TRUE)
                        {
                        if(SUBJECTNOTNIL(sub,pat))
                            {
                            s.c.rmr = (char)(match(ind+1,sub,pat->RIGHT,snijaf,pposition,stringLength));
                            }
                        else
                            {
                            s.c.rmr = (char)(match(ind+1,nil(pat),pat->RIGHT, NULL,pposition,stringLength));
                            }
                        if(!(s.c.lmr & (ONCE|POSITION_ONCE)))
                            {
                            s.c.rmr &= ~(ONCE|POSITION_ONCE);
                            }
                        s.c.rmr |= (s.c.lmr & POSITION_MAX_REACHED);
                        if(s.c.rmr)
                            break;
                        }
                    if(  (s.c.lmr & POSITION_ONCE)
                      || (s.c.rmr & POSITION_MAX_REACHED)
                      )
                        {
                        printf("SKIP LOOP\n");
                        }
                    else
                        {
                        if (  kop(sub) == kop(pat)
                            && (loc = sub->RIGHT) != snijaf
                            )
                            {
                            do
                                {
                                ++pposition;
#if DEBUGBRACMAT
                                if(debug){printf("%d%*ssub:",ind,ind,"");results(sub,loc);printf(" / ");results(loc,snijaf);if(snijaf){printf(" \\ ");result(snijaf);}printf("  pat:");result(pat->LEFT);printf(" / ");result(pat->RIGHT);printf("\n");}
#endif
                                s.c.lmr = match(ind+1,sub, pat->LEFT, loc,pposition,stringLength);
                                if(s.c.lmr & TRUE)
                                    {
                                    if(s.c.lmr & ONCE)
                                        s.c.rmr = (char)(match(ind+1,loc, pat->RIGHT, snijaf,pposition,stringLength));
                                    else
                                        s.c.rmr = (char)(~(ONCE|POSITION_ONCE) & match(ind+1,loc, pat->RIGHT, snijaf,pposition,stringLength));
                                    }
                                else
                                    s.c.rmr = (char)0;

                                if(s.c.rmr & TRUE)
                                    {
                                    if(oncePattern(pat))
                                        {
                                        s.c.rmr |= ONCE;
                                        s.c.rmr |= (char)(pat->v.fl & FENCE);
                                        }
#if DEBUGBRACMAT
                                    if(debug){printf("%d%*s",ind,ind,"");printf("OK ");printf("s.c.rmr %d s.c.lmr %d\n",s.c.rmr,s.c.lmr);}
#endif
                                    return /*s.c.once
                                        |*/ (s.c.lmr & POSITION_MAX_REACHED)
                                        | ((char)(s.c.rmr ^ (char)NIKS(pat)));
                                    /*return (char)(s.c.rmr ^ (char)NIKS(pat));*/
                                    }
                                else if(((s.c.lmr & ONCE) /*&& !(s.c.lmr & TRUE)*/))
                                    {
                                    s.c.rmr |= (char)(pat->v.fl & FENCE);
                                    if(!(s.c.lmr & TRUE))
                                        s.c.rmr |= ONCE;
#if DEBUGBRACMAT
                                    if(debug){printf("%d%*s",ind,ind,"");printf("CUT ");printf("s.c.rmr %d s.c.lmr %d\n",s.c.rmr,s.c.lmr);}
#endif
                                    return /*s.c.once
                                        |*/ (s.c.lmr & POSITION_MAX_REACHED)
                                        | (/* ~(ONCE|POSITION_ONCE)
                                          &*/ ((char)(s.c.rmr
                                            ^ (char)NIKS(pat))
                                            )
                                          );
                                    /*return (char)(s.c.rmr ^ (char)NIKS(pat));*/
                                    }
                                else if (kop(loc) != kop(pat))
                                    {
#if DEBUGBRACMAT
                                    if(debug){printf("%d%*s",ind,ind,"");printf("break\n");}
#endif
                                    break;
                                    }
                                if(  (s.c.lmr & POSITION_ONCE)
                                  || (s.c.rmr & POSITION_MAX_REACHED)
                                  )
                                    {
                                    return s.c.rmr;
                                    }
                                loc = loc->RIGHT;
                                }
                            while(loc != snijaf);
#if DEBUGBRACMAT
                            if(debug){printf("%d%*s",ind,ind,"");printf("na loop s.c.lmr %d s.c.rmr %d\n",s.c.lmr,s.c.rmr);}
#endif
                            s.c.rmr = 0;
                            }

                        if (SUBJECTNOTNIL(sub,pat))
                            {
                            ++pposition;
#if DEBUGBRACMAT
                            if(debug){printf("%d%*s",ind,ind,"");printf("SUBJECTNOTNIL s.c.lmr %d s.c.rmr %d\n",s.c.lmr,s.c.rmr);}
#endif
                            if(!(s.c.lmr & ONCE))
                                {
                                if(TRUE & (s.c.lmr = (char)(match(ind+1,sub, pat->LEFT, snijaf,pposition,stringLength))))
                                    s.c.rmr |= (char)(~ONCE & match(ind+1,nil(pat), pat->RIGHT, NULL,pposition,stringLength));
                                else
                                    s.c.rmr |= (char)(s.c.lmr & (FENCE | ONCE));
                                }
                            else
                                s.c.rmr = 0;
                            }
                        else if(s.c.lmr & TRUE)
                            s.c.rmr |= (char)(s.c.lmr & (FENCE | ONCE));
                        }
/*
dbg'(x y z m a i n :? (m a i) ?W) & out$(W !W)
dbg'(m a i n l  :? (m a i  n) ?W) & out$(W !W)
*/
                    if(oncePattern(pat))
                        {
                        s.c.rmr |= (char)(pat->v.fl & FENCE);
                        s.c.rmr |= ONCE;
                        }

                    s.c.rmr ^= (char)NIKS(pat);
#if DEBUGBRACMAT
                    if(debug)
                        {
                        printf("%d%*smatch(",ind,ind,"");results(sub,snijaf);printf(":");result(pat);printf(") s.c.rmr %d (A)",s.c.rmr);
                        if(pat->v.fl & BREUK)
                            printf("BREUK ");
                        if(pat->v.fl & NUMBER)
                            printf("NUMBER ");
                        if(pat->v.fl & SMALLER_THAN)
                            printf("SMALLER_THAN ");
                        if(pat->v.fl & GREATER_THAN)
                            printf("GREATER_THAN ");
                        if(pat->v.fl & ATOM)
                            printf("ATOM ");
                        if(pat->v.fl & FENCE)
                            printf("FENCE ");
                        if(pat->v.fl & IDENT)
                            printf("IDENT");
                        printf("\n");
                        }
#endif
                    printMatchState("AFTER LOOP",s,pposition,stringLength);
                    return /*s.c.once
                        |*/ (s.c.lmr & POSITION_MAX_REACHED)
                        | s.c.rmr;
                    /*return s.c.rmr;*/
                    /*break;*/
#endif
                    }
                case STREEP:
                    if (is_op(sub))
                        {
                        if(kop(sub) == WORDT && ISBUILTIN((objectknoop*)sub))
                            {
                            printf("You cannot match an object '=' with '_' if the object is built-in\n");
                            s.c.rmr = ONCE;
                            }
                        else if(  ((s.c.lmr = match(ind+1,sub->LEFT, pat->LEFT, NULL,0,expressionLength(sub->LEFT))) & TRUE)
                               && ((s.c.rmr = match(ind+1,sub->RIGHT, pat->RIGHT, snijaf,0,expressionLength(sub->RIGHT))) & TRUE)
                               ) /* NULL --> snijaf 20031110 */
                            {
                            dummy_op = kop(sub);
                            dummy_flgs = sub->v.fl & VISIBLE_FLAGS;
                            }
                        }
                    if (s.c.lmr != PRISTINE)
                        s.c.rmr |= (char)(s.c.lmr & (FENCE | ONCE));
                    break;
                case EN:
                    if ((s.c.lmr = match(ind+1,sub, pat->LEFT, snijaf,pposition,stringLength)) & TRUE)
                        {
                        loc = zelfde_als_w(pat->RIGHT);
                        /* 13 november 1991 */
                        evalueer(&loc);
                        if (loc->v.fl & SUCCESS)
                            {
                            s.c.rmr = TRUE;
                            if(loc->v.fl & FENCE)
                                s.c.rmr |= ONCE;
                            }
                        else
                            {
                            s.c.rmr = FALSE;
                            if (loc->v.fl & FENCE)
                                s.c.rmr |= (FENCE | ONCE);        /* 13 november 1991 */
                            }
                        wis(loc);
                        }
                    /*if (s.c.lmr != SCHAR_MAX)*/
                        s.c.rmr |= (char)(s.c.lmr & (FENCE | ONCE));
                    break;
                case MATCH:
                    if ((s.c.lmr = match(ind+1,sub, pat->LEFT, snijaf,pposition,stringLength)) & TRUE)
                        {
                        if((pat->v.fl & ATOM)
#if !STRINGMATCH_CAN_BE_NEGATED
                            && !ONTKENNING(pat->v.fl,ATOM)
#endif
                            )
                            s.c.rmr = (char)(stringmatch(ind+1,"U",POBJ(sub),NULL,pat->RIGHT, sub,0,strlen(POBJ(sub))) & TRUE /* TODO stringmatch code doesn't have & TRUE */);
                        else
                            s.c.rmr = (char)(match(ind+1,sub, pat->RIGHT, snijaf,pposition,stringLength) & TRUE /* TODO stringmatch code doesn't have & TRUE */);
                        }
                    else
                        s.c.rmr = FALSE;
                    s.c.rmr |= (char)(s.c.lmr & (FENCE | ONCE | POSITION_MAX_REACHED));
 /*
dbg'(x y z f t m a i n l:? ((m a i n|f t):?X) ?W) & out$(X !X W !W)
correct:X f t W m a i n l

@(jfhljkhlhfgjkhfas:? ((lh|jk):?W) ?) & !W
wrong: jf
correct: jk
*/
                    break;
                case OF:
/*
                    if ( (s.c.lmr = (char)( stringmatch(ind+1,"R",sub, pat->LEFT, subkn,pposition,stringLength)))
                       & (TRUE | FENCE)
                       )
                        {
                        if((s.c.lmr & ONCE) && !stringOncePattern(pat->RIGHT))
                            {
                            s.c.rmr = (char)(s.c.lmr & TRUE);
                            }
                        else
                            {
                            s.c.rmr = (char)(s.c.lmr & (TRUE|ONCE));
                            }
                        }
                    else
                        {
                        s.c.rmr = stringmatch(ind+1,"S",sub, pat->RIGHT, subkn,pposition,stringLength);
                        if(  (s.c.rmr & ONCE)
                          && !(s.c.lmr & ONCE)
                          )
                            {
                            s.c.rmr &= ~(ONCE|POSITION_ONCE);
                            }
                        if(  (s.c.rmr & POSITION_MAX_REACHED)
                          && !(s.c.lmr & POSITION_MAX_REACHED)
                          )
                            {
                            s.c.rmr &= ~(POSITION_MAX_REACHED|POSITION_ONCE);
                            }
                        }
                    break;
*/
                    if ( (s.c.lmr = (char)match(ind+1,sub, pat->LEFT, snijaf,pposition,stringLength))
                       & (TRUE | FENCE)
                       )
                        {
                        if((s.c.lmr & ONCE) && !oncePattern(pat->RIGHT))
                            {
                            s.c.rmr = (char)(s.c.lmr & TRUE);
                            }
                        else
                            {
                            s.c.rmr = (char)(s.c.lmr & (TRUE|ONCE));
                            }
                        }
                    else
                        {
                        s.c.rmr = match(ind+1,sub, pat->RIGHT, snijaf,pposition,stringLength);
                        if(  (s.c.rmr & ONCE)
                          && !(s.c.lmr & ONCE)
                          )
                            {
                            s.c.rmr &= ~(ONCE|POSITION_ONCE);
                            }
                        if(  (s.c.rmr & POSITION_MAX_REACHED)
                          && !(s.c.lmr & POSITION_MAX_REACHED)
                          )
                            {
                            s.c.rmr &= ~(POSITION_MAX_REACHED|POSITION_ONCE);
                            }
                        }
#if DEBUGBRACMAT
                    if(debug)
                        {
                        printf("%d%*s",ind,ind,"");
                        printf("OF s.c.lmr %d s.c.rmr %d\n",s.c.lmr,s.c.rmr);
                        }
#endif
/*
:?W:?X:?Y:?Z & dbg'(a b c d:?X (((a ?:?W) & ~`|?Y)|?Z) d) & out$(X !X W !W Y !Y Z !Z)
erroneous: X a W a b c d Y b c Z
expected: X W a b c Y Z a b c
*/
                    break;
/*
20070222 This is now much quicker than previously, because the whole expression
(|bc|x) is ONCE if the start of the subject does not match the start of any of
the alternations:
dbg'(h h h h h h h h h b b b b b b b b b b b b b b b b b b b b b b b b b b b b
b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b
b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b
b b h h h a b c d:?X (|b c|x) d)
*/
                case FUN:
                case FUU:
                    loc = zelfde_als_w(pat);
                    evalueer(&loc);
                    if (vgl(pat, loc))
                        {
                        s.c.rmr = /*~DONOTSHORTEN & */(char)(match(ind+1,sub, loc, snijaf,pposition,stringLength) ^ NIKS(loc));
                        wis(loc);
                        break;
                        }
                    wis(loc);
                    /* doorvallen */
                default:
                    if(is_op(pat))
                        {
                        if(kop(sub) == kop(pat))
                            {
                            if ((s.c.lmr = match(ind+1,sub->LEFT, pat->LEFT, NULL,0,expressionLength(sub->LEFT))) & TRUE)
                                s.c.rmr = match(ind+1,sub->RIGHT, pat->RIGHT, NULL,0,expressionLength(sub->RIGHT));
                            /*if (s.c.lmr != SCHAR_MAX)*/
                            s.c.rmr |= (char)(s.c.lmr & (FENCE | ONCE));
                            }
                        }
                    else
                        {
                        /* 19971207 register long Flgs;*/
                        /*Flgs = pat->v.fl;*/
                        if (pat->u.obj
                        || !(Flgs & (BREUK | NUMBER | NONIDENT | ATOM | IDENT)))
                            {

                            s.c.rmr = (char)(/**/ ONCE | /**/ compare(sub, pat));
                            }
                        else         /* e.g.    a b c : % */
                            {
                            s.c.rmr = TRUE;
                            }
                        }
                }
        }
    if(oncePattern(pat) || /* Bart 20070820 (a b X k:(|? b|`) X ?id) must fail*/ (s.c.rmr & (TRUE|FENCE|ONCE)) == FENCE)
        {
        s.c.rmr |= (char)(pat->v.fl & FENCE);
        s.c.rmr |= ONCE;
#if DEBUGBRACMAT
        if(debug)
            {
            printf("%d%*smatch(",ind,ind,"");
            results(sub,snijaf);
            printf(":");
            result(pat);
            printf(") (B)");
#ifndef NDEBUG
            printf(" rmr t %d o %d p %d m %d f %d ",
                    s.b.brmr_true,s.b.brmr_once,s.b.brmr_position_once,s.b.brmr_position_max_reached,s.b.brmr_fence);
#endif
            if(pat->v.fl & POSITION)
                printf("POSITION ");
            if(pat->v.fl & BREUK)
                printf("BREUK ");
            if(pat->v.fl & NUMBER)
                printf("NUMBER ");
            if(pat->v.fl & SMALLER_THAN)
                printf("SMALLER_THAN ");
            if(pat->v.fl & GREATER_THAN)
                printf("GREATER_THAN ");
            if(pat->v.fl & ATOM)
                printf("ATOM ");
            if(pat->v.fl & FENCE)
                printf("FENCE ");
            if(pat->v.fl & IDENT)
                printf("IDENT");
            printf("\n");
            }
#endif
        }
    if(is_op(pat))
        s.c.rmr ^= (char)NIKS(pat);
    if(name)
        wis(name);
    return s.c.rmr;
    }

static int subroot(ngetal ag,char *conc[],int *pind)
{
int macht,i;
unsigned long g,kleindeler;
unsigned long ores;
static int bijt[12]=
  {1,  2,  2,  4,    2,    4,    2,    4,    6,    2,  6};
/*2-3,3-5,5-7,7-11,11-13,13-17,17-19,19-23,23-29,29-1,1-7*/
unsigned long grootdeler;

#ifdef ERANGE   /* ANSI C : strtoul() out of range */
errno = 0;
g = strtoul(ag.number,NULL,10);
if(errno == ERANGE)
    return FALSE;
#else  /* TURBOC, vcc */
if(ag.length > 10 || ag.length == 10  && strcmp(ag.number,"4294967295") > 0)
    return FALSE;
g = strtoul(ag.number,NULL,10);
#endif
ores = 1;
macht = 1;
kleindeler = 2;
i = 0;
while((grootdeler = g / kleindeler) >= kleindeler)
    {
    if(grootdeler * kleindeler == g)
        {
        g = grootdeler;
        if(kleindeler != ores)
            {
            if(ores != 1)
                {
                if(ores < 1000)
                    conc[(*pind)] = (char *)bmalloc(__LINE__,12);
                else
                    conc[*pind] = (char *)bmalloc(__LINE__,20);
                sprintf(conc[(*pind)++],"%lu^(%d*\1)*",ores,macht);
                }
            macht = 1;
            ores = kleindeler;
            }
        else
            macht++;
        }
    else
        {
        kleindeler += bijt[i];
        if(++i > 10)
            i = 3;
        }
    }
if(ores == 1 && macht == 1)
    return FALSE;
conc[*pind] = (char *)bmalloc(__LINE__,24);
if((ores == g && ++macht) || ores == 1)
    sprintf(conc[(*pind)++],"%lu^(%d*\1)",g,macht);
else
    sprintf(conc[(*pind)++],"%lu^(%d*\1)*%lu^\1",ores,macht,g);
return TRUE;
}

static int root(ppsk pkn)
{
char **conc,slash = 0;
int wipe[20],ind;
ngetal teller,noemer;
for(ind = 0; ind < 20; wipe[ind++] = TRUE);
ind = 0;
conc = (char **)bmalloc(__LINE__,20 * sizeof(char **));
   /* 20 is veilige waarde voor ULONGs */
adr[1] = (*pkn)->RIGHT;
if(RAT_RAT_COMP((*pkn)->LEFT))
    {
    splits((*pkn)->LEFT,&teller,&noemer);
    if(!subroot(teller,conc,&ind))
        {
        wipe[ind] = FALSE;
        conc[ind++] = teller.number;
        slash = teller.number[teller.length];
        teller.number[teller.length] = 0;

        wipe[ind] = FALSE;
        conc[ind++] = "^\1";
        }
    wipe[ind] = FALSE;
    conc[ind++] = "*(";
    if(!subroot(noemer,conc,&ind))
        {
        wipe[ind] = FALSE;
        conc[ind++] = noemer.number;
        wipe[ind] = FALSE;
        conc[ind++] = "^\1";
        }
    wipe[ind] = FALSE;
    conc[ind++] = ")^-1";
    }
else
    {
    teller.number = (char *)POBJ((*pkn)->LEFT);
    teller.alloc = NULL;
    teller.length = strlen(teller.number);
    if(!subroot(teller,conc,&ind))
        {
        bfree(conc);
        return TRUE;
        }
    }
conc[ind--] = NULL;
*pkn = vopb(*pkn,(const char **)conc);
if(slash)
    teller.number[teller.length] = slash;
for(;ind >= 0;ind--)
   if(wipe[ind])
       bfree(conc[ind]);
bfree(conc);
return TRUE;
}

static int abseen(psk kn)
{
register unsigned char *pstring;
pstring = POBJ(kn);
return(*pstring == '1' && *++pstring == 0);
}

static int casemacht(ppsk pkn)
{
static const char *conc[] = {NULL,NULL,NULL,NULL,NULL,NULL},
haakmineen[] = ")^-1",
haakhekje1macht[] = "(\1^",
macht2maaleenmacht[] = ")^2*\1^";
psk lknoop,rknoop;
lknoop = (*pkn)->LEFT;
if(!RATIONAAL_COMP(lknoop))
    {
    return FALSE;
    }
rknoop = (*pkn)->RIGHT;
if(INTEGER_NIET_NUL_COMP(rknoop) && !abseen(rknoop))
    {
    adr[1] = lknoop;
    if(INTEGER_POS_COMP(rknoop))
        {
        if(_qvergelijk(&tweek,rknoop) & MINUS)
            {
            /* m^n = (m^(n\2))^2*m^(n mod 2) */
            conc[0] = haakhekje1macht;
            conc[1] = hekje5;
            conc[3] = hekje6;
            adr[5] = _qheeldeel(rknoop,&tweek);
            conc[2] = macht2maaleenmacht;
            adr[6] = _qmodulo(rknoop,&tweek);
            *pkn = vopb(*pkn,conc);
            wis(adr[5]);
            wis(adr[6]);
            }
        else
            {
            /*int ra;*/
            /* m^2 = m*m */
            /*ra = range(rknoop);
            if(!ra) 20070707*/
                *pkn = opb(*pkn,"(\1*\1)",NULL);
            /*else
                *pkn = opb(*pkn,
                          ra == -2 ?  "<(\1*\1)" :
                          ra == -1 ? "~>(\1*\1)" :
                          ra ==  1 ? "~<(\1*\1)" :
                                      ">(\1*\1)"
                          ,NULL); 20070707*/
            }
        }
    else
        {
        /* (a+b)^-n = ((a+b)^n)^-1 */
        conc[0] = haakhekje1macht;
        conc[1] = hekje6;
        adr[6] = _qmaalmineen(rknoop);
        conc[2] = haakmineen;
        conc[3] = 0;
        *pkn = vopb(*pkn,conc);
        wis(adr[6]);
        }
    return TRUE;
    }
else if(RAT_RAT(rknoop))
    {
    return root(pkn);
    }
return FALSE;
}

#define UNDERSCORE 1

static psk _linkertak(psk pkn)
{
psk lknoop;
lknoop = pkn->LEFT;
if(!(pkn->v.fl & SUCCESS))
    {
    lknoop = prive(lknoop);
    lknoop->v.fl ^= SUCCESS;
    }
if(pkn->v.fl & FENCE && !(lknoop->v.fl & FENCE))
    {
    lknoop = prive(lknoop);
    lknoop->v.fl |= FENCE;
    }
wis(pkn->RIGHT);
return lknoop;
}

static psk linkertak(psk pkn)
{
psk lknoop = _linkertak(pkn);
pskfree(pkn);
return lknoop;
}

static psk _flinkertak(psk pkn)
{
psk lknoop;
lknoop = pkn->LEFT;
if(pkn->v.fl & SUCCESS)
    {
    lknoop = prive(lknoop);
    lknoop->v.fl ^= SUCCESS;
    }
if((pkn->v.fl & FENCE) && !(lknoop->v.fl & FENCE))
    {
    lknoop = prive(lknoop);
    lknoop->v.fl |= FENCE;
    }
wis(pkn->RIGHT);
return lknoop;
}

static psk flinkertak(psk pkn)
{
psk lknoop = _flinkertak(pkn);
pskfree(pkn);
return lknoop;
}

static psk _fencelinkertak(psk pkn)
{
psk lknoop;
lknoop = pkn->LEFT;
if(!(pkn->v.fl & SUCCESS))
    {
    lknoop = prive(lknoop);
    lknoop->v.fl ^= SUCCESS;
    }
if(pkn->v.fl & FENCE) /* 19980207 */
    {
    if(!(lknoop->v.fl & FENCE))
        {
        lknoop = prive(lknoop);
        lknoop->v.fl |= FENCE;
        }
    }
else if(lknoop->v.fl & FENCE)
    {
    lknoop = prive(lknoop);
    lknoop->v.fl &= ~FENCE;
    }
/*
if(pkn->v.fl & FENCE && !(lknoop->v.fl & FENCE))
    {
    lknoop = prive(lknoop);
    lknoop->v.fl |= FENCE;
    }
else
if(lknoop->v.fl & FENCE)
    {
    lknoop = prive(lknoop);
    lknoop->v.fl &= ~FENCE;
    }
*/
wis(pkn->RIGHT);
return lknoop;
}

static psk _rechtertak(psk pkn)
{
psk rknoop;
rknoop = pkn->RIGHT;
if(!(pkn->v.fl & SUCCESS))
    {
    rknoop = prive(rknoop);
    rknoop->v.fl ^= SUCCESS;
    }
if(pkn->v.fl & FENCE && !(rknoop->v.fl & FENCE))
    {
    rknoop = prive(rknoop);
    rknoop->v.fl |= FENCE;
    }
wis(pkn->LEFT);
return rknoop;
}

static psk rechtertak(psk pkn)
{
psk rknoop = _rechtertak(pkn);
pskfree(pkn);
return rknoop;
}

static void pop(psk kn)
    {
    while(is_op(kn))
        {
        pop(kn->LEFT);
        /* pop(kn->RIGHT);
        18 Maart 1997 */
        kn = kn->RIGHT;
        }
    deleteNode(kn);
    }

static int tryq(ppsk pkn,psk fun)
{
psk anker;
psh(&argk,*pkn,NULL);
(*pkn)->v.fl |= READY;

anker = subboomcopie(fun->RIGHT);

psh(fun->LEFT,&nulk,NULL);
evalueer(&anker);
pop(fun->LEFT);
if(anker->v.fl & SUCCESS)
    {
    wis(*pkn);
    *pkn = anker;
    deleteNode(&argk);
    return TRUE;
    }
else
    {
    wis(anker);
    deleteNode(&argk);
    return FALSE;
    }
}

static int try_le_elq(psk fun,ppsk pkn)
{
if(!is_op((*pkn)->RIGHT))
    return FALSE;
else
    return tryq(pkn,fun);
}

static psk rechteroperand(psk pkn)
{
psk temp;
unsigned int teken;
temp = (pkn->RIGHT);
return((teken = kop(pkn)) == kop(temp) &&
        (teken == PLUS || teken == MAAL || teken == LUCHT) ?
       temp->LEFT : temp);
}

static int differentieren(ppsk pkn)
{
psk lknoop,rknoop;
rknoop = (*pkn)->RIGHT;
if(RATIONAAL_COMP(lknoop = (*pkn)->LEFT) || is_op(lknoop))
    return FALSE;
if(RATIONAAL_COMP(rknoop))
    replace(pkn,&nulk);
else
    if(kop(rknoop) == PLUS)
        {
        adr[1] = (*pkn)->LEFT;
        adr[2] = rknoop->LEFT;
        adr[3] = rknoop->RIGHT;
        *pkn = opb(*pkn,"((\1\017\2)+(\1\017\3))",NULL);
        }
    else
        {
        if(is_op(rknoop))
            {
            adr[2] = rknoop->LEFT;
            adr[1] = lknoop;
            adr[3] = rknoop->RIGHT;
            switch(kop(rknoop))
                {
                case MAAL :
                    *pkn = opb(*pkn,"(\001\017\2*\3+\2*\001\017\3)",NULL);
                    break;
                case EXP:
                    *pkn = opb(*pkn,
     "(\2^(-1+\3)*\3*\001\017\2+\2^\3*e\016\2*\001\017\3)",NULL);
                    break;
                case LOG :
                    *pkn = opb(*pkn,
     "(\2^-1*e\016\2^-2*e\016\3*\001\017\2+\3^-1*e\016\2^-1*\001\017\3)",NULL);
                    break;
                }
            }
        else
            return FALSE;
        }
return TRUE;
}

static int atomtest(psk kn)
{
return (!is_op(kn) && !HAS_UNOPS(kn)) ? (int)kn->u.obj : -1;
}

/* 20001222 void -> int */
static int evalmacro(ppsk pkn)
    {/* BJO 24 Jan 1996: dit moet efficienter kunnen! Alleen kopieren waar het nodig is! */
    if(!is_op(*pkn))
        { /* 20080129 */
        if((*pkn)->v.fl & INDIRECT)
            {
            *pkn = prive(*pkn);
            (*pkn)->v.fl &= ~READY;
            }
        }
    else
        {
        while(!((*pkn)->v.fl & READY))
            {
            psk h;
            *pkn = prive(*pkn);
            if(!evalmacro(&((*pkn)->LEFT)))
                return FALSE;
            switch(kop(*pkn))
                {
                case STREEP: /* Bart 20021215 */
        /*
                    (*pkn)->v.fl &= (~OPERATOR & ~READY);
        */

                    if(dummy_op == WORDT)
                        {
                        psk old = *pkn;
                        *pkn = (psk)bmalloc(__LINE__,sizeof(objectknoop));
                        ((typedObjectknoop*)(*pkn))->refcount = 0;
                        UNSETCREATEDWITHNEW((typedObjectknoop*)*pkn);
                        UNSETBUILTIN((typedObjectknoop*)*pkn);
                        (*pkn)->LEFT = subboomcopie(old->LEFT);
                        (*pkn)->RIGHT = subboomcopie(old->RIGHT);
                        /*(*pkn)->v.fl |= dummy_flgs;*/
                        wis(old);
                        }
                    /*else*/
                        {
                        (*pkn)->v.fl &= ~OPERATOR;
                        (*pkn)->ops |= dummy_op;
                        (*pkn)->v.fl |= dummy_flgs;
                        }
                    break;
                case FUN :
                    if(atomtest((*pkn)->LEFT) == 0)
                        {
                        int newval;
                        psk tmp = zelfde_als_w((*pkn)->RIGHT);
                        evalueer(&tmp);

        /*                    if(  (atomtest((*pkn)->RIGHT) > 0 || kop((*pkn)->RIGHT) == DOT)
                          && find((*pkn)->RIGHT,&h,&newval,NULL,NULL,NULL)*/
                        if(  (atomtest(tmp) > 0 || kop(tmp) == DOT)
                          && find(tmp,&h,&newval,NULL,NULL,NULL)
                          )  /* alleen $<atoom> of $(<blah>.<blah>) komt erdoor */
                            {
                            int Flgs = (*pkn)->v.fl & (UNOPS/*|QGETAL|MINUS|QNUL|QBREUK*/);
                            wis(*pkn);
                            if(newval)
                                *pkn = h;
                            else
                                *pkn = zelfde_als_w(h);
                            if(  Flgs
                              )
                                {
                                *pkn = prive(*pkn);
                                (*pkn)->v.fl |= Flgs;
                                if((*pkn)->v.fl & INDIRECT)
                                    (*pkn)->v.fl &= ~READY;
                                }
                            else if((*pkn)->v.fl & INDIRECT)
                                { /* 20080128 */
                                *pkn = prive(*pkn);
                                (*pkn)->v.fl &= ~READY;
                                }

                            wis(tmp);
                            return TRUE;
                            }
                        else
                            {
                            printf("\nevalmacro fails: identifier (");result((*pkn)->RIGHT);printf(") not found.\n");
                            wis(tmp);
                            return FALSE;
                            }
                        }
                    break;
                case FUU :
                    if(atomtest((*pkn)->LEFT) == 0)
                        return TRUE; /* afblijven van geneste macro's */
                }
            /* evalmacro(&((*pkn)->RIGHT));
            18 Maart 1997 */
            pkn = &((*pkn)->RIGHT);
            if(!is_op(*pkn))
                {
                if((*pkn)->v.fl & INDIRECT)
                    {
                    *pkn = prive(*pkn);
                    (*pkn)->v.fl &= ~READY;
                    }
                break;
                }
            }
        }
    return TRUE;
    }

static void combiflags(psk kn)
{
int lflgs;
if((lflgs = kn->LEFT->v.fl & UNOPS) != 0)
    {
    kn->RIGHT = prive(kn->RIGHT);
    if(NIKSF(lflgs))
        {
        kn->RIGHT->v.fl |= lflgs & ~NOT;
        kn->RIGHT->v.fl ^= NOT|SUCCESS;
        }
    else
        kn->RIGHT->v.fl |= lflgs;
    }
}


static int is_afhankelyk_van(psk el,psk lijst)
    {
    int ret;
    while(lijst)
        {
        psk hlp/*,hlp2*/;
        if(!vgl(el,(hlp = (kop(lijst) == KOMMA) ? lijst->LEFT : lijst)))
            return TRUE;

        if(is_op(hlp))
            {
            if(is_afhankelyk_van(el,hlp->LEFT)
            || is_afhankelyk_van(el,hlp->RIGHT))
                return TRUE;
            }
        else
            {
            /*int dummy;
            int retobsolete = FALSE; 20070707*/
            psk kn = NULL;
            /*hlp2 = NULL;
            if(find(hlp,&hlp2,&dummy,NULL,NULL,NULL))
                {
                if(is_afhankelyk_van(el,hlp2))
                    {
                    retobsolete = TRUE;
                    }
                }*/
             adr[1] = hlp;
             adr[2] = el;
             kn = opb(kn,"(!dep:(? (\1.? \2 ?) ?)",NULL);
             ret = (evalueer(&kn) == TRUE);
             wis(kn);
             /*if(retobsolete && !ret)
                 errorprintf("Warning:Obsolete dependency is neglected (!%s depends on %s, but is not mentioned in variable dep).\n",
                (char *)POBJ(hlp),(char *)POBJ(el));*/
             return ret/* || retobsolete*/;
            }
        /* return is_afhankelyk_van(el,(kop(lijst) == KOMMA) ? lijst->RIGHT : NULL);
        18 Maart 1997 */
        lijst = (kop(lijst) == KOMMA) ? lijst->RIGHT : NULL;
        }
    return FALSE;
    }

static int zoekopt(psk kn,long opt)
    {
    while(is_op(kn))
        {
        /*return zoekopt(kn->LEFT,opt) || zoekopt(kn->RIGHT,opt);
        18 Maart 1997 */
        if(zoekopt(kn->LEFT,opt))
            return TRUE;
        kn = kn->RIGHT;
        /*19970825 continue;*/
        }
    return PLOBJ(kn) == opt;
    }

static void mmf(ppsk pk)
{
psk goal;
ppsk pgoal;
vars *navar;
int alfabet,ext;
char dim[22];
ext = zoekopt(*pk,EXT);
wis(*pk);
pgoal = pk;
for(alfabet = 0;alfabet < 256/*0x80*/;alfabet++)
    {
    for(navar = variabelen[alfabet];
        navar;
        navar = navar->next)
        {
        goal = *pgoal = (psk)bmalloc(__LINE__,sizeof(kknoop));
        goal->v.fl = LUCHT | SUCCESS;
        if(ext && navar->n > 0) /* was 1 (16 March 1993) */
            {
            goal = goal->LEFT = (psk)bmalloc(__LINE__,sizeof(kknoop));
            goal->v.fl = DOT | SUCCESS;
            sprintf(dim,"%d.%d",navar->n,navar->selector);
            goal->RIGHT = NULL;
            goal->RIGHT = opb(goal->RIGHT,dim,NULL);
            }
        goal = goal->LEFT =
            (psk)bmalloc(__LINE__,sizeof(unsigned long) + 1 + strlen((char *)VARNAME(navar)));
        goal->v.fl = (READY|SUCCESS);
        strcpy((char *)POBJ(goal),(char *)VARNAME(navar));
        pgoal = &(*pgoal)->RIGHT;
        }
    }
*pgoal = zelfde_als_w(&nilk);
}

static void lstsub(psk kn)
{
vars *navar;
unsigned char *naam;
int alfabet,n;
mooi = FALSE;
naam = POBJ(kn);
for(alfabet = 0;alfabet<256;alfabet++)
    {
    for(navar = variabelen[alfabet];
        navar;
        navar = navar->next)
        {
        if((kn->u.obj == 0 && alfabet < 0x80) || !STRCMP(VARNAME(navar),naam))
            {
            for(n = navar->n;n >= 0;n--)
                {
                if(fpo == stdout)
                    {
                    if(navar->n > 0)
                        printf("%c%d (",n == navar->selector ? '>' : ' ',n);
                    else
                        printf("(");
                    }
                if(haalaan(VARNAME(navar)))
                    myprintf("\"",(char *)VARNAME(navar),"\"=",NULL);
                else
                    myprintf((char *)VARNAME(navar),"=",NULL);
                if(hum)
                    myprintf("\n",NULL);
                assert(navar->pvaria);
                result(*Head(entry(navar->n,n,&navar->pvaria)));
                if(fpo == stdout)
                    printf(")");
                myprintf(";\n",NULL);
                }
            }
        }
    }
mooi = TRUE;
}

static void lst(psk kn)
    {
    while(is_op(kn))
        {
        lst(kn->LEFT);
        /* lst(kn->RIGHT);
        18 Maart 1997 */
        kn = kn->RIGHT;
        }
    lstsub(kn);
    }


static long tijdnr = 0L;
/*
static int openCount = 0;
static int maxOpenCount = 0;
static int allOpenCount = 0;
*/
static void sluitfile(filehendel *fh)
{
fh->filepos = ftell(fh->fp);
fclose(fh->fp);
/* fh->pos != -1 means that the file is closed,
   so it is not necessary to set fh->fp to 0
*/
/*--openCount;
printf("--OPEN %d (%d %d)\n",openCount,maxOpenCount,allOpenCount);
*/
}

static long someopt(psk kn,long opt[])
    {
    int i;
    while(is_op(kn))
        {
        /* return someopt(kn->LEFT,opt) || someopt(kn->RIGHT,opt);
        18 Maart 1997 */
        if(someopt(kn->LEFT,opt))
            return TRUE;
        kn = kn->RIGHT;
        }
    for(i=0;opt[i];i++)
        if(PLOBJ(kn) == opt[i])
            return opt[i];
    return 0L;
    }

FILE * myfopen(const char * filename,const char * mode)
    {
    FILE * fp = fopen(filename,mode);
    if(fp)
        return fp;
    else if(targetPath && strchr(mode,'r'))
        {
        const char * p = filename;
        char * q;
        size_t len;
        while(*p)
            {
            if(*p == '\\' || *p == '/')
                {
                if(p == filename)
                    return NULL;
                break;
                }
            else if((*p == ':') && (p == filename + 1))
                return NULL;
            ++p;
            }
        q = malloc((len = strlen(targetPath)) + strlen(filename) + 1);
        if(q)
            {
            strcpy(q,targetPath);
            strcpy(q+len,filename);
            fp = fopen(q,mode);
            free(q);
            }
        return fp;
        }
    return NULL;
    }

static FILE *bfopen(char *naam,char *mode)
{
FILE *fp;
filehendel *fh,*fhmin;
if((fp=myfopen(naam,mode)) == NULL)
    {
    if(fh0 == NULL)
        return NULL;
    for(fh = fh0,fhmin = fh0;
        fh != NULL;
        fh = fh->next)
        {
        if(fh->filepos == -1L /* fh->fp != NULL */ /* test added 12 Aug 1996 */ && fh->tijd < fhmin->tijd)
            fhmin = fh;
        }
    if(fhmin == NULL)/* test added 12 Aug 1996 */
        return NULL;
    sluitfile(fhmin);
    if((fp=myfopen(naam,mode)) == NULL)
        return NULL;
    }
/*
++openCount;
++allOpenCount;
if(openCount > maxOpenCount)
    maxOpenCount = openCount;
printf("++OPEN %d (%d %d)\n",openCount,maxOpenCount,allOpenCount);
*/
return fp;
}

static filehendel * preparefp(filehendel * fh,char * naam,long mode)
    {
    assert(fh != NULL);
    assert(!strcmp(fh->naam,naam));
    if( mode != 0L /* added 16 July 1996 */
    &&  mode != fh->mode)
        {
        fh->mode = mode;
        if((fh->fp = freopen(fh->naam,(char *)&(fh->mode),fh->fp)) == NULL)
            return NULL;
        fh->written = FALSE;
        }
    else if(fh->filepos > 0L)
        {
        if((fh->fp = bfopen(naam,(char *)&(fh->mode))) == NULL)
            return NULL;
        fh->written = FALSE;
        fseek(fh->fp,fh->filepos,SEEK_SET);
        }
    fh->filepos = -1L;
    fh->tijd = tijdnr++;
    return fh;
    }
/*
Find an existing or create a fresh file handle for a known file name
If the file mode differs from the current file mode,
    reopen the file with the new file mode.
If the file is known but has been closed (e.g. to save file handles),
    open the file with the memorized file mode and go to the memorized position
*/
static filehendel *zoekfp(char *naam,long mode)
    {
    filehendel *fh;
    for(fh = fh0;fh;fh = fh->next)
        if(!strcmp(naam,fh->naam))
            return preparefp(fh,naam,mode);
    return NULL;
    }

static void setStop(filehendel *fh,char * stopstring)
    {
    if(fh->stop)
#ifdef BMALLLOC
        bfree(fh->stop);
    fh->stop = (char *)bmalloc(__LINE__,strlen(stopstring + 1);
#else
        free(fh->stop);
    fh->stop = (char *)malloc(strlen(stopstring) + 1);
#endif
    strcpy(fh->stop,stopstring);
    }

static int fil(ppsk pkn)
{
FILE *fp;
psk kns[4];
long ind;
int sh;
psk kn;
static filehendel *fh = NULL;
char *naam;

static long types[]={CHR,DEC,STRt,0L};
static long whences[]={SET,CUR,END,0L};
static long modes[]={
O('r', 0 , 0 ),/*open text file for reading                                  */
O('w', 0 , 0 ),/*create text file for writing, or trucate to zero length     */
O('a', 0 , 0 ),/*append; open text file or create for writing at eof         */
O('r','b', 0 ),/*open binary file for reading                                */
O('w','b', 0 ),/*create binary file for writing, or trucate to zero length   */
O('a','b', 0 ),/*append; open binary file or create for writing at eof       */
O('r','+', 0 ),/*open text file for update (reading and writing)             */
O('w','+', 0 ),/*create text file for update, or trucate to zero length      */
O('a','+', 0 ),/*append; open text file or create for update, writing at eof */
O('r','+','b'),
O('r','b','+'),/*open binary file for update (reading and writing)           */
O('w','+','b'),
O('w','b','+'),/*create binary file for update, or trucate to zero length    */
O('a','+','b'),
O('a','b','+'),/*append;open binary file or create for update, writing at eof*/
0L};

static long type,numwaarde,whence;
union
    {
    long l;
    char c[4];
    } mode;

union
    {
    short s;
    char c[2];
    } snum;

/*
Fail if there are more than four arguments or if an argument is non-atomic
*/
for(ind = 0,kn = (*pkn)->RIGHT;
    is_op(kn);
    kn = kn->RIGHT)
    {
    if(is_op(kn->LEFT) || ind > 2)
        {
        return FALSE;
        }
    kns[ind++] = kn->LEFT;
    }
kns[ind++] = kn;
for(;ind < 4;)
    kns[ind++] = NULL;

/*
  FIRST ARGUMENT: File name
  if the current file name is different from the argument,
        reset the current file name
  if the first argument is empty, the current file name must not be NULL
  fil$(name)
  fil$(name,...)
  name field is optional in all fil$ operations
*/
if(kns[0]->u.obj)
    {
    naam = (char *)POBJ(kns[0]);
    if(fh && strcmp(naam,fh->naam))
        fh = NULL;
    }
else
    {
    if(fh)
        naam = fh->naam;
    else
        {
        return FALSE;
        }
    }

/*
  SECOND ARGUMENT: mode, type, whence or TEL
        if the second argument is a mode string,
                the file handel is found and adapted to the  mode
                or a new file handel is made
        else
                file handel is set to current naam

        If the second argument is set, fil$ does never read or write!
*/
if(kns[1] && kns[1]->u.obj)
    {
    /*
    SECOND ARGUMENT:FILE MODE
    fil$(,"r")
    fil$(,"b")
    fil$(,"a")
    etc.
    */
    if((mode.l = someopt(kns[1],modes)) != 0L)
        {
        if(fh)
            fh = preparefp(fh,naam,mode.l);
        else
            fh = zoekfp(naam,mode.l);
        if(fh == NULL)
            {
            if((fp=bfopen(naam,(char *)&mode)) == NULL)
                {
                return FALSE;
                }
            fh = (filehendel*)bmalloc(__LINE__,sizeof(filehendel));
            fh->naam = (char *)bmalloc(__LINE__,strlen(naam) + 1);
            strcpy(fh->naam,naam);
            fh->fp = fp;
            fh->filepos = -1L;
            fh->mode = mode.l;
            fh->type = CHR;
            fh->size = 1;
            fh->getal = 1;
            fh->tijd = tijdnr++;
            fh->written = FALSE;
            fh->next = fh0;
            fh->stop = NULL;
            fh0 = fh;
            }
        return TRUE;
        }
    else
        {
    /*
    We do not open a file now, so we should have a file handle in memory.
    */
        if(fh)
            fh = preparefp(fh,naam,0L);
        else
            fh = zoekfp(naam,0L);

        if(!fh)
            {
            return FALSE;
            }

    /*
    SECOND ARGUMENT:TYPE
    fil$(,CHR)
    fil$(,DEC)
    fil$(,CHR,size)
    fil$(,DEC,size)
    fil$(,CHR,size,number)
    fil$(,DEC,size,number)
    fil$(,STR)        (stop == NULL)
    fil$(,STR,stop)
    */
        if((type = someopt(kns[1],types)) != 0L)
            {
            fh->type = type;
            if(type == STRt)
                {
                /*
                  THIRD ARGUMENT: primary stopping character (e.g. "\n")
                  20081113:
                  An empty string "" sets stopping string to NULL, 
                  (Changed behaviour! Previously default stop was newline!)
                */
                if(kns[2] && kns[2]->u.obj)
                    {
                    setStop(fh,(char *)&kns[2]->u.obj);
                    }
                else
                    {
                    if(fh->stop)
#ifdef BMALLLOC
                       bfree(fh->stop);
                    fh->stop = NULL;
                    /*fh->stop = (char *)bmalloc(__LINE__,2);*/
#else
                        free(fh->stop);
                    fh->stop = NULL;
                    /*fh->stop = (char *)malloc(2);*/
#endif
                    /*strcpy(fh->stop,"\n");*/
                    }
                }
            else
                {
                /*
                  THIRD ARGUMENT: a size of elements to read or write
                */
                if(kns[2] && kns[2]->u.obj)
                    {
                    if(!INTEGER(kns[2]))
                        {
                        return FALSE;
                        }
                    fh->size = toLong(kns[2]);
                    }
                else
                    {
                    fh->size = 1;
                    fh->getal = 1;
                    }
                /*
                  FOURTH ARGUMENT: the number of elements to read or write
                */
                if(kns[3] && kns[3]->u.obj)
                    {
                    if(!INTEGER(kns[3]))
                        {
                        return FALSE;
                        }
                    fh->getal = toLong(kns[3]);
                    }
                else
                    fh->getal = 1;
                }
            return TRUE;
            }
    /*
    SECOND ARGUMENT:POSITIONING
    fil$(,SET)
    fil$(,END)
    fil$(,CUR)
    fil$(,SET,offset)
    fil$(,END,offset)
    fil$(,CUR,offset)
    */
        else if((whence = someopt(kns[1],whences)) != 0L)
            {
            long offset;
            fh->tijd = tijdnr++;
            /*
              THIRD ARGUMENT: an offset
            */
            if(kns[2] && kns[2]->u.obj)
                {
                if(!INTEGER(kns[2]))
                    {
                    return FALSE;
                    }
                offset = toLong(kns[2]);
                }
            else
                offset = 0L;

            if((offset < 0L && whence == SEEK_SET)
            || (offset > 0L && whence == SEEK_END)
            || fseek(fh->fp,offset,whence == SET ? SEEK_SET
                            : whence == END ? SEEK_END
                                            : SEEK_CUR))
                {
                filehendel * fhvorig, * fhh;
                sluitfile(fh);
                for(fhvorig = NULL,fhh = fh0
                   ;fhh != fh
                   ;fhvorig = fhh,fhh = fhh->next
                   )
                   ;
                if(fhvorig)
                    fhvorig->next = fh->next;
                else
                    fh0 = fh->next;
                bfree(fh->naam);
                if(fh->stop)
#ifdef BMALLLOC
                    bfree(fh->stop);
#else
                    free(fh->stop);
#endif
                bfree(fh);
                fh = NULL;
                return FALSE;
                }
            fh->written = FALSE;
            return TRUE;
            }
    /*
    SECOND ARGUMENT:TELL POSITION
    fil$(,TEL)
    */
        else if(PLOBJ(kns[1]) == TEL)
            {
            char pos[11];
            sprintf(pos,"%ld",ftell(fh->fp));
            *pkn = opb(*pkn,pos,NULL);
            return TRUE;
            }
        else
            {
            return FALSE;
            }
        }
    /*
    return FALSE if the second argument is not empty but could not be recognised
    */
    }

if(!fh)
    {
    return FALSE;
    }
/*
READ OR WRITE
Now we are either going to read or to write
*/

type = fh->type;
mode.l = fh->mode;
fp = fh->fp;

/*
THIRD ARGUMENT: the number of elements to read or write
OR stop characters, depending on type (20081113)
*/

if(kns[2] && kns[2]->u.obj)
    {
    if(type == STRt)
        {
        setStop(fh,(char *)&kns[2]->u.obj);
        }
    else
        {
        if(!INTEGER(kns[2]))
            {
            return FALSE;
            }
        fh->getal = toLong(kns[2]);
        }
    }

/*
We allow 1, 2 or 4 bytes to be read/written in one fil$ operation
These can be distributed over decimal numbers.
*/

if(type == DEC)
    {
    switch((int)fh->size)
        {
        case 1 :
            if(fh->getal > 4)
                fh->getal = 4;
            break;
        case 2 :
            if(fh->getal > 2)
                fh->getal = 2;
            break;
        default :
            fh->size = 4; /*Invalid size declaration adjusted*/
            fh->getal = 1;
        }
    }
fh->tijd = tijdnr++;
/*
FOURTH ARGUMENT:VALUE TO WRITE
*/
if(kns[3])
    {
    if(mode.c[0] != 'r' || mode.c[1] == '+' || mode.c[2] == '+')
/*
WRITE
*/
        {
        fh->written = TRUE;
        if(type == DEC)
            {
            numwaarde = toLong(kns[3]);
            for(ind=0;ind < fh->getal;ind++)
                switch((int)fh->size)
                    {
                    case 1 :
                        fputc((int)numwaarde & 0xFF,fh->fp);
                        numwaarde >>= 8;
                        break;
                    case 2 :
                        snum.s = (short)(numwaarde & 0xFFFF);
                        fwrite(snum.c,1,2,fh->fp);
                        numwaarde >>= 16;
                        break;
                    default :
                        fwrite((char *)&numwaarde,1,4,fh->fp);
                        break;
                    }
            }
        else if(type == CHR)
            {
            size_t len,len1,minl;
            len1 = (size_t)(fh->size*fh->getal);
            len = strlen((char *)POBJ(kns[3]));
            minl = len1 < len ? (len1 > 0 ? len1 : len) : len;
            if(fwrite(POBJ(kns[3]),1,minl,fh->fp) == minl)
                for(;len < len1 && putc(' ',fh->fp) != EOF;len++);
            }
        else /*if(type == STRt)*/
            {
            if(  fh->stop 
              && fh->stop[0]
              )/* 20081113 stop string also works when writing. */
                {
                char * s = (char *)POBJ(kns[3]);
                while(!strchr(fh->stop,*s))
                    fputc(*s++,fh->fp);
                }
            else
                {
                fputs((char *)POBJ(kns[3]),fh->fp);
                }
            }
        }
    else
        {
        /*
        Fail if not in write mode
        */
        return FALSE;
        }
    }
else
    {
    if(mode.c[0] == 'r' || mode.c[1] == '+' || mode.c[2] == '+')
        {
/*
READ
*/
#define INPUTBUFFERSIZE 256
        unsigned char buffer[INPUTBUFFERSIZE];
        unsigned char * bbuffer = buffer;
        if(fh->written)
            {
            fflush(fh->fp);
            fh->written = FALSE;
            }
        if(feof(fp))
            {
            return FALSE;
            }
        if(type == STRt)
            {
            psk lpkn = NULL;
            psk rpkn = NULL;
            char * conc[2];
            int count = 0;
            long pos = ftell(fp);
            int kar = 0;
            while(  count < (INPUTBUFFERSIZE - 1)
                 && (kar = fgetc(fp)) != EOF 
                 && (  !fh->stop 
                    || !strchr(fh->stop,kar)
                    )
                 )
                {
                buffer[count++] = (char)kar;
                }
            if(count < (INPUTBUFFERSIZE - 1))
                {
                buffer[count] = '\0';
                bbuffer = buffer;
                }
            else
                {
                buffer[(INPUTBUFFERSIZE - 1)] = '\0';
                while(  (kar = fgetc(fp)) != EOF 
                     && (  !fh->stop 
                        || !strchr(fh->stop,kar)
                        )
                     )
                    count++;
                if(count >= INPUTBUFFERSIZE)
                    {
                    bbuffer = (unsigned char *)bmalloc(__LINE__,(size_t)count+1);
                    strcpy((char *)bbuffer,(char *)buffer);
                    fseek(fp,pos+(INPUTBUFFERSIZE - 1),SEEK_SET);
                    if(fread((char *)bbuffer+(INPUTBUFFERSIZE - 1),1,count - (INPUTBUFFERSIZE - 1),fh->fp) == 0)
                        {
                        bfree(bbuffer); /* 20040226 */
                        return FALSE;
                        }
                    if(ferror(fh->fp))
                        {
                        bfree(bbuffer); /* 20040226 */
                        perror("fread");
                        return FALSE;
                        }
                    if(kar != EOF)
                        fgetc(fp); /* skip stopping character (which is in 'kar') */
                    }
                else
                    bbuffer = buffer;
                }
            bron = bbuffer;
            input(NULL,&lpkn,1,NULL/*int * err*/);
            if(kar == EOF)
                bbuffer[0] = '\0';
            else
                {
                bbuffer[0] = (char)kar;
                bbuffer[1] = '\0';
                }
            bron = bbuffer;
            input(NULL,&rpkn,1,NULL/*int * err*/);
            conc[0] = "(\1.\2)";
            adr[1] = lpkn;
            adr[2] = rpkn;
            conc[1] = NULL;
            *pkn = vopb(*pkn,(const char **)conc);
            wis(adr[1]);
            wis(adr[2]);
            }
        else
            {
            if(fh->size * fh->getal > 255)
                bbuffer = (unsigned char *)bmalloc(__LINE__,(size_t)(fh->size * fh->getal)+1);
                          /* +1 added 18 Maart 1997 */
            else
                bbuffer = buffer;
            if(fread((char *)bbuffer,(size_t)fh->size,(size_t)fh->getal,fh->fp) == 0
            && (size_t)fh->size*(size_t)fh->getal != 0)
                {
                return FALSE;
                }
            if(ferror(fh->fp))
                {
                perror("fread");
                return FALSE;
                }
            *(bbuffer+(int)(fh->size*fh->getal)) = 0;
            if(type == DEC)
                {
                numwaarde = 0L;
                sh = 0;
                for(ind = 0;ind < fh->getal;)
                    {
                    switch((int)fh->size)
                        {
                        case 1 :
                            numwaarde += (long)bbuffer[ind++] << sh;
                            sh += 8;
                            continue;
                        case 2 :
                            numwaarde += (long)(*(short*)(bbuffer+ind)) << sh;
                            ind += 2;
                            sh += 16;
                            continue;
                        default :
                            numwaarde += *(long*)bbuffer;
                            break;
                        }
                    break;
                    }
                sprintf((char *)bbuffer,"%ld",numwaarde);
                }
            bron = bbuffer;
            input(NULL,pkn,1,NULL/*int * err*/);
            }
        if(bbuffer != (unsigned char *)&buffer[0])
        /* buffer ---> (unsigned char *)&buffer[0]
           20 Dec 1995, to make Borland at ease. */
            bfree(bbuffer);
        return TRUE;
        }
    else
        {
        return FALSE;
        }
    }

return TRUE;
}

static int allopts(psk kn,long opt[])
    {
    int i;
    while(is_op(kn))
        {
        /* return allopts(kn->LEFT,opt) && allopts(kn->RIGHT,opt);
        18 Maart 1997 */
        if(!allopts(kn->LEFT,opt))
            return FALSE;
        kn = kn->RIGHT;
        }
    for(i=0;opt[i];i++)
        if(PLOBJ(kn) == opt[i])
            return TRUE;
    return FALSE;
    }

static int flush(void)
    {
#ifdef __GNUC__
    return fflush(fpo);
#else
#ifdef BRACMATEMBEDDED /*MICROSOFT_WINDOWS_API*/
    WinFlush();
    return 1;
#else
    return 1;
#endif
#endif
    }


static int output(ppsk pkn,void (*hoe)(psk k))
{
FILE *redfpo;
psk rknoop,rlknoop,rrknoop,rrrknoop;
static long opts[] =
{APP,NEW,
 TXT,VAP,
 EXT,MEM,
 CON,LIN,
 0L};
if(kop(rknoop = (*pkn)->RIGHT) == KOMMA)
   {
   redfpo = fpo;
   rlknoop = rknoop->LEFT;
   rrknoop = rknoop->RIGHT;
   hum = !zoekopt(rrknoop,LIN);
   if(allopts(rrknoop,opts))
        {
        if(zoekopt(rrknoop,MEM))
            {
            psk ret;
            telling = 1;
            verwerk = tel;
            fpo = NULL;
            (*hoe)(rlknoop);
            ret = (psk)bmalloc(__LINE__,sizeof(unsigned long)+telling);
            ret->v.fl = READY | SUCCESS;
            verwerk = plak;
            bron = POBJ(ret);
            (*hoe)(rlknoop);
            hum = 1;
            verwerk = myputc;
            wis(*pkn);
            *pkn = ret;
            fpo = redfpo;
            return TRUE;
            }
        else
            {
            (*hoe)(rlknoop);
            flush();
            adr[2] = rlknoop;
            }
        }
    else if(kop(rrknoop) == KOMMA
         && !is_op(rrknoop->LEFT)
         && allopts((rrrknoop = rrknoop->RIGHT),opts))
        {
        fpo = myfopen((char *)POBJ(rrknoop->LEFT),
                    zoekopt(rrrknoop,NEW) ? "w" : "a");
        if(fpo == NULL)
            {
            errorprintf("cannot open %s\n",POBJ(rrknoop->LEFT));
            fpo = redfpo;
            hum = 1;
            return FALSE;
            }
        else
            {
            (*hoe)(rlknoop);
            fclose(fpo);
            fpo = redfpo;
            adr[2] = rlknoop;
            }
        }
    else
        {
        (*hoe)(rknoop);
        flush();
        adr[2] = rknoop;
        }
    dopb(pkn,adr[2]);
    }
else
    {
    (*hoe)(rknoop);
    flush();
    *pkn = rechtertak(*pkn);
    }
hum = 1;
return TRUE;
}

static ptrdiff_t simil(char *s1,char *s2)
{
/*#define TOLOWER(c) (c >= 'A' && c <= 'Z' ? c - 'A' + 'a' : c)*/
char *ls1,*s1l = NULL,*s1r = NULL,*s2l = NULL,*s2r = NULL;
ptrdiff_t max;
/* beschouw elk teken van s1 als mogelijk startpunt voor match */
for(max = 0,ls1 = s1;*ls1;ls1++)
    {
    char *ls2;
    /* vergelijk met s2 */
    for(ls2 = s2;*ls2;ls2++)
        {
        char *lls1,*lls2;
        /* bepaal lengte gelijke stukken */
        for(lls1 = ls1,lls2 = ls2;
            *lls1 && (int)lowerEquivalent[(unsigned char)*lls1] == (int)lowerEquivalent[(unsigned char)*lls2]; /* 20040223 */
            /**lls1 && TOLOWER(*lls1) == TOLOWER(*lls2);*/
            lls1++,lls2++);
        /* pas evt score aan */
        if(lls1 - ls1 > max)
            {
            max = lls1 - ls1;
            /* onthou eindpunten van linkerstrings en
            beginpunten rechterstrings */
            s1l = ls1;
            s1r = lls1;
            s2l = ls2;
            s2r = lls2;
            }
        }
    }
if(max)
    {
    char c1,c2;
    c1 = *s1l;
    c2 = *s2l;
    *s1l = 0;
    *s2l = 0;
    max += simil(s1,s2) + simil(s1r,s2r);
    *s1l = c1;
    *s2l = c2;
    }
return max;
}


static function_return_type find_func(ppsk pkn)
{
psk lknoop = (*pkn)->LEFT;
int nieuw = FALSE;
psk self = NULL;
/*psk dest = NULL;*/
method_pnt theMethod = NULL;
psk object = NULL;
adr[1] = NULL;
if(find(lknoop,&adr[1],&nieuw,&self,&object,&theMethod))
    {
    if(adr[1])
        {
        if(is_op(adr[1])
          && kop(adr[1]) == DOT /*Bart 20010820*/
          )
            {
            psh(&argk,(*pkn)->RIGHT,NULL);
            dopb(pkn,adr[1]);
            if(nieuw)
                wis(adr[1]);
            if(self)
                {
#ifndef SELF
                psh(&selfkn,self,NULL);
#endif
                if(object)
                    {
                    psh(&Selfkn,object,NULL);
                    return builtin_object_user_method_ok;
                    }
                else
                    return user_object_method_ok;
                }
            else
                return user_function_ok;
            }
        else
            {
            errorprintf("(Syntax error) The following is not a function:\n\n  ");
#ifdef BRACMATEMBEDDED
            fpo = stderr;
#else
            fpo = errorStream;
#endif
            result(lknoop);
            exit(1);
            }
        }
    else if(theMethod)
        {
        return theMethod((struct typedObjectknoop *)object,pkn);
/*
#ifdef SELF
        if(self)
            return builtin_object_user_method_ok;
        else
#endif
            return builtin_object_builtin_method_ok;
*/
        }
    else
        return function_fail; /* should not come here */
    /*return TRUE+TRUE+(self?TRUE:0);*/
    }
else if(debug)
    {
    errorprintf("Function not found");
    writeError(*pkn);
    printf("\n");
    }
return function_fail;
}

static int hasSubObject(psk src)
    {
    while(is_op(src))
        {
        if(kop(src) == WORDT)
            return TRUE;
        else
            {
            /*return hasSubObject(src->LEFT) || hasSubObject(src->RIGHT);
            18 Maart 1997*/
            if(hasSubObject(src->LEFT))
                return TRUE;
            src = src->RIGHT;
            }
        }
    return FALSE;
    }

static psk objectcopiesub(psk src);

static psk objectcopiesub2(psk src) /* src is NOT an object */
    {
    psk goal;
    if(is_op(src) && hasSubObject(src))
        {
        goal = /*new_operator_like(src); */(psk)bmalloc(__LINE__,sizeof(kknoop));
        goal->ops = src->ops & ~ALL_REFCOUNT_BITS_SET;
        goal->LEFT = objectcopiesub(src->LEFT);
        goal->RIGHT = objectcopiesub(src->RIGHT);
        return goal;
        }
    else
        return zelfde_als_w(src);
    }

static psk objectcopiesub(psk src)
    {
    psk goal;
    if(is_object(src))
        {
/*        goal = new_operator_like(src);*/
        if(ISBUILTIN((objectknoop*)src))
            {
            goal = (psk)bmalloc(__LINE__,sizeof(typedObjectknoop));
            ((typedObjectknoop*)goal)->refcount = 0;
            UNSETCREATEDWITHNEW((typedObjectknoop*)goal);/*TODO: This line seems to be superfluous*/
            SETBUILTIN((typedObjectknoop*)goal);
            ((typedObjectknoop*)goal)->vtab = ((typedObjectknoop*)src)->vtab;
            ((typedObjectknoop*)goal)->voiddata = NULL;
            }
        else
            {
            goal = (psk)bmalloc(__LINE__,sizeof(objectknoop));
            ((typedObjectknoop*)goal)->refcount = 0;
            UNSETBUILTIN((typedObjectknoop*)goal);
            }
        UNSETCREATEDWITHNEW((typedObjectknoop*)goal);
        goal->ops = src->ops & ~ALL_REFCOUNT_BITS_SET;
        goal->LEFT = zelfde_als_w(src->LEFT);
        goal->RIGHT = zelfde_als_w(src->RIGHT);
        return goal;
        }
    else
        return objectcopiesub2(src);
    }

static psk objectcopie(psk src)
    {
    psk goal;
    if(is_object(src))                              /* Make a copy of this '=' node ... */
        {
        if(ISBUILTIN((objectknoop*)src))
            {
            goal = (psk)bmalloc(__LINE__,sizeof(typedObjectknoop));
            ((typedObjectknoop*)goal)->refcount = 0;
            UNSETCREATEDWITHNEW((typedObjectknoop*)goal);/*TODO: This line seems to be superfluous*/
            SETBUILTIN((typedObjectknoop*)goal);
            ((typedObjectknoop*)goal)->vtab = ((typedObjectknoop*)src)->vtab;
            ((typedObjectknoop*)goal)->voiddata = NULL;
            }
        else
            {
            goal = (psk)bmalloc(__LINE__,sizeof(objectknoop));
            ((typedObjectknoop*)goal)->refcount = 0;
            UNSETBUILTIN((typedObjectknoop*)goal);
            }
        UNSETCREATEDWITHNEW((typedObjectknoop*)goal);
        goal->ops = src->ops & ~ALL_REFCOUNT_BITS_SET;
        goal->LEFT = zelfde_als_w(src->LEFT);
        /*?? This adds an extra level of copying, but ONLY for objects that have a '=' node as the lhs of the main '=' node*/
        /* What is it good for? Bart 20010220 */
        goal->RIGHT = objectcopiesub(src->RIGHT); /* and of all '=' child nodes (but not of grandchildren!) */
        return goal;
        }
    else
        return objectcopiesub2(src);/*zelfde_als_w(src);*/
    }

static psk getObjectDef(psk source)
    {
    psk def;
    typedObjectknoop * dest;
    if(!is_op(source))
        {
        classdef * df = classes;
        /*printf("built-in?\n");*/
        for(;df->name && strcmp(df->name,(char *)POBJ(source));++df)
            ;
        if(df->vtab)
            {
            dest = (typedObjectknoop *)bmalloc(__LINE__,sizeof(typedObjectknoop));
            dest->v.fl = WORDT | SUCCESS;
            dest->links = zelfde_als_w(&nilk);
            dest->rechts = zelfde_als_w(&nilk);
            dest->refcount = 0;
            SETBUILTIN(dest);
            VOID(dest) = NULL;
            dest->vtab = df->vtab;
            return (psk)dest;
            }
        }
    else if(kop(source) == WORDT)
        {
        source->RIGHT = *Head(&source->RIGHT);
        return objectcopie(source);
        }



    if(naamwoord_w(source,&def))
        {
        dest = (typedObjectknoop *)bmalloc(__LINE__,sizeof(typedObjectknoop));
        dest->v.fl = WORDT | SUCCESS;
        /*dest->v.fl ^= Flgs;*/
        dest->links = zelfde_als_w(&nilk);
/*Bart 20010507        dest->rechts = def;*/
        /*printf("def:");
        result(def);
        printf("\n");*/
        dest->rechts = objectcopie(def); /* TODO Head(&def) ? */
        wis(def);
        dest->refcount = 0;
        UNSETBUILTIN(dest);
        VOID(dest) = NULL;
        dest->vtab = NULL;
        return (psk)dest;
        }
    return NULL;
    }

static psk changeCase(psk pkn,int dos,int low)
    {
    unsigned char * s, *d, * dest;
    int bitset = 0;
    psk ret;
    for(s = POBJ(pkn);*s;++s)
        if(*s & 0x80)
            ++bitset;
    dest = bmalloc(__LINE__,s - POBJ(pkn) + bitset + 1);
    if(low)
        {
        if(dos)
            for(s = POBJ(pkn), d = dest;*s;++s,++d)
                {
                *d = ISO8859toCodePage850(lowerEquivalent[CodePage850toISO8859(*s)]);
                if(*d & 0x80)
                    {
                    *(d+1) = *d ;
                    *d = 0x7F;
                    ++d;
                    }
                else
                    *d |= 0x80;
                }
        else
            for(s = POBJ(pkn), d = dest;*s;++s,++d)
                {
                *d = lowerEquivalent[(int)*s];
                if(*d & 0x80)
                    {
                    *(d+1) = *d ;
                    *d = 0x7F;
                    ++d;
                    }
                else
                    *d |= 0x80;
                }
        }
    else
        {
        if(dos)
            for(s = POBJ(pkn), d = dest;*s;++s,++d)
                {
                *d = ISO8859toCodePage850(upperEquivalent[CodePage850toISO8859(*s)]);
                if(*d & 0x80)
                    {
                    *(d+1) = *d ;
                    *d = 0x7F;
                    ++d;
                    }
                else
                    *d |= 0x80;
                }
        else
            for(s = POBJ(pkn), d = dest;*s;++s,++d)
                {
                *d = upperEquivalent[(int)*s];
                if(*d & 0x80)
                    {
                    *(d+1) = *d ;
                    *d = 0x7F;
                    ++d;
                    }
                else
                    *d |= 0x80;
                }
        }
    *d = '\0';
    ret = NULL;
    ret = opb(ret,dest,NULL);
    setflgs(&ret,pkn->v.fl);
    bfree(dest);
    return ret;
    }

static void * strToPointer(const char * str)
    {
    size_t res = 0;
    while(*str)
        res = 10*res+(*str++ - '0');
    return (void *)res;
    }

static void pointerToStr(char * pc,void * p)
    {
    size_t P = (size_t)p;
    char * PC = pc;
    while(P)
        {
        *pc++ = (char)(P % 10) + '0';
        P /= 10;
        }
    *pc-- = '\0';
    while(PC < pc)
        {
        char sav = *PC;
        *PC = *pc;
        *pc = sav;
        ++PC;
        --pc;
        }
    }


#if O_S
static function_return_type swi(ppsk pkn,psk rlknoop,psk rrknoop)
    {
    int i;
    union
        {
        unsigned int i[sizeof(os_regset) + 1];
        struct
            {
            int swicode;
            os_regset regs;
            } s;
        } u;
    char pc[121];
    for(i = 0;i < sizeof(os_regset)/sizeof(int);i++)
        u.s.regs.r[i] = 0;
    rrknoop = *pkn;
    i=0;
    do
        {
        rrknoop = rrknoop->RIGHT;
        rlknoop = is_op(rrknoop) ? rrknoop->LEFT : rrknoop;
        if(is_op(rlknoop) || !INTEGER_NIET_NEG(rlknoop))
            return function_fail;
        u.i[i++] = (unsigned int)
            strtoul((char *)POBJ(rlknoop),(char **)NULL,10);
        }
    while(is_op(rrknoop) && i < 10);
#ifdef __TURBOC__
    intr(u.s.swicode,(struct REGPACK *)&u.s.regs);
    sprintf(pc,"0.%u,%u,%u,%u,%u,%u,%u,%u,%u,%u",
        u.i[1],u.i[2],u.i[3],u.i[4],u.i[5],
        u.i[6],u.i[7],u.i[8],u.i[9],u.i[10]);
#else
#if defined ARM
    i = (int)os_swix(u.s.swicode,&u.s.regs);
    sprintf(pc,"%u.%u,%u,%u,%u,%u,%u,%u,%u,%u,%u",
        i,
        u.i[1],u.i[2],u.i[3],u.i[4],u.i[5],
        u.i[6],u.i[7],u.i[8],u.i[9],u.i[10]);
#endif
#endif
    *pkn = opb(*pkn,pc,NULL);
    return built_in_function_ok;
    }
#endif

static void stringreverse(char * a,size_t len) /*Bart 20070220 int -> size_t*/
    {
    char * b;
    b = a + len;
    while(a < --b)
        {
        char c = *a;
        *a = *b;
        *b = c;
        ++a;
        }
    }

static void print_clock(char * pklad,clock_t time)
    {
    if(time == -1)
        sprintf(pklad,"-1");
    else
#if defined __TURBOC__ && !defined __BORLANDC__
        sprintf(pklad,"%0lu/%lu",(long unsigned int)time,(long unsigned int)(10.0*CLOCKS_PER_SEC));/* CLOCKS_PER_SEC == 18.2 */
#else
        sprintf(pklad,"%0ld/%ld",(long int)time,(long int)CLOCKS_PER_SEC);
#endif
    }

#define LONGCASE

#ifdef LONGCASE
#define SWITCH(v) switch(v)
#define FIRSTCASE(a) case a :
#define CASE(a) case a :
#define DEFAULT default :
#else
#define SWITCH(v) long lob;lob = v;
#define FIRSTCASE(a) if(lob == a)
#define CASE(a) else if(lob == a)
#define DEFAULT else
#endif


static function_return_type functies(ppsk pkn)
    {
    static char klad[22];
    psk lknoop;
    psk rknoop,rrknoop,rlknoop,rrlknoop;
    if(is_op(lknoop = (*pkn)->LEFT))
        return find_func(pkn);
        /*return built_in_function_ok;*/
    rknoop = (*pkn)->RIGHT;
    {
    SWITCH(PLOBJ(lknoop))
        {
        FIRSTCASE(STR) /* str$(arg arg arg .. ..) */
            {
            mooi = FALSE;
            hum = 0;/* 15 Dec 1995 */
            telling = 1;
            verwerk = tstr;
            result(rknoop);
            rlknoop = (psk)bmalloc(__LINE__,sizeof(unsigned long)+telling);
    /*
            rlknoop->v.fl = READY | SUCCESS;
#ifndef LONGCASE
            rlknoop->ops = 0;
#endif
    */
            verwerk = pstr;
            bron = POBJ(rlknoop);
            result(rknoop);
            rlknoop->v.fl = (READY|SUCCESS) | (numbercheck(POBJ(rlknoop),NULL) & ~DEFINITELYNONUMBER);
            mooi = TRUE;
            hum = 1;/* 15 Dec 1995 */
            verwerk = myputc;
            wis(*pkn);
            *pkn = rlknoop;
            return built_in_function_ok;
            }
#if O_S
        CASE(SWI) /* swi$(<interrupt number>.(input regs)) */
            {
            swi(pkn,rlknoop,rrknoop);
            }
#endif

#ifdef ERR
#ifndef BRACMATEMBEDDED
        CASE(ERR) /* err $ <file name to direct errorStream to> */
            {
            if(!is_op(rknoop))
                {
                if(redirectError((char *)POBJ(rknoop)))
                    return built_in_function_ok;
                }
            return function_fail;
            }
#endif
#endif
        CASE(ALC)  /* alc $ <aantal bytes> */
            {
            void *p;
            if(is_op(rknoop)
            || !INTEGER_POS(rknoop)
            || (p = bmalloc(__LINE__,(int)strtoul((char *)POBJ(rknoop),(char **)NULL,10)))
                  == NULL)
                return function_fail;
/*            sprintf(pc,"%ld",(long)p);*/
            pointerToStr(klad,p);
            /*sprintf(klad,"%Iu",p);*/
            *pkn = opb(*pkn,klad,NULL);
            return built_in_function_ok;
            }
        CASE(FRE) /* fre $ <pointer> */
            {
            void * p;
            if(is_op(rknoop) || !INTEGER_POS(rknoop))
                return function_fail;
            p = strToPointer((char *)POBJ(rknoop));
            /*sscanf((char *)POBJ(rknoop),"%Iu",&p);*/
            pskfree(p);
            /*pskfree((void*)strtoul((char *)POBJ(rknoop),(char **)NULL,10));*/
            return built_in_function_ok;
            }
        CASE(PEE) /* pee $ (<pointer>,type) (1,2,4)*/
            {
            void *p;
            int aantal = 1;
            if(is_op(rknoop))
                {
                rlknoop = rknoop->LEFT;
                rrknoop = rknoop->RIGHT;
                if(!is_op(rrknoop))
                    switch(rrknoop->u.obj)
                        {
                        case '2':
                            aantal = 2;
                            break;
                        case '4':
                            aantal = 4;
                            break;
                        }
                }
            else
                rlknoop = rknoop;
            if(is_op(rlknoop) || !INTEGER_POS(rlknoop))
                return function_fail;
            p = strToPointer((char *)POBJ(rlknoop));
            /*sscanf((char *)POBJ(rlknoop),"%Iu",&p);*/
            p = (void*)((char *)p - (ptrdiff_t)((size_t)p % aantal));
            /*            p = (void*)strtoul((char *)POBJ(rlknoop),(char **)NULL,10);
            p = (void*)((char *)p - (unsigned)((unsigned long)p % aantal));*/
            switch(aantal)
                {
                case 1:
                    sprintf(klad,"%u",(int)*(unsigned char *)p);
                    break;
                case 2:
                    sprintf(klad,"%hu",*(short unsigned int*)p);
                    break;
                default:
                    sprintf(klad,"%lu",*(long unsigned int*)p);
                    break;
                }
            *pkn = opb(*pkn,klad,NULL);
            return built_in_function_ok;
            }
        CASE(POK) /* pok $ (<pointer>,getal,nbytes) */
            {
            int aantal;
            void *p;
            long val;
            aantal = 1;
            if(!is_op(rknoop))
                return function_fail;
            rlknoop = rknoop->LEFT;
            rrknoop = rknoop->RIGHT;
            if(is_op(rrknoop))
                {
                psk rrrknoop;
                rrrknoop = rrknoop->RIGHT;
                rrlknoop = rrknoop->LEFT;
                if(!is_op(rrrknoop))
                    switch(rrrknoop->u.obj)
                        {
                        case '2':
                            aantal = 2;
                            break;
                        case '4':
                            aantal = 4;
                        }
                }
            else
                rrlknoop = rrknoop;
            if(is_op(rlknoop) || !INTEGER_POS(rlknoop)
            || is_op(rrlknoop) || !INTEGER(rrlknoop))
                return function_fail;
            p = strToPointer((char *)POBJ(rlknoop));
            /*sscanf((char *)POBJ(rlknoop),"%Iu",&p);*/
            p = (void*)((char *)p - (ptrdiff_t)((size_t)p % aantal));
            /*p = (void*)strtoul((char *)POBJ(rlknoop),(char **)NULL,10);
            p = (void*)((char *)p - (unsigned)((unsigned long)p % aantal));*/
    /*        if(INTEGER_NIET_NEG(rrlknoop))
                val = strtoul((char *)POBJ(rrlknoop),(char **)NULL,10);
            else*/
                val = toLong(rrlknoop);
            switch(aantal)
                {
                case 1:
                    *(unsigned char *)p = (unsigned char)val;
                    break;
                case 2:
                    *(unsigned short int*)p = (unsigned short int)val;
                    break;
                default:
                    *(long*)p = val;
                    break;
                }
            return built_in_function_ok;
            }
        CASE(KAR) /* chr $ getal */
            {
            /*char pc[3];*/
            int val;
            if(is_op(rknoop) || !INTEGER_POS(rknoop))
                return function_fail;
            val = (unsigned char)strtoul((char *)POBJ(rknoop),(char **)NULL,10);
            /*if(val == 0x7F)
                return function_fail; ook dit zal wel niet goed zijn geweest */
            if(val > 0x7F)
                {
                klad[0] = 0x7F;
                klad[1] = (char)(val | 0x80);
                klad[2] = 0;
                }
            else
                {
                klad[0] = (char)(val | 0x80);
                klad[1] = 0;
                }
            *pkn = opb(*pkn,klad,NULL);
            return built_in_function_ok;
            }
        CASE(ASC) /* asc $ character */
            {
            /*char pc[4];*/
            if(is_op(rknoop))
                return function_fail;
            sprintf(klad,"%d",(int)rknoop->u.obj);
            *pkn = opb(*pkn,klad,NULL);
            return built_in_function_ok;
            }
        CASE(FIL) /* fil $ (<naam>,[<offset>,[set|cur|end]]) */
            {
            return fil(pkn) ? built_in_function_ok : function_fail;
            }
        CASE(FLG) /* flg $ <expr>  or flg$(=<expr>) */
            {
            int Flgs;
            if(is_object(rknoop) && !(rknoop->LEFT->v.fl & VISIBLE_FLAGS))
                rknoop = rknoop->RIGHT;
            Flgs = rknoop->v.fl;
            adr[3] = zelfde_als_w(rknoop);
            adr[3] = prive(adr[3]);
            adr[3]->v.fl = adr[3]->v.fl & ~VISIBLE_FLAGS;
            adr[2] = zelfde_als_w(&nilk);
            adr[2] = prive(adr[2]);
            adr[2]->v.fl &= ~VISIBLE_FLAGS;         /*20050405*/
            adr[2]->v.fl |= VISIBLE_FLAGS & Flgs;   /*20050405*/
            if(NIKSF(Flgs))
                {
                adr[3]->v.fl ^= SUCCESS;
                }
            sprintf(klad,"=\2.\3");
            *pkn = opb(*pkn,klad,NULL);
            wis(adr[2]);
            wis(adr[3]);
            return built_in_function_ok;
            }
        CASE(GLF) /* glf $ (=<flags>.<exp>) : (=?a)  a=<flags><exp> */
            {
            int Flgs;
            if(  is_object(rknoop)
              && kop(rknoop->RIGHT) == DOT
              )
                {
                Flgs = rknoop->RIGHT->LEFT->v.fl & VISIBLE_FLAGS;
                if(Flgs && (rknoop->RIGHT->RIGHT->v.fl & Flgs))
                    return function_fail;
                adr[3] = zelfde_als_w(rknoop->RIGHT->RIGHT);
                adr[3] = prive(adr[3]);
                /*adr[3]->v.fl &= ~VISIBLE_FLAGS;*/
                adr[3]->v.fl |= Flgs;
                if(NIKSF(Flgs))
                    {
                    adr[3]->v.fl ^= SUCCESS;
                    }
                sprintf(klad,"=\3");
                *pkn = opb(*pkn,klad,NULL);
                wis(adr[3]);
                return built_in_function_ok;
                }
            return function_fail;
            }
        CASE(FNC) /* fnc $ (<function pointer>.<struct pointer>) */
            {
            typedef Boolean (*fncTp)(void *);
            union
                {
                fncTp pfnc; /* Hoping this works. */
                void * vp;  /* Pointers to data and pointers to functions may
                               have different sizes. */
                } u;
            /*fncTp pfnc;*/
            void * argStruct;
            if(sizeof(int (*)(void *)) != sizeof(void *) || !is_op(rknoop))
                return function_fail;
            u.vp = strToPointer((char *)POBJ(rknoop->LEFT));
            /*20031126 pfnc = (fncTp)strtoul((char *)POBJ(rknoop->LEFT),(char **)NULL,10);*/
            if(!u.pfnc)
                return function_fail;
            argStruct = strToPointer((char *)POBJ(rknoop->RIGHT));
            /*20031126 argStruct = (void *)strtoul((char *)POBJ(rknoop->RIGHT),(char **)NULL,10);*/
            return u.pfnc(argStruct) ? built_in_function_ok : function_fail;
            }
#if TELMAX
        CASE(BEZ) /* bez $  */
            {
            sprintf(klad,"%u.%u.%d",globalloc,maxgloballoc,maxbez / ONE);
            *pkn = opb(*pkn,klad,NULL);
#if TELLING
            bezetting();
#endif
            return built_in_function_ok;
            }
#endif
        CASE(MMF) /* mem $ [EXT] */
            {
            mmf(pkn);
            return built_in_function_ok;
            }
        CASE(MOD)
            {
            if(RATIONAAL(rlknoop = rknoop->LEFT) &&
               RATIONAAL(rrknoop = rknoop->RIGHT))
                {
                psk kn;
                kn = _qmodulo(rlknoop,rrknoop);
                wis(*pkn);
                *pkn = kn;
                }
            return built_in_function_ok;
            }
        CASE(REV)
            {
            if(!is_op(rknoop))
                {
                size_t len = strlen((char *)POBJ(rknoop)); /*Bart 20070220 int -> size_t*/
                psk kn;
                kn = zelfde_als_w(rknoop);
                if(len > 1)
                    {
                    kn = prive(kn);
                    stringreverse((char *)POBJ(kn),len);
                    }
                wis(*pkn);
                *pkn = kn;
                return built_in_function_ok;
                }
            else
                return function_fail;
            }
        CASE(LOW)
            {
            psk kn;
            if(!is_op(rknoop))
                kn = changeCase(rknoop,FALSE,TRUE);
            else if(!is_op(rlknoop = rknoop->LEFT))
                kn = changeCase(rlknoop,zoekopt(rknoop->RIGHT,DOS),TRUE);
            else
                return function_fail;
            wis(*pkn);
            *pkn = kn;
            return built_in_function_ok;
            }
        CASE(UPP)
            {
            psk kn;
            if(!is_op(rknoop))
                kn = changeCase(rknoop,FALSE,FALSE);
            else if(!is_op(rlknoop = rknoop->LEFT))
                kn = changeCase(rlknoop,zoekopt(rknoop->RIGHT,DOS),FALSE);
            else
                return function_fail;
            wis(*pkn);
            *pkn = kn;
            return built_in_function_ok;
            }
        CASE(DIV)
            {
            if(  is_op(rknoop)
              && RATIONAAL_COMP(rlknoop = rknoop->LEFT)
              && RATIONAAL_COMP(rrknoop = rknoop->RIGHT)
              )
                {
                psk kn;
                /*int ral,rar;*/
                kn = _qheeldeel(rlknoop,rrknoop);
                /*
                ral = range(rlknoop);
                rar = range(rrknoop);
                */
                wis(*pkn);
                *pkn = kn;
                return built_in_function_ok;
                }
            return function_fail;
            }
        CASE(DEN)
            {
            if(RATIONAAL_COMP(rknoop))
                {
                psk kn;
                kn = _qdenominator(rknoop);
                wis(*pkn);
                *pkn = kn;
                }
            return built_in_function_ok;
            }
        CASE(LST)
            {
            return output(pkn,lst);
            }
        CASE(REN)
            {
            if(  is_op(rknoop)
              && !is_op(rlknoop = rknoop->LEFT)
              && !is_op(rrknoop = rknoop->RIGHT)
              )
                {
                int ret = rename((const char *)POBJ(rlknoop),(const char *)POBJ(rrknoop));
                if(ret)
                    {
#ifndef EACCES
                    sprintf(klad,"%d",ret);
#else
                    switch(errno)
                        {
                        case EACCES:
                            /*
                            File or directory specified by newname already exists or
                            could not be created (invalid path); or oldname is a directory
                            and newname specifies a different path.
                            */
                            strcpy(klad,"EACCES");
                            break;
                        case ENOENT:
                            /*
                            File or path specified by oldname not found.
                            */
                            strcpy(klad,"ENOENT");
                            break;
                        case EINVAL:
                            /*
                            Name contains invalid characters.
                            */
                            strcpy(klad,"EINVAL");
                            break;
                        default:
                            sprintf(klad,"%d",errno);
                            break;
                        }
#endif
                    }
                else
                    strcpy(klad,"0");
                *pkn = opb(*pkn,klad,NULL);
                return built_in_function_ok;
                }
            else
                return function_fail;
            }
        CASE(GET) /* get$file */
            {
            int echmemvapstr;
            if(is_op(rknoop))
                {
                if(is_op(rlknoop = rknoop->LEFT))
                    return function_fail;
                rrknoop = rknoop->RIGHT;
                echmemvapstr = (zoekopt(rrknoop,ECH) << SHIFT_ECH)
                             + (zoekopt(rrknoop,MEM) << SHIFT_MEM)
                             + (zoekopt(rrknoop,VAP) << SHIFT_VAP)
                             + (zoekopt(rrknoop,STG) << SHIFT_STR);
                }
            else
                {
                echmemvapstr = 0;
                rlknoop = rknoop;
                }
            if(echmemvapstr & OPT_MEM)
                {
                int err;
                adr[1] = zelfde_als_w(rlknoop);
                bron = POBJ(adr[1]);
                while(input(NULL,pkn,echmemvapstr,&err) && !err)
                    evalueer(pkn);
                wis(adr[1]);
                }
            else
                {
                if(rlknoop->u.obj && strcmp((char *)POBJ(rlknoop),"stdin"))
                    {
                    FILE *red;
                    int err;
                    red = fpi;
                    fpi = myfopen((char *)POBJ(rlknoop),"r");
                    if(fpi == NULL)
                        {
                        fpi = red;
                        return function_fail;
                        }
                    while(input(fpi,pkn,echmemvapstr,&err) && !err)
                        {
                        evalueer(pkn);
                        }
                    fclose(fpi);
                    fpi = red;
                    }
                else
                    {
                    int err;
                    echmemvapstr |= OPT_ECH;
#ifdef DELAY_DUE_TO_INPUT
                    for(;;)
                        {
                        clock_t time0;
                        Boolean somethingToDo;
                        time0 = clock();
                        somethingToDo = input(stdin,pkn,echmemvapstr,&err) && !err;
                        delayDueToInput += clock() - time0;
                        if(!somethingToDo)
                            break;
                        evalueer(pkn);
                        }
#else
                    while(input(stdin,pkn,echmemvapstr,&err) && !err)
                        evalueer(pkn);
#endif
                    }
                }
            return built_in_function_ok;
            }
        CASE(PUT) /* put$(file,mode,knoop) of put$knoop */
            {
            return output(pkn,result) ? built_in_function_ok : function_fail;
            }
#if !defined __SYMBIAN32__ && (!MICROSOFT_WINDOWS_API || defined __WIN32__ || defined _WIN32)
        /* system() not implemented under older Windows */
        CASE(SYS)
            {
            if(is_op(rknoop))
                return function_fail;
            else
                {
                int ret = system((const char *)POBJ(rknoop));
                if(ret)
#ifndef E2BIG
                    sprintf(klad,"%d",ret);
#else
                    switch(errno)
                        {
                        case E2BIG:
                            /*
                            Argument list (which is system-dependent) is too big.
                            */
                            strcpy(klad,"E2BIG");
                            break;
                        case ENOENT:
                            /*
                            Command interpreter cannot be found.
                            */
                            strcpy(klad,"ENOENT");
                            break;
                        case ENOEXEC:
                            /*
                            Command-interpreter file has invalid format and is not executable.
                            */
                            strcpy(klad,"ENOEXEC");
                            break;
                        case ENOMEM:
                            /*
                            Not enough memory is available to execute command; or available
                            memory has been corrupted; or invalid block exists, indicating
                            that process making call was not allocated properly.
                            */
                            strcpy(klad,"ENOMEM");
                            break;
                        default:
                            sprintf(klad,"%d",errno);
                            break;
                        }
#endif
                else
                    strcpy(klad,"0");
                *pkn = opb(*pkn,klad,NULL);
                return built_in_function_ok;
                }
            }
#endif
        CASE(TBL) /* tbl$(varnaam,lengte) */
            {
            if(is_op(rknoop))
                return psh(rknoop->LEFT,&nulk,rknoop->RIGHT) ? built_in_function_ok : function_fail;
            else
                return function_fail;
            }
        CASE(PRV) /* "?"$<expr> */
            {
            if((rknoop->v.fl & SUCCESS)
            && (is_op(rknoop) || rknoop->u.obj || HAS_UNOPS(rknoop)))
                insert(&nilk,rknoop);
            *pkn = rechtertak(*pkn);
            return built_in_function_ok;
            }
        CASE(CLK) /* clk' */
            {
            clock_t time = clock();
#ifdef DELAY_DUE_TO_INPUT
            time -= delayDueToInput;
#endif
            print_clock(klad,time);
            *pkn = opb(*pkn,klad,NULL);
            return built_in_function_ok;
            }

        CASE(SIM) /* sim$(<atoom>,<atoom>) , fuzzy compare (percentage) */
            {
            if(kop(rknoop) == KOMMA
            && !is_op(rlknoop = rknoop->LEFT)
            && !is_op(rrknoop = rknoop->RIGHT))
                {
                char *str1,*str2;
                str1 = (char *)POBJ(rlknoop);
                str2 = (char *)POBJ(rrknoop);
                sprintf(klad,"%ld/%ld",
           (2L*(long)simil(str1,str2)),((long)strlen(str1) + (long)strlen(str2)));
                *pkn = opb(*pkn,klad,NULL);
                return built_in_function_ok;
                }
            else
                return function_fail;
            }
        CASE(DBG) /* dbg$<expr> */
            {
            ++debug;
            if(kop(*pkn) != FUU)
                {
                errorprintf("Use dbg'(expression), not dbg$(expression)!\n");
                writeError(*pkn);
                }
            *pkn = rechtertak(*pkn);
            evalueer(pkn);
            --debug;
            return built_in_function_ok;
            }
        CASE(WHL) /*20080127*/
            {
            psk kn;
            while( (kn = zelfde_als_w((*pkn)->RIGHT))
                 , (evalueer(&kn) & (TRUE|FENCE))
                 )
                {
                wis(kn);
                }
            wis(kn);
            return built_in_function_ok; // 20080211 function_fail -> built_in_function_ok
            }
#ifdef TIL
        CASE(TIL) /*20080127*/
            {
            psk kn;
            while( (kn = zelfde_als_w((*pkn)->RIGHT))
                 , !(evalueer(&kn) & (TRUE|FENCE))
                 )
                {
                wis(kn);
                }
            wis(*pkn);
            *pkn = kn;
            return built_in_function_ok;
            }
#endif
        CASE(New) /* new$<object>*/
            {
            if(kop(rknoop) == KOMMA)
                {
                adr[2] = getObjectDef(rknoop->LEFT);
                if(!adr[2])
                    return function_fail;
                adr[3] = rknoop->RIGHT;
                if(ISBUILTIN((objectknoop*)adr[2]))
                    *pkn = opb(*pkn,"(((\2.New)'\3)|)",NULL);
    /*                *pkn = opb(*pkn,"(((\2.New)'\3)&(\2.new)'\3)|)&\2",NULL);*/
    /* We might be able to call 'new' if 'New' had attached the argument
        (containing the definition of a 'new' method) to the rhs of the '='.
       This cannot be done in a general way without introducing new syntax rules for the new$ function.
    */
                else
                    *pkn = opb(*pkn,"(((\2.new)'\3)|)&\2",NULL);
                }
            else
                {
                adr[2] = getObjectDef(rknoop);
                if(!adr[2])
                    return function_fail;
                if(ISBUILTIN((objectknoop*)adr[2]))
                    *pkn = opb(*pkn,"(((\2.New)')|)",NULL);
                /* There cannot be a user-defined 'new' method on a built-in object if there is no way to supply it*/
                /* 'die' CAN be user-supplied. The built-in function is 'Die' */
                else
                    *pkn = opb(*pkn,"(((\2.new)')|)&\2",NULL);
                }
            SETCREATEDWITHNEW((objectknoop*)adr[2]);
            wis(adr[2]);
            return built_in_function_ok;
            }
        CASE(0) /* $<expr>  '<expr> */
            {
            if(kop(*pkn) == FUU && !HAS_UNOPS((*pkn)->LEFT))
                {
                if(!evalmacro(&((*pkn)->RIGHT)))
                    return function_fail;
                adr[1] = (*pkn)->RIGHT;
                *pkn = opb(*pkn,"=\1",NULL);
                }
            else
                {
                combiflags(*pkn);
                *pkn = rechtertak(*pkn);
                }
            return built_in_function_ok;
            }
        DEFAULT
            {
    /*        int dummy;*/
            if(INTEGER(lknoop))
                {
                vars *navar;
                if(is_op(rknoop))
                    return function_fail;
                for(navar = variabelen[rknoop->u.obj];
                    navar && (STRCMP(VARNAME(navar),POBJ(rknoop)) < 0);
                    navar = navar->next);
                /* eerste naam in een rij gelijke wordt gevonden */
                if(navar && !STRCMP(VARNAME(navar),POBJ(rknoop)))
                    {
                    navar->selector =
                       (int)toLong(lknoop)
                     % (navar->n + 1);
                    if(navar->selector < 0)
                        navar->selector += (navar->n + 1);
                    *pkn = rechtertak(*pkn);
                    return built_in_function_ok;
                    }
                }
            if(!(rknoop->v.fl & SUCCESS))
                return function_fail;
            adr[1] = NULL;
            return find_func(pkn);
            }
        }
        }
    /*return built_in_function_ok; 20 Dec 1995, unreachable code in Borland C */
    }

static int machtbuitenhaakjes(ppsk pkn)
    {
    psk lknoop;
    lknoop = (*pkn)->LEFT;
    if(kop(lknoop) == MAAL)
        {
        adr[1] = lknoop->LEFT;
        adr[2] = lknoop->RIGHT;
        adr[3] = (*pkn)->RIGHT;
        *pkn = opb(*pkn,"\1^\3*\2^\3",NULL);
        return TRUE;
        }
    return FALSE;
    }



/*
Bart 20010316
Improvement that DOES evaluate b+(i*c+i*d)+-i*c
It also allows much deeper structures, because the right place for insertion
is found iteratively, not recursively. This also causes some operations to
be tremendously faster. e.g. (1+a+b+c)^30+1&ready evaluates in about
4,5 seconds now, previously in 330 seconds! (AST Bravo MS 5233M 233 MHz MMX Pentium)
*/
static void splitProduct_number_im_rest(psk pknoop,ppsk N,ppsk I, ppsk NNNI)
    {
    psk temp;
    if(kop(pknoop) == MAAL)
        {
        if(RATIONAAL_COMP(pknoop->LEFT))
            {
            *N = pknoop->LEFT;
            temp = pknoop->RIGHT;
            }
        else
            {
            *N = NULL;
            temp = pknoop;
            }
        if(kop(temp) == MAAL)
            {
            if(!is_op(temp->LEFT) && PLOBJ(temp->LEFT) == IM)
                {
                *I = temp->LEFT;
                *NNNI = temp->RIGHT;
                }
            else
                {
                *I = NULL;
                *NNNI = temp;
                }
            }
        else
            {
            if(!is_op(temp) && PLOBJ(temp) == IM)
                {
                *I = temp;
                *NNNI = NULL;
                }
            else
                {
                *I = NULL;
                *NNNI = temp;
                }
            }
        }
    else if(RATIONAAL_COMP(pknoop))
        {
        *N = pknoop;
        *I = NULL;
        *NNNI = NULL;
        }
    else if(!is_op(pknoop) && PLOBJ(pknoop) == IM)
        {
        *N = NULL;
        *I = pknoop;
        *NNNI = NULL;
        }
    else
        {
        *N = NULL;
        *I = NULL;
        *NNNI = pknoop;
        }
    }

static void rechteroperand_and_tail(psk pkn,ppsk head,ppsk tail)
    {
    psk temp = pkn->RIGHT;
    if(kop(pkn) == kop(temp))
        {
        *head = temp->LEFT;
        *tail = temp->RIGHT;
        }
    else
        {
        *head = temp;
        *tail = NULL;
        }
    }

static void linkeroperand_and_tail(psk pkn,ppsk head,ppsk tail)
    {
    psk temp = pkn->LEFT;
    if(kop(pkn) == kop(temp))
        {
        *head = temp->LEFT;
        *tail = temp->RIGHT;
        }
    else
        {
        *head = temp;
        *tail = NULL;
        }
    }

static int expandProduct(ppsk pkn)
    {
    switch(kop(*pkn))
        {
        case MAAL :
        case EXP  :
            {
            int len = expressionLength(*pkn);
            if((match(0,*pkn,m0,NULL,0,len) & TRUE && tryq(pkn,f0))
            || (match(0,*pkn,m1,NULL,0,len) & TRUE && tryq(pkn,f1)))
                {
                (*pkn)->v.fl &= ~READY;
                return TRUE;
                }
            }
        }
    return FALSE;
    }

static int plus_samenvoegen_of_sorteren(ppsk pkn)
    {
    /*
    Split pkn in left L and right R argument

    If L is zero,
        return R

    If R is zero,
        return L

    If L is a product containing a sum,
        expand it

    If R is a product containing a sum,
        expand it

    Find the proper place split of R into Rhead , RtermS,  RtermGE and Rtail for L to insert into:
        L + R -> Rhead + RtermS + L + RtermGE + Rtail:
    Start with Rhead = NIL, RtermS = NIL  RtermGE is first term of R and Rtail is remainder of R
    Split L into Lterm and Ltail
    If Lterm is a number
        if RtermGE is a number
            return sum(Lterm,RtermGE) + Ltail + Rtail
        else
            return Lterm + Ltail + R
    Else if Rterm is a number
        return Rterm + L + Rtail
    Else
        get the non-numerical factor LtermNN of Lterm
        if LtermNN is imaginary
            get the nonimaginary factors of LtermNN (these may also include 'e' and 'pi') LtermNNNI
            find Rhead,  RtermS, RtermGE and Rtail
                such that Rhead does contain all non-imaginary terms
                and such that RtermGE and Rtail
                    either are NIL
                    or RtermGE is imaginary
                        and (RtermS is NIL or RtermSNNNI <  LtermNNNI) and LtermNNNI <= RtermGENNNI
            if RtermGE is NIL
                return R + L
            else
                if LtermNNNI < RtermGENNNI
                    return Rhead + RtermS + L + RtermGE + Rtail
                else
                    return Rhead + RtermS + sum(L,RtermGE) + Rtail
        else
            find Rhead,  RtermS, RtermGE and Rtail
                such that RtermGE and Rtail
                    either are NIL
                    or (RtermS is NIL or RtermSNN <  LtermNN) and LtermNN <= RtermGENN
            if RtermGE is NIL
                return R + L
            else
                if LtermNN < RtermGENN
                    return Rhead + RtermS + L + RtermGE + Rtail
                else
                    return Rhead + RtermS + sum(L,RtermGE) + Rtail


    */
    static const char *conc[] = {NULL,NULL,NULL,NULL};
    int res = FALSE;
    psk top = *pkn;

    psk L = top->LEFT;
    psk Lterm,Ltail;
    psk LtermN,LtermI,LtermNNNI;

    psk R;
    psk Rterm,Rtail;
    psk RtermN,RtermI,RtermNNNI;

    if(!is_op(L) && RAT_NUL_COMP(L))
        {
        /* 0+x -> x */
        *pkn = rechtertak(top);
        return TRUE;
        }

    R = top->RIGHT;
    if(!is_op(R) && RAT_NUL_COMP(R))
        {
        /* x+0 -> x */
        *pkn = linkertak(top);
        return TRUE;
        }

    if(  is_op(L)
      && expandProduct(&top->LEFT)
      )
        {
        res = TRUE;
        }

    if(  is_op(R)
      && expandProduct(&top->RIGHT)
      )
        {
        res = TRUE;
        }

    if(res)
        {
        (*pkn)->v.fl &= ~READY;
        return TRUE;
        }

    rechteroperand_and_tail(top,&Rterm,&Rtail);
    linkeroperand_and_tail(top,&Lterm,&Ltail);
    if(RATIONAAL_COMP(Lterm))
        {
        if(RATIONAAL_COMP(Rterm))
            {
            conc[0] = hekje6;
            if(Lterm == Rterm)
                /* 7+7 -> 2*7 */
                adr[6] = _qmaal(&tweek,Rterm);
            else
                {
                /* 4+7 -> 11 */
                adr[6] = _qplus(Lterm,Rterm);
                }
            if(Ltail != NULL)
                {
                adr[5] = Ltail;
                conc[1] = "+\5";
                }
            else
                conc[1] = NULL;
            conc[2] = NULL;
            if(Rtail != NULL)
                {
                adr[4] = Rtail;
                conc[Ltail == NULL ? 1 : 2] = "+\4";
                }
            *pkn = vopb(top,conc);
            wis(adr[6]);
            return TRUE;
            }
        else if(Ltail != NULL)
            {
            adr[1] = Lterm;
            adr[2] = Ltail;
            adr[3] = R;
            *pkn = opb(top,"\1+\2+\3",NULL);
            return TRUE;
            }
        return res;
        }
    else if(RATIONAAL_COMP(Rterm))
        {
        adr[1] = Rterm;
        adr[2] = L;
        if(Rtail)
            {
            adr[3] = Rtail;
            *pkn = opb(top,"\1+\2+\3",NULL);
            }
        else
            {
            *pkn = opb(top,"\1+\2",NULL);
            }
        return TRUE;
        }

    if(  kop(Lterm) == LOG
      && kop(Rterm) == LOG
      && !vgl(Lterm->LEFT,Rterm->LEFT)
      )
        {
        adr[1] = Lterm->LEFT;
        adr[2] = Lterm->RIGHT;
        adr[3] = Rterm->RIGHT;
        if(Rtail == NULL)
            *pkn = opb(top,"\1\016(\2*\3)",NULL);
        else
            {
            adr[4] = Rtail;
            *pkn = opb(top,"\1\016(\2*\3)+\4",NULL);
            }
        return TRUE;
        }

    splitProduct_number_im_rest(Lterm,&LtermN,&LtermI,&LtermNNNI);

    if(LtermI)
        {
        ppsk loper = pkn;
        assert(LtermNNNI != NULL);
        splitProduct_number_im_rest(Rterm,&RtermN,&RtermI,&RtermNNNI);
        while(  /*RtermNNNI != NULL
             &&*/ RtermI == NULL
/*
             && (dif = vgl(LtermNNNI,RtermNNNI)) > 0
*/
             && kop((*loper)->RIGHT) == PLUS
             )
            {
            loper = &(*loper)->RIGHT;
            *loper = prive(*loper);
            rechteroperand_and_tail((*loper),&Rterm,&Rtail);
            splitProduct_number_im_rest(Rterm,&RtermN,&RtermI,&RtermNNNI);
            }
        if(RtermI != NULL)
            {
            int indx;
            int dif;
            if(LtermNNNI == NULL)
                dif = RtermNNNI == NULL ? 0 : -1;
            else if(RtermNNNI == NULL)
                dif = 1;
            else
                while( (dif = vgl(LtermNNNI,RtermNNNI)) > 0
                     && kop((*loper)->RIGHT) == PLUS
                     )
                    {
                    loper = &(*loper)->RIGHT;
                    *loper = prive(*loper);
                    rechteroperand_and_tail((*loper),&Rterm,&Rtail);
                    splitProduct_number_im_rest(Rterm,&RtermN,&RtermI,&RtermNNNI);
                    }
            if(dif == 0)
                {
                if(RtermN)
                    {
                    adr[2] = RtermN;
                    if(LtermN == NULL)
                        {
                        /* a+n*a */
                        if(HAS_MINUS_SIGN(LtermI))
                            if(HAS_MINUS_SIGN(RtermI))
                                {
                                conc[0] = "(1+\2)*-i";
                                }
                            else
                                {
                                conc[0] = "(-1+\2)*i";
                                }
                        else
                            if(HAS_MINUS_SIGN(RtermI))
                                {
                                conc[0] = "(-1+\2)*-i";
                                }
                            else
                                {
                                conc[0] = "(1+\2)*i";
                                }
                        }
                    /* (1+n)*a */
                    else
                        {
                        /* n*a+m*a */
                        adr[3] = LtermN;
                        if(HAS_MINUS_SIGN(LtermI))
                            if(HAS_MINUS_SIGN(RtermI))
                                {
                                conc[0] = "(\3+\2)*-i";
                                }
                            else
                                {
                                conc[0] = "(-1*\3+\2)*i";
                                }
                        else
                            if(HAS_MINUS_SIGN(RtermI))
                                {
                                conc[0] = "(\3+-1*\2)*i";
                                }
                            else
                                {
                                conc[0] = "(\3+\2)*i";
                                }
                        /* (n+m)*a */
                        }
                    }
                else
                    {
                    adr[1] = LtermNNNI;
                    if(LtermN != NULL)
                        {
                        /* m*a+a */
                        adr[2] = LtermN;
                        if(HAS_MINUS_SIGN(LtermI))
                            if(HAS_MINUS_SIGN(RtermI))
                                {
                                conc[0] = "(1+\2)*-i";
                                }
                            else
                                {
                                conc[0] = "(-1+\2)*-i";
                                }
                        else
                            if(HAS_MINUS_SIGN(RtermI))
                                {
                                conc[0] = "(-1+\2)*i";
                                }
                            else
                                {
                                conc[0] = "(1+\2)*i";
                                }
                        /* (1+m)*a */
                        }
                    else
                        {
                        /* a+a */
                        if(HAS_MINUS_SIGN(LtermI))
                            if(HAS_MINUS_SIGN(RtermI))
                                {
                                conc[0] = "2*-i";
                                }
                            else
                                {
                                conc[0] = "0";
                                }
                        else
                            if(HAS_MINUS_SIGN(RtermI))
                                {
                                conc[0] = "0";
                                }
                            else
                                {
                                conc[0] = "2*i";
                                }
                        }
                    /* 2*a */
                    }
                if(LtermNNNI != NULL)
                    {
                    adr[1] = RtermNNNI;
                    conc[1] = "*\1";
                    indx = 2;
                    }
                else
                    indx = 1;
                if(Ltail != NULL)
                    {
                    adr[5] = Ltail;
                    conc[indx++] = "+\5";
                    }
                if(Rtail != NULL)
                    {
                    adr[4] = Rtail;
                    conc[indx++] = "+\4";
                    }
                conc[indx] = NULL;
                (*loper)->RIGHT = vopb((*loper)->RIGHT,conc);
                /*evalueer(&loper->RIGHT);*/
                if(loper != pkn)
                    {
                    (*loper)->v.fl &= ~READY;
                    evalueer(loper);
                    }
                *pkn = rechtertak(top);
                return TRUE;
                }
            else if(dif > 0) /* b + a */
                {
                adr[1] = Rterm;
                adr[2] = L;
                (*loper)->RIGHT = opb((*loper)->RIGHT,"\1+\2",NULL);
                (*loper)->RIGHT->v.fl |= READY;
                /*
                evalueer(&(*loper)->RIGHT);
                */
                *pkn = rechtertak(top);
                return TRUE;
                }
            else if((*loper) != top) /* b + a + c */
                {
                adr[1] = L;
                adr[2] = (*loper)->RIGHT;
                (*loper)->RIGHT = opb((*loper)->RIGHT,"\1+\2",NULL);
                evalueer(&(*loper)->RIGHT);
                *pkn = rechtertak(top);
                return TRUE;
                }
            else if(Ltail != NULL) /* (a+c+f)+b+d+g */
                {
                adr[1] = Lterm;
                adr[2] = Ltail;
                adr[3] = top->RIGHT;
                *pkn = opb(top,"\1+\2+\3",NULL);
                return TRUE;
                }
            }
        else  /* LtermI != NULL && RtermI == NULL */
            {
            adr[1] = Rterm; /* (*loper)->RIGHT; */
            adr[2] = L;
            (*loper)->RIGHT = opb((*loper)->RIGHT,"\1+\2",NULL);
            (*loper)->RIGHT->v.fl |= READY;
            /*
            evalueer(&(*loper)->RIGHT);
            */
            *pkn = rechtertak(top);
            return TRUE;
            }
        }
    else /* LtermI == NULL */
        {
        ppsk loper = pkn;
        int dif = 1;
        assert(LtermNNNI != NULL);
        splitProduct_number_im_rest(Rterm,&RtermN,&RtermI,&RtermNNNI);
        while(  RtermNNNI != NULL
             && RtermI == NULL
             && (dif = vgl(LtermNNNI,RtermNNNI)) > 0
             && kop((*loper)->RIGHT) == PLUS
             )
            {
            loper = &(*loper)->RIGHT;
            *loper = prive(*loper);
            rechteroperand_and_tail((*loper),&Rterm,&Rtail);
            splitProduct_number_im_rest(Rterm,&RtermN,&RtermI,&RtermNNNI);
            }
        if(RtermI != NULL)
            dif = -1;
        if(dif == 0)
            {
            if(RtermN)
                {
                adr[1] = RtermNNNI;
                adr[2] = RtermN;
                if(LtermN == NULL)
                    /* a+n*a */
                    conc[0] = "(1+\2)*\1";
                /* (1+n)*a */
                else
                    {
                    /* n*a+m*a */
                    adr[3] = LtermN;
                    conc[0] = "(\3+\2)*\1";
                    /* (n+m)*a */
                    }
                }
            else
                {
                adr[1] = LtermNNNI;
                if(LtermN != NULL)
                    {
                    /* m*a+a */
                    adr[2] = LtermN;
                    conc[0] = "(1+\2)*\1";
                    /* (1+m)*a */
                    }
                else
                    /* a+a */
                    conc[0] = "2*\1";
                /* 2*a */
                }
            if(Ltail != NULL)
                {
                adr[5] = Ltail;
                conc[1] = "+\5";
                }
            else
                conc[1] = NULL;
            conc[2] = NULL;
            if(Rtail != NULL)
                {
                adr[4] = Rtail;
                conc[Ltail == NULL ? 1 : 2] = "+\4";
                }
            (*loper)->RIGHT = vopb((*loper)->RIGHT,conc);
            /*evalueer(&loper->RIGHT);*/
            if(loper != pkn)
                {
                (*loper)->v.fl &= ~READY;
                evalueer(loper);
                }
            *pkn = rechtertak(top);
            return TRUE;
            }
        else if(dif > 0) /* b + a */
            {
            adr[1] = Rterm;
            adr[2] = L;
            (*loper)->RIGHT = opb((*loper)->RIGHT,"\1+\2",NULL);
            (*loper)->RIGHT->v.fl |= READY;
            /*evalueer(&(*loper)->RIGHT);*/
            *pkn = rechtertak(top);
            return TRUE;
            }
        else if((*loper) != top) /* b + a + c */
            {
            adr[1] = L;
            adr[2] = (*loper)->RIGHT;
            (*loper)->RIGHT = opb((*loper)->RIGHT,"\1+\2",NULL);
            evalueer(&(*loper)->RIGHT);
            *pkn = rechtertak(top);
            return TRUE;
            }
        else if(Ltail != NULL) /* (a+c+f)+b+d+g */
            {
            adr[1] = Lterm;
            adr[2] = Ltail;
            adr[3] = top->RIGHT;
            *pkn = opb(top,"\1+\2+\3",NULL);
            return TRUE;
            }
        }
    return res;
    }

static int maal_samenvoegen_of_sorteren(ppsk pkn)
{
static char *conc[] = {NULL,NULL,NULL,NULL};
psk temp,iknoop,rechtsknoop,linksknoop,llknoop,rlknoop;
int knverschil;
iknoop = *pkn;
rechtsknoop = rechteroperand(*pkn);
linksknoop = iknoop->LEFT;
rlknoop = kop(rechtsknoop) == EXP ? rechtsknoop->LEFT : rechtsknoop;
llknoop = kop(linksknoop) == EXP ? linksknoop->LEFT : linksknoop;
if((knverschil = vgl(llknoop,rlknoop)) == 0)
    {
    /* a^n*a^m */
    if(rlknoop != rechtsknoop)
        {
        adr[1] = rlknoop;
        adr[2] = rechtsknoop->RIGHT;
        if(llknoop == linksknoop)
            /* a*a^n */
            conc[0] = "\1^(1+\2)";
            /* a^(1+n) */
        else
            {
            /* a^n*a^m */
            adr[3] = linksknoop->RIGHT;
            conc[0] = "\1^(\3+\2)";
            /* a^(n+m) */
            }
        }
    else
        {
        if(llknoop != linksknoop)
            {
            /* a^m*a */
            adr[1] = llknoop;
            adr[2] = linksknoop->RIGHT;
            conc[0] = "\1^(1+\2)";
            /* a^(m+1) */
            }
        else
            {
            /* a*a */
            adr[1] = llknoop;
            conc[0] = "\1^2";
            /* a^2 */
            }
        }
    if(rechtsknoop != (temp = iknoop->RIGHT))
        {
        adr[4] = temp->RIGHT;
        conc[1] = "*\4";
        }
    else
        conc[1] = NULL;
    *pkn = vopb(*pkn,(const char **)conc);
    return TRUE;
    }
else
    {
    int graad;
    graad = getal_graad(rlknoop) - getal_graad(llknoop);
    if(graad > 0
    || (graad == 0 && (knverschil > 0)))
        {
        /* b^n*a^m */
        /* l^n*a^m */
        if((temp = iknoop->RIGHT) == rechtsknoop)
            {
            iknoop->RIGHT = linksknoop;
            iknoop->LEFT = rechtsknoop;
            iknoop->v.fl &= ~READY;
            }
        else
            {
            adr[1] = linksknoop;
            adr[2] = temp->LEFT;
            adr[3] = temp->RIGHT;
            *pkn = opb(*pkn,"\2*\1*\3",NULL);
            }
        return TRUE;
        /* a^m*b^n */
        /* a^m*l^n */
        }
    else if(PLOBJ(rlknoop) == IM)
        {
        if(PLOBJ(llknoop) == IM)
            {
            /* i^n*-i^m */
            if(rlknoop != rechtsknoop)
                {
                adr[1] = llknoop;
                adr[2] = rechtsknoop->RIGHT;
                if(llknoop == linksknoop)
                    /* i*-i^n */
                    conc[0] = "\1^(1+-1*\2)";
                    /* i^(1-n) */
                else
                    {
                    /* i^n*-i^m */
                    adr[3] = linksknoop->RIGHT;
                    conc[0] = "\1^(\3+-1*\2)";
                    /* i^(n-m) */
                    }
                }
            else
                {
                if(llknoop != linksknoop)
                    {
                    /* i^m*-i */
                    adr[1] = llknoop;
                    adr[2] = linksknoop->RIGHT;
                    conc[0] = "\1^(-1+\2)";
                    /* i^(m-1) */
                    }
                else
                    {
                    /* i*-i */
                    conc[0] = "1";
                    /* 1 */
                    }
                }
            }
        else if(RAT_NEG_COMP(llknoop))
            {
            /* -n*i^m -> n*-i^(2+m) */
            /* -n*-i^m -> n*i^(2+m) */
            if(rlknoop != rechtsknoop)
                {
                adr[1] = llknoop;
                adr[2] = rechtsknoop->LEFT;
                adr[3] = rechtsknoop->RIGHT;
                adr[4] = &tweek;
                if(llknoop == linksknoop)
                    conc[0] = "(-1*\1)*\2^(\3+\4)";
                else
                    return FALSE;
                }
            else
                return FALSE;
            }
        else
            return FALSE;
        if(rechtsknoop != (temp = iknoop->RIGHT))
            {
            adr[4] = temp->RIGHT;
            conc[1] = "*\4";
            }
        else
            conc[1] = NULL;
        *pkn = vopb(*pkn,(const char **)conc);
        return TRUE;
        }
    }
return FALSE;
}

static int rechtsbrengen(psk kn)
    {
    psk lknoop;
    register int gedaan;
    gedaan = FALSE;
    for(;kop(lknoop = kn->LEFT) == kop(kn);)
        {
        lknoop = prive(lknoop);
        lknoop->v.fl &= ~READY;
        kn->LEFT = lknoop->LEFT;
        lknoop->LEFT = lknoop->RIGHT;
        lknoop->RIGHT = kn->RIGHT;
        kn->v.fl &= ~READY;
        kn->RIGHT = lknoop;
        kn = lknoop;
        gedaan = TRUE;
        }
    return gedaan;
    }

static int stapelmacht(ppsk pkn)
{
psk lknoop;
int gedaan;
gedaan = FALSE;
for(;((lknoop = (*pkn)->LEFT)->v.fl & READY) && kop(lknoop) == EXP;)
    {
    gedaan = TRUE;
    (*pkn)->LEFT = lknoop = prive(lknoop);
    lknoop->v.fl &= ~READY & ~OPERATOR;/* READY vlag uitzetten */
    lknoop->ops |= MAAL;
    adr[1] = lknoop->LEFT;
    adr[2] = lknoop->RIGHT;
    adr[3] = (*pkn)->RIGHT;
    *pkn = opb(*pkn,"(\1^(\2*\3))",NULL);
    }
return gedaan;
}

static int substmaal(ppsk pkn)
{
static const char * conc[] = {NULL,NULL,NULL};
psk rkn,lkn;
psk rvar,lvar;

if(is_op(rkn = rechteroperand(*pkn)))
    rvar = NULL;
else
    {
    if(RAT_NUL(rkn))
        {
        replace(pkn,&nulk);
        return TRUE;
        }
    rvar = rkn;
    }

if(is_op(lkn = (*pkn)->LEFT))
    return FALSE;
else
    {
    if(RAT_NUL(lkn))
        {
        replace(pkn,&nulk);
        return TRUE;
        }
    lvar = lkn;
    }

if(IS_EEN(lkn))
    {
    *pkn = rechtertak(*pkn);
    return TRUE;
    }
else if(RATIONAAL_COMP(lkn) && rvar)
    {
    if(RATIONAAL_COMP(rkn))
        {
        if(rkn == lkn)
            lvar = ((*pkn)->LEFT = prive(lkn));
        conc[0] = hekje6;
        adr[6] = _qmaal(rvar,lvar);
        if(rkn == (*pkn)->RIGHT)
            conc[1] = NULL;
        else
            {
            adr[1] = (*pkn)->RIGHT->RIGHT;
            conc[1] = "*\1";
            }
        *pkn = vopb(*pkn,conc);
        wis(adr[6]);
        return TRUE;
        }
    else
        {
        if(PLOBJ(rkn) == IM && RAT_NEG_COMP(lkn))
            {
            conc[0] = "(\2*\3)";
            adr[2] = _qmaalmineen(lkn);
            adr[3] = _qmaalmineen(rkn);
            if(rkn == (*pkn)->RIGHT)
                conc[1] = NULL;
            else
                {
                adr[1] = (*pkn)->RIGHT->RIGHT;
                conc[1] = "*\1";
                }
            *pkn = vopb(*pkn,conc);
            wis(adr[2]);
            wis(adr[3]);
            return TRUE;
            }
        else
            return FALSE;
        }
    }
else
    return FALSE;
/*
return TRUE;
*/
}

static void numboom(ppsk pkn,psk lknoop,const char *conc[])
{
if(lknoop == (*pkn)->LEFT)
    *pkn = vopb(*pkn,conc+2);
else
    {
    conc[0] = hekje1;
    adr[1] = (*pkn)->LEFT->LEFT;
    *pkn = vopb(*pkn,conc);
    }
}

/*
static int unevenDenominator(psk kn)
    {
    unsigned char *p = POBJ(kn);
    return (p[strlen((char *)p)-1] - '0') & 1;
    }
*/

static int substmacht(ppsk pkn)
{

static const char *conc[] = {NULL,NULL,NULL,NULL};

Qgetal iexponent,
hiexponent;

psk lknoop,rknoop;
if(!is_op(rknoop = (*pkn)->RIGHT))
    {
    if(RAT_NUL(rknoop))
        {
        replace(pkn,&eenk);
        return TRUE;
        }
    if(IS_EEN(rknoop))
        {
        *pkn = linkertak(*pkn);
        return TRUE;
        }
    }

if(is_op(lknoop = (*pkn)->LEFT))
    {
    return FALSE;
    }

if((RAT_NUL(lknoop) && /*20080910*/!RAT_NEG_COMP(rknoop)) || IS_EEN(lknoop))
    {
    *pkn = linkertak(*pkn);
    return TRUE;
    }

if(is_op(rknoop) || !RATIONAAL_COMP(rknoop))
    {
    return FALSE;
    }

if(RATIONAAL_COMP(lknoop))
    {
    if(RAT_NEG_COMP(rknoop) && abseen(rknoop))
        {
        conc[2] = hekje6;
        adr[6] = _q_qdeel(&eenk,lknoop);
        numboom(pkn,lknoop,conc);
        wis(adr[6]);
        return TRUE;
        }
    else
        if(RAT_NEG_COMP(lknoop) && RAT_RAT_COMP(rknoop))
            {
#if 0 /* Bart 19980331 Dit ziet er raar uit! */
            if(unevenDenominator(rknoop))
                /* (-3/4)^5/3  -->  -1*(-3/4*-1)^5/3 */
                conc[2]="-1*(\2*-1)^\3";
            else
                {
                return TRUE;
                }
                /* (-3/4)^5/6  -->  (-3/4*-1)^5/6*i^(2*5/6) */
            /*    conc[2]="(\2*-1)^\3*i^(2*\3)";*/
            /* notice: according to this algorithm,
                 f(x) = {(-7)^x | x in R} is not continuous !
               However, it would be distressing to return
               (-1)^1/3 = i^2/3
               instead of
               (-1)^1/3 = -1
               Even worse, (-1*i)^1/3 would result in i, whereas
                           ( 1*i)^1/3 would result in i^1/3, which
               is not the complex conjugate of i.
               With the chosen algorithm, we have
               (-1*i)^1/3 = i^1/3
               ( 1*i)^1/3 = i^1/3
               and
               (-1*i)^5/6 = i^5/3*i^5/6 = i^15/6
               ( 1*i)^5/6 =               i^ 5/6
               which is still undesirable, as it leaves (-i)^5/6+i^5/6
               with an imaginary part.
            */
            adr[2] = lknoop;
            adr[3] = rknoop;
            numboom(pkn,lknoop,conc);
#endif
            return TRUE;
            }
        else
            {
            /* hier ontbreekt n^m, met m > 2.
               Dit wordt in casemacht behandeld. */
            return FALSE;
            }
    }

if(PLOBJ(lknoop) == IM)
    {
    if(_qvergelijk(rknoop,&nulk) & MINUS)
        { /* i^-n -> -i^n */
          /* -i^-n -> i^n */
        conc[0] = "(\2^\3)";
        adr[2] = _qmaalmineen(lknoop);
        adr[3] = _qmaalmineen(rknoop);
        conc[1] = NULL;
        *pkn = vopb(*pkn,conc);
        wis(adr[2]);
        wis(adr[3]);
        return TRUE;
        }
    else if(_qvergelijk(&tweek,rknoop) & (QNUL|MINUS))
        {
        iexponent = _qmodulo(rknoop,&vierk);
        if(iexponent->ops & QNUL)
            replace(pkn,&eenk);
        else
            {
            int teken;
            teken = _qvergelijk(iexponent,&tweek);
            if(teken & QNUL)
                replace(pkn,&mineenk);
            else
                {
                if(!(teken & MINUS))
                    {
                    hiexponent = _qmaalmineen(iexponent);
                    wis(iexponent);
                    iexponent = _qplus(hiexponent,&vierk);
                    wis(hiexponent);
                    }
                adr[2] = lknoop;
                adr[6] = iexponent;
                conc[0] = "(-1*\2)^";
                conc[1] = "(\6)";/*hekje6;*/
                *pkn = vopb(*pkn,conc);
                }
            }
        wis(iexponent);
        return TRUE;
        }
    }
return FALSE;
}

static int substlog(ppsk pkn)
{
static const char *conc[] = {NULL,NULL,NULL,NULL};
psk lknoop,rknoop;
if(is_op(rknoop = (*pkn)->RIGHT))
    {
    if(!vgl((*pkn)->LEFT,rknoop))
        {
        replace(pkn,&eenk);
        return TRUE;
        }
    else
        return FALSE;
    }
if(is_op(lknoop = (*pkn)->LEFT))
    return FALSE;

if(RATIONAAL_COMP(lknoop) && RATIONAAL_COMP(rknoop))
    {
    if(_qvergelijk(rknoop,lknoop) & QNUL)
        {
        replace(pkn,&eenk);
        return TRUE;
        }
    }
else if(!vgl((*pkn)->LEFT,rknoop))
    {
    replace(pkn,&eenk);
    return TRUE;
    }

if(IS_EEN(rknoop))
    {
    replace(pkn,&nulk);
    return TRUE;
    }
else
    {
    if(RATIONAAL_COMP(rknoop))
        {
        if(_qvergelijk(rknoop,&nulk) & MINUS)
            {
            /* (nL-m = i*pi/eLn+nLm)  */
            adr[1] = lknoop;
            adr[2] = rknoop;
            *pkn = opb(*pkn,"(i*pi*e\016\1^-1+\1\016(-1*\2))",NULL);
            return TRUE;
            }
        else if(RATIONAAL(lknoop))
            {
            if(_qvergelijk(lknoop,&eenk) & MINUS)
                {
                /* (1/n)Lm = -1*nLm */
                adr[1] = rknoop;
                conc[0] = "(-1*";
                conc[1] = hekje6;
                adr[6] = _q_qdeel(&eenk,lknoop);
                conc[2] = "L\1)";
                *pkn = vopb(*pkn,conc);
                wis(adr[6]);
                return TRUE;
                }
            else if(_qvergelijk(lknoop,rknoop) & MINUS)
                {
                /* nLm = 1+nL(m/n) */
                conc[0] = "(1+\1\016";
                if(lknoop == rknoop)
                    rknoop = (*pkn)->RIGHT = prive(rknoop);
                adr[1] = lknoop;
                conc[1] = hekje6;
                adr[6] = _q_qdeel(rknoop,lknoop);
                conc[2] = ")";
                *pkn = vopb(*pkn,conc);
                wis(adr[6]);
                return TRUE;
                }
            else if(_qvergelijk(rknoop,&eenk) & MINUS)
                {
                /* nLm = -1+nL(m*n) */
                conc[0] = "(-1+\1\016";
                if(lknoop == rknoop)
                    rknoop = (*pkn)->RIGHT = prive(rknoop);
                adr[1] = lknoop;
                conc[1] = hekje6;
                adr[6] = _qmaal(rknoop,lknoop);
                conc[2] = ")";
                *pkn = vopb(*pkn,conc);
                wis(adr[6]);
                return TRUE;
                }
            }
        }
    }
return FALSE;
}

static int substdiff(ppsk pkn)
{
static const char *conc[] = {NULL,NULL,NULL,NULL};
psk lknoop,rknoop;
lknoop = (*pkn)->LEFT;
rknoop = (*pkn)->RIGHT;
if(RATIONAAL_COMP(lknoop) && RATIONAAL_COMP(rknoop))
    {
    conc[2] = hekje5;
    adr[5] = copievan(&nulk);
    numboom(pkn,lknoop,conc);
    wis(adr[5]);
    return TRUE;
    }
else
    {
    if(is_constant(lknoop) || is_constant(rknoop))
        {
        replace(pkn,&nulk);
        return TRUE;
        }
    else
        {
        if(!vgl(lknoop,rknoop))
            {
            replace(pkn,&eenk);
            return TRUE;
            }
        else
            if(  (  kop(rknoop) == FUN
                 || !is_op(rknoop)
                 )
              && is_afhankelyk_van(lknoop,rknoop)
              )
                return TRUE;
            else
                if(!is_op(rknoop))
                    {
                    replace(pkn,&nulk);
                    return TRUE;
                    }
        }
    }
return FALSE;
}


#if JMP /*Bart 20030410: Often no need for polling in multithreaded apps.*/
#include <windows.h>
#include <dde.h>
    static void PeekMsg(void)
    {
    static MSG msg;
    while(PeekMessage(&msg,NULL,WM_PAINT,/*WM_MOUSELAST*/WM_DDE_LAST,PM_REMOVE))
            {
            if(msg.message == WM_QUIT)
                    {
                    PostThreadMessage(GetCurrentThreadId(), WM_QUIT,0,0L);
                    longjmp(jumper,1);
                    }
            TranslateMessage(&msg);        /* Translates virtual key codes */
            DispatchMessage(&msg);        /* Dispatches message to window*/
            }
    }
#endif

/*
Iterative handling of LUCHT operator in evalueer.
Can now handle very deep structures without stack overflow
*/

static void handleLUCHT(ppsk pkn)
    { /* assumption: (kop(*pkn) == LUCHT) && !((*pkn)->v.fl & READY) */
    static psk hulp;
    /*psk luchtknoop = *pkn;*/
    psk luchtknoop;
    psk next;
    ppsk pluchtknoop = pkn;
    ppsk prevpluchtknoop = NULL;
    while(TRUE)
        {
        evalueer(&((luchtknoop = *pluchtknoop)->LEFT));
        if  (  !is_op(hulp=luchtknoop->LEFT)
            && !(hulp->u.obj)
            && !HAS_UNOPS(hulp)
            )
            {
            *pluchtknoop = rechtertak(luchtknoop);
            }
        else
            {
            prevpluchtknoop = pluchtknoop;
            pluchtknoop = &(luchtknoop->RIGHT);
            }
        if(kop(luchtknoop = *pluchtknoop) == LUCHT && !(luchtknoop->v.fl & READY))
            {
            copyop(pluchtknoop);
            }
        else
            {
            evalueer(pluchtknoop);
            if(  prevpluchtknoop
              && !is_op(luchtknoop = *pluchtknoop)
              && !((luchtknoop)->u.obj)
              && !HAS_UNOPS(luchtknoop)
              )
                *prevpluchtknoop = linkertak(*prevpluchtknoop);
            break;
            }
        }

    luchtknoop = *pkn;
    while(kop(luchtknoop) == LUCHT)
        {
        next = luchtknoop->RIGHT;
        rechtsbrengen(luchtknoop);
        if(next->v.fl & READY)
            break;
        luchtknoop = next;
        luchtknoop->v.fl |= READY;
        }
    }
/*
Iterative handling of KOMMA operator in evalueer.
Can now handle very deep structures without stack overflow
*/
static void handleKOMMA(ppsk pkn)
    { /* assumption: (kop(*pkn) == KOMMA) && !((*pkn)->v.fl & READY) */
    psk kommaknoop = *pkn;
    psk next;
    ppsk pkommaknoop;
    while(kop(kommaknoop->RIGHT) == KOMMA && !(kommaknoop->RIGHT->v.fl & READY))
        {
        evalueer(&(kommaknoop->LEFT));
        pkommaknoop = &(kommaknoop->RIGHT);
        kommaknoop = kommaknoop->RIGHT;
        if(copyop(&kommaknoop))
            *pkommaknoop = kommaknoop;
        }
    evalueer(&kommaknoop->LEFT);
    evalueer(&kommaknoop->RIGHT);
    kommaknoop = *pkn;
    while(kop(kommaknoop) == KOMMA)
        {
        next = kommaknoop->RIGHT;
        rechtsbrengen(kommaknoop);
        if(next->v.fl & READY)
            break;
        kommaknoop = next;
        kommaknoop->v.fl |= READY;
        }
    }

static void evalvar(ppsk pkn)
    {
    psk adr;
    if(naamwoord_w(*pkn,&adr))
        {
        wis(*pkn);
        *pkn = adr;
        }
    else
        {
        if(shared(*pkn))
            {
            dec_refcount(*pkn);
            *pkn = icopievan(*pkn);
            }
        (*pkn)->v.fl |= READY;
        (*pkn)->v.fl ^= SUCCESS;
        }
    }

static void privatized(ppsk pkn,psk plkn)
    {
    *plkn = **pkn;
    if(sharedo(*plkn))
        {
        dec_refcount(*pkn);
        plkn->LEFT = zelfde_als_w(plkn->LEFT);
        plkn->RIGHT = zelfde_als_w(plkn->RIGHT);
        }
    else
        pskfree(*pkn);
    }

static psk __rechtertak(psk pkn)
    {
    psk ret;
    int success = pkn->v.fl & SUCCESS;
    if(shared(pkn))
        {
        ret = zelfde_als_w(pkn->RIGHT);
        dec_refcount(pkn);
        }
    else
        {
        ret = pkn->RIGHT;
        wis(pkn->LEFT);
        pskfree(pkn);
        }
    if(!success)
        {
        ret = prive(ret);
        ret->v.fl ^= SUCCESS;
        }
    return ret;
    }


static int evalueer(ppsk pkn)
{
/*
Notice the low number of local variables on the stack. This ensures maximal
utilisation of stack-depth for recursion.
*/
#if DEBUGBRACMAT
if(debug)
    {
    printf("evaluate:");result(*pkn);printf("\n");
    }
#endif
while(!((*pkn)->v.fl & READY))
    {
    if(is_op(*pkn))
        {
        sk lkn;
        /* The operators MATCH, EN and OF are treated in another way than
        the other operators. These three operators are the only 'volatile'
        operators: they cannot occur in a fully evaluated tree. For that reason
        there is no need to allocate space for an evaluated version of such
        operators on the stack. Instead the local variable lkn is used.
        */
        switch(kop(*pkn))
            {
            case MATCH :
                {
                privatized(pkn,&lkn);
                /*if(evalueer(&(lkn.LEFT)) == TRUE)*/
                if(evalueer(&(lkn.LEFT)) & (TRUE|FENCE))
                    /* 20080113
                    `~a:?b will assign `~a to b
                    */
                    {
#if DEBUGBRACMAT
                    if(debug)
                        {
                        printf("before match:");result(&lkn);printf("\n");
                        }
#endif
#if STRINGMATCH_CAN_BE_NEGATED
                    if(lkn.flgs & ATOM) /*20071229 should other flags be
                                          excluded, including ~ ?*/
#else
                    if((lkn.flgs & ATOM) && !ONTKENNING(lkn.flgs,ATOM))
#endif
                        {
                        if(!is_op(lkn.LEFT) && stringmatch(0,"V",POBJ(lkn.LEFT),NULL,lkn.RIGHT, lkn.LEFT,0,strlen(POBJ(lkn.LEFT))) & TRUE)
                            *pkn = _linkertak/*s*/(&lkn); /* 20071229 ~@(a:a) is now treated like ~(a:a)*/
                        else
                            {
                            if(is_op(lkn.LEFT))
                                {
                                printf("!stringmatch:<");result(&lkn);printf(">\n");
                                getchar();
                                }
                            *pkn = _flinkertak/*s*/(&lkn);/* 20071229 ~@(a:b) is now treated like ~(a:b)*/
                            }
                        }
                    else
                        {
                        if(match(0,lkn.LEFT,lkn.RIGHT,NULL,0,expressionLength(lkn.LEFT)) & TRUE)
                            *pkn = _linkertak(&lkn);
                        else
                            *pkn = _flinkertak(&lkn);
                        }
                    }
                else
                    {
                    *pkn = _linkertak(&lkn);
                    }
#if DEBUGBRACMAT
                if(debug)
                    {
                    printf("after match:");result(*pkn);printf("\n");
                    if((*pkn)->v.fl & SUCCESS)
                        {
                        printf(" SUCCESS\n");
                        }
                    else
                        {
                        printf(" FENCE\n");
                        }
                    }
#endif
                break;
                }
            /* The operators EN and OF are tail-recursion optimised. */
            case EN :
                {
                privatized(pkn,&lkn);
                if(evalueer(&(lkn.LEFT)))
                    *pkn = _rechtertak(&lkn);/* TRUE of FENCE */
                else
                    *pkn = _linkertak(&lkn);/* FAAL */
                break;
                }
            case OF :
                {
                privatized(pkn,&lkn);
                if(evalueer(&(lkn.LEFT)))
                    *pkn = _fencelinkertak(&lkn);/* FENCE of TRUE */
                else
                    *pkn = _rechtertak(&lkn);/* FAAL */
                break;
                }
            /* Operators that can occur in evaluated expressions: */
            case WORDT :
               if(   !is_op((*pkn)->LEFT)
                  && !(*pkn)->LEFT->u.obj
                  && ((*pkn)->v.fl & INDIRECT)
                  && !((*pkn)->v.fl & DOUBLY_INDIRECT)
                  )
                    {
                    /*privatized(pkn,&lkn);*/
                    /*evalueer(&(lkn.LEFT));*/
                    /**pkn = _rechtertak(&lkn);*/
                    *pkn = __rechtertak(*pkn);
                    break;

/*                    *pkn = (*pkn)->RIGHT;*/
                    }
                else
                    {
                    copyop(pkn);
                    (*pkn)->v.fl |= READY;
                    evalueer(&((*pkn)->LEFT));
                    if(is_op((*pkn)->LEFT) /* 30 juli 1993 */
                    || (*pkn)->LEFT->u.obj)
                        {
                        if(assign(pkn))
                            *pkn = linkertak(*pkn);
                        else
                            *pkn = flinkertak(*pkn);
                        }
                    else if((*pkn)->v.fl & INDIRECT)
                      /* 20080103: !(=a) -> a */
                        {
                        evalvar(pkn);
                        }
                    }
                break;
            case DOT :
                {
                copyop(pkn);
                (*pkn)->v.fl |= READY;
                evalueer(&((*pkn)->LEFT));
                evalueer(&((*pkn)->RIGHT));
                if((*pkn)->v.fl & INDIRECT)
                    {
                    evalvar(pkn);
                    }
                break;
                }
            case KOMMA :
                copyop(pkn);
                (*pkn)->v.fl |= READY;
                handleKOMMA(pkn);/* do not recurse, iterate! */
                break;
            case LUCHT :
                copyop(pkn);
                (*pkn)->v.fl |= READY;
                handleLUCHT(pkn);/* do not recurse, iterate! */
                break;
            case PLUS :
                 copyop(pkn);
                (*pkn)->v.fl |= READY;
                if(evalueer(&((*pkn)->LEFT)) == TRUE &&
                   evalueer(&((*pkn)->RIGHT)) == TRUE)
                    {
                    if(  plus_samenvoegen_of_sorteren(pkn)
                      )
                        ;
                    }
                else
                    (*pkn)->v.fl ^= SUCCESS;
                break;
            case MAAL :
                copyop(pkn);
                (*pkn)->v.fl |= READY;
                if(evalueer(&((*pkn)->LEFT)) == TRUE &&
                   evalueer(&((*pkn)->RIGHT)) == TRUE)
                    {
                    if(  rechtsbrengen(*pkn)
                      || substmaal(pkn)
                      || maal_samenvoegen_of_sorteren(pkn)
                      )
                        ;
                    }
                else
                    (*pkn)->v.fl ^= SUCCESS;
                break;
            case EXP :
                copyop(pkn);
                (*pkn)->v.fl |= READY;
                if(evalueer(&((*pkn)->LEFT)) == TRUE &&
                   evalueer(&((*pkn)->RIGHT)) == TRUE)
                    {
                    if(  stapelmacht(pkn)        /* (a^b)^c->a^(b*c)             */
                      || substmacht(pkn)         /* 0^a 1^a a^0 a^1 n^-1 i^n     */
                      || machtbuitenhaakjes(pkn) /* (a+b)^(c+n)->(a+b)^c*(a+b)^n */
                                                 /* (a*b)^c->a^c*b^c             */
                      || casemacht(pkn)
                      || try_le_elq(f4,pkn)
                      )
                        ;
                    }
                else
                    (*pkn)->v.fl ^= SUCCESS;
                break;
            case LOG :
                copyop(pkn);
                (*pkn)->v.fl |= READY;
                if(evalueer(&((*pkn)->LEFT)) == TRUE &&
                   evalueer(&((*pkn)->RIGHT)) == TRUE)
                    {
                    if(  substlog(pkn)
                      || try_le_elq(f5,pkn)
                      )
                        ;
                    }
                else
                    (*pkn)->v.fl ^= SUCCESS;
                break;
            case DIF :
                copyop(pkn);
                (*pkn)->v.fl |= READY;
                if(evalueer(&((*pkn)->LEFT)) == TRUE &&
                   evalueer(&((*pkn)->RIGHT)) == TRUE)
                    {
                    if(!substdiff(pkn))
                        {
                        if(!differentieren(pkn))
                            (*pkn)->v.fl ^= SUCCESS;/*???*/
                        }
                    }
                else
                    (*pkn)->v.fl ^= SUCCESS;
                break;
            case FUN :
            case FUU :
                copyop(pkn);
                (*pkn)->v.fl |= READY;
                evalueer(&((*pkn)->LEFT));
                if(kop(*pkn) == FUN)
                    {
                    evalueer(&((*pkn)->RIGHT));
                    }
                rechtsbrengen(*pkn);
                switch(functies(pkn))
                    {
    /*
    typedef enum    {function_fail
                    ,built_in_function_ok
                    ,user_function_ok
                    ,user_object_method_ok
                    ,builtin_object_builtin_method_ok
                    ,builtin_object_user_method_ok
                    } function_return_type;
    */
    /*                case 0:*/
                    case function_fail:
                        (*pkn)->v.fl ^= SUCCESS;
                        break;
                    case built_in_function_ok:
                    case builtin_object_builtin_method_ok:
                        break;
    /*                case TRUE+TRUE:*/
                    case user_function_ok:
                        if(kop(*pkn) == DOT)
                            {
                            psh((*pkn)->LEFT,&nulk,NULL);
                            evalueer(pkn);
                            pop((*pkn)->LEFT);
                            dopb(pkn,(*pkn)->RIGHT);
                            }
                        deleteNode(&argk);
                        break;
    /*                case TRUE+TRUE+TRUE:*/
                    case user_object_method_ok:
                        if(kop(*pkn) == DOT)
                            {
                            psh((*pkn)->LEFT,&nulk,NULL);
                            evalueer(pkn);
                            pop((*pkn)->LEFT);
                            dopb(pkn,(*pkn)->RIGHT);
                            }
                        deleteNode(&argk);
                        deleteNode(&selfkn);
                        break;
                    case builtin_object_user_method_ok:
                        if(kop(*pkn) == DOT)
                            {
                            psh((*pkn)->LEFT,&nulk,NULL);
                            evalueer(pkn);
                            pop((*pkn)->LEFT);
                            dopb(pkn,(*pkn)->RIGHT);
                            }
                        deleteNode(&argk);
                        deleteNode(&selfkn);
                        deleteNode(&Selfkn);
                        break;
                    }
                break;
            case STREEP :
                copyop(pkn);
                (*pkn)->v.fl |= READY;
                if(dummy_op == WORDT)
                    {
                    psk old = *pkn;
                    *pkn = (psk)bmalloc(__LINE__,sizeof(objectknoop));
                    ((typedObjectknoop*)(*pkn))->refcount = 0;
                    UNSETCREATEDWITHNEW((typedObjectknoop*)*pkn);
                    UNSETBUILTIN((typedObjectknoop*)*pkn);
                    (*pkn)->LEFT = subboomcopie(old->LEFT);
                    old->RIGHT = *Head(&old->RIGHT);
                    (*pkn)->RIGHT = subboomcopie(old->RIGHT);
                    /*(*pkn)->v.fl |= dummy_flgs;*/
                    wis(old);
                    }
                /*else*/
                    {
                    (*pkn)->v.fl &= (~OPERATOR & ~READY);
                    (*pkn)->ops |= dummy_op;
                    (*pkn)->v.fl |= dummy_flgs;
                    }
                break;
            }
        }
    else
        {
        /* An unevaluated leaf can only be an atom with ! or !!,
        so we don't need to test for this condition.*/
        evalvar(pkn);
        /* After evaluation of a variable, the loop continues.
        Together with how & and | (EN and OF) are treated, this ensures that
        a loop can run indefinitely, without using stack space. */
        }
    }
#if JMP
PeekMsg();
#endif
if((*pkn)->v.fl & SUCCESS)
    {
    return TRUE;
    }
else
    {
    return (*pkn)->v.fl & FENCE;
    }
}






static void init_ruimte(void)
{
p4start = (byte4*)malloc((size_t)(PROMILLAGE4*sizeof(byte4)*KILOKNOPEN));
if(p4start == NULL)
    {
    exit(-1);
    }
p4end = p4start+(size_t)(PROMILLAGE4*KILOKNOPEN);
for(p4 = p4start;
    p4 < p4end - 1;
    p4++)
    p4->u.p = p4+1;
p4->u.p = NULL;
p4 = p4start;
p8start = (byte8*)malloc((size_t)(PROMILLAGE8*sizeof(byte8)*KILOKNOPEN));
if(p8start == NULL)
    {
    exit(-1);
    }
p8end = p8start+(size_t)(PROMILLAGE8*KILOKNOPEN);
for(p8 = p8start;
    p8 < p8end - 1;
    p8++)
    p8->u.p = p8+1;
p8->u.p = NULL;
p8 = p8start;

p12start = (byte12*)malloc((size_t)(PROMILLAGE12*sizeof(byte12)*KILOKNOPEN));

if(p12start == NULL)
    {
    exit(-1);
    }
p12end = p12start+(size_t)(PROMILLAGE12*KILOKNOPEN);
for(p12 = p12start;
    p12 < p12end - 1;
    p12++)
    p12->u.p = p12+1;
p12->u.p = NULL;
p12 = p12start;

p16start = (byte16*)malloc((size_t)(PROMILLAGE16*sizeof(byte16)*KILOKNOPEN));

if(p16start == NULL)
    {
    exit(-1);
    }
p16end = p16start+(size_t)(PROMILLAGE16*KILOKNOPEN);
for(p16 = p16start;
    p16 < p16end - 1;
    p16++)
    p16->u.p = p16+1;
p16->u.p = NULL;
p16 = p16start;

#ifdef _4_5
p20start = (byte20*)malloc((size_t)(PROMILLAGE20*sizeof(byte20)*KILOKNOPEN));

if(p20start == NULL)
    {
    exit(-1);
    }
p20end = p20start+(size_t)(PROMILLAGE20*KILOKNOPEN);
for(p20 = p20start;
    p20 < p20end - 1;
    p20++)
    p20->u.p = p20+1;
p20->u.p = NULL;
p20 = p20start;

p24start = (byte24*)malloc((size_t)(PROMILLAGE24*sizeof(byte24)*KILOKNOPEN));

if(p24start == NULL)
    {
    exit(-1);
    }
p24end = p24start+(size_t)(PROMILLAGE24*KILOKNOPEN);
for(p24 = p24start;
    p24 < p24end - 1;
    p24++)
    p24->u.p = p24+1;
p24->u.p = NULL;
p24 = p24start;
#endif
}

void startProc(
#ifdef BRACMATEMBEDDED
               startStruct * init
#else
               void
#endif
               )
    {
    int tel;
#ifdef BRACMATEMBEDDED /*MICROSOFT_WINDOWS_API*/
    if(init)
        {
        if(init->WinIn)
            {
            WinIn = init->WinIn;
            }
        if(init->WinOut)
            {
            WinOut = init->WinOut;
            }
        if(init->WinFlush)
            {
            WinFlush = init->WinFlush;
            }
        }
#endif
    for(tel = 0;tel<256;variabelen[tel++] = NULL);
    init_ruimte();
    init_opcode();
    anker = NULL;
    fpi = stdin;
    fpo = stdout;

    argk.flgs = READY | SUCCESS;
    argk.u.lobj = O('a','r','g');

    selfkn.flgs = READY | SUCCESS;
    selfkn.u.lobj = O('i','t','s');

    Selfkn.flgs = READY | SUCCESS;
    Selfkn.u.lobj = O('I','t','s');

    nilk.flgs = READY | SUCCESS | IDENT
        ;
    nilk.u.lobj = 0L;


    nulk.flgs = READY | SUCCESS | IDENT | QGETAL | QNUL;
    nulk.u.lobj = 0L;
    nulk.u.obj = '0';

    eenk.u.lobj = 0L;
    eenk.u.obj = '1';
    eenk.flgs = READY | SUCCESS | IDENT | QGETAL;
    *(&(eenk.u.obj)+1) = 0;

    mintweek.u.lobj = 0L;
    mintweek.u.obj = '2';
    mintweek.flgs = READY | SUCCESS | QGETAL | MINUS;
    *(&(mintweek.u.obj)+1) = 0;

    mineenk.u.lobj = 0L;
    mineenk.u.obj = '1';
    mineenk.flgs = READY | SUCCESS | QGETAL | MINUS;
    *(&(mineenk.u.obj)+1) = 0;

    tweek.u.lobj = 0L;
    tweek.u.obj = '2';
    tweek.flgs = READY | SUCCESS | QGETAL;
    *(&(tweek.u.obj)+1) = 0;

    vierk.u.lobj = 0L;
    vierk.u.obj = '4';
    vierk.flgs = READY | SUCCESS | QGETAL;
    *(&(vierk.u.obj)+1) = 0;

    minvierk.u.lobj = 0L;
    minvierk.u.obj = '4';
    minvierk.flgs = READY | SUCCESS | QGETAL | MINUS;
    *(&(minvierk.u.obj)+1) = 0;



    m0 = opb(m0,"?*(%+%)^~/#>1*?" , NULL);
    m1 = opb(m1,"?*(%+%)*?" , NULL);
    f0 = opb(f0,  "(g,k,pow"
                ".(pow"
                    "=b,c,d,l,s,f"
                      ".!arg:(%?b+%?c)^?d"
                          "&1:?f"
                          "&(s"
                            "=!d:1&0"
                              "|(!f*!d*(1+!l:?l)^-1:?f)"
                                  "*!b^!l"
                                  "*pow$(!c^(-1+!d:?d))"
                                "+!s"
                            ")"
                          "&!b^!d+!c^!d+!s"
                        "|!arg"
                    ")"
                  "&!arg:?g*((%+%)^~/#>1:?arg)*?k"
                  "&!g*pow$!arg*!k)",NULL);
    f1 = opb(f1,
        "((\177g,\177h,\177i).!arg:?\177g*(%?\177h+%?\177i)*",
        "?arg&!\177g*!\177h*!arg+!\177g*!\177i*!arg)",NULL);
    f4 = opb(f4,  "l,a,b,c,e,f"
                ".(a"
                 "=j,g,h,i"
                  ".!arg:?l^(?j+?g*!l\016?h*?i+?arg)"
                   "&!l^(!j+!arg)*!h^(!g*!i)"
                 ")"
                "&(e"
                 "=j,g,I"
                 ".!arg:?j+#?g*((i|-i):?I)*pi+?arg"
                   "&1:?l"
                   "&!j+(mod$(1+!g,2)+-1)*!I*pi+!arg"
                 ")"
                "&(f"
                 "=j,i"
                  ".!arg:?j+#?l*((i|-i):?I)*pi+?arg"
                   "&!I^(2*!l):?l"
                   "&!j+!arg"
                 ")"
                "&(b"
                 "="
                  "(!l:(<-1|>1)&e"
                  "|(-1|1/2|-1/2)&f"
                  ")"
                  ":?l"
                 ")"
                "&(c"
                 "="
                  ".1+!arg:?arg"
                   "&1:?l"
                   "&-1+!arg"
                 ")"
                "&(!arg:?l^(?+?*!l\016?*?+?)&a$!arg"
                 "|!arg"
                  ":e^((?+#?l*(i|-i)*pi+?&`!b"
                      "|?"
                       "*(pi|i|-i)"
                       "*?"
                       "*(?+?*(pi|i|-i)*?+?:%+%)"
                       "*?"
                        "&c:?l"
                      ")"
                     ":?arg"
                     ")"
                   "&e^!l$!arg*!l"
                 ")",NULL);
    f5 = opb(f5,
         "l,d"
         ".(d"
          "=j,g,h"
           ".!arg:?l\016(?j*!l^?g*?h)&!g+!l\016(!j*!h)"
          ")"
          "&!arg:?l\016(?*!l^?*?)"
          "&d$!arg", NULL);

    startboom_w(&anker ,
        /*"(cat=((\177w,\177n,\177o,\177l,\177c,\177d,\177p).!arg:((?\177w,",
        "(?\177n,?\177o)|?\177n&():?\177o)|?\177w&():?\177n:?\177o)&(\177l=(.",
        "!arg:%?\177c ?arg&!\177c:((?\177d.?)|?\177d)&()'(? (`=()$\177d|(()$\177d.?",
        ")) ?):?\177p&(!\177w:!\177p&~$(!\177n:!\177p)&!\177c|()) \177l$!arg|()))&(",
        "():!\177w:!\177n|(():!\177w&mem$():?\177w|())&\177l)$(mem$!\177o))),",*/
        "(cat=c,w,tay,fct,cos,out,sgn.!arg:((?c,(?w,?tay)|?w&:?tay)|?c&:?w:"
        "?tay)&(fct=.!arg:%?cos ?arg&!cos:((?out.?)|?out)&'(? (`=$out|($out.?)"
        ") ?):?sgn&(!c:!sgn&~$(!w:!sgn)&!cos|) fct$!arg|)&(:!c:!w|(:!c&mem$:?c"
        "|)&fct)$(mem$!tay)),",



        "(out=(.put$!arg:?arg&put$\212&!arg)),",
        "(flt=((e,d,m,s,f).!arg:(~0:?arg,~<0:?d)&(-1*!arg:>0:?arg&-1|1):?s&",
        "10\016!arg:?e+(10\016?m|0&1:?m)&(!m+1/2*1/10^!d:~<10&1+!e:?e&!m*1/10",
        ":?m|)&get$(div$(!m+1/2*(1/10^!d:?d),!d),MEM,VAP):",
        "`%?f ?m&str$(!s*!f (!d:~1&\254|) !m \252\261\260\305 !e))),",

        "(tay=((f,tot,x,fac,cnt,res,R).",
        "(R=!cnt:!tot&!res|!res+(sub$(!x\017!f:?f.!x.0))*((!fac*(!cnt+1:?cnt))",
        ":?fac)^-1*!x^!cnt:?res&!R)&",
        "!arg:(?f,?x,?tot)&(fac=1)&(cnt=0)&((sub$(!f.!x.0)):?res)&!R)),",

        /*"(ego=(r.sub$(sub$(!arg.(sin.?r).'sin$!r).(cos.?r).'cos$!r))),",

        "(goe=((h,s).sub$(!arg.'(e^?h).",
        "'(-1*(sgn$(-1+i*!h+1:?h):?s)*i*(sin.-1+!s*!h+1:?s)+(cos.!s))))),",*/

        "(sin=(.i*(-1/2*e^(i*!arg)+1/2*e^(-i*!arg)))),",

        "(cos=(.1/2*(e^(i*!arg)+e^(-i*!arg)))),",

        "(sgn=(.!arg:?#%arg*%+?&sgn$!arg|!arg:<0&-1|1)),",
        "(abs=(.sgn$!arg*!arg)),",

        "(sub=((\177e,\177x,\177v,\177F).(\177F=((\177l,\177r).",
        "(!arg:!\177x&!\177v:?arg|)&!arg:%?\177l_%?\177r&(\177F$!\177l)_",
        "(\177F$!\177r)|!arg))&!arg:(",
        "(?\177e.?\177x.?\177v)|out$str$(UseDotInSub !arg)&get'&`~)&\177F$!\177e)),",
        fct,
        NULL);


#if JMP
    if(setjmp(jumper) != 0)
        return;
#endif
    evalueer(&anker);
}

void endProc(void)
    {
    int err;
/*  stringEval("cat$:? CloseDown ? & CloseDown$ | out$\"No CloseDown function provided, exiting all the same.\"",NULL,&err);*/
    stringEval("cat$:? CloseDown ? & CloseDown$ | ",NULL,&err);
    if(err)
        printf("Error executing CloseDown\n");
    }

/* main - the text-mode front end for bracmat */


#if defined BRACMATEMBEDDED
#else

#include <stddef.h>

#if defined ARM
#define COPYRIGHT "\xA9"
#else
#define COPYRIGHT "(c)"
#endif


void mainlus(int argc,char *argv[])
    {
    int err;
    char *mainloop;

    mainloop = argc > 1 ? argv[1] :
    "(w=\"11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY\\n"
    "FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN\\n"
    "OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES\\n"
    "PROVIDE THE PROGRAM \\\"AS IS\\\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED\\n"
    "OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\\n"
    "MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS\\n"
    "TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE\\n"
    "PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,\\n"
    "REPAIR OR CORRECTION.\\n\")&"
    "(c=\"12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING\\n"
    "WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR\\n"
    "REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,\\n"
    "INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING\\n"
    "OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED\\n"
    "TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY\\n"
    "YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER\\n"
    "PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE\\n"
    "POSSIBILITY OF SUCH DAMAGES.\\n\")&"
    "out$\"\\nBracmat version " VERSION ", build " BUILD " (" DATUM ")\\n"
    "Copyright (C) 2002 Bart Jongejan\\n"
    "Bracmat comes with ABSOLUTELY NO WARRANTY; for details type `!w'.\\n"
    "This is free software, and you are welcome to redistribute it\\n"
    "under certain conditions; type `!c' for details.\\n\\n"
        "\\n\\n{?} get$help { tutorial }\\n{?} )        { stop }\"&"

        "(main=put$\"{?} \"&clk$():?SEC&((\"?\"$(get'):(|?&clk$+-1*!SEC:?SEC&"
        "put$\"{!} \"&put$!&put$(\"\\n    S  \" str$(div$(!SEC,1) \",\" (div$(mod$("
        "!SEC*100,100),1):?SEC&!SEC:<10&0|) !SEC) sec))|put$\"\\n    F\")|"
        "put$\"\\n    I\")&"

#if TELMAX

        "out$str$(\"  \" bez')&"
#else
        "out$&"
#endif

        "!main)&!main";


        stringEval(mainloop,NULL,&err);
    }

int main(int argc,char *argv[])
    {
    char * p = argv[0] + strlen(argv[0]);
    assert(sizeof(tFlags) == sizeof(unsigned int));
    while(--p >= argv[0])
        if(*p == '\\' || *p == '/')
            {
            ++p;
            targetPath = malloc(p - argv[0] + 1);
            if(targetPath)
                {
                strncpy(targetPath,argv[0],p - argv[0]);
                targetPath[p - argv[0]] = '\0';
                }
            break;
            }
/*  printf("targetPath=%s\n",targetPath);*/

    errorStream = stderr;
    startProc();
    mainlus(argc,argv);
    endProc();
    if(targetPath)
        free(targetPath);
    return 0;
    }

#endif /*#ifndef BRACMATEMBEDDED*/

