/*
CSTLEMMA - trainable lemmatiser using word-end inflectional rules

Copyright (C) 2002, 2004  Center for Sprogteknologi, University of Copenhagen

This file is part of CSTLEMMA.

CSTLEMMA is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

CSTLEMMA is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with CSTLEMMA; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef BASEFRM_H
#define BASEFRM_H

#include "outputclass.h"
#include <stdio.h>
#include <string.h>

class baseformpointer;
class unTaggedWord;
class basefrm : public OutputClass
    {
    private:
        unTaggedWord ** fullForm; // list of full forms
        unsigned int nfullForm:8;
//        int cnting;
#if FREQ24
        unsigned int freq24:24; // 0 for new words; >= 0 for words from the
        // dictionary: the number of times the word is found in a 
        // corpus (-N<frequency file).
#endif
        char * s;
        char * t;
        static int index;
        static FILE * fp;
        void T() const
            {
            fprintf(fp,"%s",t);
            }
        void F() const
            {
            fprintf(fp,"%d",lemmaFreq()/*nfullForm*//*cnting*/); // shows the frequency of the lemma in the current text.
            }
#if FREQ24
        void N() const
            {
            fprintf(fp,"%u",freq24);
            }
#endif
            /*        void P() const
            {
            fprintf(fp,"%u",freq); need sum of frequencies here
            }*/
        void W() const
            {
            fprintf(fp,"%s",s);
            }
        void L() const;
    public:
        static functionTree * bfuncs;// used if -W option set
        static functionTree * Bfuncs;// used if -W option set
        static functionTree * wfuncs;// used if -W option set
        static functionTree * Format(const char * format);
        static bool hasW;
        static const char * sep;
        static bool setFormat(char * Wformat,const char * bformat,const char * Bformat,bool InputHasTags); // used with -W option
        static function * getBasefrmFunction(int character,bool & DummySortInput,int & testType);
        static function * getBasefrmFunctionNoW(int character,bool & DummySortInput,int & testType);
        static void setFile(FILE * fp);
        int cmpt(basefrm * b){return strcmp(t,b->t);}
        int cmps(basefrm * b){return strcmp(s,b->s);}
//        int cmpf(basefrm * b){return freq24 - b->freq24;}
//        void inc(basefrm * b){cnting += b->cnting;}
        baseformpointer & owner;
#if FREQ24
        basefrm(const char * s,const char * t,baseformpointer & owner,int len,/*int cnt,*/unsigned int frequency):fullForm(NULL),nfullForm(0),freq24(frequency),owner(owner)
#else
        basefrm(const char * s,const char * t,baseformpointer & owner,int len/*int cnt,*/):fullForm(NULL),nfullForm(0),owner(owner)
#endif
            {
            this->s = new char[len+1];
            strncpy(this->s,s,len);
            this->s[len] = '\0';
            this->t = new char[strlen(t)+1];
            strcpy(this->t,t);
            }
        ~basefrm();
        void getAbsorbedBy(basefrm * other);
        void addFullForm(unTaggedWord * word);
        void addFullForms(basefrm * other);
        virtual void printb()const;
        virtual void printB()const;
        int countFullForms() const;
        int lemmaFreq() const;
        void testPrint()const;
        bool equal(const char * s,const char * t)
            {
            return !strcmp(s,this->s) && !strcmp(t,this->t);
            }
        int Closeness(const char * tag);
//        void remove(baseformpointer * tobermoved);
        void removeFullForm(unTaggedWord * w);
    };

class tagpairs;
extern tagpairs * TagFriends;


#endif
