/*
CSTLEMMA - trainable lemmatiser using word-end inflectional rules

Copyright (C) 2002, 2004  Center for Sprogteknologi, University of Copenhagen

This file is part of CSTLEMMA.

CSTLEMMA is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

CSTLEMMA is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with CSTLEMMA; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef FUNCTION_H
#define FUNCTION_H

#include <stdio.h>

class OutputClass;
class basefrm;
class unTaggedWord;
class taggedWord;

typedef void (basefrm::*fptrbf)() const;
typedef void (unTaggedWord::*fptr)() const;
typedef void (taggedWord::*fptrt)() const;
typedef int (unTaggedWord::*fptcount)() const;
typedef int (basefrm::*fptcountbf)() const;

class function
    {
    public:
        virtual void doIt(const OutputClass * outputObj)const = 0;
        virtual int count(const OutputClass * outputObj)const{return -1;}
        virtual ~function(){}
        virtual bool skip(const basefrm * bf)const = 0;
    };


class functionNoArgB : public function
    {
    private:
        fptrbf fn;
    public:
        functionNoArgB(fptrbf fn):fn(fn){}
        void doIt(const OutputClass * outputObj)const
            {
            (((basefrm*)outputObj)->*fn)();
            }
        virtual bool skip(const basefrm * bf)const
            {
            return false;
            }
    };

class functionString : public function
    {
    private:
        char * arg;
    public:
        static FILE * fp;
        functionString(char * arg);
        ~functionString()
            {
            delete [] arg;
            }
        void doIt(const OutputClass * outputObj)const
            {
            for(char * s = arg;*s;++s)
                fputc(*s,fp);
            }
        virtual bool skip(const basefrm * bf)const
            {
            return false;
            }
    };

class functionNoArg : public function
    {
    private:
        fptr fn;
        fptcount fncount;
    public:
        functionNoArg(fptr fn,fptcount fncount):fn(fn),fncount(fncount){}
        void doIt(const OutputClass  * u)const
            {
            unTaggedWord * tmp = (unTaggedWord*)u;
            (tmp->*fn)();
            }
        virtual bool skip(const basefrm * bf)const
            {
            return false;
            }
        int count(const OutputClass  * u)const
            {
            if(fncount)
                {
                unTaggedWord * tmp = (unTaggedWord*)u;
                return (tmp->*fncount)();
                }
            else
                return function::count(u);
            }
    };

class functionNoArgW : public function
    {
    private:
        fptrbf fn;
        fptcountbf fncount;
    public:
        functionNoArgW(fptrbf fn,fptcountbf fncount):fn(fn),fncount(fncount){}
        void doIt(const OutputClass  * u)const
            {
            basefrm * tmp = (basefrm*)u;
            (tmp->*fn)();
            }
        virtual bool skip(const basefrm * bf)const
            {
            return false;
            }
        int count(const OutputClass  * u)const
            {
            if(fncount)
                {
                basefrm * tmp = (basefrm*)u;
                return (tmp->*fncount)();
                }
            else
                return function::count(u);
            }
    };


class functionNoArgT : public function
    {
    private:
        fptrt fn;
    public:
        functionNoArgT(fptrt fn):fn(fn){}
        void doIt(const OutputClass  * u)const
            {
            ((taggedWord*)u->*fn)();
            }
        virtual bool skip(const basefrm * bf)const
            {
            return false;
            }
    };


#endif
