/*
CSTLEMMA - trainable lemmatiser using word-end inflectional rules

Copyright (C) 2002, 2004  Center for Sprogteknologi, University of Copenhagen

This file is part of CSTLEMMA.

CSTLEMMA is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

CSTLEMMA is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with CSTLEMMA; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "word.h"
#include "basefrm.h"
#include "functio.h"
#include "functiontree.h"
#include "flex.h"
#include "lemmtags.h"
#include "tags.h"
#include "caseconv.h"
#if !QSORT
#include "text.h"
#include "dictionary.h"
#endif
#include <assert.h>
#include <stdlib.h>
#include <limits.h>

FILE * unTaggedWord::fp = NULL;
functionTree * unTaggedWord::funcs = NULL;
functionTree * unTaggedWord::bfuncs = NULL;
functionTree * unTaggedWord::Bfuncs = NULL;
bool unTaggedWord::hasb = false;
bool unTaggedWord::hasB = false;
const char * unTaggedWord::sep;


/*
The next function makes an >>uneducated<< guess at the type of the word.
Only used for untagged texts.
We could use several techniques to improve: return the type that is
most probable, given the word's ending (then we would need to have a most
probable type for the case that NO rule aplies, 
i.e. the unkown word is in base form already.)
*/
const char * baseform(char * word,const char ** tag /*return value!*/)
    { // construct baseform by applying general rules (e.g. removing endings)
    char * wrd;
    int borrow;
    assert(tag);
    *tag = Flex.Baseform(word,wrd,borrow);
    if(*tag)
        return wrd;
    else
        return allToLower(word); 
    }


const char * baseform(char * word,const char * tag)
    { // construct baseform by applying general rules (e.g. removing endings)
    char * wrd;
    int borrow;
    if(Flex.Baseform(word,tag,wrd,borrow))
        return wrd;
    else if(flex::baseformsAreLowercase)
        return allToLower(word); 
    else
        return /*Bart 20021001 allToLower*/(word); 
    }



void unTaggedWord::setFile(FILE * fp)
    {
    unTaggedWord::fp = fp;
    basefrm::setFile(fp);
    }



function * unTaggedWord::getUnTaggedWordFunction(int character,bool & SortInput,int & testType)
    {
    switch(character)
        {
        case 'i':
            return new functionNoArg(&unTaggedWord::i,NULL);
        case 'f':
            SortInput = true;
            return new functionNoArg(&unTaggedWord::f,NULL);
        case 'w':
            return new functionNoArg(&unTaggedWord::w,NULL);
        case 'b':
            hasb = true;
            testType |= NUMBERTEST;
            return new functionNoArg(&unTaggedWord::b,&unTaggedWord::countBaseForms);
        case 'B':
            hasB = true;
            testType |= NUMBERTEST;
            return new functionNoArg(&unTaggedWord::B,&unTaggedWord::countBaseFormsL);
        default:
            return NULL;
        }
    }

function * unTaggedWord::getUnTaggedWordFunctionNoBb(int character,bool & SortInput,int & testType)
    {
    switch(character)
        {
        case 'i':
            return new functionNoArg(&unTaggedWord::i,NULL);
        case 'f':
            SortInput = true;
            return new functionNoArg(&unTaggedWord::f,NULL);
        case 'w':
            return new functionNoArg(&unTaggedWord::w,NULL);
        default:
            return NULL;
        }
    }

void unTaggedWord::print()const
    {
    funcs->printIt(this);
    }

int unTaggedWord::addBaseFormsL()
    {
    const char * tag = NULL;
    const char * wrd = baseform(word,&tag);
    if(!tag)
        tag = NOT_KNOWN;// TODO do something better (NUM, XX, TEGN, etc)
//        return 0;
    if(!*wrd)
        wrd = allToLower(word);
    return addBaseFormL(wrd,LemmaTag(tag));
    }

#if PFRQ || FREQ24
int unTaggedWord::addBaseFormL(const char * s,const char * t)
    {
    int cntL = 0;
    const char * sep;
    while((sep = strchr(s,' ')) != NULL)
        {
        //       ++cntL;
        if(pbfL)
            cntL += pbfL->addBaseForm(s,t,sep - s,/*1,*/0/*freq*/);
        else
            {
            pbfL = new baseformpointer(s,t,sep - s,/*1,*/0/*freq*/);
            ++cntL;
            }
        s = sep + 1;
        }
    //++cntL;
    if(pbfL)
        cntL += pbfL->addBaseForm(s,t,strlen(s),/*1,*/0/*freq*/);
    else
        {
        pbfL = new baseformpointer(s,t,strlen(s),/*1,*/0/*freq*/);
        ++cntL;
        }
    return cntL;
    }
#else
int unTaggedWord::addBaseFormL(const char * s,const char * t)
    {
    int cntL = 0;
    const char * sep;
    while((sep = strchr(s,' ')) != NULL)
        {
        //       ++cntL;
        if(pbfL)
            cntL += pbfL->addBaseForm(s,t,sep - s);
        else
            {
            pbfL = new baseformpointer(s,t,sep - s);
            ++cntL;
            }
        s = sep + 1;
        }
    //++cntL;
    if(pbfL)
        cntL += pbfL->addBaseForm(s,t,strlen(s));
    else
        {
        pbfL = new baseformpointer(s,t,strlen(s));
        ++cntL;
        }
    return cntL;
    }
#endif

int unTaggedWord::addBaseFormsDL(lext * Plext,int nmbr,// The dictionary's available
                                 // lexical information for this word.
                                 bool & ,int & cntD,int & )//
    {
    int n;
#define WRIT 1
#if WRIT
    int written = 0;// Bart 20030206 INT_MIN;
#endif
    unsigned int maxFreq = maxFrequency(Plext,nmbr,NULL,n);
    if(n > 1)
        {
        const char * tp = commonType(Plext,nmbr,maxFreq);
        unsigned int off;
        char * stem = commonStem(Plext,nmbr,tp,maxFreq,off);
        if(tp)
            {
            /*
            unsigned int off;
            char * stem = commonStem(Plext,nmbr,tp,maxFreq,off);
            */
            if(stem)
                {
                /*
                static char buf[256];
                const char * w;
                char * pbuf = buf;
                for(w = word;*w && off;--off)
                    {
                    *pbuf++ = Lower(*w);
                    w++;
                    }
                for(w = stem;*w;)
                    {
                    *pbuf++ = *w++;
                    }
                *pbuf = '\0';*/
#if PFRQ || FREQ24
                cntD += addBaseFormD(stem/*buf*/,/**/LemmaTag/**/(tp)/*tp*/,/*1,*/maxFreq);
#else
                cntD += addBaseFormD(stem/*buf*/,/**/LemmaTag/**/(tp)/*tp*/);
#endif
                FoundInDict = true;
                return cnt;
                }
            }
        else
            {
            if(stem && !strcmp(stem,Plext->constructBaseform(word))) 
                // Bart 20021105: if all baseforms are the same, then use that common baseform.
                {
#if PFRQ || FREQ24
                cntD += addBaseFormD(stem,NOT_KNOWN,0);
#else
                cntD += addBaseFormD(stem,NOT_KNOWN);
#endif
/*            
                cntD += addBaseFormD(allToLower(word),NOT_KNOWN,0);*/
                FoundInDict = true;
                return cnt;
                }
            else
                {
#if WRIT
                written = 0; // force flex rule application
#else
#if 0
        /*cntL +=*/ addBaseFormsL(); // Bart 20021105
                return 0;
#else
                cntD += addBaseFormD(allToLower(word),NOT_KNOWN,0);
                FoundInDict = true;
                return cnt;
#endif
#endif
                }
            }
        }

//    printf("word %s\n",word);
    lext * plext;
    // Lemmatiser adds tag from dictionary
    plext = Plext;
    while(true)
        {
        if(plext->S.frequency >= maxFreq)
            {
#if PFRQ || FREQ24
            cntD += addBaseFormD(plext->constructBaseform(word),/**/LemmaTag/**/(plext->Type),/*1,*/plext->S.frequency);
#else
            cntD += addBaseFormD(plext->constructBaseform(word),/**/LemmaTag/**/(plext->Type));
#endif
            FoundInDict = true;
#if WRIT
            written++;
#endif
            }
        // write the remainder of the baseform and the tag, as
        // found in the dictionary
        
        if(--nmbr)
            {
            ++plext;
            }
        else
            break;
        }
#if WRIT
    if(written > 1)
        {
        /*cntL +=*/ addBaseFormsL(); // Bart 20021105
        }
#endif
    return cnt;
    }


bool unTaggedWord::setFormat(const char * cformat,const char * bformat,const char * Bformat,bool InputHasTags)
    {
    bool SortInput = false;
    getFunction gfnc = InputHasTags ? taggedWord::getTaggedWordFunction : unTaggedWord::getUnTaggedWordFunction;
    funcs = new functionTree();
    int testType = 0;
    OutputClass::Format(cformat,gfnc,*funcs,cformat,SortInput,testType);
    if(hasb)
        {
        if(bformat)
            {
            bfuncs = basefrm::Format(bformat);
            }
        else
            {
            printf("Error: Missing -b pattern on commandline. (Output format %s specifies dictionary field $b)\n",cformat);
            exit(0);
            }
        }
    else if(bformat)
        {
        printf("Warning: -b pattern specified on commandline but not used. (Output format %s doesn't specify dictionary field $b)\n",cformat);
        }

    if(hasB)
        {
        if(Bformat)
            {
            Bfuncs = basefrm::Format(Bformat);
            }
        else
            {
            printf("Error: Missing -B pattern on commandline. (Output format %s specifies flexrule field $B)\n",cformat);
            exit(0);
            }
        }
    else if(bformat)
        {
        printf("Warning: -B pattern specified on commandline but not used. (Output format %s doesn't specify flexrule field $B)\n",cformat);
        }
    return SortInput;
    }

unsigned int unTaggedWord::maxFrequency(lext * Plext,int nmbr,const char * type,int & n)// The dictionary's available
                               // lexical information for this word.
    {
    n = 1;
    if(!lext::DictUnique)
        return 0;
    if(nmbr < 2)
        return 0;
    unsigned int maxfreq = 0;
    //int maxi = -1;
    for(int i = 0;i < nmbr;++i)
        {
        if(!type || !strcmp(type,LemmaTag(Plext[i].Type)))
            {
            if(Plext[i].S.frequency > maxfreq)
                {
                n = 1;
                maxfreq = Plext[i].S.frequency;
        //            maxi = i;
                }
            else if(Plext[i].S.frequency == maxfreq)
                ++n;
            }
        }
    return maxfreq;//maxi;
    }

/*
Find the common stem by disregarding cardinal numbers, i.e. abcd,1 and abcd,2 have common stem abcd.
*/
#if 0
char * unTaggedWord::commonStem(lext * Plext,int nmbr,const char * type,unsigned int freq,unsigned int & off)
    {
    if(!lext::DictUnique)
        return 0;
    if(nmbr < 2)
        return 0;
    static char buf[256];
    buf[0] = '\0';
    off = 0;
    char * ret = NULL;
    for(int i = 0;i < nmbr;++i)
        {
        if(freq == Plext[i].S.frequency && !strcmp(type,/**/LemmaTag/**/(Plext[i].Type)))
            {
            if(ret && off != Plext[i].S.Offset)
                {
                return NULL;
                }
            char * bf = Plext[i].BaseFormSuffix;
            char * komma = strchr(bf,',');
            if(komma)
                {
                if(buf[0])
                    {
                    if(strncmp(buf,bf,komma-bf))
                        {
                        return NULL;
                        }
                    }
                else
                    {
                    strncpy(buf,bf,komma-bf);
                    ret = buf;
                    off = Plext[i].S.Offset;
                    }
                }
            else
                {
                if(buf[0])
                    {
                    if(strcmp(buf,bf))
                        {
                        return NULL;
                        }
                    }
                else
                    {
                    strcpy(buf,bf);
                    ret = buf;
                    off = Plext[i].S.Offset;
                    }
                }
            }
        }
    return ret;

    static char buf[256];
    const char * w;
    char * pbuf = buf;
    for(w = word;*w && off;--off)
        {
        *pbuf++ = Lower(*w);
        w++;
        }
    for(w = stem;*w;)
        {
        *pbuf++ = *w++;
        }
    *pbuf = '\0';
    return buf;
    }
#else
char * unTaggedWord::commonStem(lext * Plext,int nmbr,const char * type,unsigned int freq,unsigned int & off)
    {
    if(!lext::DictUnique)
        return 0;
    if(nmbr < 2)
        return 0;
    static char buf[256];
/*    for(int f = 0;f < 256;++f)
        buf[f] = '\0';*/
    buf[0] = '\0';
    off = 0;
    char * ret = NULL;
    int i;
    for(i = 0;i < nmbr;++i)
        {
        if(freq == Plext[i].S.frequency && (!type /*Bart 20021105*/ || !strcmp(type,/**/LemmaTag/**/(Plext[i].Type))))
            {
            if(ret && off != Plext[i].S.Offset)
                {
                return NULL;
                }
            char * bf = Plext[i].BaseFormSuffix;
            char * komma = strchr(bf,',');
            if(komma)
                {
                if(buf[0])
                    {
                    if(strncmp(buf,bf,komma-bf))
                        {
                        return NULL;
                        }
                    }
                else
                    {
                    strncpy(buf,bf,komma-bf);
                    buf[komma-bf] = '\0';
                    ret = buf;
                    off = Plext[i].S.Offset;
                    }
                }
            else
                {
                if(buf[0])
                    {
                    if(strcmp(buf,bf))
                        {
                        return NULL;
                        }
                    }
                else
                    {
                    strcpy(buf,bf);
                    ret = buf;
                    off = Plext[i].S.Offset;
                    }
                }
            }
        }
    
    i = strlen(buf);
    unsigned int j = i + off;
    buf[j] = '\0';
    while(j > off)
        {
        --j;
        buf[j] = buf[j - off];
        }
    const char * w;
    char * pbuf = buf;
    for(w = word;*w && off;--off)
        {
        *pbuf++ = Lower(*w);
        w++;
        }
/*    for(w = stem;*w;)
        {
        *pbuf++ = *w++;
        }
    *pbuf = '\0';*/
    return buf;
    }
#endif


char * unTaggedWord::commonType(lext * Plext,int nmbr,unsigned int freq)
    {
    if(!lext::DictUnique)
        return NULL;
    if(nmbr < 2)
        return NULL;
    static char buf[256];
    buf[0] = '\0';
    char * ret = NULL;
    for(int i = 0;i < nmbr;++i)
        {
        if(freq == Plext[i].S.frequency)
            {
            const char * t = /**/LemmaTag/**/(Plext[i].Type);
            if(buf[0])
                {
                if(strcmp(buf,t))
                    {
                    return NULL;
                    }
                }
            else
                {
                strcpy(buf,t);
                ret = buf;
                }
            }
        }
    return ret;
    }

function * taggedWord::getTaggedWordFunction(int character,bool & SortInput,int & testType)
    {
    switch(character)
        {
        case 't':
            return new functionNoArgT(&taggedWord::t);
        }
    return unTaggedWord::getUnTaggedWordFunction(character,SortInput,testType);
    }

function * taggedWord::getTaggedWordFunctionNoBb(int character,bool & SortInput,int & testType)
    {
    switch(character)
        {
        case 't':
            return new functionNoArgT(&taggedWord::t);
        }
    return unTaggedWord::getUnTaggedWordFunctionNoBb(character,SortInput,testType);
    }

int taggedWord::addBaseFormsL()
    {
    const char *ttag = TextToDictTags ? TextToDictTags->translate(tag) : tag; // Bart 20030910 hurtig hack
    const char * wrd = baseform(word,ttag);
    return addBaseFormL(wrd,LemmaTag(ttag /*eller tag?*/));
    }


int taggedWord::addBaseFormsDL(lext * Plext,int nmbr,// The dictionary's available
                               // lexical information for this word.
                               bool & conflict,int & cntD,int & cntL)//
    {
    lext * plext;
    //   int cnt = 0;
    const char * Tp = TextToDictTags ? TextToDictTags->translate(tag) : tag; // tag as found in the text
/*    if(TextToDictTags)
        tag = TextToDictTags->translate(tag);*/  // TODO Bart 20030910 Skal tag-member erstattes med translate(tag)?
    /*
    for(int i = 0;i < tagcnt;++i)
        {
        if(!strcmp(tag,textTags[i]))
            {
            Tp = dictTags[i]; // translate tag to dictionary-type
            break;
            }
        }
        */
    // See whether the word's tag can be found in the
    // dictionary's lexical information.
    int written = 0;
    
    plext = Plext;
    int m;

    const char * baseTp = /**/LemmaTag/**/(Tp);

    unsigned int maxFreq = maxFrequency(Plext,nmbr,baseTp/*Tp*/,m);
    if(m > 1)
        {
        unsigned int off;
        char * stem = commonStem(Plext,nmbr,baseTp/*Tp*/,maxFreq,off);
        if(stem)
            {/*
            static char buf[256];
            const char * w;
            char * pbuf = buf;
            for(w = word;*w && off;--off)
                {
                *pbuf++ = Lower(*w);
                w++;
                }
            for(w = stem;*w;)
                {
                *pbuf++ = *w++;
                }
            *pbuf = '\0';*/
//            printf("word %s stem %s maxFreq %d baseTp %s\n",word,stem,maxFreq,baseTp);
#if PFRQ || FREQ24
            cntD += addBaseFormD(stem/*buf*/,baseTp/*LemmaTag(Tp)*/,/*1,*/maxFreq);
#else
            cntD += addBaseFormD(stem/*buf*/,baseTp/*LemmaTag(Tp)*/);
#endif
            FoundInDict = true;
            return cnt;
            }
        }

//    const char * baseTp = /**/LemmaTag/**/(Tp);
    for(int n = nmbr;n;--n,++plext)
        {
        if(plext->S.frequency >= maxFreq)
            {
            if(!strcmp(baseTp/*Tp*/,/**/LemmaTag/**/(plext->Type))) // Word is in dictionary,
                // and type info matches.
                {
/*            printf("word %s constructed %s freq %d maxFreq %d baseTp %s\n",
                word,plext->constructBaseform(word),plext->S.frequency,maxFreq,baseTp);*/
#if PFRQ || FREQ24
                cntD += addBaseFormD(plext->constructBaseform(word),baseTp,/*1,*/plext->S.frequency);
#else
                cntD += addBaseFormD(plext->constructBaseform(word),baseTp);
#endif
                ++written;
                FoundInDict = true;
                }
            }
        //There is a problem with the statistics if more than one lemma is added!
        }
    
    if(written > 1)
        /*cntL +=*/ addBaseFormsL(); // Let the rules decide if the word is a 
        // homograph, with more than one readings having the correct lexical 
        // type. First try other disambiguation tricks (frequency).
    else if(!written)
        {
        conflict = true;
        // There is a conflict between the tagger and the dictionary. 
        // The word is in the dictionary, but not with the lexical type assigned by the tagger.
        cntL += addBaseFormsL();
        
        if(nmbr)
            {
            unsigned int maxFreq = maxFrequency(Plext,nmbr,NULL,m);
            if(m > 1)
                {
                char * tp = commonType(Plext,nmbr,maxFreq);
                if(tp)
                    {
                    unsigned int off;
                    char * stem = commonStem(Plext,nmbr,tp,maxFreq,off);
                    if(stem)
                        {/*
                        static char buf[256];
                        const char * w;
                        char * pbuf = buf;
                        for(w = word;*w && off;--off)
                            {
                            *pbuf++ = *w++;
                            }
                        for(w = stem;*w;)
                            {
                            *pbuf++ = *w++;
                            }
                        *pbuf = '\0';*/
#if PFRQ || FREQ24
                        addBaseFormD(stem/*buf*/,/*LemmaTag*/(tp),/*1,*/maxFreq);
#else
                        addBaseFormD(stem/*buf*/,/*LemmaTag*/(tp));
#endif
/*
                        printf("stem %s tp %s baseTp %s\n",stem,tp,baseTp);
stem fire tp V baseTp N
stem jens tp N baseTp EGEN
stem tabe tp V baseTp ADJ
stem stege tp V baseTp ADJ
stem mtte tp V baseTp ADJ
stem ende tp V baseTp ADJ
*/
                        return cnt;
                        }
                    }
                }
            plext = Plext;
            while(true)
                {
                if(plext->S.frequency >= maxFreq)
#if PFRQ || FREQ24
                    /*cntD +=*/ addBaseFormD(plext->constructBaseform(word),/**/LemmaTag/**/(plext->Type),/*0,*/plext->S.frequency);
#else
                    /*cntD +=*/ addBaseFormD(plext->constructBaseform(word),/**/LemmaTag/**/(plext->Type));
#endif
                    // We choose not to count the dictionary lemmas if the constructed lemma already is counted on.
                    if(--nmbr)
                        ++plext;
                    else
                        break;
                }
            }
        }
    return cnt;
    }

functionTree * unTaggedWord::Format(char * format)
    {
    functionTree * ret = new functionTree();
    bool DummySortInput;
    int testType = 0;
    OutputClass::Format(format,getUnTaggedWordFunctionNoBb,*ret,format,DummySortInput,testType);
/*    printf("\nFormat %s:",format);
    ret->print();
    printf("\n");*/
    return ret;
    }

functionTree * taggedWord::Format(char * format)
    {
    functionTree * ret = new functionTree();
    bool DummySortInput;
    int testType = 0;
    OutputClass::Format(format,getTaggedWordFunctionNoBb,*ret,format,DummySortInput,testType);
/*    printf("\nFormat %s:",format);
    ret->print();
    printf("\n");*/
    return ret;
    }


#if !QSORT
void unTaggedWord::lookup(void * arg)
    {
    taggedText * txt = (taggedText *)arg;
        bool conflict = false;
        tcount Pos;
        int Nmbr;
        if(dictionary::findword(itsWord(),Pos,Nmbr))
            {
            addBaseFormsDL(LEXT + Pos,Nmbr,conflict,txt->cntD,txt->cntL);
//            files.write(LEXT + Pos,Nmbr,TaggedWords[k]->word,TaggedWords[k]->tag,conflict);
            if(conflict)
                {
                txt->aConflictTypes++;
                txt->aConflict += itsCnt();
                }
            }
        else
            {
            txt->newcntTypes++;
            txt->newcnt += itsCnt();
            txt->cntL += addBaseFormsL();
//            files.writeWordAndTag(TaggedWords[k]->word,TaggedWords[k]->tag,text.Sorted() ? TaggedWords[k]->cnt:-1);
            }
        if(basefrm::hasW)
            addFullForm();
    }

void unTaggedWord::assign(void * arg)
    {
    taggedText * txt = (taggedText *)arg;
    assignTo(txt->D,txt->L);
    }

void unTaggedWord::traverse(trav fnc,void * arg)
    {
    if(left)
        left->traverse(fnc,arg);
    (this->*fnc)(arg);
    if(right)
        right->traverse(fnc,arg);
    }

void unTaggedWord::traverse0(trav0 fnc)
    {
    if(left)
        left->traverse0(fnc);
    (this->*fnc)();
    if(right)
        right->traverse0(fnc);
    }

void taggedWord::traverse0T(trav0T fnc)
    {
    if(left)
        ((taggedWord*)left)->traverse0T(fnc);
    (this->*fnc)();
    if(right)
        ((taggedWord*)right)->traverse0T(fnc);
    }

void unTaggedWord::traverse0C(trav0C fnc)
    {
    if(left)
        left->traverse0C(fnc);
    (this->*fnc)();
    if(right)
        right->traverse0C(fnc);
    }

unTaggedWord * unTaggedWord::insert(const char * w)
    {
    int c = strcmp(word,w);
    if(!c)
        {
        ++cnt;
        }
    else
        {
        if(c < 0)
            {
            if(left)
                return left->insert(w);
            else
                {
                unTaggedWord * ret = new unTaggedWord(w);
                left = ret;
                return ret;
                }
            }
        else
            {
            if(right)
                return right->insert(w);
            else
                {
                unTaggedWord * ret = new unTaggedWord(w);
                right = ret;
                return ret;
                }
            }
        }
    return this;
    }

taggedWord * taggedWord::insert(const char * w,const char * t)
    {
    int c = strcmp(tag,t);
    if(!c)
        c = strcmp(word,w);
    if(!c)
        {
        ++cnt;
        }
    else
        {
        if(c < 0)
            {
            if(left)
                return ((taggedWord*)left)->insert(w,t);
            else
                {
                taggedWord * ret = new taggedWord(w,t);
                left = ret;
                return ret;
                }
            }
        else
            {
            if(right)
                return ((taggedWord*)right)->insert(w,t);
            else
                {
                taggedWord * ret = new taggedWord(w,t);
                right = ret;
                return ret;
                }
            }
        }
    return this;
    }

int unTaggedWord::reducedtotal = 0;
#endif
